"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAccessibleTextUpdateEvent(PySide6.QtGui.QAccessibleTextCursorEvent):
    """
    https://doc.qt.io/qt-6/qaccessibletextupdateevent.html

    **Detailed Description**

    This class is used with **QAccessible::updateAccessibility** ().
    """

    @overload
    def __init__(
        self,
        iface: PySide6.QtGui.QAccessibleInterface,
        position: int,
        oldText: str,
        text: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletextupdateevent.html#QAccessibleTextUp
        dateEvent

        **QAccessibleTextUpdateEvent::QAccessibleTextUpdateEvent(QObject *
        object , int position , const QString & oldText , const QString & text
        )**

        Constructs a new QAccessibleTextUpdateEvent for **object**. The text
        change takes place at **position** where the **oldText** was removed and
        **text** inserted instead.
        """
        ...

    @overload
    def __init__(
        self, obj: PySide6.QtCore.QObject, position: int, oldText: str, text: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletextupdateevent.html#QAccessibleTextUp
        dateEvent-1

        **QAccessibleTextUpdateEvent::QAccessibleTextUpdateEvent(QAccessibleInte
        rface * iface , int position , const QString & oldText , const QString &
        text )**

        Constructs a new QAccessibleTextUpdateEvent for **iface**. The text
        change takes place at **position** where the **oldText** was removed and
        **text** inserted instead.
        """
        ...

    def changePosition(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletextupdateevent.html#changePosition

        **int QAccessibleTextUpdateEvent::changePosition() const**

        Returns where the change took place.
        """
        ...

    def textInserted(self) -> str:
        """
        https://doc.qt.io/qt-6/qaccessibletextupdateevent.html#textInserted

        **QString QAccessibleTextUpdateEvent::textInserted() const**

        Returns the inserted text.
        """
        ...

    def textRemoved(self) -> str:
        """
        https://doc.qt.io/qt-6/qaccessibletextupdateevent.html#textRemoved

        **QString QAccessibleTextUpdateEvent::textRemoved() const**

        Returns the removed text.
        """
        ...
