"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAccessibleTextSelectionEvent(PySide6.QtGui.QAccessibleTextCursorEvent):
    """
    https://doc.qt.io/qt-6/qaccessibletextselectionevent.html

    **Detailed Description**

    This class is used with **QAccessible::updateAccessibility** ().
    """

    @overload
    def __init__(
        self, iface: PySide6.QtGui.QAccessibleInterface, start: int, end: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletextselectionevent.html#QAccessibleTex
        tSelectionEvent

        **QAccessibleTextSelectionEvent::QAccessibleTextSelectionEvent(QObject *
        object , int start , int end )**

        Constructs a new QAccessibleTextSelectionEvent for **object**. The new
        selection this event notifies about is from position **start** to
        **end**.
        """
        ...

    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, start: int, end: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletextselectionevent.html#QAccessibleTex
        tSelectionEvent-1

        **QAccessibleTextSelectionEvent::QAccessibleTextSelectionEvent(QAccessib
        leInterface * iface , int start , int end )**

        Constructs a new QAccessibleTextSelectionEvent for **iface**. The new
        selection this event notifies about is from position **start** to
        **end**.
        """
        ...

    def selectionEnd(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletextselectionevent.html#selectionEnd

        **int QAccessibleTextSelectionEvent::selectionEnd() const**

        Returns the position of the last selected character.
        """
        ...

    def selectionStart(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletextselectionevent.html#selectionStart

        **int QAccessibleTextSelectionEvent::selectionStart() const**

        Returns the position of the first selected character.
        """
        ...

    def setSelection(self, start: int, end: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletextselectionevent.html#setSelection

        **void QAccessibleTextSelectionEvent::setSelection(int start , int end
        )**

        Sets the selection for this event from position **start** to **end**.
        """
        ...
