"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List

bytes = str


class QAccessibleActionInterface(object):
    """
    https://doc.qt.io/qt-6/qaccessibleactioninterface.html

    **Detailed Description**

    Accessible objects should implement the action interface if they support
    user interaction. Usually this interface is implemented by classes that also
    implement **QAccessibleInterface** .

    The supported actions should use the predefined actions offered in this
    class unless they do not fit a predefined action. In that case a custom
    action can be added.

    When subclassing QAccessibleActionInterface you need to provide a list of
    **actionNames**  which is the primary means to discover the available
    actions. Action names are never localized. In order to present actions to
    the user there are two functions that need to return localized versions of
    the name and give a description of the action. For the predefined action
    names use **QAccessibleActionInterface::localizedActionName** () and
    **QAccessibleActionInterface::localizedActionDescription** () to return
    their localized counterparts.

    In general you should use one of the predefined action names, unless
    describing an action that does not fit these:

    Action nameDescription
    **toggleAction** ()toggles the item (checkbox,
    radio button, switch, ...)
    **decreaseAction** ()decrease the value of the
    accessible (e.g. spinbox)
    **increaseAction** ()increase the value of the
    accessible (e.g. spinbox)
    **pressAction** ()press or click or activate the
    accessible (should correspond to clicking the object with the mouse)
    **setFocusAction** ()set the focus to this accessible
    **showMenuAction**
    ()show a context menu, corresponds to right-clicks

    In order to invoke the action, **doAction** () is called with an action
    name.

    Most widgets will simply implement **pressAction** (). This is what happens
    when the widget is activated by being clicked, space pressed or similar.

    **IAccessible2 Specification**
    """

    def __init__(self) -> None:
        ...

    def actionNames(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#actionNames

        **[pure virtual] QStringList QAccessibleActionInterface::actionNames()
        const**

        Returns the list of actions supported by this accessible object. The
        actions returned should be in preferred order, i.e. the action that the
        user most likely wants to trigger should be returned first, while the
        least likely action should be returned last.

        The list does only contain actions that can be invoked. It won't return
        disabled actions, or actions associated with disabled UI controls.

        The list can be empty.

        Note that this list is not localized. For a localized representation re-
        implement **localizedActionName** () and **localizedActionDescription**
        ()

        **See also** **doAction** (), **localizedActionName** (), and
        **localizedActionDescription** ().
        """
        ...

    @staticmethod
    def decreaseAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#decreaseAction

        **[static] const QString &QAccessibleActionInterface::decreaseAction()**

        Returns the name of the decrease default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    def doAction(self, actionName: str) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#doAction

        **[pure virtual] void QAccessibleActionInterface::doAction(const QString
        & actionName )**

        Invokes the action specified by **actionName**. Note that **actionName**
        is the non-localized name as returned by **actionNames** () This
        function is usually implemented by calling the same functions that other
        user interaction, such as clicking the object, would trigger.

        **See also** **actionNames** ().
        """
        ...

    @staticmethod
    def increaseAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#increaseAction

        **[static] const QString &QAccessibleActionInterface::increaseAction()**

        Returns the name of the increase default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    def keyBindingsForAction(self, actionName: str) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#keyBindingsForAct
        ion

        **[pure virtual] QStringList
        QAccessibleActionInterface::keyBindingsForAction(const QString &
        actionName ) const**

        Returns a list of the keyboard shortcuts available for invoking the
        action named **actionName**.

        This is important to let users learn alternative ways of using the
        application by emphasizing the keyboard.

        **See also** **actionNames** ().
        """
        ...

    def localizedActionDescription(self, name: str) -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#localizedActionDe
        scription

        **[virtual] QString
        QAccessibleActionInterface::localizedActionDescription(const QString &
        actionName ) const**

        Returns a localized action description of the action **actionName**.

        When using one of the default names, you can call this function in
        **QAccessibleActionInterface**  to get the localized string.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    def localizedActionName(self, name: str) -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#localizedActionNa
        me

        **[virtual] QString
        QAccessibleActionInterface::localizedActionName(const QString &
        actionName ) const**

        Returns a localized action name of **actionName**.

        For custom actions this function has to be re-implemented. When using
        one of the default names, you can call this function in
        **QAccessibleActionInterface**  to get the localized string.

        **See also** **actionNames** () and **localizedActionDescription** ().
        """
        ...

    @staticmethod
    def nextPageAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#nextPageAction

        **[static] QString QAccessibleActionInterface::nextPageAction()**

        Returns the name of the next page default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def pressAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#pressAction

        **[static] const QString &QAccessibleActionInterface::pressAction()**

        Returns the name of the press default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def previousPageAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#previousPageActio
        n

        **[static] QString QAccessibleActionInterface::previousPageAction()**

        Returns the name of the previous page default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def scrollDownAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#scrollDownAction

        **[static] QString QAccessibleActionInterface::scrollDownAction()**

        Returns the name of the scroll down default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def scrollLeftAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#scrollLeftAction

        **[static] QString QAccessibleActionInterface::scrollLeftAction()**

        Returns the name of the scroll left default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def scrollRightAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#scrollRightAction

        **[static] QString QAccessibleActionInterface::scrollRightAction()**

        Returns the name of the scroll right default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def scrollUpAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#scrollUpAction

        **[static] QString QAccessibleActionInterface::scrollUpAction()**

        Returns the name of the scroll up default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def setFocusAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#setFocusAction

        **[static] const QString &QAccessibleActionInterface::setFocusAction()**

        Returns the name of the set focus default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def showMenuAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#showMenuAction

        **[static] const QString &QAccessibleActionInterface::showMenuAction()**

        Returns the name of the show menu default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...

    @staticmethod
    def toggleAction() -> str:
        """
        https://doc.qt.io/qt-6/qaccessibleactioninterface.html#toggleAction

        **[static] const QString &QAccessibleActionInterface::toggleAction()**

        Returns the name of the toggle default action.

        **See also** **actionNames** () and **localizedActionName** ().
        """
        ...
