"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Callable, Tuple, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAccessible(object):
    """
    https://doc.qt.io/qt-6/qaccessible.html

    **Detailed Description**

    This class is part of **Accessibility for QWidget Applications** .

    Accessible applications can be used by people who are not able to use
    applications by conventional means.

    The functions in this class are used for communication between accessible
    applications (also called AT Servers) and accessibility tools (AT Clients),
    such as screen readers and braille displays. Clients and servers communicate
    in the following way:

    * **AT Servers** notify the clients about events through calls to the
    **updateAccessibility** () function.
      * **AT Clients** request information
    about the objects in the server. The **QAccessibleInterface**  class is the
    core interface, and encapsulates this information in a pure virtual API.
    Implementations of the interface are provided by Qt through the
    **queryAccessibleInterface** () API.

    The communication between servers and clients is initialized by the
    **setRootObject** () function. Function pointers can be installed to replace
    or extend the default behavior of the static functions in QAccessible.

    Qt supports Microsoft Active Accessibility (MSAA), macOS Accessibility, and
    the Unix/X11 AT-SPI standard. Other backends can be supported using
    QAccessibleBridge.

    In the Unix/X11 AT-SPI implementation, applications become accessible when
    two conditions are met:

    * org.a11y.Status.IsEnabled DBus property is true
      *
    org.a11y.Status.ScreenReaderEnabled DBus property is true

    An alternative to setting the DBus AT-SPI properties is to set the
    QT_LINUX_ACCESSIBILITY_ALWAYS_ON environment variable.

    In addition to QAccessible's static functions, Qt offers one generic
    interface, **QAccessibleInterface** , that can be used to wrap all widgets
    and objects (e.g., **QPushButton** ). This single interface provides all the
    metadata necessary for the assistive technologies. Qt provides
    implementations of this interface for its built-in widgets as plugins.

    When you develop custom widgets, you can create custom subclasses of
    **QAccessibleInterface**  and distribute them as plugins (using
    **QAccessiblePlugin** ) or compile them into the application. Likewise, Qt's
    predefined accessibility support can be built as plugin (the default) or
    directly into the Qt library. The main advantage of using plugins is that
    the accessibility classes are only loaded into memory if they are actually
    used; they don't slow down the common case where no assistive technology is
    being used.

    Qt also includes two convenience classes, **QAccessibleObject**  and
    **QAccessibleWidget** , that inherit from **QAccessibleInterface**  and
    provide the lowest common denominator of metadata (e.g., widget geometry,
    window title, basic help text). You can use them as base classes when
    wrapping your custom **QObject**  or **QWidget**  subclasses.

    **See also** **QAccessibleInterface** .
    """

    SoundPlayed: QAccessible.Event = ...
    Alert: QAccessible.Event = ...
    ForegroundChanged: QAccessible.Event = ...
    MenuStart: QAccessible.Event = ...
    MenuEnd: QAccessible.Event = ...
    PopupMenuStart: QAccessible.Event = ...
    PopupMenuEnd: QAccessible.Event = ...
    ContextHelpStart: QAccessible.Event = ...
    ContextHelpEnd: QAccessible.Event = ...
    DragDropStart: QAccessible.Event = ...
    DragDropEnd: QAccessible.Event = ...
    DialogStart: QAccessible.Event = ...
    DialogEnd: QAccessible.Event = ...
    ScrollingStart: QAccessible.Event = ...
    ScrollingEnd: QAccessible.Event = ...
    MenuCommand: QAccessible.Event = ...
    ActionChanged: QAccessible.Event = ...
    ActiveDescendantChanged: QAccessible.Event = ...
    AttributeChanged: QAccessible.Event = ...
    DocumentContentChanged: QAccessible.Event = ...
    DocumentLoadComplete: QAccessible.Event = ...
    DocumentLoadStopped: QAccessible.Event = ...
    DocumentReload: QAccessible.Event = ...
    HyperlinkEndIndexChanged: QAccessible.Event = ...
    HyperlinkNumberOfAnchorsChanged: QAccessible.Event = ...
    HyperlinkSelectedLinkChanged: QAccessible.Event = ...
    HypertextLinkActivated: QAccessible.Event = ...
    HypertextLinkSelected: QAccessible.Event = ...
    HyperlinkStartIndexChanged: QAccessible.Event = ...
    HypertextChanged: QAccessible.Event = ...
    HypertextNLinksChanged: QAccessible.Event = ...
    ObjectAttributeChanged: QAccessible.Event = ...
    PageChanged: QAccessible.Event = ...
    SectionChanged: QAccessible.Event = ...
    TableCaptionChanged: QAccessible.Event = ...
    TableColumnDescriptionChanged: QAccessible.Event = ...
    TableColumnHeaderChanged: QAccessible.Event = ...
    TableModelChanged: QAccessible.Event = ...
    TableRowDescriptionChanged: QAccessible.Event = ...
    TableRowHeaderChanged: QAccessible.Event = ...
    TableSummaryChanged: QAccessible.Event = ...
    TextAttributeChanged: QAccessible.Event = ...
    TextCaretMoved: QAccessible.Event = ...
    TextColumnChanged: QAccessible.Event = ...
    TextInserted: QAccessible.Event = ...
    TextRemoved: QAccessible.Event = ...
    TextUpdated: QAccessible.Event = ...
    TextSelectionChanged: QAccessible.Event = ...
    VisibleDataChanged: QAccessible.Event = ...
    ObjectCreated: QAccessible.Event = ...
    ObjectDestroyed: QAccessible.Event = ...
    ObjectShow: QAccessible.Event = ...
    ObjectHide: QAccessible.Event = ...
    ObjectReorder: QAccessible.Event = ...
    Focus: QAccessible.Event = ...
    Selection: QAccessible.Event = ...
    SelectionAdd: QAccessible.Event = ...
    SelectionRemove: QAccessible.Event = ...
    SelectionWithin: QAccessible.Event = ...
    StateChanged: QAccessible.Event = ...
    LocationChanged: QAccessible.Event = ...
    NameChanged: QAccessible.Event = ...
    DescriptionChanged: QAccessible.Event = ...
    ValueChanged: QAccessible.Event = ...
    ParentChanged: QAccessible.Event = ...
    HelpChanged: QAccessible.Event = ...
    DefaultActionChanged: QAccessible.Event = ...
    AcceleratorChanged: QAccessible.Event = ...
    InvalidEvent: QAccessible.Event = ...
    TextInterface: QAccessible.InterfaceType = ...
    EditableTextInterface: QAccessible.InterfaceType = ...
    ValueInterface: QAccessible.InterfaceType = ...
    ActionInterface: QAccessible.InterfaceType = ...
    ImageInterface: QAccessible.InterfaceType = ...
    TableInterface: QAccessible.InterfaceType = ...
    TableCellInterface: QAccessible.InterfaceType = ...
    HyperlinkInterface: QAccessible.InterfaceType = ...
    AllRelations: QAccessible.RelationFlag = ...
    Label: QAccessible.RelationFlag = ...
    Labelled: QAccessible.RelationFlag = ...
    Controller: QAccessible.RelationFlag = ...
    Controlled: QAccessible.RelationFlag = ...
    NoRole: QAccessible.Role = ...
    TitleBar: QAccessible.Role = ...
    MenuBar: QAccessible.Role = ...
    ScrollBar: QAccessible.Role = ...
    Grip: QAccessible.Role = ...
    Sound: QAccessible.Role = ...
    Cursor: QAccessible.Role = ...
    Caret: QAccessible.Role = ...
    AlertMessage: QAccessible.Role = ...
    Window: QAccessible.Role = ...
    Client: QAccessible.Role = ...
    PopupMenu: QAccessible.Role = ...
    MenuItem: QAccessible.Role = ...
    ToolTip: QAccessible.Role = ...
    Application: QAccessible.Role = ...
    Document: QAccessible.Role = ...
    Pane: QAccessible.Role = ...
    Chart: QAccessible.Role = ...
    Dialog: QAccessible.Role = ...
    Border: QAccessible.Role = ...
    Grouping: QAccessible.Role = ...
    Separator: QAccessible.Role = ...
    ToolBar: QAccessible.Role = ...
    StatusBar: QAccessible.Role = ...
    Table: QAccessible.Role = ...
    ColumnHeader: QAccessible.Role = ...
    RowHeader: QAccessible.Role = ...
    Column: QAccessible.Role = ...
    Row: QAccessible.Role = ...
    Cell: QAccessible.Role = ...
    Link: QAccessible.Role = ...
    HelpBalloon: QAccessible.Role = ...
    Assistant: QAccessible.Role = ...
    List: QAccessible.Role = ...
    ListItem: QAccessible.Role = ...
    Tree: QAccessible.Role = ...
    TreeItem: QAccessible.Role = ...
    PageTab: QAccessible.Role = ...
    PropertyPage: QAccessible.Role = ...
    Indicator: QAccessible.Role = ...
    Graphic: QAccessible.Role = ...
    StaticText: QAccessible.Role = ...
    EditableText: QAccessible.Role = ...
    Button: QAccessible.Role = ...
    PushButton: QAccessible.Role = ...
    CheckBox: QAccessible.Role = ...
    RadioButton: QAccessible.Role = ...
    ComboBox: QAccessible.Role = ...
    ProgressBar: QAccessible.Role = ...
    Dial: QAccessible.Role = ...
    HotkeyField: QAccessible.Role = ...
    Slider: QAccessible.Role = ...
    SpinBox: QAccessible.Role = ...
    Canvas: QAccessible.Role = ...
    Animation: QAccessible.Role = ...
    Equation: QAccessible.Role = ...
    ButtonDropDown: QAccessible.Role = ...
    ButtonMenu: QAccessible.Role = ...
    ButtonDropGrid: QAccessible.Role = ...
    Whitespace: QAccessible.Role = ...
    PageTabList: QAccessible.Role = ...
    Clock: QAccessible.Role = ...
    Splitter: QAccessible.Role = ...
    LayeredPane: QAccessible.Role = ...
    Terminal: QAccessible.Role = ...
    Desktop: QAccessible.Role = ...
    Paragraph: QAccessible.Role = ...
    WebDocument: QAccessible.Role = ...
    Section: QAccessible.Role = ...
    Notification: QAccessible.Role = ...
    ColorChooser: QAccessible.Role = ...
    Footer: QAccessible.Role = ...
    Form: QAccessible.Role = ...
    Heading: QAccessible.Role = ...
    Note: QAccessible.Role = ...
    ComplementaryContent: QAccessible.Role = ...
    UserRole: QAccessible.Role = ...
    Name: QAccessible.Text = ...
    Description: QAccessible.Text = ...
    Value: QAccessible.Text = ...
    Help: QAccessible.Text = ...
    Accelerator: QAccessible.Text = ...
    DebugDescription: QAccessible.Text = ...
    UserText: QAccessible.Text = ...
    CharBoundary: QAccessible.TextBoundaryType = ...
    WordBoundary: QAccessible.TextBoundaryType = ...
    SentenceBoundary: QAccessible.TextBoundaryType = ...
    ParagraphBoundary: QAccessible.TextBoundaryType = ...
    LineBoundary: QAccessible.TextBoundaryType = ...
    NoBoundary: QAccessible.TextBoundaryType = ...

    class Event(Enum):
        SoundPlayed: QAccessible.Event = ...
        Alert: QAccessible.Event = ...
        ForegroundChanged: QAccessible.Event = ...
        MenuStart: QAccessible.Event = ...
        MenuEnd: QAccessible.Event = ...
        PopupMenuStart: QAccessible.Event = ...
        PopupMenuEnd: QAccessible.Event = ...
        ContextHelpStart: QAccessible.Event = ...
        ContextHelpEnd: QAccessible.Event = ...
        DragDropStart: QAccessible.Event = ...
        DragDropEnd: QAccessible.Event = ...
        DialogStart: QAccessible.Event = ...
        DialogEnd: QAccessible.Event = ...
        ScrollingStart: QAccessible.Event = ...
        ScrollingEnd: QAccessible.Event = ...
        MenuCommand: QAccessible.Event = ...
        ActionChanged: QAccessible.Event = ...
        ActiveDescendantChanged: QAccessible.Event = ...
        AttributeChanged: QAccessible.Event = ...
        DocumentContentChanged: QAccessible.Event = ...
        DocumentLoadComplete: QAccessible.Event = ...
        DocumentLoadStopped: QAccessible.Event = ...
        DocumentReload: QAccessible.Event = ...
        HyperlinkEndIndexChanged: QAccessible.Event = ...
        HyperlinkNumberOfAnchorsChanged: QAccessible.Event = ...
        HyperlinkSelectedLinkChanged: QAccessible.Event = ...
        HypertextLinkActivated: QAccessible.Event = ...
        HypertextLinkSelected: QAccessible.Event = ...
        HyperlinkStartIndexChanged: QAccessible.Event = ...
        HypertextChanged: QAccessible.Event = ...
        HypertextNLinksChanged: QAccessible.Event = ...
        ObjectAttributeChanged: QAccessible.Event = ...
        PageChanged: QAccessible.Event = ...
        SectionChanged: QAccessible.Event = ...
        TableCaptionChanged: QAccessible.Event = ...
        TableColumnDescriptionChanged: QAccessible.Event = ...
        TableColumnHeaderChanged: QAccessible.Event = ...
        TableModelChanged: QAccessible.Event = ...
        TableRowDescriptionChanged: QAccessible.Event = ...
        TableRowHeaderChanged: QAccessible.Event = ...
        TableSummaryChanged: QAccessible.Event = ...
        TextAttributeChanged: QAccessible.Event = ...
        TextCaretMoved: QAccessible.Event = ...
        TextColumnChanged: QAccessible.Event = ...
        TextInserted: QAccessible.Event = ...
        TextRemoved: QAccessible.Event = ...
        TextUpdated: QAccessible.Event = ...
        TextSelectionChanged: QAccessible.Event = ...
        VisibleDataChanged: QAccessible.Event = ...
        ObjectCreated: QAccessible.Event = ...
        ObjectDestroyed: QAccessible.Event = ...
        ObjectShow: QAccessible.Event = ...
        ObjectHide: QAccessible.Event = ...
        ObjectReorder: QAccessible.Event = ...
        Focus: QAccessible.Event = ...
        Selection: QAccessible.Event = ...
        SelectionAdd: QAccessible.Event = ...
        SelectionRemove: QAccessible.Event = ...
        SelectionWithin: QAccessible.Event = ...
        StateChanged: QAccessible.Event = ...
        LocationChanged: QAccessible.Event = ...
        NameChanged: QAccessible.Event = ...
        DescriptionChanged: QAccessible.Event = ...
        ValueChanged: QAccessible.Event = ...
        ParentChanged: QAccessible.Event = ...
        HelpChanged: QAccessible.Event = ...
        DefaultActionChanged: QAccessible.Event = ...
        AcceleratorChanged: QAccessible.Event = ...
        InvalidEvent: QAccessible.Event = ...

    class InterfaceType(Enum):
        TextInterface: QAccessible.InterfaceType = ...
        EditableTextInterface: QAccessible.InterfaceType = ...
        ValueInterface: QAccessible.InterfaceType = ...
        ActionInterface: QAccessible.InterfaceType = ...
        ImageInterface: QAccessible.InterfaceType = ...
        TableInterface: QAccessible.InterfaceType = ...
        TableCellInterface: QAccessible.InterfaceType = ...
        HyperlinkInterface: QAccessible.InterfaceType = ...

    class Relation(object):
        ...

    class RelationFlag(Enum):
        AllRelations: QAccessible.RelationFlag = ...
        Label: QAccessible.RelationFlag = ...
        Labelled: QAccessible.RelationFlag = ...
        Controller: QAccessible.RelationFlag = ...
        Controlled: QAccessible.RelationFlag = ...

    class Role(Enum):
        NoRole: QAccessible.Role = ...
        TitleBar: QAccessible.Role = ...
        MenuBar: QAccessible.Role = ...
        ScrollBar: QAccessible.Role = ...
        Grip: QAccessible.Role = ...
        Sound: QAccessible.Role = ...
        Cursor: QAccessible.Role = ...
        Caret: QAccessible.Role = ...
        AlertMessage: QAccessible.Role = ...
        Window: QAccessible.Role = ...
        Client: QAccessible.Role = ...
        PopupMenu: QAccessible.Role = ...
        MenuItem: QAccessible.Role = ...
        ToolTip: QAccessible.Role = ...
        Application: QAccessible.Role = ...
        Document: QAccessible.Role = ...
        Pane: QAccessible.Role = ...
        Chart: QAccessible.Role = ...
        Dialog: QAccessible.Role = ...
        Border: QAccessible.Role = ...
        Grouping: QAccessible.Role = ...
        Separator: QAccessible.Role = ...
        ToolBar: QAccessible.Role = ...
        StatusBar: QAccessible.Role = ...
        Table: QAccessible.Role = ...
        ColumnHeader: QAccessible.Role = ...
        RowHeader: QAccessible.Role = ...
        Column: QAccessible.Role = ...
        Row: QAccessible.Role = ...
        Cell: QAccessible.Role = ...
        Link: QAccessible.Role = ...
        HelpBalloon: QAccessible.Role = ...
        Assistant: QAccessible.Role = ...
        List: QAccessible.Role = ...
        ListItem: QAccessible.Role = ...
        Tree: QAccessible.Role = ...
        TreeItem: QAccessible.Role = ...
        PageTab: QAccessible.Role = ...
        PropertyPage: QAccessible.Role = ...
        Indicator: QAccessible.Role = ...
        Graphic: QAccessible.Role = ...
        StaticText: QAccessible.Role = ...
        EditableText: QAccessible.Role = ...
        Button: QAccessible.Role = ...
        PushButton: QAccessible.Role = ...
        CheckBox: QAccessible.Role = ...
        RadioButton: QAccessible.Role = ...
        ComboBox: QAccessible.Role = ...
        ProgressBar: QAccessible.Role = ...
        Dial: QAccessible.Role = ...
        HotkeyField: QAccessible.Role = ...
        Slider: QAccessible.Role = ...
        SpinBox: QAccessible.Role = ...
        Canvas: QAccessible.Role = ...
        Animation: QAccessible.Role = ...
        Equation: QAccessible.Role = ...
        ButtonDropDown: QAccessible.Role = ...
        ButtonMenu: QAccessible.Role = ...
        ButtonDropGrid: QAccessible.Role = ...
        Whitespace: QAccessible.Role = ...
        PageTabList: QAccessible.Role = ...
        Clock: QAccessible.Role = ...
        Splitter: QAccessible.Role = ...
        LayeredPane: QAccessible.Role = ...
        Terminal: QAccessible.Role = ...
        Desktop: QAccessible.Role = ...
        Paragraph: QAccessible.Role = ...
        WebDocument: QAccessible.Role = ...
        Section: QAccessible.Role = ...
        Notification: QAccessible.Role = ...
        ColorChooser: QAccessible.Role = ...
        Footer: QAccessible.Role = ...
        Form: QAccessible.Role = ...
        Heading: QAccessible.Role = ...
        Note: QAccessible.Role = ...
        ComplementaryContent: QAccessible.Role = ...
        UserRole: QAccessible.Role = ...

    class State(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, State: PySide6.QtGui.QAccessible.State) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class Text(Enum):
        Name: QAccessible.Text = ...
        Description: QAccessible.Text = ...
        Value: QAccessible.Text = ...
        Help: QAccessible.Text = ...
        Accelerator: QAccessible.Text = ...
        DebugDescription: QAccessible.Text = ...
        UserText: QAccessible.Text = ...

    class TextBoundaryType(Enum):
        CharBoundary: QAccessible.TextBoundaryType = ...
        WordBoundary: QAccessible.TextBoundaryType = ...
        SentenceBoundary: QAccessible.TextBoundaryType = ...
        ParagraphBoundary: QAccessible.TextBoundaryType = ...
        LineBoundary: QAccessible.TextBoundaryType = ...
        NoBoundary: QAccessible.TextBoundaryType = ...

    def __init__(self, QAccessible: PySide6.QtGui.QAccessible) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def accessibleInterface(uniqueId: int) -> PySide6.QtGui.QAccessibleInterface:
        """
        https://doc.qt.io/qt-6/qaccessible.html#accessibleInterface

        **[static] QAccessibleInterface
        *QAccessible::accessibleInterface(QAccessible::Id id )**

        Returns the **QAccessibleInterface**  belonging to the **id**.

        Returns `nullptr` if the id is invalid.
        """
        ...

    @staticmethod
    def cleanup() -> None:
        ...

    @staticmethod
    def deleteAccessibleInterface(uniqueId: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessible.html#deleteAccessibleInterface

        **[static] void QAccessible::deleteAccessibleInterface(QAccessible::Id
        id )**

        Removes the interface belonging to this **id** from the cache and
        deletes it. The id becomes invalid an may be re-used by the cache.
        """
        ...

    @staticmethod
    def installFactory(arg__1: Callable) -> None:
        """
        https://doc.qt.io/qt-6/qaccessible.html#installFactory

        **[static] void
        QAccessible::installFactory(QAccessible::InterfaceFactory factory )**

        Installs the **InterfaceFactory**  **factory**. The last factory added
        is the first one used by **queryAccessibleInterface** ().
        """
        ...

    @staticmethod
    def isActive() -> bool:
        """
        https://doc.qt.io/qt-6/qaccessible.html#isActive

        **[static] bool QAccessible::isActive()**

        Returns `true` if the platform requested accessibility information.

        This function will return false until a tool such as a screen reader
        accessed the accessibility framework. It is still possible to use
        **QAccessible::queryAccessibleInterface** () even if accessibility is
        not active. But there will be no notifications sent to the platform.

        It is recommended to use this function to prevent expensive
        notifications via **updateAccessibility** () when they are not needed.
        """
        ...

    @staticmethod
    def qAccessibleTextBoundaryHelper(
        cursor: PySide6.QtGui.QTextCursor,
        boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType,
    ) -> Tuple[int, int]:
        ...

    @staticmethod
    def queryAccessibleInterface(
        arg__1: PySide6.QtCore.QObject,
    ) -> PySide6.QtGui.QAccessibleInterface:
        """
        https://doc.qt.io/qt-6/qaccessible.html#queryAccessibleInterface

        **[static] QAccessibleInterface
        *QAccessible::queryAccessibleInterface(QObject * object )**

        If a **QAccessibleInterface**  implementation exists for the given
        **object** , this function returns a pointer to the implementation;
        otherwise it returns `nullptr`.

        The function calls all installed factory functions (from most recently
        installed to least recently installed) until one is found that provides
        an interface for the class of **object**. If no factory can provide an
        accessibility implementation for the class the function loads installed
        accessibility plugins, and tests if any of the plugins can provide the
        implementation.

        If no implementation for the object's class is available, the function
        tries to find an implementation for the object's parent class, using the
        above strategy.

        All interfaces are managed by an internal cache and should not be
        deleted.
        """
        ...

    @staticmethod
    def registerAccessibleInterface(iface: PySide6.QtGui.QAccessibleInterface) -> int:
        """
        https://doc.qt.io/qt-6/qaccessible.html#registerAccessibleInterface

        **[static] QAccessible::Id
        QAccessible::registerAccessibleInterface(QAccessibleInterface * iface
        )**

        Call this function to ensure that manually created interfaces are
        properly memory managed.

        Must only be called exactly once per interface **iface**. This is
        implicitly called when calling **queryAccessibleInterface** , calling
        this function is only required when QAccessibleInterfaces are
        instantiated with the "new" operator. This is not recommended, whenever
        possible use the default functions and let **queryAccessibleInterface**
        () take care of this.

        When it is necessary to reimplement the **QAccessibleInterface::child**
        () function and returning the child after constructing it, this function
        needs to be called.
        """
        ...

    @staticmethod
    def setActive(active: bool) -> None:
        ...

    @staticmethod
    def setRootObject(object: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qaccessible.html#setRootObject

        **[static] void QAccessible::setRootObject(QObject * object )**

        Sets the root object of the accessible objects of this application to
        **object**. All other accessible objects are reachable using object
        navigation from the root object.

        Normally, it isn't necessary to call this function, because Qt sets the
        **QApplication**  object as the root object immediately before the event
        loop is entered in **QApplication::exec** ().

        Use QAccessible::installRootObjectHandler() to redirect the function
        call to a customized handler function.

        **See also** **queryAccessibleInterface** ().
        """
        ...

    @staticmethod
    def uniqueId(iface: PySide6.QtGui.QAccessibleInterface) -> int:
        """
        https://doc.qt.io/qt-6/qaccessible.html#uniqueId

        **[static] QAccessible::Id QAccessible::uniqueId(QAccessibleInterface *
        iface )**

        Returns the unique ID for the **QAccessibleInterface**  **iface**.
        """
        ...

    @staticmethod
    def updateAccessibility(event: PySide6.QtGui.QAccessibleEvent) -> None:
        """
        https://doc.qt.io/qt-6/qaccessible.html#updateAccessibility

        **[static] void QAccessible::updateAccessibility(QAccessibleEvent *
        event )**

        Notifies about a change that might be relevant for accessibility
        clients.

        **event** provides details about the change. These include the source of
        the change and the nature of the change. The **event** should contain
        enough information give meaningful notifications.

        For example, the type `ValueChange` indicates that the position of a
        slider has been changed.

        Call this function whenever the state of your accessible object or one
        of its sub-elements has been changed either programmatically (e.g. by
        calling **QLabel::setText** ()) or by user interaction.

        If there are no accessibility tools listening to this event, the
        performance penalty for calling this function is small, but if
        determining the parameters of the call is expensive you can test
        **QAccessible::isActive** () to avoid unnecessary computation.
        """
        ...
