"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAbstractTextDocumentLayout(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html

    **Detailed Description**

    The standard layout provided by Qt can handle simple word processing
    including inline images, lists and tables.

    Some applications, e.g., a word processor or a DTP application might need
    more features than the ones provided by Qt's layout engine, in which case
    you can subclass QAbstractTextDocumentLayout to provide custom layout
    behavior for your text documents.

    An instance of the QAbstractTextDocumentLayout subclass can be installed on
    a **QTextDocument**  object with the **setDocumentLayout** () function.

    You can insert custom objects into a **QTextDocument** ; see the
    **QTextObjectInterface**  class description for details.

    **See also** **QTextObjectInterface** .
    """

    class PaintContext(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, PaintContext: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class Selection(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, Selection: PySide6.QtGui.QAbstractTextDocumentLayout.Selection
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#QAbstractTextDoc
        umentLayout

        **QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument
        * document )**

        Creates a new text document layout for the given **document**.
        """
        ...

    def anchorAt(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> str:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#anchorAt

        **QString QAbstractTextDocumentLayout::anchorAt(const QPointF & position
        ) const**

        Returns the reference of the anchor the given **position** , or an empty
        string if no anchor exists at that point.
        """
        ...

    def blockBoundingRect(
        self, block: PySide6.QtGui.QTextBlock
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#blockBoundingRec
        t

        **[pure virtual] QRectF
        QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock & block
        ) const**

        Returns the bounding rectangle of **block**.
        """
        ...

    def blockWithMarkerAt(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#blockWithMarkerA
        t

        **[since 5.14] QTextBlock
        QAbstractTextDocumentLayout::blockWithMarkerAt(const QPointF & pos )
        const**

        Returns the block (probably a list item) whose **marker**  is found at
        the given position **pos**.

        This function was introduced in Qt 5.14.
        """
        ...

    def document(self) -> PySide6.QtGui.QTextDocument:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#document

        **QTextDocument *QAbstractTextDocumentLayout::document() const**

        Returns the text document that this layout is operating on.
        """
        ...

    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#documentChanged

        **[pure virtual protected] void
        QAbstractTextDocumentLayout::documentChanged(int position , int
        charsRemoved , int charsAdded )**

        This function is called whenever the contents of the document change. A
        change occurs when text is inserted, removed, or a combination of these
        two. The change is specified by **position** , **charsRemoved** , and
        **charsAdded** corresponding to the starting character position of the
        change, the number of characters removed from the document, and the
        number of characters added.

        For example, when inserting the text "Hello" into an empty document,
        **charsRemoved** would be 0 and **charsAdded** would be 5 (the length of
        the string).

        Replacing text is a combination of removing and inserting. For example,
        if the text "Hello" gets replaced by "Hi", **charsRemoved** would be 5
        and **charsAdded** would be 2.

        For subclasses of **QAbstractTextDocumentLayout** , this is the central
        function where a large portion of the work to lay out and position
        document contents is done.

        For example, in a subclass that only arranges blocks of text, an
        implementation of this function would have to do the following:

        * Determine the list of changed **QTextBlock** (s) using the parameters
        provided.
          * Each **QTextBlock**  object's corresponding
        **QTextLayout**  object needs to be processed. You can access the
        **QTextBlock** 's layout using the **QTextBlock::layout** () function.
        This processing should take the document's page size into consideration.
        * If the total number of pages changed, the **pageCountChanged** ()
        signal should be emitted.
          * If the total size changed, the
        **documentSizeChanged** () signal should be emitted.
          * The **update**
        () signal should be emitted to schedule a repaint of areas in the layout
        that require repainting.

        **See also** **QTextLayout** .
        """
        ...

    def documentSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#documentSize

        **[pure virtual] QSizeF QAbstractTextDocumentLayout::documentSize()
        const**

        Returns the total size of the document's layout.

        This information can be used by display widgets to update their scroll
        bars correctly.

        **See also** **documentSizeChanged** () and **QTextDocument::pageSize**
        .
        """
        ...

    def draw(
        self,
        painter: PySide6.QtGui.QPainter,
        context: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#draw

        **[pure virtual] void QAbstractTextDocumentLayout::draw(QPainter *
        painter , const QAbstractTextDocumentLayout::PaintContext & context )**

        Draws the layout with the given **painter** using the given **context**.
        """
        ...

    def drawInlineObject(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        object: PySide6.QtGui.QTextInlineObject,
        posInDocument: int,
        format: PySide6.QtGui.QTextFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#drawInlineObject

        **[virtual protected] void
        QAbstractTextDocumentLayout::drawInlineObject(QPainter * painter , const
        QRectF & rect , QTextInlineObject object , int posInDocument , const
        QTextFormat & format )**

        This function is called to draw the inline object, **object** , with the
        given **painter** within the rectangle specified by **rect** using the
        specified text **format**.

        **posInDocument** specifies the position of the object within the
        document.

        The default implementation calls drawObject() on the object handlers.
        This function is called only within Qt. Subclasses can reimplement this
        function to customize the drawing of inline objects.

        **See also** **draw** ().
        """
        ...

    def format(self, pos: int) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#format

        **[protected] QTextCharFormat QAbstractTextDocumentLayout::format(int
        position )**

        Returns the character format that is applicable at the given
        **position**.
        """
        ...

    def formatAt(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtGui.QTextFormat:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#formatAt

        **[since 5.8] QTextFormat QAbstractTextDocumentLayout::formatAt(const
        QPointF & pos ) const**

        Returns the text format at the given position **pos**.

        This function was introduced in Qt 5.8.
        """
        ...

    def formatIndex(self, pos: int) -> int:
        ...

    def frameBoundingRect(
        self, frame: PySide6.QtGui.QTextFrame
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#frameBoundingRec
        t

        **[pure virtual] QRectF
        QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame * frame )
        const**

        Returns the bounding rectangle of **frame**.
        """
        ...

    def handlerForObject(self, objectType: int) -> PySide6.QtGui.QTextObjectInterface:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#handlerForObject

        **QTextObjectInterface
        *QAbstractTextDocumentLayout::handlerForObject(int objectType ) const**

        Returns a handler for objects of the given **objectType**.
        """
        ...

    def hitTest(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        accuracy: PySide6.QtCore.Qt.HitTestAccuracy,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#hitTest

        **[pure virtual] int QAbstractTextDocumentLayout::hitTest(const QPointF
        & point , Qt::HitTestAccuracy accuracy ) const**

        Returns the cursor position for the given **point** with the specified
        **accuracy**. Returns -1 if no valid cursor position was found.
        """
        ...

    def imageAt(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> str:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#imageAt

        **[since 5.8] QString QAbstractTextDocumentLayout::imageAt(const QPointF
        & pos ) const**

        Returns the source of the image at the given position **pos** , or an
        empty string if no image exists at that point.

        This function was introduced in Qt 5.8.
        """
        ...

    def pageCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#pageCount

        **[pure virtual] int QAbstractTextDocumentLayout::pageCount() const**

        Returns the number of pages contained in the layout.

        **See also** **pageCountChanged** ().
        """
        ...

    def paintDevice(self) -> PySide6.QtGui.QPaintDevice:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#paintDevice

        **QPaintDevice *QAbstractTextDocumentLayout::paintDevice() const**

        Returns the paint device used to render the document's layout.

        **See also** **setPaintDevice** ().
        """
        ...

    def positionInlineObject(
        self,
        item: PySide6.QtGui.QTextInlineObject,
        posInDocument: int,
        format: PySide6.QtGui.QTextFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#positionInlineOb
        ject

        **[virtual protected] void
        QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item
        , int posInDocument , const QTextFormat & format )**

        Lays out the inline object **item** using the given text **format**.

        **posInDocument** specifies the position of the object within the
        document.

        The default implementation does nothing. This function is called only
        within Qt. Subclasses can reimplement this function to customize the
        position of inline objects.

        **See also** **drawInlineObject** ().
        """
        ...

    def registerHandler(
        self, objectType: int, component: PySide6.QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#registerHandler

        **void QAbstractTextDocumentLayout::registerHandler(int objectType ,
        QObject * component )**

        Registers the given **component** as a handler for items of the given
        **objectType**.

        **Note:** registerHandler() has to be called once for each object type.
        This means that there is only one handler for multiple replacement
        characters of the same object type.

        The text document layout does not take ownership of `component`.
        """
        ...

    def resizeInlineObject(
        self,
        item: PySide6.QtGui.QTextInlineObject,
        posInDocument: int,
        format: PySide6.QtGui.QTextFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#resizeInlineObje
        ct

        **[virtual protected] void
        QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item ,
        int posInDocument , const QTextFormat & format )**

        Sets the size of the inline object **item** corresponding to the text
        **format**.

        **posInDocument** specifies the position of the object within the
        document.

        The default implementation resizes the **item** to the size returned by
        the object handler's intrinsicSize() function. This function is called
        only within Qt. Subclasses can reimplement this function to customize
        the resizing of inline objects.
        """
        ...

    def setPaintDevice(self, device: PySide6.QtGui.QPaintDevice) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#setPaintDevice

        **void QAbstractTextDocumentLayout::setPaintDevice(QPaintDevice * device
        )**

        Sets the paint device used for rendering the document's layout to the
        given **device**.

        **See also** **paintDevice** ().
        """
        ...

    def unregisterHandler(
        self, objectType: int, component: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#unregisterHandle
        r

        **[since 5.2] void QAbstractTextDocumentLayout::unregisterHandler(int
        objectType , QObject * component = nullptr)**

        Unregisters the given **component** as a handler for items of the given
        **objectType** , or any handler if the **component** is not specified.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def documentSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#documentSizeChan
        ged

        **[signal] void QAbstractTextDocumentLayout::documentSizeChanged(const
        QSizeF & newSize )**

        This signal is emitted when the size of the document layout changes to
        **newSize**.

        Subclasses of **QAbstractTextDocumentLayout**  should emit this signal
        when the document's entire layout size changes. This signal is useful
        for widgets that display text documents since it enables them to update
        their scroll bars correctly.

        **See also** **documentSize** ().
        """
        ...

    @property
    def pageCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#pageCountChanged

        **[signal] void QAbstractTextDocumentLayout::pageCountChanged(int
        newPages )**

        This signal is emitted when the number of pages in the layout changes;
        **newPages** is the updated page count.

        Subclasses of **QAbstractTextDocumentLayout**  should emit this signal
        when the number of pages in the layout has changed. Changes to the page
        count are caused by changes to the layout or the document content
        itself.

        **See also** **pageCount** ().
        """
        ...

    @property
    def update(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#update

        **[signal] void QAbstractTextDocumentLayout::update(const QRectF & rect
        = QRectF(0., 0., 1000000000., 1000000000.))**

        This signal is emitted when the rectangle **rect** has been updated.

        Subclasses of **QAbstractTextDocumentLayout**  should emit this signal
        when the layout of the contents change in order to repaint.
        """
        ...

    @property
    def updateBlock(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstracttextdocumentlayout.html#updateBlock

        **[signal] void QAbstractTextDocumentLayout::updateBlock(const
        QTextBlock & block )**

        This signal is emitted when the specified **block** has been updated.

        Subclasses of **QAbstractTextDocumentLayout**  should emit this signal
        when the layout of **block** has changed in order to repaint.
        """
        ...
