"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAbstractFileIconProvider(object):
    """
    https://doc.qt.io/qt-6/qabstractfileiconprovider.html

    **Detailed Description**
    """

    Computer: QAbstractFileIconProvider.IconType = ...
    Desktop: QAbstractFileIconProvider.IconType = ...
    Trashcan: QAbstractFileIconProvider.IconType = ...
    Network: QAbstractFileIconProvider.IconType = ...
    Drive: QAbstractFileIconProvider.IconType = ...
    Folder: QAbstractFileIconProvider.IconType = ...
    File: QAbstractFileIconProvider.IconType = ...
    DontUseCustomDirectoryIcons: QAbstractFileIconProvider.Option = ...

    class IconType(Enum):
        Computer: QAbstractFileIconProvider.IconType = ...
        Desktop: QAbstractFileIconProvider.IconType = ...
        Trashcan: QAbstractFileIconProvider.IconType = ...
        Network: QAbstractFileIconProvider.IconType = ...
        Drive: QAbstractFileIconProvider.IconType = ...
        Folder: QAbstractFileIconProvider.IconType = ...
        File: QAbstractFileIconProvider.IconType = ...

    class Option(Enum):
        DontUseCustomDirectoryIcons: QAbstractFileIconProvider.Option = ...

    class Options(object):
        ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractfileiconprovider.html#QAbstractFileIconP
        rovider

        **QAbstractFileIconProvider::QAbstractFileIconProvider()**

        Constructs a file icon provider.
        """
        ...

    @overload
    def icon(self, arg__1: PySide6.QtCore.QFileInfo) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qabstractfileiconprovider.html#icon

        **[virtual] QIcon
        QAbstractFileIconProvider::icon(QAbstractFileIconProvider::IconType type
        ) const**

        Returns an icon set for the given **type** , using the current icon
        theme.

        **See also** **QIcon::fromTheme** .
        """
        ...

    @overload
    def icon(
        self, arg__1: PySide6.QtGui.QAbstractFileIconProvider.IconType
    ) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qabstractfileiconprovider.html#icon-1

        **[virtual] QIcon QAbstractFileIconProvider::icon(const QFileInfo & info
        ) const**

        Returns an icon for the file described by **info** , using the current
        icon theme.

        **See also** **QIcon::fromTheme** .
        """
        ...

    def options(self) -> PySide6.QtGui.QAbstractFileIconProvider.Options:
        """
        https://doc.qt.io/qt-6/qabstractfileiconprovider.html#options

        **[virtual] QAbstractFileIconProvider::Options
        QAbstractFileIconProvider::options() const**

        Returns all the options that affect the icon provider. By default, all
        options are disabled.

        **See also** **setOptions** ().
        """
        ...

    def setOptions(
        self, arg__1: PySide6.QtGui.QAbstractFileIconProvider.Options
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractfileiconprovider.html#setOptions

        **[virtual] void
        QAbstractFileIconProvider::setOptions(QAbstractFileIconProvider::Options
        options )**

        Sets **options** that affect the icon provider.

        **See also** **options** ().
        """
        ...

    def type(self, arg__1: PySide6.QtCore.QFileInfo) -> str:
        """
        https://doc.qt.io/qt-6/qabstractfileiconprovider.html#type

        **[virtual] QString QAbstractFileIconProvider::type(const QFileInfo &
        info ) const**

        Returns the type of the file described by **info**.
        """
        ...
