"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from typing import List, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtDesigner

bytes = str


class QFormBuilder(PySide6.QtDesigner.QAbstractFormBuilder):
    """
    https://doc.qt.io/qt-6/qformbuilder.html

    **Detailed Description**

    The QFormBuilder class provides a mechanism for dynamically creating user
    interfaces at run-time, based on UI files created with **Qt Designer**. For
    example:

    MyForm::MyForm(**QWidget**  *parent)
                    : **QWidget** (parent)
    {
                    **QFormBuilder**  builder;
                    **QFile**
    file(":/forms/myWidget.ui");
                    file.open(**QFile**
    ::ReadOnly);
                    **QWidget**  *myWidget = builder.load(&file,
    this);
                    file.close();

                    **QVBoxLayout**
    *layout = new **QVBoxLayout** ;
                    layout->addWidget(myWidget);
    setLayout(layout);
                }

    By including the user interface in the example's resources (`myForm.qrc`),
    we ensure that it will be present when the example is run:

    <!DOCTYPE RCC><RCC version="1.0">
            <qresource prefix="/forms">
    <file>mywidget.ui</file>
            </qresource>
            </RCC>

    QFormBuilder extends the **QAbstractFormBuilder**  base class with a number
    of functions that are used to support custom widget plugins:

    * **pluginPaths** () returns the list of paths that the form builder
    searches when loading custom widget plugins.
      * **addPluginPath** () allows
    additional paths to be registered with the form builder.
      *
    **setPluginPath** () is used to replace the existing list of paths with a
    list obtained from some other source.
      * **clearPluginPaths** () removes
    all paths registered with the form builder.
      * **customWidgets** () returns
    a list of interfaces to plugins that can be used to create new instances of
    registered custom widgets.

    The QFormBuilder class is typically used by custom components and
    applications that embed **Qt Designer**. Standalone applications that need
    to dynamically generate user interfaces at run-time use the **QUiLoader**
    class, found in the **QtUiTools**  module.

    **See also** **QAbstractFormBuilder**  and **Qt UI Tools** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qformbuilder.html#QFormBuilder

        **QFormBuilder::QFormBuilder()**

        Constructs a new form builder.
        """
        ...

    def addPluginPath(self, pluginPath: str) -> None:
        """
        https://doc.qt.io/qt-6/qformbuilder.html#addPluginPath

        **void QFormBuilder::addPluginPath(const QString & pluginPath )**

        Adds a new plugin path specified by **pluginPath** to the list of paths
        that will be searched by the form builder when loading a custom widget
        plugin.

        **See also** **setPluginPath** () and **clearPluginPaths** ().
        """
        ...

    def clearPluginPaths(self) -> None:
        """
        https://doc.qt.io/qt-6/qformbuilder.html#clearPluginPaths

        **void QFormBuilder::clearPluginPaths()**

        Clears the list of paths that the form builder uses to search for custom
        widget plugins.

        **See also** **pluginPaths** ().
        """
        ...

    def createLayout(
        self, layoutName: str, parent: PySide6.QtCore.QObject, name: str
    ) -> PySide6.QtWidgets.QLayout:
        ...

    def createWidget(
        self, widgetName: str, parentWidget: PySide6.QtWidgets.QWidget, name: str
    ) -> PySide6.QtWidgets.QWidget:
        ...

    def customWidgets(self) -> List[PySide6.QtDesigner.QDesignerCustomWidgetInterface]:
        """
        https://doc.qt.io/qt-6/qformbuilder.html#customWidgets

        **QList<QDesignerCustomWidgetInterface *> QFormBuilder::customWidgets()
        const**

        Returns a list of the available plugins.
        """
        ...

    def pluginPaths(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qformbuilder.html#pluginPaths

        **QStringList QFormBuilder::pluginPaths() const**

        Returns the list of paths the form builder searches for plugins.

        **See also** **addPluginPath** ().
        """
        ...

    def setPluginPath(self, pluginPaths: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qformbuilder.html#setPluginPath

        **void QFormBuilder::setPluginPath(const QStringList & pluginPaths )**

        Sets the list of plugin paths to the list specified by **pluginPaths**.

        **See also** **addPluginPath** ().
        """
        ...

    def updateCustomWidgets(self) -> None:
        ...

    @staticmethod
    def widgetByName(
        topLevel: PySide6.QtWidgets.QWidget, name: str
    ) -> PySide6.QtWidgets.QWidget:
        ...
