"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from typing import Any

bytes = str


class QDesignerPropertySheetExtension(object):
    """
    https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html

    **Detailed Description**

    QDesignerPropertySheetExtension provides a collection of functions that are
    typically used to query a widget's properties, and to manipulate the
    properties' appearance in the property editor. For example:

    QDesignerPropertySheetExtension *propertySheet  = 0;
    **QExtensionManager**  manager = formEditor->extensionManager();
    propertySheet = qt_extension<QDesignerPropertySheetExtension*>(manager,
    widget);
        int index = propertySheet->indexOf(QLatin1String("margin"));
    propertySheet->setProperty(index, 10);
        propertySheet->setChanged(index,
    true);

        delete propertySheet;

    Note that if you change the value of a property using the
    **QDesignerPropertySheetExtension::setProperty** () function, the undo stack
    is not updated. To ensure that a property's value can be reverted using the
    undo stack, you must use the
    **QDesignerFormWindowCursorInterface::setProperty** () function, or its
    buddy **setWidgetProperty** (), instead.

    When implementing a custom widget plugin, a pointer to **Qt Designer** 's
    current **QDesignerFormEditorInterface**  object (`formEditor` in the
    example above) is provided by the
    **QDesignerCustomWidgetInterface::initialize** () function's parameter.

    The property sheet, or any other extension, can be retrieved by querying
    **Qt Designer** 's extension manager using the **qt_extension** () function.
    When you want to release the extension, you only need to delete the pointer.

    All widgets have a default property sheet which populates **Qt Designer** 's
    property editor with the widget's properties (i.e the ones defined with the
    **Q_PROPERTY** () macro). But QDesignerPropertySheetExtension also provides
    an interface for creating custom property sheet extensions.

    Keep the following limitations in mind:

    * **Qt Designer** uses the QDesignerPropertySheetExtension to feed its
    property editor. Whenever a widget is selected in its workspace, **Qt
    Designer** will query for the widget's property sheet extension. If the
    selected widget has an implemented property sheet extension, this extension
    will override the default property sheet.
      * The data types used by the
    property sheet for some properties are opaque custom **QVariant**  types
    containing additional information instead of plain Qt data types. For
    example, this is the case for enumerations, flags, icons, pixmaps and
    strings.
      * **Qt Designer** 's property editor has no implementation for
    handling **Q_PROPERTY**  types for custom types that have been declared with
    **Q_DECLARE_METATYPE** ().

    To create a property sheet extension, your extension class must inherit from
    both **QObject**  and QDesignerPropertySheetExtension. Then, since we are
    implementing an interface, we must ensure that it's made known to the meta
    object system using the **Q_INTERFACES** () macro:

    class MyPropertySheetExtension : public **QObject** ,
                public
    QDesignerPropertySheetExtension
        {
            Q_OBJECT
    Q_INTERFACES(QDesignerPropertySheetExtension)

        public:
            ...
    }

    This enables **Qt Designer** to use **qobject_cast** () to query for
    supported interfaces using nothing but a **QObject**  pointer.

    In **Qt Designer** the extensions are not created until they are required.
    For that reason, when implementing a property sheet extension, you must also
    create a **QExtensionFactory** , i.e a class that is able to make an
    instance of your extension, and register it using **Qt Designer** 's
    **extension manager** .

    When a property sheet extension is required, **Qt Designer** 's **extension
    manager**  will run through all its registered factories calling
    **QExtensionFactory::createExtension** () for each until the first one that
    is able to create a property sheet extension for the selected widget, is
    found. This factory will then make an instance of the extension. If no such
    factory can be found, **Qt Designer** will use the default property sheet.

    There are four available types of extensions in **Qt Designer** :
    **QDesignerContainerExtension** , **QDesignerMemberSheetExtension** ,
    QDesignerPropertySheetExtension and **QDesignerTaskMenuExtension** . Qt
    Designer's behavior is the same whether the requested extension is
    associated with a multi page container, a member sheet, a property sheet or
    a task menu.

    The **QExtensionFactory**  class provides a standard extension factory, and
    can also be used as an interface for custom extension factories. You can
    either create a new **QExtensionFactory**  and reimplement the
    **QExtensionFactory::createExtension** () function. For example:

    **QObject**  *ANewExtensionFactory::createExtension(**QObject**  *object,
    const **QString**  &iid, **QObject**  *parent) const
        {
            if (iid
    != Q_TYPEID(QDesignerPropertySheetExtension))
                return 0;
    if (MyCustomWidget *widget = qobject_cast<MyCustomWidget*>
    (object))
                return new MyPropertySheetExtension(widget, parent);
    return 0;
        }

    Or you can use an existing factory, expanding the
    **QExtensionFactory::createExtension** () function to make the factory able
    to create a property sheet extension extension as well. For example:

    **QObject**  *AGeneralExtensionFactory::createExtension(**QObject**
    *object,
                const **QString**  &iid, **QObject**  *parent) const
    {
            MyCustomWidget *widget = qobject_cast<MyCustomWidget*>(object);
    if (widget && (iid == Q_TYPEID(**QDesignerTaskMenuExtension** ))) {
    return new MyTaskMenuExtension(widget, parent);

            } else if
    (widget && (iid == Q_TYPEID(QDesignerPropertySheetExtension))) {
    return new MyPropertySheetExtension(widget, parent);

            } else {
    return 0;
            }
        }

    For a complete example using an extension class, see the **Task Menu
    Extension example** . The example shows how to create a custom widget plugin
    for Qt Designer, and how to to use the **QDesignerTaskMenuExtension**  class
    to add custom items to **Qt Designer** 's task menu.

    **See also** **QDesignerDynamicPropertySheetExtension** ,
    **QExtensionFactory** , **QExtensionManager** , and **Creating Custom Widget
    Extensions** .
    """

    def __init__(self) -> None:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#count

        **[pure virtual] int QDesignerPropertySheetExtension::count() const**

        Returns the selected widget's number of properties.
        """
        ...

    def hasReset(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#hasReset

        **[pure virtual] bool QDesignerPropertySheetExtension::hasReset(int
        index ) const**

        Returns true if the property at the given **index** has a reset button
        in **Qt Designer** 's property editor, otherwise false.

        **See also** **indexOf** () and **reset** ().
        """
        ...

    def indexOf(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#indexOf

        **[pure virtual] int QDesignerPropertySheetExtension::indexOf(const
        QString & name ) const**

        Returns the index for a given property **name**.

        **See also** **propertyName** ().
        """
        ...

    def isAttribute(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#isAttribute

        **[pure virtual] bool QDesignerPropertySheetExtension::isAttribute(int
        index ) const**

        Returns true if the property at the given **index** is an attribute,
        which will be **excluded** from the UI file, otherwise false.

        **See also** **indexOf** () and **setAttribute** ().
        """
        ...

    def isChanged(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#isChanged

        **[pure virtual] bool QDesignerPropertySheetExtension::isChanged(int
        index ) const**

        Returns true if the value of the property at the given **index** differs
        from the property's default value, otherwise false.

        **See also** **indexOf** (), **setChanged** (), and **reset** ().
        """
        ...

    def isEnabled(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#isEnabled

        **[pure virtual, since 5.0] bool
        QDesignerPropertySheetExtension::isEnabled(int index ) const**

        Returns true if the property at the given **index** is enabled in **Qt
        Designer** 's property editor, otherwise false.

        This function was introduced in Qt 5.0.

        **See also** **indexOf** ().
        """
        ...

    def isVisible(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#isVisible

        **[pure virtual] bool QDesignerPropertySheetExtension::isVisible(int
        index ) const**

        Returns true if the property at the given **index** is visible in **Qt
        Designer** 's property editor, otherwise false.

        **See also** **indexOf** () and **setVisible** ().
        """
        ...

    def property(self, index: int) -> Any:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#property

        **[pure virtual] QVariant QDesignerPropertySheetExtension::property(int
        index ) const**

        Returns the value of the property at the given **index**.

        **See also** **indexOf** (), **setProperty** (), and **propertyGroup**
        ().
        """
        ...

    def propertyGroup(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#propertyGrou
        p

        **[pure virtual] QString
        QDesignerPropertySheetExtension::propertyGroup(int index ) const**

        Returns the property group for the property at the given **index**.

        **Qt Designer** 's property editor supports property groups, i.e.
        sections of related properties. A property can be related to a group
        using the **setPropertyGroup** () function. The default group of any
        property is the name of the class that defines it. For example, the
        **QObject::objectName**  property appears within the **QObject**
        property group.

        **See also** **indexOf** () and **setPropertyGroup** ().
        """
        ...

    def propertyName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#propertyName

        **[pure virtual] QString
        QDesignerPropertySheetExtension::propertyName(int index ) const**

        Returns the name of the property at the given **index**.

        **See also** **indexOf** ().
        """
        ...

    def reset(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#reset

        **[pure virtual] bool QDesignerPropertySheetExtension::reset(int index
        )**

        Resets the value of the property at the given **index** , to the default
        value. Returns true if a default value could be found, otherwise false.

        **See also** **indexOf** (), **hasReset** (), and **isChanged** ().
        """
        ...

    def setAttribute(self, index: int, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#setAttribute

        **[pure virtual] void QDesignerPropertySheetExtension::setAttribute(int
        index , bool attribute )**

        If **attribute** is true, the property at the given **index** is made an
        attribute which will be **excluded** from the UI file; otherwise it will
        be included.

        **See also** **indexOf** () and **isAttribute** ().
        """
        ...

    def setChanged(self, index: int, changed: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#setChanged

        **[pure virtual] void QDesignerPropertySheetExtension::setChanged(int
        index , bool changed )**

        Sets whether the property at the given **index** is different from its
        default value, or not, depending on the **changed** parameter.

        **See also** **indexOf** () and **isChanged** ().
        """
        ...

    def setProperty(self, index: int, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#setProperty

        **[pure virtual] void QDesignerPropertySheetExtension::setProperty(int
        index , const QVariant & value )**

        Sets the **value** of the property at the given **index**.

        **Warning:** If you change the value of a property using this function,
        the undo stack is not updated. To ensure that a property's value can be
        reverted using the undo stack, you must use the
        **QDesignerFormWindowCursorInterface::setProperty** () function, or its
        buddy **setWidgetProperty** (), instead.

        **See also** **indexOf** (), **property** (), and **propertyGroup** ().
        """
        ...

    def setPropertyGroup(self, index: int, group: str) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#setPropertyG
        roup

        **[pure virtual] void
        QDesignerPropertySheetExtension::setPropertyGroup(int index , const
        QString & group )**

        Sets the property group for the property at the given **index** to
        **group**.

        Relating a property to a group makes it appear within that group's
        section in the property editor. The default property group of any
        property is the name of the class that defines it. For example, the
        **QObject::objectName**  property appears within the **QObject**
        property group.

        **See also** **indexOf** (), **property** (), and **propertyGroup** ().
        """
        ...

    def setVisible(self, index: int, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerpropertysheetextension.html#setVisible

        **[pure virtual] void QDesignerPropertySheetExtension::setVisible(int
        index , bool visible )**

        If **visible** is true, the property at the given **index** is visible
        in **Qt Designer** 's property editor; otherwise the property is hidden.

        **See also** **indexOf** () and **isVisible** ().
        """
        ...
