"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from typing import List
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtDesigner

bytes = str


class QDesignerMemberSheetExtension(object):
    """
    https://doc.qt.io/qt-6/qdesignermembersheetextension.html

    **Detailed Description**

    QDesignerMemberSheetExtension is a collection of functions that is typically
    used to query a widget's member functions, and to manipulate the member
    functions' appearance in **Qt Designer** 's signals and slots editing mode.
    For example:

    QDesignerMemberSheetExtension *memberSheet  = 0;
        **QExtensionManager**
    manager = formEditor->extensionManager();

        memberSheet =
    qt_extension<QDesignerMemberSheetExtension*>(manager, widget);
        int index
    = memberSheet->indexOf(setEchoMode);
        memberSheet->setVisible(index,
    false);

        delete memberSheet;

    When implementing a custom widget plugin, a pointer to **Qt Designer** 's
    current **QDesignerFormEditorInterface**  object (`formEditor` in the
    example above) is provided by the
    **QDesignerCustomWidgetInterface::initialize** () function's parameter.

    The member sheet (and any other extension), can be retrieved by querying
    **Qt Designer** 's extension manager using the **qt_extension** () function.
    When you want to release the extension, you only need to delete the pointer.

    All widgets have a default member sheet used in **Qt Designer** 's signals
    and slots editing mode with the widget's member functions. But
    QDesignerMemberSheetExtension also provides an interface for creating custom
    member sheet extensions.

    **Warning:** **Qt Designer** uses the QDesignerMemberSheetExtension to
    facilitate the signal and slot editing mode. Whenever a connection between
    two widgets is requested, **Qt Designer** will query for the widgets' member
    sheet extensions. If a widget has an implemented member sheet extension,
    this extension will override the default member sheet.

    To create a member sheet extension, your extension class must inherit from
    both **QObject**  and QDesignerMemberSheetExtension. Then, since we are
    implementing an interface, we must ensure that it's made known to the meta
    object system using the **Q_INTERFACES** () macro:

    class MyMemberSheetExtension : public **QObject** ,
                public
    QDesignerMemberSheetExtension
        {
            Q_OBJECT
    Q_INTERFACES(QDesignerMemberSheetExtension)

        public:
            ...
    }

    This enables **Qt Designer** to use **qobject_cast** () to query for
    supported interfaces using nothing but a **QObject**  pointer.

    In **Qt Designer** the extensions are not created until they are required.
    For that reason, when implementing a member sheet extension, you must also
    create a **QExtensionFactory** , i.e a class that is able to make an
    instance of your extension, and register it using **Qt Designer** 's
    **extension manager** .

    When a widget's member sheet extension is required, **Qt Designer** 's
    **extension manager**  will run through all its registered factories calling
    **QExtensionFactory::createExtension** () for each until the first one that
    is able to create a member sheet extension for that widget, is found. This
    factory will then make an instance of the extension. If no such factory is
    found, **Qt Designer** will use the default member sheet.

    There are four available types of extensions in **Qt Designer** :
    **QDesignerContainerExtension** , QDesignerMemberSheetExtension,
    **QDesignerPropertySheetExtension**  and **QDesignerTaskMenuExtension** .
    **Qt Designer** 's behavior is the same whether the requested extension is
    associated with a multi page container, a member sheet, a property sheet or
    a task menu.

    The **QExtensionFactory**  class provides a standard extension factory, and
    can also be used as an interface for custom extension factories. You can
    either create a new **QExtensionFactory**  and reimplement the
    **QExtensionFactory::createExtension** () function. For example:

    **QObject**  *ANewExtensionFactory::createExtension(**QObject**  *object,
    const **QString**  &iid, **QObject**  *parent) const
        {
            if (iid
    != Q_TYPEID(QDesignerMemberSheetExtension))
                return 0;
    if (MyCustomWidget *widget = qobject_cast<MyCustomWidget*>
    (object))
                return new MyMemberSheetExtension(widget, parent);
    return 0;
        }

    Or you can use an existing factory, expanding the
    **QExtensionFactory::createExtension** () function to make the factory able
    to create a member sheet extension as well. For example:

    **QObject**  *AGeneralExtensionFactory::createExtension(**QObject**
    *object,
                const **QString**  &iid, **QObject**  *parent) const
    {
            MyCustomWidget *widget = qobject_cast<MyCustomWidget*>(object);
    if (widget && (iid == Q_TYPEID(**QDesignerTaskMenuExtension** ))) {
    return new MyTaskMenuExtension(widget, parent);

            } else if
    (widget && (iid == Q_TYPEID(QDesignerMemberSheetExtension))) {
    return new MyMemberSheetExtension(widget, parent);

            } else {
    return 0;
            }
        }

    For a complete example using an extension class, see **Task Menu Extension
    example** . The example shows how to create a custom widget plugin for Qt
    Designer, and how to to use the **QDesignerTaskMenuExtension**  class to add
    custom items to **Qt Designer** 's task menu.

    **See also** **QExtensionFactory** , **QExtensionManager** , and **Creating
    Custom Widget Extensions** .
    """

    def __init__(self) -> None:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#count

        **[pure virtual] int QDesignerMemberSheetExtension::count() const**

        Returns the extension's number of member functions.
        """
        ...

    def declaredInClass(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#declaredInClas
        s

        **[pure virtual] QString
        QDesignerMemberSheetExtension::declaredInClass(int index ) const**

        Returns the name of the class in which the member function with the
        given **index** is declared.

        **See also** **indexOf** ().
        """
        ...

    def indexOf(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#indexOf

        **[pure virtual] int QDesignerMemberSheetExtension::indexOf(const
        QString & name ) const**

        Returns the index of the member function specified by the given
        **name**.

        **See also** **memberName** ().
        """
        ...

    def inheritedFromWidget(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#inheritedFromW
        idget

        **[pure virtual] bool
        QDesignerMemberSheetExtension::inheritedFromWidget(int index ) const**

        Returns true if the member function with the given **index** is
        inherited from **QWidget** , otherwise false.

        **See also** **indexOf** ().
        """
        ...

    def isSignal(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#isSignal

        **[pure virtual] bool QDesignerMemberSheetExtension::isSignal(int index
        ) const**

        Returns true if the member function with the given **index** is a
        signal, otherwise false.

        **See also** **indexOf** ().
        """
        ...

    def isSlot(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#isSlot

        **[pure virtual] bool QDesignerMemberSheetExtension::isSlot(int index )
        const**

        Returns true if the member function with the given **index** is a slot,
        otherwise false.

        **See also** **indexOf** ().
        """
        ...

    def isVisible(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#isVisible

        **[pure virtual] bool QDesignerMemberSheetExtension::isVisible(int index
        ) const**

        Returns true if the member function with the given **index** is visible
        in **Qt Designer** 's signal and slot editor, otherwise false.

        **See also** **indexOf** () and **setVisible** ().
        """
        ...

    def memberGroup(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#memberGroup

        **[pure virtual] QString QDesignerMemberSheetExtension::memberGroup(int
        index ) const**

        Returns the name of the member group specified for the function with the
        given **index**.

        **See also** **indexOf** () and **setMemberGroup** ().
        """
        ...

    def memberName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#memberName

        **[pure virtual] QString QDesignerMemberSheetExtension::memberName(int
        index ) const**

        Returns the name of the member function with the given **index**.

        **See also** **indexOf** ().
        """
        ...

    def parameterNames(self, index: int) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#parameterNames

        **[pure virtual] QList<QByteArray>
        QDesignerMemberSheetExtension::parameterNames(int index ) const**

        Returns the parameter names of the member function with the given
        **index** , as a **QByteArray**  list.

        **See also** **indexOf** () and **parameterTypes** ().
        """
        ...

    def parameterTypes(self, index: int) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#parameterTypes

        **[pure virtual] QList<QByteArray>
        QDesignerMemberSheetExtension::parameterTypes(int index ) const**

        Returns the parameter types of the member function with the given
        **index** , as a **QByteArray**  list.

        **See also** **indexOf** () and **parameterNames** ().
        """
        ...

    def setMemberGroup(self, index: int, group: str) -> None:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#setMemberGroup

        **[pure virtual] void QDesignerMemberSheetExtension::setMemberGroup(int
        index , const QString & group )**

        Sets the member group of the member function with the given **index** ,
        to **group**.

        **See also** **indexOf** () and **memberGroup** ().
        """
        ...

    def setVisible(self, index: int, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#setVisible

        **[pure virtual] void QDesignerMemberSheetExtension::setVisible(int
        index , bool visible )**

        If **visible** is true, the member function with the given **index** is
        visible in **Qt Designer** 's signals and slots editing mode; otherwise
        the member function is hidden.

        **See also** **indexOf** () and **isVisible** ().
        """
        ...

    def signature(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qdesignermembersheetextension.html#signature

        **[pure virtual] QString QDesignerMemberSheetExtension::signature(int
        index ) const**

        Returns the signature of the member function with the given **index**.

        **See also** **indexOf** ().
        """
        ...
