"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtDesigner

bytes = str


class QDesignerFormWindowManagerInterface(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html

    **Detailed Description**

    QDesignerFormWindowManagerInterface is not intended to be instantiated
    directly. **Qt Designer** uses the form window manager to control the
    various form windows in its workspace. You can retrieve an interface to **Qt
    Designer** 's form window manager using the
    **QDesignerFormEditorInterface::formWindowManager** () function. For
    example:

    **QDesignerFormWindowManagerInterface**  *manager = 0;
    **QDesignerFormWindowInterface**  *formWindow = 0;

                manager
    = formEditor->formWindowManager();
                formWindow =
    manager->formWindow(0);
    manager->setActiveFormWindow(formWindow);

    When implementing a custom widget plugin, a pointer to **Qt Designer** 's
    current **QDesignerFormEditorInterface**  object (`formEditor` in the
    example above) is provided by the
    **QDesignerCustomWidgetInterface::initialize** () function's parameter. You
    must subclass the **QDesignerCustomWidgetInterface**  to expose your plugin
    to Qt Designer.

    The form window manager interface provides the **createFormWindow** ()
    function that enables you to create a new form window which you can add to
    the collection of form windows that the manager maintains, using the
    **addFormWindow** () slot. It also provides the **formWindowCount** ()
    function returning the number of form windows currently under the manager's
    control, the **formWindow** () function returning the form window associated
    with a given index, and the **activeFormWindow** () function returning the
    currently selected form window. The **removeFormWindow** () slot allows you
    to reduce the number of form windows the manager must maintain, and the
    **setActiveFormWindow** () slot allows you to change the form window focus
    in **Qt Designer** 's workspace.

    In addition, QDesignerFormWindowManagerInterface contains a collection of
    functions that enables you to intervene and control **Qt Designer** 's form
    editing actions. All these functions return the original action, making it
    possible to propagate the function further after intervention.

    Finally, the interface provides three signals which are emitted when a form
    window is added, when the currently selected form window changes, or when a
    form window is removed, respectively. All the signals carry the form window
    in question as their parameter.

    **See also** **QDesignerFormEditorInterface**  and
    **QDesignerFormWindowInterface** .
    """

    CutAction: QDesignerFormWindowManagerInterface.Action = ...
    CopyAction: QDesignerFormWindowManagerInterface.Action = ...
    PasteAction: QDesignerFormWindowManagerInterface.Action = ...
    DeleteAction: QDesignerFormWindowManagerInterface.Action = ...
    SelectAllAction: QDesignerFormWindowManagerInterface.Action = ...
    LowerAction: QDesignerFormWindowManagerInterface.Action = ...
    RaiseAction: QDesignerFormWindowManagerInterface.Action = ...
    UndoAction: QDesignerFormWindowManagerInterface.Action = ...
    RedoAction: QDesignerFormWindowManagerInterface.Action = ...
    HorizontalLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
    VerticalLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
    SplitHorizontalAction: QDesignerFormWindowManagerInterface.Action = ...
    SplitVerticalAction: QDesignerFormWindowManagerInterface.Action = ...
    GridLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
    FormLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
    BreakLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
    AdjustSizeAction: QDesignerFormWindowManagerInterface.Action = ...
    SimplifyLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
    DefaultPreviewAction: QDesignerFormWindowManagerInterface.Action = ...
    FormWindowSettingsDialogAction: QDesignerFormWindowManagerInterface.Action = ...
    StyledPreviewActionGroup: QDesignerFormWindowManagerInterface.ActionGroup = ...

    class Action(Enum):
        CutAction: QDesignerFormWindowManagerInterface.Action = ...
        CopyAction: QDesignerFormWindowManagerInterface.Action = ...
        PasteAction: QDesignerFormWindowManagerInterface.Action = ...
        DeleteAction: QDesignerFormWindowManagerInterface.Action = ...
        SelectAllAction: QDesignerFormWindowManagerInterface.Action = ...
        LowerAction: QDesignerFormWindowManagerInterface.Action = ...
        RaiseAction: QDesignerFormWindowManagerInterface.Action = ...
        UndoAction: QDesignerFormWindowManagerInterface.Action = ...
        RedoAction: QDesignerFormWindowManagerInterface.Action = ...
        HorizontalLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
        VerticalLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
        SplitHorizontalAction: QDesignerFormWindowManagerInterface.Action = ...
        SplitVerticalAction: QDesignerFormWindowManagerInterface.Action = ...
        GridLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
        FormLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
        BreakLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
        AdjustSizeAction: QDesignerFormWindowManagerInterface.Action = ...
        SimplifyLayoutAction: QDesignerFormWindowManagerInterface.Action = ...
        DefaultPreviewAction: QDesignerFormWindowManagerInterface.Action = ...
        FormWindowSettingsDialogAction: QDesignerFormWindowManagerInterface.Action = ...

    class ActionGroup(Enum):
        StyledPreviewActionGroup: QDesignerFormWindowManagerInterface.ActionGroup = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#QDesigne
        rFormWindowManagerInterface

        **QDesignerFormWindowManagerInterface::QDesignerFormWindowManagerInterfa
        ce(QObject * parent = nullptr)**

        Constructs an interface with the given **parent** for the form window
        manager.
        """
        ...

    def action(
        self, action: PySide6.QtDesigner.QDesignerFormWindowManagerInterface.Action
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#action

        **[pure virtual, since 5.0] QAction *QDesignerFormWindowManagerInterface
        ::action(QDesignerFormWindowManagerInterface::Action action ) const**

        Returns the action specified by the enumeration value **action**.

        Obsoletes the action accessors of Qt 4.X.

        This function was introduced in Qt 5.0.
        """
        ...

    def actionAdjustSize(self) -> PySide6.QtGui.QAction:
        ...

    def actionBreakLayout(self) -> PySide6.QtGui.QAction:
        ...

    def actionCopy(self) -> PySide6.QtGui.QAction:
        ...

    def actionCut(self) -> PySide6.QtGui.QAction:
        ...

    def actionDelete(self) -> PySide6.QtGui.QAction:
        ...

    def actionFormLayout(self) -> PySide6.QtGui.QAction:
        ...

    def actionGridLayout(self) -> PySide6.QtGui.QAction:
        ...

    def actionGroup(
        self,
        actionGroup: PySide6.QtDesigner.QDesignerFormWindowManagerInterface.ActionGroup,
    ) -> PySide6.QtGui.QActionGroup:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#actionGr
        oup

        **[pure virtual, since 5.0] QActionGroup *QDesignerFormWindowManagerInte
        rface::actionGroup(QDesignerFormWindowManagerInterface::ActionGroup
        actionGroup ) const**

        Returns the action group specified by the enumeration value
        **actionGroup**.

        This function was introduced in Qt 5.0.
        """
        ...

    def actionHorizontalLayout(self) -> PySide6.QtGui.QAction:
        ...

    def actionLower(self) -> PySide6.QtGui.QAction:
        ...

    def actionPaste(self) -> PySide6.QtGui.QAction:
        ...

    def actionRaise(self) -> PySide6.QtGui.QAction:
        ...

    def actionRedo(self) -> PySide6.QtGui.QAction:
        ...

    def actionSelectAll(self) -> PySide6.QtGui.QAction:
        ...

    def actionSimplifyLayout(self) -> PySide6.QtGui.QAction:
        ...

    def actionSplitHorizontal(self) -> PySide6.QtGui.QAction:
        ...

    def actionSplitVertical(self) -> PySide6.QtGui.QAction:
        ...

    def actionUndo(self) -> PySide6.QtGui.QAction:
        ...

    def actionVerticalLayout(self) -> PySide6.QtGui.QAction:
        ...

    def activeFormWindow(self) -> PySide6.QtDesigner.QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#activeFo
        rmWindow

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowManagerInterface::activeFormWindow() const**

        Returns the currently active form window in **Qt Designer** 's
        workspace.

        **See also** **setActiveFormWindow** () and **removeFormWindow** ().
        """
        ...

    def addFormWindow(
        self, formWindow: PySide6.QtDesigner.QDesignerFormWindowInterface
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#addFormW
        indow

        **[pure virtual slot] void QDesignerFormWindowManagerInterface::addFormW
        indow(QDesignerFormWindowInterface * formWindow )**

        Adds the given **formWindow** to the collection of windows that **Qt
        Designer** 's form window manager maintains.

        **See also** **formWindowAdded** ().
        """
        ...

    def closeAllPreviews(self) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#closeAll
        Previews

        **[pure virtual slot, since 5.0] void
        QDesignerFormWindowManagerInterface::closeAllPreviews()**

        Close all currently open previews.

        This function was introduced in Qt 5.0.

        **See also** **showPreview** ().
        """
        ...

    def core(self) -> PySide6.QtDesigner.QDesignerFormEditorInterface:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#core

        **[pure virtual] QDesignerFormEditorInterface
        *QDesignerFormWindowManagerInterface::core() const**

        Returns a pointer to **Qt Designer** 's current
        **QDesignerFormEditorInterface**  object.
        """
        ...

    def createFormWindow(
        self,
        parentWidget: Optional[PySide6.QtWidgets.QWidget] = ...,
        flags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> PySide6.QtDesigner.QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#createFo
        rmWindow

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowManagerInterface::createFormWindow(QWidget * parent
        = nullptr, Qt::WindowFlags flags = Qt::WindowFlags())**

        Creates a form window with the given **parent** and the given window
        **flags**.

        **See also** **addFormWindow** ().
        """
        ...

    def createPreviewPixmap(self) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#createPr
        eviewPixmap

        **[pure virtual] QPixmap
        QDesignerFormWindowManagerInterface::createPreviewPixmap() const**

        Creates a pixmap representing the preview of the currently active form.
        """
        ...

    def dragItems(
        self, item_list: Sequence[PySide6.QtDesigner.QDesignerDnDItemInterface]
    ) -> None:
        ...

    def formWindow(self, index: int) -> PySide6.QtDesigner.QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#formWind
        ow

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowManagerInterface::formWindow(int index ) const**

        Returns the form window at the given **index**.

        **See also** **setActiveFormWindow** () and **removeFormWindow** ().
        """
        ...

    def formWindowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#formWind
        owCount

        **[pure virtual] int
        QDesignerFormWindowManagerInterface::formWindowCount() const**

        Returns the number of form windows maintained by **Qt Designer** 's form
        window manager.
        """
        ...

    def removeFormWindow(
        self, formWindow: PySide6.QtDesigner.QDesignerFormWindowInterface
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#removeFo
        rmWindow

        **[pure virtual slot] void QDesignerFormWindowManagerInterface::removeFo
        rmWindow(QDesignerFormWindowInterface * formWindow )**

        Removes the given **formWindow** from the collection of windows that
        **Qt Designer** 's form window manager maintains.

        **See also** **formWindow** () and **formWindowRemoved** ().
        """
        ...

    def setActiveFormWindow(
        self, formWindow: PySide6.QtDesigner.QDesignerFormWindowInterface
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#setActiv
        eFormWindow

        **[pure virtual slot] void QDesignerFormWindowManagerInterface::setActiv
        eFormWindow(QDesignerFormWindowInterface * formWindow )**

        Sets the given **formWindow** to be the currently active form window in
        **Qt Designer** 's workspace.

        **See also** **activeFormWindow** () and **activeFormWindowChanged** ().
        """
        ...

    def showPluginDialog(self) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#showPlug
        inDialog

        **[pure virtual slot, since 5.0] void
        QDesignerFormWindowManagerInterface::showPluginDialog()**

        Opens a dialog showing the plugins loaded by **Qt Designer** 's and its
        plugin load failures.

        This function was introduced in Qt 5.0.
        """
        ...

    def showPreview(self) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#showPrev
        iew

        **[pure virtual slot, since 5.0] void
        QDesignerFormWindowManagerInterface::showPreview()**

        Show a preview of the current form using the default parameters.

        This function was introduced in Qt 5.0.

        **See also** **closeAllPreviews** ().
        """
        ...

    @property
    def activeFormWindowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#activeFo
        rmWindowChanged

        **[signal] void QDesignerFormWindowManagerInterface::activeFormWindowCha
        nged(QDesignerFormWindowInterface * formWindow )**

        This signal is emitted when the contents of the currently active form
        window in **Qt Designer** 's workspace changed. A pointer to the
        currently active **formWindow** is passed as an argument.

        **See also** **activeFormWindow** ().
        """
        ...

    @property
    def formWindowAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#formWind
        owAdded

        **[signal] void QDesignerFormWindowManagerInterface::formWindowAdded(QDe
        signerFormWindowInterface * formWindow )**

        This signal is emitted when a new form window is added to the collection
        of windows that **Qt Designer** 's form window manager maintains. A
        pointer to the new **formWindow** is passed as an argument.

        **See also** **addFormWindow** () and **setActiveFormWindow** ().
        """
        ...

    @property
    def formWindowRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#formWind
        owRemoved

        **[signal] void QDesignerFormWindowManagerInterface::formWindowRemoved(Q
        DesignerFormWindowInterface * formWindow )**

        This signal is emitted when a form window is removed from the collection
        of windows that **Qt Designer** 's form window manager maintains. A
        pointer to the removed **formWindow** is passed as an argument.

        **See also** **removeFormWindow** ().
        """
        ...

    @property
    def formWindowSettingsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowmanagerinterface.html#formWind
        owSettingsChanged

        **[signal] void QDesignerFormWindowManagerInterface::formWindowSettingsC
        hanged(QDesignerFormWindowInterface * formWindow )**

        This signal is emitted when the settings of the form window change. It
        can be used to update window titles, etc. accordingly. A pointer to the
        **formWindow** is passed as an argument.

        **See also** **FormWindowSettingsDialogAction** .
        """
        ...
