"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtDesigner

bytes = str


class QDesignerFormWindowCursorInterface(object):
    """
    https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html

    **Detailed Description**

    QDesignerFormWindowCursorInterface is a convenience class that provides an
    interface to the associated form window's text cursor; it provides a
    collection of functions that enables you to query a given form window's
    selection and change the selection's focus according to defined modes
    (**MoveMode** ) and movements (**MoveOperation** ). You can also use the
    interface to query the form's widgets and change their properties.

    The interface is not intended to be instantiated directly, but to provide
    access to the selections and widgets of **Qt Designer** 's current form
    windows. **QDesignerFormWindowInterface**  always provides an associated
    cursor interface. The form window for a given widget can be retrieved using
    the static **QDesignerFormWindowInterface::findFormWindow** () functions.
    For example:

    **QDesignerFormWindowInterface**  *formWindow = 0;
            formWindow =
    **QDesignerFormWindowInterface** ::findFormWindow(myWidget);
    formWindow->cursor()->setProperty(myWidget, myProperty, newValue);

    You can retrieve any of **Qt Designer** 's current form windows through **Qt
    Designer** 's **form window manager** .

    Once you have a form window's cursor interface, you can check if the form
    window has a selection at all using the **hasSelection** () function. You
    can query the form window for its total **widgetCount** () and
    **selectedWidgetCount** (). You can retrieve the currently selected widget
    (or widgets) using the **current** () or **selectedWidget** () functions.

    You can retrieve any of the form window's widgets using the **widget** ()
    function, and check if a widget is selected using the **isWidgetSelected**
    () function. You can use the **setProperty** () function to set the selected
    widget's properties, and the **setWidgetProperty** () or
    **resetWidgetProperty** () functions to modify the properties of any given
    widget.

    Finally, you can change the selection by changing the text cursor's
    **position** () using the **setPosition** () and **movePosition** ()
    functions.

    **See also** **QDesignerFormWindowInterface**  and
    **QDesignerFormWindowManagerInterface** .
    """

    MoveAnchor: QDesignerFormWindowCursorInterface.MoveMode = ...
    KeepAnchor: QDesignerFormWindowCursorInterface.MoveMode = ...
    NoMove: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Start: QDesignerFormWindowCursorInterface.MoveOperation = ...
    End: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Next: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Prev: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Left: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Right: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Up: QDesignerFormWindowCursorInterface.MoveOperation = ...
    Down: QDesignerFormWindowCursorInterface.MoveOperation = ...

    class MoveMode(Enum):
        MoveAnchor: QDesignerFormWindowCursorInterface.MoveMode = ...
        KeepAnchor: QDesignerFormWindowCursorInterface.MoveMode = ...

    class MoveOperation(Enum):
        NoMove: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Start: QDesignerFormWindowCursorInterface.MoveOperation = ...
        End: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Next: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Prev: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Left: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Right: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Up: QDesignerFormWindowCursorInterface.MoveOperation = ...
        Down: QDesignerFormWindowCursorInterface.MoveOperation = ...

    def __init__(self) -> None:
        ...

    def current(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#current

        **[pure virtual] QWidget *QDesignerFormWindowCursorInterface::current()
        const**

        Returns the currently selected widget in the form window.

        **See also** **selectedWidget** ().
        """
        ...

    def formWindow(self) -> PySide6.QtDesigner.QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#formWindo
        w

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowCursorInterface::formWindow() const**

        Returns the form window interface associated with this cursor interface.
        """
        ...

    def hasSelection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#hasSelect
        ion

        **[pure virtual] bool QDesignerFormWindowCursorInterface::hasSelection()
        const**

        Returns true if the form window contains a selection; otherwise returns
        false.
        """
        ...

    def isWidgetSelected(self, widget: PySide6.QtWidgets.QWidget) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#isWidgetS
        elected

        **bool QDesignerFormWindowCursorInterface::isWidgetSelected(QWidget *
        widget ) const**

        Returns true if the specified **widget** is selected; otherwise returns
        false.
        """
        ...

    def movePosition(
        self,
        op: PySide6.QtDesigner.QDesignerFormWindowCursorInterface.MoveOperation,
        mode: PySide6.QtDesigner.QDesignerFormWindowCursorInterface.MoveMode = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#movePosit
        ion

        **[pure virtual] bool QDesignerFormWindowCursorInterface::movePosition(Q
        DesignerFormWindowCursorInterface::MoveOperation operation ,
        QDesignerFormWindowCursorInterface::MoveMode mode = MoveAnchor)**

        Performs the given **operation** on the cursor using the specified
        **mode** , and returns true if it completed successfully; otherwise
        returns false.

        **See also** **position** () and **setPosition** ().
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#position

        **[pure virtual] int QDesignerFormWindowCursorInterface::position()
        const**

        Returns the cursor position.

        **See also** **setPosition** () and **movePosition** ().
        """
        ...

    def resetWidgetProperty(self, widget: PySide6.QtWidgets.QWidget, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#resetWidg
        etProperty

        **[pure virtual] void
        QDesignerFormWindowCursorInterface::resetWidgetProperty(QWidget * widget
        , const QString & name )**

        Resets the property with the given **name** for the specified **widget**
        to its default value.

        **See also** **setProperty** () and **setWidgetProperty** ().
        """
        ...

    def selectedWidget(self, index: int) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#selectedW
        idget

        **[pure virtual] QWidget
        *QDesignerFormWindowCursorInterface::selectedWidget(int index ) const**

        Returns the widget with the given **index** in the list of selected
        widgets.

        **See also** **current** () and **widget** ().
        """
        ...

    def selectedWidgetCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#selectedW
        idgetCount

        **[pure virtual] int
        QDesignerFormWindowCursorInterface::selectedWidgetCount() const**

        Returns the number of selected widgets in the form window.

        **See also** **widgetCount** ().
        """
        ...

    def setPosition(
        self,
        pos: int,
        mode: PySide6.QtDesigner.QDesignerFormWindowCursorInterface.MoveMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#setPositi
        on

        **[pure virtual] void
        QDesignerFormWindowCursorInterface::setPosition(int position ,
        QDesignerFormWindowCursorInterface::MoveMode mode = MoveAnchor)**

        Sets the position of the cursor to the given **position** using the
        **mode** to specify how it is moved there.

        **See also** **position** () and **movePosition** ().
        """
        ...

    def setProperty(self, name: str, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#setProper
        ty

        **[pure virtual] void
        QDesignerFormWindowCursorInterface::setProperty(const QString & name ,
        const QVariant & value )**

        Sets the property with the given **name** for the currently selected
        widget to the specified **value**.

        **See also** **setWidgetProperty** () and **resetWidgetProperty** ().
        """
        ...

    def setWidgetProperty(
        self, widget: PySide6.QtWidgets.QWidget, name: str, value: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#setWidget
        Property

        **[pure virtual] void
        QDesignerFormWindowCursorInterface::setWidgetProperty(QWidget * widget ,
        const QString & name , const QVariant & value )**

        Sets the property with the given **name** for the given **widget** to
        the specified **value**.

        **See also** **resetWidgetProperty** () and **setProperty** ().
        """
        ...

    def widget(self, index: int) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#widget

        **[pure virtual] QWidget *QDesignerFormWindowCursorInterface::widget(int
        index ) const**

        Returns the widget with the given **index** in the list of widgets in
        the form window.

        **See also** **selectedWidget** ().
        """
        ...

    def widgetCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerformwindowcursorinterface.html#widgetCou
        nt

        **[pure virtual] int QDesignerFormWindowCursorInterface::widgetCount()
        const**

        Returns the number of widgets in the form window.

        **See also** **selectedWidgetCount** ().
        """
        ...
