"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtDesigner

bytes = str


class QDesignerContainerExtension(object):
    """
    https://doc.qt.io/qt-6/qdesignercontainerextension.html

    **Detailed Description**

    ![](images/containerextension-example.png)

    QDesignerContainerExtension provide an interface for creating custom
    container extensions. A container extension consists of a collection of
    functions that **Qt Designer** needs to manage a multi-page container
    plugin, and a list of the container's pages.

    **Warning:** This is **not** an extension for container plugins in general,
    only custom **multi-page** containers.

    To create a container extension, your extension class must inherit from both
    **QObject**  and QDesignerContainerExtension. For example:

    class MyContainerExtension : public **QObject** ,
               public
    QDesignerContainerExtension
        {
            Q_OBJECT
    Q_INTERFACES(QDesignerContainerExtension)

        public:
    MyContainerExtension(MyCustomWidget *widget,
    **QObject**  *parent = 0);
            int count() const;
            **QWidget**
    *widget(int index) const;
            int currentIndex() const;
            void
    setCurrentIndex(int index);
            void addWidget(**QWidget**  *widget);
    void insertWidget(int index, **QWidget**  *widget);
            void remove(int
    index);

        private:
            MyCustomWidget *myWidget;
        };

    Since we are implementing an interface, we must ensure that it's made known
    to the meta object system using the **Q_INTERFACES** () macro. This enables
    **Qt Designer** to use the **qobject_cast** () function to query for
    supported interfaces using nothing but a **QObject**  pointer.

    You must reimplement several functions to enable **Qt Designer** to manage a
    custom multi-page container widget: **Qt Designer** uses **count** () to
    keep track of the number pages in your container, **widget** () to return
    the page at a given index in the list of the container's pages, and
    **currentIndex** () to return the list index of the selected page. **Qt
    Designer** uses the **addWidget** () function to add a given page to the
    container, expecting it to be appended to the list of pages, while it
    expects the **insertWidget** () function to add a given page to the
    container by inserting it at a given index.

    In **Qt Designer** the extensions are not created until they are required.
    For that reason you must also create a **QExtensionFactory** , i.e a class
    that is able to make an instance of your extension, and register it using
    **Qt Designer** 's **extension manager** .

    When a container extension is required, **Qt Designer** 's **extension
    manager**  will run through all its registered factories calling
    **QExtensionFactory::createExtension** () for each until the first one that
    is able to create a container extension, is found. This factory will then
    create the extension for the plugin.

    There are four available types of extensions in **Qt Designer** :
    QDesignerContainerExtension , **QDesignerMemberSheetExtension** ,
    **QDesignerPropertySheetExtension**  and **QDesignerTaskMenuExtension** .
    **Qt Designer** 's behavior is the same whether the requested extension is
    associated with a multi page container, a member sheet, a property sheet or
    a task menu.

    The **QExtensionFactory**  class provides a standard extension factory, and
    can also be used as an interface for custom extension factories. You can
    either create a new **QExtensionFactory**  and reimplement the
    **QExtensionFactory::createExtension** () function. For example:

    **QObject**  *ANewExtensionFactory::createExtension(**QObject**  *object,
    const **QString**  &iid, **QObject**  *parent) const
        {
            if (iid
    != Q_TYPEID(QDesignerContainerExtension))
                return 0;
    if (MyCustomWidget *widget = qobject_cast<MyCustomWidget*>
    (object))
                return new MyContainerExtension(widget, parent);
    return 0;
        }

    Or you can use an existing factory, expanding the
    **QExtensionFactory::createExtension** () function to make the factory able
    to create a container extension as well. For example:

    **QObject**  *AGeneralExtensionFactory::createExtension(**QObject**
    *object,
                const **QString**  &iid, **QObject**  *parent) const
    {
            MyCustomWidget *widget = qobject_cast<MyCustomWidget*>(object);
    if (widget && (iid == Q_TYPEID(**QDesignerTaskMenuExtension** ))) {
    return new MyTaskMenuExtension(widget, parent);

            } else if
    (widget && (iid == Q_TYPEID(QDesignerContainerExtension))) {
    return new MyContainerExtension(widget, parent);

            } else {
    return 0;
            }
        }

    For a complete example using the QDesignerContainerExtension class, see the
    **Container Extension example** . The example shows how to create a custom
    multi-page plugin for **Qt Designer**.

    **See also** **QExtensionFactory** , **QExtensionManager** , and **Creating
    Custom Widget Extensions** .
    """

    def __init__(self) -> None:
        ...

    def addWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#addWidget

        **[pure virtual] void QDesignerContainerExtension::addWidget(QWidget *
        page )**

        Adds the given **page** to the container by appending it to the
        extension's list of pages.

        **See also** **insertWidget** (), **remove** (), and **widget** ().
        """
        ...

    def canAddWidget(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#canAddWidget

        **[pure virtual, since 5.0] bool
        QDesignerContainerExtension::canAddWidget() const**

        Returns whether a widget can be added. This determines whether the
        context menu options to add or insert pages are enabled.

        This should return false for containers that have a single, fixed page,
        for example **QScrollArea**  or **QDockWidget** .

        This function was introduced in Qt 5.0.

        **See also** **addWidget** () and **canRemove** ().
        """
        ...

    def canRemove(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#canRemove

        **[pure virtual, since 5.0] bool
        QDesignerContainerExtension::canRemove(int index ) const**

        Returns whether the widget at the given **index** can be removed. This
        determines whether the context menu option to remove the current page is
        enabled.

        This should return false for containers that have a single, fixed page,
        for example **QScrollArea**  or **QDockWidget** .

        This function was introduced in Qt 5.0.

        **See also** **remove** () and **canAddWidget** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#count

        **[pure virtual] int QDesignerContainerExtension::count() const**

        Returns the number of pages in the container.
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#currentIndex

        **[pure virtual] int QDesignerContainerExtension::currentIndex() const**

        Returns the index of the currently selected page in the container.

        **See also** **setCurrentIndex** ().
        """
        ...

    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#insertWidget

        **[pure virtual] void QDesignerContainerExtension::insertWidget(int
        index , QWidget * page )**

        Adds the given **page** to the container by inserting it at the given
        **index** in the extension's list of pages.

        **See also** **addWidget** (), **remove** (), and **widget** ().
        """
        ...

    def remove(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#remove

        **[pure virtual] void QDesignerContainerExtension::remove(int index )**

        Removes the page at the given **index** from the extension's list of
        pages.

        **See also** **addWidget** () and **insertWidget** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#setCurrentIndex

        **[pure virtual] void QDesignerContainerExtension::setCurrentIndex(int
        index )**

        Sets the currently selected page in the container to be the page at the
        given **index** in the extension's list of pages.

        **See also** **currentIndex** ().
        """
        ...

    def widget(self, index: int) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qdesignercontainerextension.html#widget

        **[pure virtual] QWidget *QDesignerContainerExtension::widget(int index
        ) const**

        Returns the page at the given **index** in the extension's list of
        pages.

        **See also** **addWidget** () and **insertWidget** ().
        """
        ...
