"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QValue3DAxisFormatter(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qvalue3daxisformatter.html

    **Detailed Description**

    This class provides formatting rules for a linear value 3D axis. Subclass it
    if you want to implement custom value axes.

    The base class has no public API beyond constructors and destructors. It is
    meant to be only used internally. However, subclasses may implement public
    properties as needed.

    **See also** **QValue3DAxis**  and **QLogValue3DAxisFormatter** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#QValue3DAxisFormatter-
        1

        **QValue3DAxisFormatter::QValue3DAxisFormatter(QObject * parent =
        nullptr)**

        Constructs a new value 3D axis formatter with the optional parent
        **parent**.
        """
        ...

    def allowNegatives(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#allowNegatives

        **[protected] bool QValue3DAxisFormatter::allowNegatives() const**

        Returns `true` if negative values are valid values for the parent axis.
        The default implementation always returns `true`.

        **See also** **setAllowNegatives** ().
        """
        ...

    def allowZero(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#allowZero

        **[protected] bool QValue3DAxisFormatter::allowZero() const**

        Returns `true` if zero is a valid value for the parent axis. The default
        implementation always returns `true`.

        **See also** **setAllowZero** ().
        """
        ...

    def axis(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#axis

        **[protected] QValue3DAxis *QValue3DAxisFormatter::axis() const**

        Returns the parent axis. The parent axis must only be accessed in the
        **recalculate** () method to maintain thread safety in environments
        using a threaded renderer.

        **See also** **recalculate** ().
        """
        ...

    def createNewInstance(self) -> PySide6.QtDataVisualization.QValue3DAxisFormatter:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#createNewInstance

        **[virtual protected] QValue3DAxisFormatter
        *QValue3DAxisFormatter::createNewInstance() const**

        Creates a new empty value 3D axis formatter. Must be reimplemented in a
        subclass.

        Returns the new formatter. The renderer uses this method to cache a copy
        of the formatter. The ownership of the new copy is transferred to the
        caller.
        """
        ...

    def gridPositions(self) -> List[float]:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#gridPositions

        **[protected] QList<float> &QValue3DAxisFormatter::gridPositions()
        const**

        Returns a reference to the array of normalized grid line positions. The
        default array size is equal to the segment count of the parent axis plus
        one, but a subclassed implementation of the **recalculate** () method
        may resize the array differently. The values should be between `0.0`
        (the minimum value) and `1.0` (the maximum value), inclusive.

        **See also** **QValue3DAxis::segmentCount**  and **recalculate** ().
        """
        ...

    def labelPositions(self) -> List[float]:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#labelPositions

        **[protected] QList<float> &QValue3DAxisFormatter::labelPositions()
        const**

        Returns a reference to the array of normalized label positions. The
        default array size is equal to the segment count of the parent axis plus
        one, but a subclassed implementation of the **recalculate** () method
        may resize the array differently. The values should be between `0.0`
        (the minimum value) and `1.0` (the maximum value), inclusive. By
        default, the label at the index zero corresponds to the minimum value of
        the axis.

        **See also** **QValue3DAxis::segmentCount** ,
        **QAbstract3DAxis::labels** , and **recalculate** ().
        """
        ...

    def labelStrings(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#labelStrings

        **[protected] QStringList &QValue3DAxisFormatter::labelStrings() const**

        Returns a reference to the string list containing formatter label
        strings. The array size must be equal to the size of the label positions
        array, which the indexes also correspond to.

        **See also** **labelPositions** ().
        """
        ...

    def locale(self) -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#locale

        **[protected] QLocale QValue3DAxisFormatter::locale() const**

        Returns the current locale this formatter is using.

        **See also** **setLocale** ().
        """
        ...

    def markDirty(self, labelsChange: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#markDirty

        **[protected] void QValue3DAxisFormatter::markDirty(bool labelsChange =
        false)**

        Marks this formatter dirty, prompting the renderer to make a new copy of
        its cache on the next renderer synchronization. This method should be
        called by a subclass whenever the formatter is changed in a way that
        affects the resolved values. Set **labelsChange** to `true` if the
        change requires regenerating the parent axis label strings.
        """
        ...

    def populateCopy(
        self, copy: PySide6.QtDataVisualization.QValue3DAxisFormatter
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#populateCopy

        **[virtual protected] void
        QValue3DAxisFormatter::populateCopy(QValue3DAxisFormatter & copy )
        const**

        Copies all the values necessary for resolving positions, values, and
        strings with this formatter to the **copy** of the formatter. When
        reimplementing this method in a subclass, call the superclass version at
        some point. The renderer uses this method to cache a copy of the
        formatter.

        Returns the new copy. The ownership of the new copy transfers to the
        caller.
        """
        ...

    def positionAt(self, value: float) -> float:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#positionAt

        **[virtual protected] float QValue3DAxisFormatter::positionAt(float
        value ) const**

        Returns the normalized position along the axis for the given **value**.
        The returned value should be between `0.0` (the minimum value) and `1.0`
        (the maximum value), inclusive, if the value is within the parent axis
        range.

        Reimplement this method if the position cannot be resolved by linear
        interpolation between the parent axis minimum and maximum values.

        **See also** **recalculate** () and **valueAt** ().
        """
        ...

    def recalculate(self) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#recalculate

        **[virtual protected] void QValue3DAxisFormatter::recalculate()**

        Resizes and populates the label and grid line position arrays and the
        label strings array, as well as calculates any values needed to map a
        value to its position. The parent axis can be accessed from inside this
        function.

        This method must be reimplemented in a subclass if the default array
        contents are not suitable.

        See **gridPositions** (), **subGridPositions** (), **labelPositions**
        (), and **labelStrings** () methods for documentation about the arrays
        that need to be resized and populated.

        **See also** **gridPositions** (), **subGridPositions** (),
        **labelPositions** (), **labelStrings** (), and **axis** ().
        """
        ...

    def setAllowNegatives(self, allow: bool) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#setAllowNegatives

        **[protected] void QValue3DAxisFormatter::setAllowNegatives(bool allow
        )**

        Allows the parent axis to have negative values if **allow** is `true`.

        **See also** **allowNegatives** ().
        """
        ...

    def setAllowZero(self, allow: bool) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#setAllowZero

        **[protected] void QValue3DAxisFormatter::setAllowZero(bool allow )**

        Allows the parent axis to have a zero value if **allow** is `true`.

        **See also** **allowZero** ().
        """
        ...

    def setLocale(
        self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#setLocale

        **[protected] void QValue3DAxisFormatter::setLocale(const QLocale &
        locale )**

        Sets the **locale** that this formatter uses. The graph automatically
        sets the formatter's locale to a graph's locale whenever the parent axis
        is set as an active axis of the graph, the axis formatter is set to an
        axis attached to the graph, or the graph's locale changes.

        **See also** **locale** () and **QAbstract3DGraph::locale** .
        """
        ...

    def stringForValue(self, value: float, format: str) -> str:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#stringForValue

        **[virtual protected] QString
        QValue3DAxisFormatter::stringForValue(qreal value , const QString &
        format ) const**

        Returns the formatted label string using the specified **value** and
        **format**.

        Reimplement this method in a subclass to resolve the formatted string
        for a given **value** if the default formatting rules specified for
        **QValue3DAxis::labelFormat**  property are not sufficient.

        **See also** **recalculate** (), **labelStrings** (), and
        **QValue3DAxis::labelFormat** .
        """
        ...

    def subGridPositions(self) -> List[float]:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#subGridPositions

        **[protected] QList<float> &QValue3DAxisFormatter::subGridPositions()
        const**

        Returns a reference to the array of normalized subgrid line positions.
        The default array size is equal to the segment count of the parent axis
        times the sub-segment count of the parent axis minus one, but a
        subclassed implementation of the **recalculate** () method may resize
        the array differently. The values should be between `0.0` (the minimum
        value) and `1.0` (the maximum value), inclusive.

        **See also** **QValue3DAxis::segmentCount** ,
        **QValue3DAxis::subSegmentCount** , and **recalculate** ().
        """
        ...

    def valueAt(self, position: float) -> float:
        """
        https://doc.qt.io/qt-6/qvalue3daxisformatter.html#valueAt

        **[virtual protected] float QValue3DAxisFormatter::valueAt(float
        position ) const**

        Returns the value at the normalized **position** along the axis. The
        **position** value should be between `0.0` (the minimum value) and `1.0`
        (the maximum value), inclusive, to obtain values within the parent axis
        range.

        Reimplement this method if the value cannot be resolved by linear
        interpolation between the parent axis minimum and maximum values.

        **See also** **recalculate** () and **positionAt** ().
        """
        ...
