"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QTouch3DInputHandler(PySide6.QtDataVisualization.Q3DInputHandler):
    """
    https://doc.qt.io/qt-6/qtouch3dinputhandler.html

    **Detailed Description**

    QTouch3DInputHandler is the basic input handler for touch screen devices.

    Default touch input handler has the following functionalty:

    GestureAction
    Touch-And-MoveRotate graph within limits set for
    **Q3DCamera**
    TapSelect the item tapped or remove selection if none. May
    open the secondary view depending on the **selection mode** .
    Tap-And-
    HoldSame as tap.
    PinchZoom in/out within the allowable zoom range set for
    **Q3DCamera** .
    Tap on the primary view when the secondary view is
    visibleCloses the secondary view.

    **Note:** Secondary view is available
    only for **Q3DBars**  and **Q3DSurface**  graphs.

    Rotation, zoom, and selection can each be individually disabled using
    corresponding **Q3DInputHandler**  properties.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtouch3dinputhandler.html#QTouch3DInputHandler

        **QTouch3DInputHandler::QTouch3DInputHandler(QObject * parent =
        nullptr)**

        Constructs the basic touch display input handler. An optional **parent**
        parameter can be given and is then passed to **QObject**  constructor.
        """
        ...

    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtouch3dinputhandler.html#touchEvent

        **[override virtual] void QTouch3DInputHandler::touchEvent(QTouchEvent *
        event )**

        Reimplements: **QAbstract3DInputHandler::touchEvent** (QTouchEvent
        *event).

        Override this to change handling of touch events. Touch event is given
        in the **event**.
        """
        ...
