"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QSurfaceDataItem(object):
    """
    https://doc.qt.io/qt-6/qsurfacedataitem.html

    **Detailed Description**

    A surface data item holds the data for a single vertex in a surface graph.
    Surface data proxies parse data into QSurfaceDataItem instances for
    visualization.

    **See also** **QSurfaceDataProxy**  and **Qt Data Visualization C++
    Classes** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#QSurfaceDataItem

        **QSurfaceDataItem::QSurfaceDataItem()**

        Constructs a surface data item.
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtDataVisualization.QSurfaceDataItem, PySide6.QtGui.QVector3D
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#QSurfaceDataItem-1

        **QSurfaceDataItem::QSurfaceDataItem(const QVector3D & position )**

        Constructs a surface data item at the position **position**.
        """
        ...

    @overload
    def __init__(self, position: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#QSurfaceDataItem-2

        **QSurfaceDataItem::QSurfaceDataItem(const QSurfaceDataItem & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def createExtraData(self) -> None:
        ...

    def position(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#position

        **QVector3D QSurfaceDataItem::position() const**

        Returns the position of this data item.

        **See also** **setPosition** ().
        """
        ...

    def setPosition(self, pos: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#setPosition

        **void QSurfaceDataItem::setPosition(const QVector3D & pos )**

        Sets the position **pos** to this data item.

        **See also** **position** ().
        """
        ...

    def setX(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#setX

        **void QSurfaceDataItem::setX(float value )**

        Sets the x-coordinate of the item position to the value **value**.

        **See also** **x** ().
        """
        ...

    def setY(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#setY

        **void QSurfaceDataItem::setY(float value )**

        Sets the y-coordinate of the item position to the value **value**.

        **See also** **y** ().
        """
        ...

    def setZ(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#setZ

        **void QSurfaceDataItem::setZ(float value )**

        Sets the z-coordinate of the item position to the value **value**.

        **See also** **z** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#x

        **float QSurfaceDataItem::x() const**

        Returns the x-coordinate of the position of this data item.

        **See also** **setX** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#y

        **float QSurfaceDataItem::y() const**

        Returns the y-coordinate of the position of this data item.

        **See also** **setY** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qsurfacedataitem.html#z

        **float QSurfaceDataItem::z() const**

        Returns the z-coordinate of the position of this data item.

        **See also** **setZ** ().
        """
        ...
