"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QSurface3DSeries(PySide6.QtDataVisualization.QAbstract3DSeries):
    """
    https://doc.qt.io/qt-6/qsurface3dseries.html

    **Detailed Description**

    This class manages the series specific visual elements, as well as the
    series data (via a data proxy).

    If no data proxy is set explicitly for the series, the series creates a
    default proxy. Setting another proxy will destroy the existing proxy and all
    data added to it.

    The object mesh set via the **QAbstract3DSeries::mesh**  property defines
    the selection pointer shape in a surface series.

    QSurface3DSeries supports the following format tags for
    **QAbstract3DSeries::setItemLabelFormat** ():

    @xTitleTitle from x-axis
    @yTitleTitle from y-axis
    @zTitleTitle from
    z-axis
    @xLabelItem value formatted using the format of the x-axis. For
    more information, see **QValue3DAxis::setLabelFormat** ().
    @yLabelItem
    value formatted using the format of the y-axis. For more information, see
    **QValue3DAxis::setLabelFormat** ().
    @zLabelItem value formatted using the
    format of the z-axis. For more information, see
    **QValue3DAxis::setLabelFormat** ().
    @seriesNameName of the series

    For example:

    proxy->setItemLabelFormat(**QStringLiteral** ("@valueTitle for (@rowLabel,
    @colLabel): %.1f"));

    **See also** **Qt Data Visualization Data Handling** .
    """

    DrawWireframe: QSurface3DSeries.DrawFlag = ...
    DrawSurface: QSurface3DSeries.DrawFlag = ...
    DrawSurfaceAndWireframe: QSurface3DSeries.DrawFlag = ...

    class DrawFlag(Enum):
        DrawWireframe: QSurface3DSeries.DrawFlag = ...
        DrawSurface: QSurface3DSeries.DrawFlag = ...
        DrawSurfaceAndWireframe: QSurface3DSeries.DrawFlag = ...

    class DrawFlags(object):
        ...

    @overload
    def __init__(
        self,
        dataProxy: PySide6.QtDataVisualization.QSurfaceDataProxy,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#QSurface3DSeries

        **QSurface3DSeries::QSurface3DSeries(QObject * parent = nullptr)**

        Constructs a surface 3D series with the parent **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#QSurface3DSeries-1

        **QSurface3DSeries::QSurface3DSeries(QSurfaceDataProxy * dataProxy ,
        QObject * parent = nullptr)**

        Constructs a surface 3D series with the data proxy **dataProxy** and the
        parent **parent**.
        """
        ...

    def dataProxy(self) -> PySide6.QtDataVisualization.QSurfaceDataProxy:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#dataProxy-prop

        **dataProxy : QSurfaceDataProxy***

        This property holds the active data proxy.

        The series assumes ownership of any proxy set to it and deletes any
        previously set proxy when a new one is added. The proxy cannot be null
        or set to another series.

        **Access functions:**

        QSurfaceDataProxy * **dataProxy** () const
        void **setDataProxy**
        (QSurfaceDataProxy * **proxy** )

        **Notifier signal:**

        void **dataProxyChanged** (QSurfaceDataProxy * **proxy** )
        """
        ...

    def drawMode(self) -> PySide6.QtDataVisualization.QSurface3DSeries.DrawFlags:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#drawMode-prop

        **drawMode : DrawFlags**

        The drawing mode.

        Possible values are the values of **DrawFlag** . Clearing all flags is
        not allowed.

        **Access functions:**

        QSurface3DSeries::DrawFlags **drawMode** () const
        void **setDrawMode**
        (QSurface3DSeries::DrawFlags **mode** )

        **Notifier signal:**

        void **drawModeChanged** (QSurface3DSeries::DrawFlags **mode** )
        """
        ...

    @staticmethod
    def invalidSelectionPosition() -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#invalidSelectionPosition

        **[static] QPoint QSurface3DSeries::invalidSelectionPosition()**

        Returns the **QPoint**  signifying an invalid selection position. This
        is set to the **selectedPoint**  property to clear the selection from
        this series.

        **See also** **QAbstract3DGraph::clearSelection** ().
        """
        ...

    def isFlatShadingEnabled(self) -> bool:
        ...

    def isFlatShadingSupported(self) -> bool:
        ...

    def selectedPoint(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#selectedPoint-prop

        **selectedPoint : QPoint**

        This property holds the surface grid point that is selected in the
        series.

        **Access functions:**

        QPoint **selectedPoint** () const
        void ****setSelectedPoint** **
        (const QPoint & **position** )

        **Notifier signal:**

        void **selectedPointChanged** (const QPoint & **position** )
        """
        ...

    def setDataProxy(
        self, proxy: PySide6.QtDataVisualization.QSurfaceDataProxy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#dataProxy-prop

        **dataProxy : QSurfaceDataProxy***

        This property holds the active data proxy.

        The series assumes ownership of any proxy set to it and deletes any
        previously set proxy when a new one is added. The proxy cannot be null
        or set to another series.

        **Access functions:**

        QSurfaceDataProxy * **dataProxy** () const
        void **setDataProxy**
        (QSurfaceDataProxy * **proxy** )

        **Notifier signal:**

        void **dataProxyChanged** (QSurfaceDataProxy * **proxy** )
        """
        ...

    def setDrawMode(
        self, mode: PySide6.QtDataVisualization.QSurface3DSeries.DrawFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#drawMode-prop

        **drawMode : DrawFlags**

        The drawing mode.

        Possible values are the values of **DrawFlag** . Clearing all flags is
        not allowed.

        **Access functions:**

        QSurface3DSeries::DrawFlags **drawMode** () const
        void **setDrawMode**
        (QSurface3DSeries::DrawFlags **mode** )

        **Notifier signal:**

        void **drawModeChanged** (QSurface3DSeries::DrawFlags **mode** )
        """
        ...

    def setFlatShadingEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#flatShadingEnabled-prop

        **flatShadingEnabled : bool**

        This property holds whether surface flat shading is enabled.

        Preset to `true` by default.

        When disabled, the normals on the surface are interpolated making the
        edges look round. When enabled, the normals are kept the same on a
        triangle making the color of the triangle solid. This makes the data
        more readable from the model.

        **Note:** Flat shaded surfaces require at least GLSL version 1.2 with
        GL_EXT_gpu_shader4 extension. The value of the **flatShadingSupported**
        property indicates whether flat shading is supported at runtime.

        **Access functions:**

        bool **isFlatShadingEnabled** () const
        void **setFlatShadingEnabled**
        (bool **enabled** )

        **Notifier signal:**

        void **flatShadingEnabledChanged** (bool **enable** )
        """
        ...

    def setSelectedPoint(self, position: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#setSelectedPoint

        **void QSurface3DSeries::setSelectedPoint(const QPoint & position )**

        Selects a surface grid point at the position **position** in the data
        array of the series specified by a row and a column.

        Only one point can be selected at a time.

        To clear selection from this series, **invalidSelectionPosition** () is
        set as **position**. If this series is added to a graph, the graph can
        adjust the selection according to user interaction or if it becomes
        invalid.

        Removing rows from or inserting rows to the series before the row of the
        selected point will adjust the selection so that the same point will
        stay selected.

        **Note:** Setter function for property **selectedPoint** .

        **See also** **selectedPoint** () and
        **QAbstract3DGraph::clearSelection** ().
        """
        ...

    def setTexture(self, texture: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#texture-prop

        **texture : QImage**

        This property holds the texture for the surface as a **QImage** .

        Setting an empty **QImage**  clears the texture.

        **Access functions:**

        QImage **texture** () const
        void **setTexture** (const QImage &
        **texture** )

        **Notifier signal:**

        void **textureChanged** (const QImage & **image** )
        """
        ...

    def setTextureFile(self, filename: str) -> None:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#textureFile-prop

        **textureFile : QString**

        This property holds the texture for the surface as a file.

        Setting an empty file name clears the texture.

        **Access functions:**

        QString **textureFile** () const
        void **setTextureFile** (const
        QString & **filename** )

        **Notifier signal:**

        void **textureFileChanged** (const QString & **filename** )

        **Member Function Documentation**
        """
        ...

    def texture(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#texture-prop

        **texture : QImage**

        This property holds the texture for the surface as a **QImage** .

        Setting an empty **QImage**  clears the texture.

        **Access functions:**

        QImage **texture** () const
        void **setTexture** (const QImage &
        **texture** )

        **Notifier signal:**

        void **textureChanged** (const QImage & **image** )
        """
        ...

    def textureFile(self) -> str:
        """
        https://doc.qt.io/qt-6/qsurface3dseries.html#textureFile-prop

        **textureFile : QString**

        This property holds the texture for the surface as a file.

        Setting an empty file name clears the texture.

        **Access functions:**

        QString **textureFile** () const
        void **setTextureFile** (const
        QString & **filename** )

        **Notifier signal:**

        void **textureFileChanged** (const QString & **filename** )

        **Member Function Documentation**
        """
        ...

    @property
    def dataProxyChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def drawModeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def flatShadingEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def flatShadingSupportedChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedPointChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureFileChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
