"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QItemModelSurfaceDataProxy(PySide6.QtDataVisualization.QSurfaceDataProxy):
    """
    https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html

    **Detailed Description**

    QItemModelSurfaceDataProxy allows you to use **QAbstractItemModel**  derived
    models as a data source for **Q3DSurface** . It uses the defined mappings to
    map data from the model to rows, columns, and surface points of
    **Q3DSurface**  graph.

    Data is resolved asynchronously whenever the mapping or the model changes.
    **QSurfaceDataProxy::arrayReset** () is emitted when the data has been
    resolved. However, when **useModelCategories**  property is set to `true`,
    single item changes are resolved synchronously, unless the same frame also
    contains a change that causes the whole model to be resolved.

    Mappings can be used in the following ways:

    * If **useModelCategories**  property is set to `true`, this proxy will map
    rows and columns of **QAbstractItemModel**  to rows and columns of
    **Q3DSurface** , and uses the value returned for **Qt::DisplayRole**  as
    Y-position by default. Row and column headers are used for Z-position and
    X-position by default, if they can be converted to floats. Otherwise row and
    column indices are used. The Y-position role to be used can be redefined if
    **Qt::DisplayRole**  is not suitable. The Z-position and X-position roles to
    be used can be redefined if the headers or indices are not suitable.
      * For
    models that do not have data already neatly sorted into rows and columns,
    such as **QAbstractListModel**  based models, you can define a role from the
    model to map for each of row, column and Y-position.
      * If you do not want
    to include all data contained in the model, or the autogenerated rows and
    columns are not ordered as you wish, you can specify which rows and columns
    should be included and in which order by defining an explicit list of
    categories for either or both of rows and columns.

    For example, assume that you have a custom **QAbstractItemModel**  storing
    surface topography data. Each item in the model has the roles "longitude",
    "latitude", and "height". The item model already contains the data properly
    sorted so that longitudes and latitudes are first encountered in correct
    order, which enables us to utilize the row and column category
    autogeneration. You could do the following to display the data in a surface
    graph:

    **QItemModelSurfaceDataProxy**  *proxy = new **QItemModelSurfaceDataProxy**
    (customModel,
    **QStringLiteral** ("longitude"), // Row role
    **QStringLiteral** ("latitude"), // Column role
    **QStringLiteral** ("height")); // Y-position role

    If the fields of the model do not contain the data in the exact format you
    need, you can specify a search pattern regular expression and a replace rule
    for each role to get the value in a format you need. For more information
    how the replace using regular expressions works, see **QString::replace**
    (const **QRegularExpression**  &rx, const **QString**  &after) function
    documentation. Note that using regular expressions has an impact on the
    performance, so it's more efficient to utilize item models where doing
    search and replace is not necessary to get the desired values.

    For example about using the search patterns in conjunction with the roles,
    see **ItemModelBarDataProxy**  usage in **Qt Quick 2 Bars Example** .

    **See also** **Qt Data Visualization Data Handling** .
    """

    MMBFirst: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...
    MMBLast: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...
    MMBAverage: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...
    MMBCumulativeY: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...

    class MultiMatchBehavior(Enum):
        MMBFirst: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...
        MMBLast: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...
        MMBAverage: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...
        MMBCumulativeY: QItemModelSurfaceDataProxy.MultiMatchBehavior = ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QObject *
        parent = nullptr)**

        Constructs QItemModelSurfaceDataProxy with optional **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        xPosRole: str,
        yPosRole: str,
        zPosRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy-1

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemMo
        del * itemModel , QObject * parent = nullptr)**

        Constructs QItemModelSurfaceDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        xPosRole: str,
        yPosRole: str,
        zPosRole: str,
        rowCategories: Sequence[str],
        columnCategories: Sequence[str],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy-2

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemMo
        del * itemModel , const QString & yPosRole , QObject * parent =
        nullptr)**

        Constructs QItemModelSurfaceDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The **yPosRole**
        role is set to **yPosRole**. This constructor is meant to be used with
        models that have data properly sorted in rows and columns already, so it
        also sets **useModelCategories**  property to `true`.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        yPosRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy-3

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemMo
        del * itemModel , const QString & rowRole , const QString & columnRole ,
        const QString & yPosRole , QObject * parent = nullptr)**

        Constructs QItemModelSurfaceDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , and **yPosRole**. The
        **zPosRole**  and the **xPosRole**  are set to **rowRole** and
        **columnRole** , respectively.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        yPosRole: str,
        rowCategories: Sequence[str],
        columnCategories: Sequence[str],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy-4

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemMo
        del * itemModel , const QString & rowRole , const QString & columnRole ,
        const QString & xPosRole , const QString & yPosRole , const QString &
        zPosRole , QObject * parent = nullptr)**

        Constructs QItemModelSurfaceDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , **xPosRole** , **yPosRole** ,
        and **zPosRole**.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        yPosRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy-5

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemMo
        del * itemModel , const QString & rowRole , const QString & columnRole ,
        const QString & yPosRole , const QStringList & rowCategories , const
        QStringList & columnCategories , QObject * parent = nullptr)**

        Constructs QItemModelSurfaceDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , and **yPosRole**. The
        **zPosRole**  and the **xPosRole**  are set to **rowRole** and
        **columnRole** , respectively. Row and column categories are set with
        **rowCategories** and **columnCategories**. This constructor also sets
        **autoRowCategories**  and **autoColumnCategories**  to false.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#QItemModelSurface
        DataProxy-6

        **QItemModelSurfaceDataProxy::QItemModelSurfaceDataProxy(QAbstractItemMo
        del * itemModel , const QString & rowRole , const QString & columnRole ,
        const QString & xPosRole , const QString & yPosRole , const QString &
        zPosRole , const QStringList & rowCategories , const QStringList &
        columnCategories , QObject * parent = nullptr)**

        Constructs QItemModelSurfaceDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , **xPosRole** , **yPosRole** ,
        and **zPosRole**. Row and column categories are set with
        **rowCategories** and **columnCategories**. This constructor also sets
        **autoRowCategories**  and **autoColumnCategories**  to false.
        """
        ...

    def autoColumnCategories(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#autoColumnCategor
        ies-prop

        **autoColumnCategories : bool**

        This property holds whether column categories are generated
        automatically.

        When set to `true`, the mapping ignores any explicitly set column
        categories and overwrites them with automatically generated ones
        whenever the data from the model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoColumnCategories** () const
        void
        **setAutoColumnCategories** (bool **enable** )

        **Notifier signal:**

        void **autoColumnCategoriesChanged** (bool **enable** )
        """
        ...

    def autoRowCategories(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#autoRowCategories
        -prop

        **autoRowCategories : bool**

        This property holds whether row categories are generated automatically.

        When set to `true`, the mapping ignores any explicitly set row
        categories and overwrites them with automatically generated ones
        whenever the data from the model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoRowCategories** () const
        void **setAutoRowCategories**
        (bool **enable** )

        **Notifier signal:**

        void **autoRowCategoriesChanged** (bool **enable** )
        """
        ...

    def columnCategories(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnCategories-
        prop

        **columnCategories : QStringList**

        This property holds the column categories for the mapping.

        **Access functions:**

        QStringList **columnCategories** () const
        void **setColumnCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **columnCategoriesChanged** ()
        """
        ...

    def columnCategoryIndex(self, category: str) -> int:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnCategoryInd
        ex

        **[invokable] int QItemModelSurfaceDataProxy::columnCategoryIndex(const
        QString & category )**

        Returns the index of the specified **category** in the column categories
        list. If the category is not found, -1 is returned.

        **Note:** If the automatic column categories generation is in use, this
        method will not return a valid index before the data in the model is
        resolved for the first time.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def columnRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnRole-prop

        **columnRole : QString**

        This property holds the item model role to map to the column category.

        In addition to defining which column the data belongs to, the value
        indicated by the column role is also set as the X-coordinate value of
        **QSurfaceDataItem**  when model data is resolved, unless a separate x
        position role is also defined.

        **Access functions:**

        QString **columnRole** () const
        void **setColumnRole** (const QString
        & **role** )

        **Notifier signal:**

        void **columnRoleChanged** (const QString & **role** )
        """
        ...

    def columnRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnRolePattern
        -prop

        **columnRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the column role before it is used as a column category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **columnRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **columnRolePattern** () const
        void
        **setColumnRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **columnRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **columnRole**  and **columnRoleReplace** .
        """
        ...

    def columnRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnRoleReplace
        -prop

        **columnRoleReplace : QString**

        This property holds the replace content to be used in conjunction with a
        column role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **columnRoleReplace** () const
        void **setColumnRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **columnRoleReplaceChanged** (const QString & **replace** )

        **See also** **columnRole**  and **columnRolePattern** .
        """
        ...

    def itemModel(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#itemModel-prop

        **itemModel : QAbstractItemModel***

        This property holds the item model used as a data source for the 3D
        surface.

        **Access functions:**

        QAbstractItemModel * **itemModel** () const
        void ****setItemModel** **
        (QAbstractItemModel * **itemModel** )

        **Notifier signal:**

        void **itemModelChanged** (const QAbstractItemModel * **itemModel** )
        """
        ...

    def multiMatchBehavior(
        self,
    ) -> PySide6.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#multiMatchBehavio
        r-prop

        **multiMatchBehavior : MultiMatchBehavior**

        How multiple matches for each row/column combination are handled.

        Defaults to **MMBLast** .

        For example, you might have an item model with timestamped data taken at
        irregular intervals and you want to visualize an average position of
        data items on each hour with a surface graph. This can be done by
        specifying row and column categories so that each surface point
        represents an hour, and setting this property to **MMBAverage** .

        **Access functions:**

        QItemModelSurfaceDataProxy::MultiMatchBehavior **multiMatchBehavior** ()
        const
        void **setMultiMatchBehavior**
        (QItemModelSurfaceDataProxy::MultiMatchBehavior **behavior** )

        **Notifier signal:**

        void **multiMatchBehaviorChanged**
        (QItemModelSurfaceDataProxy::MultiMatchBehavior **behavior** )
        """
        ...

    def remap(
        self,
        rowRole: str,
        columnRole: str,
        xPosRole: str,
        yPosRole: str,
        zPosRole: str,
        rowCategories: Sequence[str],
        columnCategories: Sequence[str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#remap

        **void QItemModelSurfaceDataProxy::remap(const QString & rowRole , const
        QString & columnRole , const QString & xPosRole , const QString &
        yPosRole , const QString & zPosRole , const QStringList & rowCategories
        , const QStringList & columnCategories )**

        Changes **rowRole** , **columnRole** , **xPosRole** , **yPosRole** ,
        **zPosRole** , **rowCategories** and **columnCategories** to the
        mapping.
        """
        ...

    def rowCategories(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowCategories-
        prop

        **rowCategories : QStringList**

        This property holds the row categories for the mapping.

        **Access functions:**

        QStringList **rowCategories** () const
        void **setRowCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **rowCategoriesChanged** ()
        """
        ...

    def rowCategoryIndex(self, category: str) -> int:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowCategoryIndex

        **[invokable] int QItemModelSurfaceDataProxy::rowCategoryIndex(const
        QString & category )**

        Returns the index of the specified **category** in the row categories
        list. If the row categories list is empty, -1 is returned.

        **Note:** If the automatic row categories generation is in use, this
        method will not return a valid index before the data in the model is
        resolved for the first time.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def rowRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowRole-prop

        **rowRole : QString**

        This property holds the item model role to map to the row category.

        In addition to defining which row the data belongs to, the value
        indicated by the row role is also set as the Z-coordinate value of
        **QSurfaceDataItem**  when model data is resolved, unless a separate z
        position role is also defined.

        **Access functions:**

        QString **rowRole** () const
        void **setRowRole** (const QString &
        **role** )

        **Notifier signal:**

        void **rowRoleChanged** (const QString & **role** )
        """
        ...

    def rowRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowRolePattern-
        prop

        **rowRolePattern : QRegularExpression**

        This property holds whether a search and replace is performed on the
        value mapped by the row role before it is used as a row category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **rowRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **rowRolePattern** () const
        void
        **setRowRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rowRolePatternChanged** (const QRegularExpression & **pattern** )

        **See also** **rowRole**  and **rowRoleReplace** .
        """
        ...

    def rowRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowRoleReplace-
        prop

        **rowRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the row role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rowRoleReplace** () const
        void **setRowRoleReplace** (const
        QString & **replace** )

        **Notifier signal:**

        void **rowRoleReplaceChanged** (const QString & **replace** )

        **See also** **rowRole**  and **rowRolePattern** .
        """
        ...

    def setAutoColumnCategories(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#autoColumnCategor
        ies-prop

        **autoColumnCategories : bool**

        This property holds whether column categories are generated
        automatically.

        When set to `true`, the mapping ignores any explicitly set column
        categories and overwrites them with automatically generated ones
        whenever the data from the model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoColumnCategories** () const
        void
        **setAutoColumnCategories** (bool **enable** )

        **Notifier signal:**

        void **autoColumnCategoriesChanged** (bool **enable** )
        """
        ...

    def setAutoRowCategories(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#autoRowCategories
        -prop

        **autoRowCategories : bool**

        This property holds whether row categories are generated automatically.

        When set to `true`, the mapping ignores any explicitly set row
        categories and overwrites them with automatically generated ones
        whenever the data from the model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoRowCategories** () const
        void **setAutoRowCategories**
        (bool **enable** )

        **Notifier signal:**

        void **autoRowCategoriesChanged** (bool **enable** )
        """
        ...

    def setColumnCategories(self, categories: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnCategories-
        prop

        **columnCategories : QStringList**

        This property holds the column categories for the mapping.

        **Access functions:**

        QStringList **columnCategories** () const
        void **setColumnCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **columnCategoriesChanged** ()
        """
        ...

    def setColumnRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnRole-prop

        **columnRole : QString**

        This property holds the item model role to map to the column category.

        In addition to defining which column the data belongs to, the value
        indicated by the column role is also set as the X-coordinate value of
        **QSurfaceDataItem**  when model data is resolved, unless a separate x
        position role is also defined.

        **Access functions:**

        QString **columnRole** () const
        void **setColumnRole** (const QString
        & **role** )

        **Notifier signal:**

        void **columnRoleChanged** (const QString & **role** )
        """
        ...

    def setColumnRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnRolePattern
        -prop

        **columnRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the column role before it is used as a column category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **columnRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **columnRolePattern** () const
        void
        **setColumnRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **columnRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **columnRole**  and **columnRoleReplace** .
        """
        ...

    def setColumnRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#columnRoleReplace
        -prop

        **columnRoleReplace : QString**

        This property holds the replace content to be used in conjunction with a
        column role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **columnRoleReplace** () const
        void **setColumnRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **columnRoleReplaceChanged** (const QString & **replace** )

        **See also** **columnRole**  and **columnRolePattern** .
        """
        ...

    def setItemModel(self, itemModel: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#setItemModel

        **void QItemModelSurfaceDataProxy::setItemModel(QAbstractItemModel *
        itemModel )**

        Sets the item model to **itemModel**. Does not take ownership of the
        model, but does connect to it to listen for changes.

        **Note:** Setter function for property **itemModel** .

        **See also** **itemModel** ().
        """
        ...

    def setMultiMatchBehavior(
        self,
        behavior: PySide6.QtDataVisualization.QItemModelSurfaceDataProxy.MultiMatchBehavior,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#multiMatchBehavio
        r-prop

        **multiMatchBehavior : MultiMatchBehavior**

        How multiple matches for each row/column combination are handled.

        Defaults to **MMBLast** .

        For example, you might have an item model with timestamped data taken at
        irregular intervals and you want to visualize an average position of
        data items on each hour with a surface graph. This can be done by
        specifying row and column categories so that each surface point
        represents an hour, and setting this property to **MMBAverage** .

        **Access functions:**

        QItemModelSurfaceDataProxy::MultiMatchBehavior **multiMatchBehavior** ()
        const
        void **setMultiMatchBehavior**
        (QItemModelSurfaceDataProxy::MultiMatchBehavior **behavior** )

        **Notifier signal:**

        void **multiMatchBehaviorChanged**
        (QItemModelSurfaceDataProxy::MultiMatchBehavior **behavior** )
        """
        ...

    def setRowCategories(self, categories: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowCategories-
        prop

        **rowCategories : QStringList**

        This property holds the row categories for the mapping.

        **Access functions:**

        QStringList **rowCategories** () const
        void **setRowCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **rowCategoriesChanged** ()
        """
        ...

    def setRowRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowRole-prop

        **rowRole : QString**

        This property holds the item model role to map to the row category.

        In addition to defining which row the data belongs to, the value
        indicated by the row role is also set as the Z-coordinate value of
        **QSurfaceDataItem**  when model data is resolved, unless a separate z
        position role is also defined.

        **Access functions:**

        QString **rowRole** () const
        void **setRowRole** (const QString &
        **role** )

        **Notifier signal:**

        void **rowRoleChanged** (const QString & **role** )
        """
        ...

    def setRowRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowRolePattern-
        prop

        **rowRolePattern : QRegularExpression**

        This property holds whether a search and replace is performed on the
        value mapped by the row role before it is used as a row category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **rowRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **rowRolePattern** () const
        void
        **setRowRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rowRolePatternChanged** (const QRegularExpression & **pattern** )

        **See also** **rowRole**  and **rowRoleReplace** .
        """
        ...

    def setRowRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#rowRoleReplace-
        prop

        **rowRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the row role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rowRoleReplace** () const
        void **setRowRoleReplace** (const
        QString & **replace** )

        **Notifier signal:**

        void **rowRoleReplaceChanged** (const QString & **replace** )

        **See also** **rowRole**  and **rowRolePattern** .
        """
        ...

    def setUseModelCategories(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#useModelCategorie
        s-prop

        **useModelCategories : bool**

        This property holds whether row and column roles and categories are used
        for mapping.

        When set to `true`, the mapping ignores row and column roles and
        categories, and uses the rows and columns from the model instead.
        Defaults to `false`.

        **Access functions:**

        bool **useModelCategories** () const
        void **setUseModelCategories**
        (bool **enable** )

        **Notifier signal:**

        void **useModelCategoriesChanged** (bool **enable** )
        """
        ...

    def setXPosRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#xPosRole-prop

        **xPosRole : QString**

        This property holds the item model role to map to the X position.

        If this role is not defined, **columnRole**  is used to determine the
        X-coordinate value of the resolved **QSurfaceDataItem**  objects.

        **Access functions:**

        QString **xPosRole** () const
        void **setXPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **xPosRoleChanged** (const QString & **role** )
        """
        ...

    def setXPosRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#xPosRolePattern-
        prop

        **xPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the x position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **xPosRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **xPosRolePattern** () const
        void
        **setXPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **xPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **xPosRole**  and **xPosRoleReplace** .
        """
        ...

    def setXPosRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#xPosRoleReplace-
        prop

        **xPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        an x position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **xPosRoleReplace** () const
        void **setXPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **xPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **xPosRole**  and **xPosRolePattern** .
        """
        ...

    def setYPosRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#yPosRole-prop

        **yPosRole : QString**

        This property holds the item model role to map to the Y position.

        **Access functions:**

        QString **yPosRole** () const
        void **setYPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **yPosRoleChanged** (const QString & **role** )
        """
        ...

    def setYPosRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#yPosRolePattern-
        prop

        **yPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the y position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **yPosRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **yPosRolePattern** () const
        void
        **setYPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **yPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **yPosRole**  and **yPosRoleReplace** .
        """
        ...

    def setYPosRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#yPosRoleReplace-
        prop

        **yPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        an y position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **yPosRoleReplace** () const
        void **setYPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **yPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **yPosRole**  and **yPosRolePattern** .
        """
        ...

    def setZPosRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#zPosRole-prop

        **zPosRole : QString**

        This property holds the item model role to map to the Z position.

        If this role is not defined, **rowRole**  is used to determine the
        Z-coordinate value of resolved **QSurfaceDataItem**  objects.

        **Access functions:**

        QString **zPosRole** () const
        void **setZPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **zPosRoleChanged** (const QString & **role** )
        """
        ...

    def setZPosRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#zPosRolePattern-
        prop

        **zPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the z position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **zPosRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **zPosRolePattern** () const
        void
        **setZPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **zPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **zPosRole**  and **zPosRoleReplace** .
        """
        ...

    def setZPosRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#zPosRoleReplace-
        prop

        **zPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with a
        z position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **zPosRoleReplace** () const
        void **setZPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **zPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **zPosRole**  and **zPosRolePattern** .

        **Member Function Documentation**
        """
        ...

    def useModelCategories(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#useModelCategorie
        s-prop

        **useModelCategories : bool**

        This property holds whether row and column roles and categories are used
        for mapping.

        When set to `true`, the mapping ignores row and column roles and
        categories, and uses the rows and columns from the model instead.
        Defaults to `false`.

        **Access functions:**

        bool **useModelCategories** () const
        void **setUseModelCategories**
        (bool **enable** )

        **Notifier signal:**

        void **useModelCategoriesChanged** (bool **enable** )
        """
        ...

    def xPosRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#xPosRole-prop

        **xPosRole : QString**

        This property holds the item model role to map to the X position.

        If this role is not defined, **columnRole**  is used to determine the
        X-coordinate value of the resolved **QSurfaceDataItem**  objects.

        **Access functions:**

        QString **xPosRole** () const
        void **setXPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **xPosRoleChanged** (const QString & **role** )
        """
        ...

    def xPosRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#xPosRolePattern-
        prop

        **xPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the x position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **xPosRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **xPosRolePattern** () const
        void
        **setXPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **xPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **xPosRole**  and **xPosRoleReplace** .
        """
        ...

    def xPosRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#xPosRoleReplace-
        prop

        **xPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        an x position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **xPosRoleReplace** () const
        void **setXPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **xPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **xPosRole**  and **xPosRolePattern** .
        """
        ...

    def yPosRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#yPosRole-prop

        **yPosRole : QString**

        This property holds the item model role to map to the Y position.

        **Access functions:**

        QString **yPosRole** () const
        void **setYPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **yPosRoleChanged** (const QString & **role** )
        """
        ...

    def yPosRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#yPosRolePattern-
        prop

        **yPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the y position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **yPosRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **yPosRolePattern** () const
        void
        **setYPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **yPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **yPosRole**  and **yPosRoleReplace** .
        """
        ...

    def yPosRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#yPosRoleReplace-
        prop

        **yPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        an y position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **yPosRoleReplace** () const
        void **setYPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **yPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **yPosRole**  and **yPosRolePattern** .
        """
        ...

    def zPosRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#zPosRole-prop

        **zPosRole : QString**

        This property holds the item model role to map to the Z position.

        If this role is not defined, **rowRole**  is used to determine the
        Z-coordinate value of resolved **QSurfaceDataItem**  objects.

        **Access functions:**

        QString **zPosRole** () const
        void **setZPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **zPosRoleChanged** (const QString & **role** )
        """
        ...

    def zPosRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#zPosRolePattern-
        prop

        **zPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the z position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and the **zPosRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **zPosRolePattern** () const
        void
        **setZPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **zPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **zPosRole**  and **zPosRoleReplace** .
        """
        ...

    def zPosRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelsurfacedataproxy.html#zPosRoleReplace-
        prop

        **zPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with a
        z position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see the **QString::replace**
        (const **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **zPosRoleReplace** () const
        void **setZPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **zPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **zPosRole**  and **zPosRolePattern** .

        **Member Function Documentation**
        """
        ...

    @property
    def autoColumnCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def autoRowCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemModelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiMatchBehaviorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def useModelCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xPosRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xPosRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xPosRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yPosRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yPosRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yPosRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zPosRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zPosRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zPosRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
