"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QCustom3DVolume(PySide6.QtDataVisualization.QCustom3DItem):
    """
    https://doc.qt.io/qt-6/qcustom3dvolume.html

    **Detailed Description**

    A volume rendered object is a box with a 3D texture. Three slice planes are
    supported for the volume, one along each main axis of the volume.

    Rendering volume objects is very performance intensive, especially when the
    volume is largely transparent, as the contents of the volume are ray-traced.
    The performance scales nearly linearly with the amount of pixels that the
    volume occupies on the screen, so showing the volume in a smaller view or
    limiting the zoom level of the graph are easy ways to improve performance.
    Similarly, the volume texture dimensions have a large impact on performance.
    If the frame rate is more important than pixel-perfect rendering of the
    volume contents, consider turning the high definition shader off by setting
    the **useHighDefShader**  property to `false`.

    **Note:** Volumetric objects are only supported with orthographic
    projection.

    **Note:** Volumetric objects utilize 3D textures, which are not supported in
    OpenGL ES2 environments.

    **See also** **QAbstract3DGraph::addCustomItem** (),
    **QAbstract3DGraph::orthoProjection** , and **useHighDefShader** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#QCustom3DVolume

        **QCustom3DVolume::QCustom3DVolume(QObject * parent = nullptr)**

        Constructs a custom 3D volume with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        position: PySide6.QtGui.QVector3D,
        scaling: PySide6.QtGui.QVector3D,
        rotation: PySide6.QtGui.QQuaternion,
        textureWidth: int,
        textureHeight: int,
        textureDepth: int,
        textureData: Sequence[int],
        textureFormat: PySide6.QtGui.QImage.Format,
        colorTable: Sequence[int],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#QCustom3DVolume-1

        **QCustom3DVolume::QCustom3DVolume(const QVector3D & position , const
        QVector3D & scaling , const QQuaternion & rotation , int textureWidth ,
        int textureHeight , int textureDepth , QList<uchar> * textureData ,
        QImage::Format textureFormat , const QList<QRgb> & colorTable , QObject
        * parent = nullptr)**

        Constructs a custom 3D volume with the given **position** , **scaling**
        , **rotation** , **textureWidth** , **textureHeight** , **textureDepth**
        , **textureData** , **textureFormat** , **colorTable** , and optional
        **parent**.

        **See also** **textureData** , **setTextureFormat** (), and
        **colorTable** .
        """
        ...

    def alphaMultiplier(self) -> float:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#alphaMultiplier-prop

        **alphaMultiplier : float**

        This property holds the value that the alpha value of every texel of the
        volume texture is multiplied with at the render time.

        This property can be used to introduce uniform transparency to the
        volume. If **preserveOpacity**  is `true`, only texels with at least
        some transparency to begin with are affected, and fully opaque texels
        are not affected. The value must not be negative. Defaults to `1.0f`.

        **Access functions:**

        float **alphaMultiplier** () const
        void **setAlphaMultiplier** (float
        **mult** )

        **Notifier signal:**

        void **alphaMultiplierChanged** (float **mult** )

        **See also** **preserveOpacity**  and **textureData** .
        """
        ...

    def colorTable(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#colorTable-prop

        **colorTable : QList<QRgb>**

        This property holds the array containing the colors for indexed texture
        formats.

        If the texture format is not indexed, this array is not used and can be
        empty.

        Defaults to `0`.

        **Access functions:**

        QList<QRgb> **colorTable** () const
        void **setColorTable** (const
        QList<QRgb> & **colors** )

        **Notifier signal:**

        void **colorTableChanged** ()

        **See also** **textureData** , **setTextureFormat** (), and
        **QImage::colorTable** ().
        """
        ...

    def createTextureData(self, images: Sequence[PySide6.QtGui.QImage]) -> List[int]:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#createTextureData

        **QList<uchar> *QCustom3DVolume::createTextureData(const QList<QImage *>
        & images )**

        Creates a new texture data array from an array of **images** and sets it
        as **textureData**  for this volume object. The texture dimensions are
        also set according to image and array dimensions. All of the images in
        the array must be the same size. If the images are not all in the
        **QImage::Format_Indexed8**  format, all texture data will be converted
        into the **QImage::Format_ARGB32**  format. If the images are in the
        **QImage::Format_Indexed8**  format, the **colorTable**  value for the
        entire volume will be taken from the first image.

        Returns a pointer to the newly created array.

        **See also** **textureData** , **textureWidth** , **textureHeight** ,
        **textureDepth** , and **setTextureFormat** ().
        """
        ...

    def drawSliceFrames(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#drawSliceFrames-prop

        **drawSliceFrames : bool**

        This property holds whether slice frames are drawn around the volume.

        If this property value is `true`, the frames of slices indicated by
        slice index properties will be drawn around the volume. If it is
        `false`, no slice frames will be drawn.

        Drawing slice frames is independent of drawing slices, so you can show
        the full volume and still draw the slice frames around it. This is
        useful when using **renderSlice** () to display the slices outside the
        graph itself.

        Defaults to `false`.

        **Access functions:**

        bool **drawSliceFrames** () const
        void **setDrawSliceFrames** (bool
        **enable** )

        **Notifier signal:**

        void **drawSliceFramesChanged** (bool **enabled** )

        **See also** **sliceIndexX** , **sliceIndexY** , **sliceIndexZ** ,
        **drawSlices** , and **renderSlice** ().
        """
        ...

    def drawSlices(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#drawSlices-prop

        **drawSlices : bool**

        This property holds whether the specified slices are drawn instead of
        the full volume.

        If this property value is `true`, the slices indicated by slice index
        properties will be drawn instead of the full volume. If it is `false`,
        the full volume will always be drawn. Defaults to `false`.

        **Note:** The slices are always drawn along the item axes, so if the
        item is rotated, the slices are rotated as well.

        **Access functions:**

        bool **drawSlices** () const
        void **setDrawSlices** (bool **enable** )

        **Notifier signal:**

        void **drawSlicesChanged** (bool **enabled** )

        **See also** **sliceIndexX** , **sliceIndexY** , and **sliceIndexZ** .
        """
        ...

    def preserveOpacity(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#preserveOpacity-prop

        **preserveOpacity : bool**

        This property holds whether the alpha multiplier is applied to all
        texels.

        If this property value is `true`, **alphaMultiplier**  is only applied
        to texels that already have some transparency. If it is `false`, the
        multiplier is applied to the alpha value of all texels. Defaults to
        `true`.

        **Access functions:**

        bool **preserveOpacity** () const
        void **setPreserveOpacity** (bool
        **enable** )

        **Notifier signal:**

        void **preserveOpacityChanged** (bool **enabled** )

        **See also** **alphaMultiplier** .
        """
        ...

    def renderSlice(
        self, axis: PySide6.QtCore.Qt.Axis, index: int
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#renderSlice

        **QImage QCustom3DVolume::renderSlice(Qt::Axis axis , int index )**

        Renders the slice specified by **index** along the axis specified by
        **axis** into an image. The texture format of this object is used.

        Returns the rendered image of the slice, or a null image if an invalid
        index is specified.

        **See also** **setTextureFormat** ().
        """
        ...

    def setAlphaMultiplier(self, mult: float) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#alphaMultiplier-prop

        **alphaMultiplier : float**

        This property holds the value that the alpha value of every texel of the
        volume texture is multiplied with at the render time.

        This property can be used to introduce uniform transparency to the
        volume. If **preserveOpacity**  is `true`, only texels with at least
        some transparency to begin with are affected, and fully opaque texels
        are not affected. The value must not be negative. Defaults to `1.0f`.

        **Access functions:**

        float **alphaMultiplier** () const
        void **setAlphaMultiplier** (float
        **mult** )

        **Notifier signal:**

        void **alphaMultiplierChanged** (float **mult** )

        **See also** **preserveOpacity**  and **textureData** .
        """
        ...

    def setColorTable(self, colors: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#colorTable-prop

        **colorTable : QList<QRgb>**

        This property holds the array containing the colors for indexed texture
        formats.

        If the texture format is not indexed, this array is not used and can be
        empty.

        Defaults to `0`.

        **Access functions:**

        QList<QRgb> **colorTable** () const
        void **setColorTable** (const
        QList<QRgb> & **colors** )

        **Notifier signal:**

        void **colorTableChanged** ()

        **See also** **textureData** , **setTextureFormat** (), and
        **QImage::colorTable** ().
        """
        ...

    def setDrawSliceFrames(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#drawSliceFrames-prop

        **drawSliceFrames : bool**

        This property holds whether slice frames are drawn around the volume.

        If this property value is `true`, the frames of slices indicated by
        slice index properties will be drawn around the volume. If it is
        `false`, no slice frames will be drawn.

        Drawing slice frames is independent of drawing slices, so you can show
        the full volume and still draw the slice frames around it. This is
        useful when using **renderSlice** () to display the slices outside the
        graph itself.

        Defaults to `false`.

        **Access functions:**

        bool **drawSliceFrames** () const
        void **setDrawSliceFrames** (bool
        **enable** )

        **Notifier signal:**

        void **drawSliceFramesChanged** (bool **enabled** )

        **See also** **sliceIndexX** , **sliceIndexY** , **sliceIndexZ** ,
        **drawSlices** , and **renderSlice** ().
        """
        ...

    def setDrawSlices(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#drawSlices-prop

        **drawSlices : bool**

        This property holds whether the specified slices are drawn instead of
        the full volume.

        If this property value is `true`, the slices indicated by slice index
        properties will be drawn instead of the full volume. If it is `false`,
        the full volume will always be drawn. Defaults to `false`.

        **Note:** The slices are always drawn along the item axes, so if the
        item is rotated, the slices are rotated as well.

        **Access functions:**

        bool **drawSlices** () const
        void **setDrawSlices** (bool **enable** )

        **Notifier signal:**

        void **drawSlicesChanged** (bool **enabled** )

        **See also** **sliceIndexX** , **sliceIndexY** , and **sliceIndexZ** .
        """
        ...

    def setPreserveOpacity(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#preserveOpacity-prop

        **preserveOpacity : bool**

        This property holds whether the alpha multiplier is applied to all
        texels.

        If this property value is `true`, **alphaMultiplier**  is only applied
        to texels that already have some transparency. If it is `false`, the
        multiplier is applied to the alpha value of all texels. Defaults to
        `true`.

        **Access functions:**

        bool **preserveOpacity** () const
        void **setPreserveOpacity** (bool
        **enable** )

        **Notifier signal:**

        void **preserveOpacityChanged** (bool **enabled** )

        **See also** **alphaMultiplier** .
        """
        ...

    def setSliceFrameColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameColor-prop

        **sliceFrameColor : QColor**

        This property holds the color of the slice frame.

        Transparent slice frame color is not supported.

        Defaults to black.

        **Access functions:**

        QColor **sliceFrameColor** () const
        void **setSliceFrameColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **sliceFrameColorChanged** (const QColor & **color** )

        **See also** **drawSliceFrames** .
        """
        ...

    def setSliceFrameGaps(self, values: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameGaps-prop

        **sliceFrameGaps : QVector3D**

        This property holds the size of the air gap left between the volume
        itself and the frame in each dimension.

        The gap can be different on different dimensions. The values are
        fractions of the volume thickness in the same dimension. The values
        cannot be negative.

        Defaults to `QVector3D(0.01, 0.01, 0.01)`.

        **Access functions:**

        QVector3D **sliceFrameGaps** () const
        void **setSliceFrameGaps**
        (const QVector3D & **values** )

        **Notifier signal:**

        void **sliceFrameGapsChanged** (const QVector3D & **values** )

        **See also** **drawSliceFrames** .
        """
        ...

    def setSliceFrameThicknesses(self, values: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameThicknesses-prop

        **sliceFrameThicknesses : QVector3D**

        This property holds the thickness of the slice frames for each
        dimension.

        The values are fractions of the volume thickness in the same dimension.
        The values cannot be negative.

        Defaults to `QVector3D(0.01, 0.01, 0.01)`.

        **Access functions:**

        QVector3D **sliceFrameThicknesses** () const
        void
        **setSliceFrameThicknesses** (const QVector3D & **values** )

        **Notifier signal:**

        void **sliceFrameThicknessesChanged** (const QVector3D & **values** )

        **See also** **drawSliceFrames** .
        """
        ...

    def setSliceFrameWidths(self, values: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameWidths-prop

        **sliceFrameWidths : QVector3D**

        This property holds the width of the slice frame.

        The width can be different on different dimensions, so you can for
        example omit drawing the frames on certain sides of the volume by
        setting the value for that dimension to zero. The values are fractions
        of the volume thickness in the same dimension. The values cannot be
        negative.

        Defaults to `QVector3D(0.01, 0.01, 0.01)`.

        **Access functions:**

        QVector3D **sliceFrameWidths** () const
        void **setSliceFrameWidths**
        (const QVector3D & **values** )

        **Notifier signal:**

        void **sliceFrameWidthsChanged** (const QVector3D & **values** )

        **See also** **drawSliceFrames** .
        """
        ...

    def setSliceIndexX(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceIndexX-prop

        **sliceIndexX : int**

        This property holds the x-dimension index into the texture data
        indicating which vertical slice to show.

        Setting any dimension to negative indicates no slice or slice frame for
        that dimension is drawn. If all dimensions are negative, no slices or
        slice frames are drawn and the volume is drawn normally.

        Defaults to `-1`.

        **Access functions:**

        int **sliceIndexX** () const
        void **setSliceIndexX** (int **value** )

        **Notifier signal:**

        void **sliceIndexXChanged** (int **value** )

        **See also** **textureData** , **drawSlices** , and **drawSliceFrames**
        .
        """
        ...

    def setSliceIndexY(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceIndexY-prop

        **sliceIndexY : int**

        This property holds the y-dimension index into the texture data
        indicating which horizontal slice to show.

        Setting any dimension to negative indicates no slice or slice frame for
        that dimension is drawn. If all dimensions are negative, no slices or
        slice frames are drawn and the volume is drawn normally.

        Defaults to `-1`.

        **Access functions:**

        int **sliceIndexY** () const
        void **setSliceIndexY** (int **value** )

        **Notifier signal:**

        void **sliceIndexYChanged** (int **value** )

        **See also** **textureData** , **drawSlices** , and **drawSliceFrames**
        .
        """
        ...

    def setSliceIndexZ(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceIndexZ-prop

        **sliceIndexZ : int**

        This property holds the z-dimension index into the texture data
        indicating which vertical slice to show.

        Setting any dimension to negative indicates no slice or slice frame for
        that dimension is drawn. If all dimensions are negative, no slices or
        slice frames are drawn and the volume is drawn normally.

        Defaults to `-1`.

        **Access functions:**

        int **sliceIndexZ** () const
        void **setSliceIndexZ** (int **value** )

        **Notifier signal:**

        void **sliceIndexZChanged** (int **value** )

        **See also** **textureData** , **drawSlices** , and **drawSliceFrames**
        .
        """
        ...

    def setSliceIndices(self, x: int, y: int, z: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#setSliceIndices

        **void QCustom3DVolume::setSliceIndices(int x , int y , int z )**

        A convenience function for setting all three slice indices ( **x** ,
        **y** , and **z** ) at once.

        **See also** **textureData** .
        """
        ...

    @overload
    def setSubTextureData(
        self, axis: PySide6.QtCore.Qt.Axis, index: int, data: bytes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#setSubTextureData

        **void QCustom3DVolume::setSubTextureData(Qt::Axis axis , int index ,
        const uchar * data )**

        Sets a single 2D subtexture of the 3D texture along the specified
        **axis** of the volume. The **index** parameter specifies the subtexture
        to set. The texture **data** must be in the format specified by the
        **textureFormat**  property and have the size of the cross-section of
        the volume texture along the specified axis multiplied by the texture
        format color depth in bytes. The **data** is expected to be ordered
        similarly to the data in images produced by the **renderSlice** ()
        method along the same axis.

        **Note:** Each x-dimension line of the data needs to be 32-bit aligned
        when targeting the y-axis or z-axis. If **textureFormat**  is
        **QImage::Format_Indexed8**  and the **textureWidth**  value is not
        divisible by four, padding bytes might need to be added to each
        x-dimension line of the **data** to properly align it. The padding bytes
        should indicate a fully transparent color to avoid rendering artifacts.

        **See also** **textureData**  and **renderSlice** ().
        """
        ...

    @overload
    def setSubTextureData(
        self,
        axis: PySide6.QtCore.Qt.Axis,
        index: int,
        image: Union[PySide6.QtGui.QImage, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#setSubTextureData-1

        **void QCustom3DVolume::setSubTextureData(Qt::Axis axis , int index ,
        const QImage & image )**

        Sets a single 2D subtexture of the 3D texture along the specified
        **axis** of the volume. The **index** parameter specifies the subtexture
        to set. The source **image** must be in the format specified by the
        **textureFormat**  property if **textureFormat**  is indexed. If
        **textureFormat**  is **QImage::Format_ARGB32** , the image is converted
        to that format. The image must have the size of the cross-section of the
        volume texture along the specified axis. The orientation of the image
        should correspond to the orientation of the slice image produced by
        **renderSlice** () method along the same axis.

        **Note:** Each x-dimension line of the data needs to be 32-bit aligned
        when targeting the y-axis or z-axis. If **textureFormat**  is
        **QImage::Format_Indexed8**  and the **textureWidth**  value is not
        divisible by four, padding bytes might need to be added to each
        x-dimension line of the image to properly align it. The padding bytes
        should indicate a fully transparent color to avoid rendering artifacts.
        It is not guaranteed that **QImage**  will do this automatically.

        **See also** **textureData**  and **renderSlice** ().
        """
        ...

    def setTextureData(self, arg__1: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureData-prop

        **textureData : QList<uchar>***

        This property holds the array containing the texture data in the format
        specified by **textureFormat** .

        The size of this array must be at least (`textureDataWidth *
        textureHeight * textureDepth * texture format color depth in bytes`).

        A 3D texture is defined by a stack of 2D subtextures. Each subtexture
        must be of identical size (`textureDataWidth * textureHeight`), and the
        depth of the stack is defined by the **textureDepth**  property. The
        data in each 2D texture is identical to a **QImage**  data with the same
        format, so **QImage::bits** () can be used to supply the data for each
        subtexture.

        Ownership of the new array transfers to the **QCustom3DVolume**
        instance. If another array is set, the previous array is deleted. If the
        same array is set again, it is assumed that the array contents have been
        changed and the graph rendering is triggered.

        **Note:** Each x-dimension line of the data needs to be 32-bit aligned.
        If **textureFormat**  is **QImage::Format_Indexed8**  and the
        **textureWidth**  value is not divisible by four, padding bytes might
        need to be added to each x-dimension line of the **data**. The
        **textureDataWidth** () function returns the padded byte count. The
        padding bytes should indicate a fully transparent color to avoid
        rendering artifacts.

        Defaults to `0`.

        **Access functions:**

        QList<uchar> * **textureData** () const
        void **setTextureData**
        (QList<uchar> * **data** )

        **Notifier signal:**

        void **textureDataChanged** (QList<uchar> * **data** )

        **See also** **colorTable** , **setTextureFormat** (),
        **setSubTextureData** (), and **textureDataWidth** ().
        """
        ...

    def setTextureDepth(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureDepth-prop

        **textureDepth : int**

        This property holds the depth of the 3D texture defining the volume
        content in pixels.

        Defaults to `0`.

        **Note:** The **textureData**  value may need to be resized or recreated
        if this value is changed. Defaults to `0`.

        **Access functions:**

        int **textureDepth** () const
        void **setTextureDepth** (int **value**
        )

        **Notifier signal:**

        void **textureDepthChanged** (int **value** )

        **See also** **textureData** , **textureWidth** , **textureHeight** ,
        and **setTextureFormat** ().
        """
        ...

    def setTextureDimensions(self, width: int, height: int, depth: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#setTextureDimensions

        **void QCustom3DVolume::setTextureDimensions(int width , int height ,
        int depth )**

        A convenience function for setting all three texture dimensions (
        **width** , **height** , and **depth** ) at once.

        **See also** **textureData** .
        """
        ...

    def setTextureFormat(self, format: PySide6.QtGui.QImage.Format) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#setTextureFormat

        **void QCustom3DVolume::setTextureFormat(QImage::Format format )**

        Sets the format of the **textureData**  property to **format**. Only two
        formats are supported currently: **QImage::Format_Indexed8**  and
        **QImage::Format_ARGB32** . If an indexed format is specified,
        **colorTable**  must also be set. Defaults to **QImage::Format_ARGB32**
        .

        **See also** **textureFormat** (), **colorTable** , and **textureData**
        .
        """
        ...

    def setTextureHeight(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureHeight-prop

        **textureHeight : int**

        This property holds the height of the 3D texture defining the volume
        content in pixels.

        Defaults to `0`.

        **Note:** The **textureData**  value may need to be resized or recreated
        if this value is changed. Defaults to `0`.

        **Access functions:**

        int **textureHeight** () const
        void **setTextureHeight** (int
        **value** )

        **Notifier signal:**

        void **textureHeightChanged** (int **value** )

        **See also** **textureData** , **textureWidth** , **textureDepth** , and
        **setTextureFormat** ().
        """
        ...

    def setTextureWidth(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureWidth-prop

        **textureWidth : int**

        This property holds the width of the 3D texture defining the volume
        content in pixels.

        Defaults to `0`.

        **Note:** The **textureData**  value may need to be resized or recreated
        if this value is changed. Defaults to `0`.

        **Access functions:**

        int **textureWidth** () const
        void **setTextureWidth** (int **value**
        )

        **Notifier signal:**

        void **textureWidthChanged** (int **value** )

        **See also** **textureData** , **textureHeight** , **textureDepth** ,
        **setTextureFormat** (), and **textureDataWidth** ().
        """
        ...

    def setUseHighDefShader(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#useHighDefShader-prop

        **useHighDefShader : bool**

        This property holds whether a high or low definition shader is used to
        render the volume.

        If this property value is `true`, a high definition shader is used. If
        it is `false`, a low definition shader is used.

        The high definition shader guarantees that every visible texel of the
        volume texture is sampled when the volume is rendered. The low
        definition shader renders only a rough approximation of the volume
        contents, but at a much higher frame rate. The low definition shader
        does not guarantee that every texel of the volume texture is sampled, so
        there may be flickering if the volume contains distinct thin features.

        **Note:** This value does not affect the level of detail when rendering
        the slices of the volume.

        Defaults to `true`.

        **Access functions:**

        bool **useHighDefShader** () const
        void **setUseHighDefShader** (bool
        **enable** )

        **Notifier signal:**

        void **useHighDefShaderChanged** (bool **enabled** )

        **See also** **renderSlice** ().

        **Member Function Documentation**
        """
        ...

    def sliceFrameColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameColor-prop

        **sliceFrameColor : QColor**

        This property holds the color of the slice frame.

        Transparent slice frame color is not supported.

        Defaults to black.

        **Access functions:**

        QColor **sliceFrameColor** () const
        void **setSliceFrameColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **sliceFrameColorChanged** (const QColor & **color** )

        **See also** **drawSliceFrames** .
        """
        ...

    def sliceFrameGaps(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameGaps-prop

        **sliceFrameGaps : QVector3D**

        This property holds the size of the air gap left between the volume
        itself and the frame in each dimension.

        The gap can be different on different dimensions. The values are
        fractions of the volume thickness in the same dimension. The values
        cannot be negative.

        Defaults to `QVector3D(0.01, 0.01, 0.01)`.

        **Access functions:**

        QVector3D **sliceFrameGaps** () const
        void **setSliceFrameGaps**
        (const QVector3D & **values** )

        **Notifier signal:**

        void **sliceFrameGapsChanged** (const QVector3D & **values** )

        **See also** **drawSliceFrames** .
        """
        ...

    def sliceFrameThicknesses(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameThicknesses-prop

        **sliceFrameThicknesses : QVector3D**

        This property holds the thickness of the slice frames for each
        dimension.

        The values are fractions of the volume thickness in the same dimension.
        The values cannot be negative.

        Defaults to `QVector3D(0.01, 0.01, 0.01)`.

        **Access functions:**

        QVector3D **sliceFrameThicknesses** () const
        void
        **setSliceFrameThicknesses** (const QVector3D & **values** )

        **Notifier signal:**

        void **sliceFrameThicknessesChanged** (const QVector3D & **values** )

        **See also** **drawSliceFrames** .
        """
        ...

    def sliceFrameWidths(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceFrameWidths-prop

        **sliceFrameWidths : QVector3D**

        This property holds the width of the slice frame.

        The width can be different on different dimensions, so you can for
        example omit drawing the frames on certain sides of the volume by
        setting the value for that dimension to zero. The values are fractions
        of the volume thickness in the same dimension. The values cannot be
        negative.

        Defaults to `QVector3D(0.01, 0.01, 0.01)`.

        **Access functions:**

        QVector3D **sliceFrameWidths** () const
        void **setSliceFrameWidths**
        (const QVector3D & **values** )

        **Notifier signal:**

        void **sliceFrameWidthsChanged** (const QVector3D & **values** )

        **See also** **drawSliceFrames** .
        """
        ...

    def sliceIndexX(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceIndexX-prop

        **sliceIndexX : int**

        This property holds the x-dimension index into the texture data
        indicating which vertical slice to show.

        Setting any dimension to negative indicates no slice or slice frame for
        that dimension is drawn. If all dimensions are negative, no slices or
        slice frames are drawn and the volume is drawn normally.

        Defaults to `-1`.

        **Access functions:**

        int **sliceIndexX** () const
        void **setSliceIndexX** (int **value** )

        **Notifier signal:**

        void **sliceIndexXChanged** (int **value** )

        **See also** **textureData** , **drawSlices** , and **drawSliceFrames**
        .
        """
        ...

    def sliceIndexY(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceIndexY-prop

        **sliceIndexY : int**

        This property holds the y-dimension index into the texture data
        indicating which horizontal slice to show.

        Setting any dimension to negative indicates no slice or slice frame for
        that dimension is drawn. If all dimensions are negative, no slices or
        slice frames are drawn and the volume is drawn normally.

        Defaults to `-1`.

        **Access functions:**

        int **sliceIndexY** () const
        void **setSliceIndexY** (int **value** )

        **Notifier signal:**

        void **sliceIndexYChanged** (int **value** )

        **See also** **textureData** , **drawSlices** , and **drawSliceFrames**
        .
        """
        ...

    def sliceIndexZ(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#sliceIndexZ-prop

        **sliceIndexZ : int**

        This property holds the z-dimension index into the texture data
        indicating which vertical slice to show.

        Setting any dimension to negative indicates no slice or slice frame for
        that dimension is drawn. If all dimensions are negative, no slices or
        slice frames are drawn and the volume is drawn normally.

        Defaults to `-1`.

        **Access functions:**

        int **sliceIndexZ** () const
        void **setSliceIndexZ** (int **value** )

        **Notifier signal:**

        void **sliceIndexZChanged** (int **value** )

        **See also** **textureData** , **drawSlices** , and **drawSliceFrames**
        .
        """
        ...

    def textureData(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureData-prop

        **textureData : QList<uchar>***

        This property holds the array containing the texture data in the format
        specified by **textureFormat** .

        The size of this array must be at least (`textureDataWidth *
        textureHeight * textureDepth * texture format color depth in bytes`).

        A 3D texture is defined by a stack of 2D subtextures. Each subtexture
        must be of identical size (`textureDataWidth * textureHeight`), and the
        depth of the stack is defined by the **textureDepth**  property. The
        data in each 2D texture is identical to a **QImage**  data with the same
        format, so **QImage::bits** () can be used to supply the data for each
        subtexture.

        Ownership of the new array transfers to the **QCustom3DVolume**
        instance. If another array is set, the previous array is deleted. If the
        same array is set again, it is assumed that the array contents have been
        changed and the graph rendering is triggered.

        **Note:** Each x-dimension line of the data needs to be 32-bit aligned.
        If **textureFormat**  is **QImage::Format_Indexed8**  and the
        **textureWidth**  value is not divisible by four, padding bytes might
        need to be added to each x-dimension line of the **data**. The
        **textureDataWidth** () function returns the padded byte count. The
        padding bytes should indicate a fully transparent color to avoid
        rendering artifacts.

        Defaults to `0`.

        **Access functions:**

        QList<uchar> * **textureData** () const
        void **setTextureData**
        (QList<uchar> * **data** )

        **Notifier signal:**

        void **textureDataChanged** (QList<uchar> * **data** )

        **See also** **colorTable** , **setTextureFormat** (),
        **setSubTextureData** (), and **textureDataWidth** ().
        """
        ...

    def textureDataWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureDataWidth

        **int QCustom3DVolume::textureDataWidth() const**

        Returns the actual texture data width. When the texture format is
        **QImage::Format_Indexed8** , this value equals **textureWidth**
        aligned to a 32-bit boundary. Otherwise, this value equals four times
        **textureWidth** .
        """
        ...

    def textureDepth(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureDepth-prop

        **textureDepth : int**

        This property holds the depth of the 3D texture defining the volume
        content in pixels.

        Defaults to `0`.

        **Note:** The **textureData**  value may need to be resized or recreated
        if this value is changed. Defaults to `0`.

        **Access functions:**

        int **textureDepth** () const
        void **setTextureDepth** (int **value**
        )

        **Notifier signal:**

        void **textureDepthChanged** (int **value** )

        **See also** **textureData** , **textureWidth** , **textureHeight** ,
        and **setTextureFormat** ().
        """
        ...

    def textureFormat(self) -> PySide6.QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureFormat

        **QImage::Format QCustom3DVolume::textureFormat() const**

        Returns the format of the **textureData**  property value.

        **See also** **setTextureFormat** ().
        """
        ...

    def textureHeight(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureHeight-prop

        **textureHeight : int**

        This property holds the height of the 3D texture defining the volume
        content in pixels.

        Defaults to `0`.

        **Note:** The **textureData**  value may need to be resized or recreated
        if this value is changed. Defaults to `0`.

        **Access functions:**

        int **textureHeight** () const
        void **setTextureHeight** (int
        **value** )

        **Notifier signal:**

        void **textureHeightChanged** (int **value** )

        **See also** **textureData** , **textureWidth** , **textureDepth** , and
        **setTextureFormat** ().
        """
        ...

    def textureWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureWidth-prop

        **textureWidth : int**

        This property holds the width of the 3D texture defining the volume
        content in pixels.

        Defaults to `0`.

        **Note:** The **textureData**  value may need to be resized or recreated
        if this value is changed. Defaults to `0`.

        **Access functions:**

        int **textureWidth** () const
        void **setTextureWidth** (int **value**
        )

        **Notifier signal:**

        void **textureWidthChanged** (int **value** )

        **See also** **textureData** , **textureHeight** , **textureDepth** ,
        **setTextureFormat** (), and **textureDataWidth** ().
        """
        ...

    def useHighDefShader(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#useHighDefShader-prop

        **useHighDefShader : bool**

        This property holds whether a high or low definition shader is used to
        render the volume.

        If this property value is `true`, a high definition shader is used. If
        it is `false`, a low definition shader is used.

        The high definition shader guarantees that every visible texel of the
        volume texture is sampled when the volume is rendered. The low
        definition shader renders only a rough approximation of the volume
        contents, but at a much higher frame rate. The low definition shader
        does not guarantee that every texel of the volume texture is sampled, so
        there may be flickering if the volume contains distinct thin features.

        **Note:** This value does not affect the level of detail when rendering
        the slices of the volume.

        Defaults to `true`.

        **Access functions:**

        bool **useHighDefShader** () const
        void **setUseHighDefShader** (bool
        **enable** )

        **Notifier signal:**

        void **useHighDefShaderChanged** (bool **enabled** )

        **See also** **renderSlice** ().

        **Member Function Documentation**
        """
        ...

    @property
    def alphaMultiplierChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def colorTableChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def drawSliceFramesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def drawSlicesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def preserveOpacityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceFrameColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceFrameGapsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceFrameThicknessesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceFrameWidthsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceIndexXChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceIndexYChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sliceIndexZChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureDataChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureDepthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcustom3dvolume.html#textureFormatChanged

        **[signal] void QCustom3DVolume::textureFormatChanged(QImage::Format
        format )**

        This signal is emitted when the **format** of the **textureData**  value
        changes.

        **See also** **setTextureFormat** ().
        """
        ...

    @property
    def textureHeightChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def useHighDefShaderChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
