"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QCustom3DLabel(PySide6.QtDataVisualization.QCustom3DItem):
    """
    https://doc.qt.io/qt-6/qcustom3dlabel.html

    **Detailed Description**

    The text, font, position, scaling, rotation, and colors of a custom label
    can be set. In addition, the visibility of the borders and background of the
    label can be toggled. Colors, borders, and background are determined by the
    active theme unless set explicitly.

    **Note:** In scaling, the z-coordinate has no effect. Setting the same x-
    and y-coordinates retains the original font dimensions.

    **See also** **QAbstract3DGraph::addCustomItem** ().
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#QCustom3DLabel

        **QCustom3DLabel::QCustom3DLabel(QObject * parent = nullptr)**

        Constructs a custom 3D label with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        text: str,
        font: Union[PySide6.QtGui.QFont, str, Sequence[str]],
        position: PySide6.QtGui.QVector3D,
        scaling: PySide6.QtGui.QVector3D,
        rotation: PySide6.QtGui.QQuaternion,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#QCustom3DLabel-1

        **QCustom3DLabel::QCustom3DLabel(const QString & text , const QFont &
        font , const QVector3D & position , const QVector3D & scaling , const
        QQuaternion & rotation , QObject * parent = nullptr)**

        Constructs a custom 3D label with the given **text** , **font** ,
        **position** , **scaling** , **rotation** , and optional **parent**.

        **Note:** Setting the same x- and y-coordinates for **scaling** retains
        the original font dimensions.
        """
        ...

    def backgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#backgroundColor-prop

        **backgroundColor : QColor**

        This property holds the color for the label background, if enabled.

        Defaults to `Qt::gray`.

        **Access functions:**

        QColor **backgroundColor** () const
        void **setBackgroundColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **backgroundColorChanged** (const QColor & **color** )

        **See also** **backgroundEnabled** .
        """
        ...

    def font(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#font-prop

        **font : QFont**

        This property holds the font to be used for the label.

        Defaults to `QFont("Arial", 20)`. Special formatting (for example,
        outlined) is not supported.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **Notifier signal:**

        void **fontChanged** (const QFont & **font** )
        """
        ...

    def isBackgroundEnabled(self) -> bool:
        ...

    def isBorderEnabled(self) -> bool:
        ...

    def isFacingCamera(self) -> bool:
        ...

    def setBackgroundColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#backgroundColor-prop

        **backgroundColor : QColor**

        This property holds the color for the label background, if enabled.

        Defaults to `Qt::gray`.

        **Access functions:**

        QColor **backgroundColor** () const
        void **setBackgroundColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **backgroundColorChanged** (const QColor & **color** )

        **See also** **backgroundEnabled** .
        """
        ...

    def setBackgroundEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#backgroundEnabled-prop

        **backgroundEnabled : bool**

        This property holds whether the label background is enabled.

        If set to `false`, **backgroundColor** () has no effect. Defaults to
        `true`.

        **Access functions:**

        bool **isBackgroundEnabled** () const
        void **setBackgroundEnabled**
        (bool **enabled** )

        **Notifier signal:**

        void **backgroundEnabledChanged** (bool **enabled** )
        """
        ...

    def setBorderEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#borderEnabled-prop

        **borderEnabled : bool**

        This property holds whether label borders are enabled.

        Defaults to `true`.

        **Access functions:**

        bool **isBorderEnabled** () const
        void **setBorderEnabled** (bool
        **enabled** )

        **Notifier signal:**

        void **borderEnabledChanged** (bool **enabled** )
        """
        ...

    def setFacingCamera(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#facingCamera-prop

        **facingCamera : bool**

        This property holds whether the label will always face the camera.

        Defaults to `false`. If set to `true`, **rotation** () has no effect.

        **Access functions:**

        bool **isFacingCamera** () const
        void **setFacingCamera** (bool
        **enabled** )

        **Notifier signal:**

        void **facingCameraChanged** (bool **enabled** )
        """
        ...

    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#font-prop

        **font : QFont**

        This property holds the font to be used for the label.

        Defaults to `QFont("Arial", 20)`. Special formatting (for example,
        outlined) is not supported.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **Notifier signal:**

        void **fontChanged** (const QFont & **font** )
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#text-prop

        **text : QString**

        This property holds the text for the label.

        Rich text is not supported.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **Notifier signal:**

        void **textChanged** (const QString & **text** )
        """
        ...

    def setTextColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#textColor-prop

        **textColor : QColor**

        This property holds the color for the label text.

        Also affects the label border, if enabled. Defaults to `Qt::white`.

        **Access functions:**

        QColor **textColor** () const
        void **setTextColor** (const QColor &
        **color** )

        **Notifier signal:**

        void **textColorChanged** (const QColor & **color** )

        **See also** **borderEnabled** .

        **Member Function Documentation**
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#text-prop

        **text : QString**

        This property holds the text for the label.

        Rich text is not supported.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **Notifier signal:**

        void **textChanged** (const QString & **text** )
        """
        ...

    def textColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcustom3dlabel.html#textColor-prop

        **textColor : QColor**

        This property holds the color for the label text.

        Also affects the label border, if enabled. Defaults to `Qt::white`.

        **Access functions:**

        QColor **textColor** () const
        void **setTextColor** (const QColor &
        **color** )

        **Notifier signal:**

        void **textColorChanged** (const QColor & **color** )

        **See also** **borderEnabled** .

        **Member Function Documentation**
        """
        ...

    @property
    def backgroundColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def backgroundEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def borderEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def facingCameraChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def fontChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
