"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QCategory3DAxis(PySide6.QtDataVisualization.QAbstract3DAxis):
    """
    https://doc.qt.io/qt-6/qcategory3daxis.html

    **Detailed Description**

    QCategory3DAxis provides an axis that can be given labels. The axis is
    divided into equal-sized categories based on the data window size defined by
    setting the axis range.

    Grid lines are drawn between categories, if visible. Labels are drawn to
    positions of categories if provided.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcategory3daxis.html#QCategory3DAxis

        **QCategory3DAxis::QCategory3DAxis(QObject * parent = nullptr)**

        Constructs a category 3D axis with the parent **parent**.
        """
        ...

    def labels(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qcategory3daxis.html#labels-prop

        **labels : QStringList**

        This property holds the labels for the axis applied to categories.

        If there are fewer labels than categories, the remaining ones do not
        have a label. If category labels are not defined explicitly, labels are
        generated from the data row (or column) labels of the primary series of
        the graph.

        **Access functions:**

        QStringList **labels** () const
        void **setLabels** (const QStringList
        & **labels** )

        **Notifier signal:**

        void **labelsChanged** ()

        **Member Function Documentation**
        """
        ...

    def setLabels(self, labels: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qcategory3daxis.html#labels-prop

        **labels : QStringList**

        This property holds the labels for the axis applied to categories.

        If there are fewer labels than categories, the remaining ones do not
        have a label. If category labels are not defined explicitly, labels are
        generated from the data row (or column) labels of the primary series of
        the graph.

        **Access functions:**

        QStringList **labels** () const
        void **setLabels** (const QStringList
        & **labels** )

        **Notifier signal:**

        void **labelsChanged** ()

        **Member Function Documentation**
        """
        ...

    @property
    def labelsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
