"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QBarDataProxy(PySide6.QtDataVisualization.QAbstractDataProxy):
    """
    https://doc.qt.io/qt-6/qbardataproxy.html

    **Detailed Description**

    A bar data proxy handles adding, inserting, changing, and removing rows of
    data.

    The data array is a list of vectors (rows) of **QBarDataItem**  instances.
    Each row can contain a different number of items or even be null.

    QBarDataProxy takes ownership of all QtDataVisualization::QBarDataRow
    objects passed to it, whether directly or in a
    QtDataVisualization::QBarDataArray container. If bar data row pointers are
    used to directly modify data after adding the array to the proxy, the
    appropriate signal must be emitted to update the graph.

    QBarDataProxy optionally keeps track of row and column labels, which
    **QCategory3DAxis**  can utilize to show axis labels. The row and column
    labels are stored in a separate array from the data and row manipulation
    methods provide alternate versions that do not affect the row labels. This
    enables the option of having row labels that relate to the position of the
    data in the array rather than the data itself.

    **See also** **Qt Data Visualization Data Handling** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#QBarDataProxy

        **QBarDataProxy::QBarDataProxy(QObject * parent = nullptr)**

        Constructs a bar data proxy with the given **parent**.
        """
        ...

    @overload
    def addRow(self, arg__1: Sequence[PySide6.QtDataVisualization.QBarDataItem]) -> int:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#addRow

        **int QBarDataProxy::addRow(QBarDataRow * row )**

        Adds the new row **row** to the end of an array. Existing row labels are
        not affected.

        Returns the index of the added row.
        """
        ...

    @overload
    def addRow(
        self, arg__1: Sequence[PySide6.QtDataVisualization.QBarDataItem], arg__2: str
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#addRow-1

        **int QBarDataProxy::addRow(QBarDataRow * row , const QString & label
        )**

        Adds a the new row **row** with the label **label** to the end of an
        array.

        Returns the index of the added row.
        """
        ...

    @overload
    def addRows(
        self, rows: List[List[PySide6.QtDataVisualization.QBarDataItem]]
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#addRows

        **int QBarDataProxy::addRows(const QBarDataArray & rows )**

        Adds the new **rows** to the end of an array. Existing row labels are
        not affected.

        Returns the index of the first added row.
        """
        ...

    @overload
    def addRows(
        self,
        rows: List[List[PySide6.QtDataVisualization.QBarDataItem]],
        labels: Sequence[str],
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#addRows-1

        **int QBarDataProxy::addRows(const QBarDataArray & rows , const
        QStringList & labels )**

        Adds the new **rows** with **labels** to the end of the array.

        Returns the index of the first added row.
        """
        ...

    def array(self) -> List[List[PySide6.QtDataVisualization.QBarDataItem]]:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#array

        **const QBarDataArray *QBarDataProxy::array() const**

        Returns the pointer to the data array.
        """
        ...

    def columnLabels(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#columnLabels-prop

        **columnLabels : QStringList**

        This property holds the optional column labels for the array.

        Indexes in this array match column indexes in rows. If the list is
        shorter than the longest row, all columns will not get labels.

        **Access functions:**

        QStringList **columnLabels** () const
        void **setColumnLabels** (const
        QStringList & **labels** )

        **Notifier signal:**

        void **columnLabelsChanged** ()
        """
        ...

    @overload
    def insertRow(
        self, arg__1: int, arg__2: Sequence[PySide6.QtDataVisualization.QBarDataItem]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#insertRow

        **void QBarDataProxy::insertRow(int rowIndex , QBarDataRow * row )**

        Inserts the new row **row** into **rowIndex**. If **rowIndex** is equal
        to the array size, the rows are added to the end of the array. The
        existing row labels are not affected.

        **Note:** The row labels array will be out of sync with the row array
        after this call if there were labeled rows beyond the inserted row.
        """
        ...

    @overload
    def insertRow(
        self,
        arg__1: int,
        arg__2: Sequence[PySide6.QtDataVisualization.QBarDataItem],
        arg__3: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#insertRow-1

        **void QBarDataProxy::insertRow(int rowIndex , QBarDataRow * row , const
        QString & label )**

        Inserts the new row **row** with the label **label** into **rowIndex**.
        If **rowIndex** is equal to array size, rows are added to the end of the
        array.
        """
        ...

    @overload
    def insertRows(
        self, rowIndex: int, rows: List[List[PySide6.QtDataVisualization.QBarDataItem]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#insertRows

        **void QBarDataProxy::insertRows(int rowIndex , const QBarDataArray &
        rows )**

        Inserts new **rows** into **rowIndex**. If **rowIndex** is equal to the
        array size, the rows are added to the end of the array. The existing row
        labels are not affected.

        **Note:** The row labels array will be out of sync with the row array
        after this call if there were labeled rows beyond the inserted rows.
        """
        ...

    @overload
    def insertRows(
        self,
        rowIndex: int,
        rows: List[List[PySide6.QtDataVisualization.QBarDataItem]],
        labels: Sequence[str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#insertRows-1

        **void QBarDataProxy::insertRows(int rowIndex , const QBarDataArray &
        rows , const QStringList & labels )**

        Inserts new **rows** with **labels** into **rowIndex**. If **rowIndex**
        is equal to the array size, the rows are added to the end of the array.
        """
        ...

    @overload
    def itemAt(
        self, position: PySide6.QtCore.QPoint
    ) -> PySide6.QtDataVisualization.QBarDataItem:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#itemAt

        **const QBarDataItem *QBarDataProxy::itemAt(int rowIndex , int
        columnIndex ) const**

        Returns the pointer to the item at the position specified by
        **rowIndex** and **columnIndex**. It is guaranteed to be valid only
        until the next call that modifies data.
        """
        ...

    @overload
    def itemAt(
        self, rowIndex: int, columnIndex: int
    ) -> PySide6.QtDataVisualization.QBarDataItem:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#itemAt-1

        **const QBarDataItem *QBarDataProxy::itemAt(const QPoint & position )
        const**

        Returns the pointer to the item at the position **position**. The
        x-value of **position** indicates the row and the y-value indicates the
        column. The item is guaranteed to be valid only until the next call that
        modifies data.
        """
        ...

    def removeRows(
        self, rowIndex: int, removeCount: int, removeLabels: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#removeRows

        **void QBarDataProxy::removeRows(int rowIndex , int removeCount , bool
        removeLabels = true)**

        Removes the number of rows specified by **removeCount** starting at the
        position **rowIndex**. Attempting to remove rows past the end of the
        array does nothing. If **removeLabels** is `true`, the corresponding row
        labels are also removed. Otherwise, the row labels are not affected.

        **Note:** If **removeLabels** is `false`, the row labels array will be
        out of sync with the row array if there are labeled rows beyond the
        removed rows.
        """
        ...

    @overload
    def resetArray(self) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#resetArray

        **void QBarDataProxy::resetArray()**

        Clears the existing array and row and column labels.
        """
        ...

    @overload
    def resetArray(
        self, newArray: List[List[PySide6.QtDataVisualization.QBarDataItem]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#resetArray-1

        **void QBarDataProxy::resetArray(QBarDataArray * newArray )**

        Takes ownership of the array **newArray**. Clears the existing array if
        the new array differs from it. If the arrays are the same, this function
        just triggers the **arrayReset** () signal.

        Passing a null array deletes the old array and creates a new empty
        array. Row and column labels are not affected.
        """
        ...

    @overload
    def resetArray(
        self,
        newArray: List[List[PySide6.QtDataVisualization.QBarDataItem]],
        rowLabels: Sequence[str],
        columnLabels: Sequence[str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#resetArray-2

        **void QBarDataProxy::resetArray(QBarDataArray * newArray , const
        QStringList & rowLabels , const QStringList & columnLabels )**

        Takes ownership of the array **newArray**. Clears the existing array if
        the new array differs from it. If the arrays are the same, this function
        just triggers the **arrayReset** () signal.

        Passing a null array deletes the old array and creates a new empty
        array.

        The **rowLabels** and **columnLabels** lists specify the new labels for
        rows and columns.
        """
        ...

    def rowAt(self, rowIndex: int) -> List[PySide6.QtDataVisualization.QBarDataItem]:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowAt

        **const QBarDataRow *QBarDataProxy::rowAt(int rowIndex ) const**

        Returns the pointer to the row at the position **rowIndex**. It is
        guaranteed to be valid only until the next call that modifies data.
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowCount-prop

        **[read-only] rowCount : const int**

        This property holds the number of rows in the array.

        **Access functions:**

        int **rowCount** () const

        **Notifier signal:**

        void **rowCountChanged** (int **count** )
        """
        ...

    def rowLabels(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowLabels-prop

        **rowLabels : QStringList**

        This property holds the optional row labels for the array.

        Indexes in this array match the row indexes in the data array. If the
        list is shorter than the number of rows, all rows will not get labels.

        **Access functions:**

        QStringList **rowLabels** () const
        void **setRowLabels** (const
        QStringList & **labels** )

        **Notifier signal:**

        void **rowLabelsChanged** ()
        """
        ...

    def series(self) -> PySide6.QtDataVisualization.QBar3DSeries:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#series-prop

        **[read-only] series : QBar3DSeries* const**

        This property holds the series this proxy is attached to.

        **Access functions:**

        QBar3DSeries * **series** () const

        **Notifier signal:**

        void **seriesChanged** (QBar3DSeries * **series** )

        **Member Function Documentation**
        """
        ...

    def setColumnLabels(self, labels: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#columnLabels-prop

        **columnLabels : QStringList**

        This property holds the optional column labels for the array.

        Indexes in this array match column indexes in rows. If the list is
        shorter than the longest row, all columns will not get labels.

        **Access functions:**

        QStringList **columnLabels** () const
        void **setColumnLabels** (const
        QStringList & **labels** )

        **Notifier signal:**

        void **columnLabelsChanged** ()
        """
        ...

    @overload
    def setItem(
        self,
        position: PySide6.QtCore.QPoint,
        item: Union[PySide6.QtDataVisualization.QBarDataItem, float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#setItem

        **void QBarDataProxy::setItem(int rowIndex , int columnIndex , const
        QBarDataItem & item )**

        Changes a single item at the position specified by **rowIndex** and
        **columnIndex** to the item **item**.
        """
        ...

    @overload
    def setItem(
        self,
        rowIndex: int,
        columnIndex: int,
        item: Union[PySide6.QtDataVisualization.QBarDataItem, float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#setItem-1

        **void QBarDataProxy::setItem(const QPoint & position , const
        QBarDataItem & item )**

        Changes a single item at the position **position** to the item **item**.
        The x-value of **position** indicates the row and the y-value indicates
        the column.
        """
        ...

    @overload
    def setRow(
        self, arg__1: int, arg__2: Sequence[PySide6.QtDataVisualization.QBarDataItem]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#setRow

        **void QBarDataProxy::setRow(int rowIndex , QBarDataRow * row )**

        Changes an existing row by replacing the row at the position
        **rowIndex** with the new row specified by **row**. The new row can be
        the same as the existing row already stored at **rowIndex**. Existing
        row labels are not affected.
        """
        ...

    @overload
    def setRow(
        self,
        arg__1: int,
        arg__2: Sequence[PySide6.QtDataVisualization.QBarDataItem],
        arg__3: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#setRow-1

        **void QBarDataProxy::setRow(int rowIndex , QBarDataRow * row , const
        QString & label )**

        Changes an existing row by replacing the row at the position
        **rowIndex** with the new row specified by **row**. The new row can be
        the same as the existing row already stored at **rowIndex**. Changes the
        row label to **label**.
        """
        ...

    def setRowLabels(self, labels: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowLabels-prop

        **rowLabels : QStringList**

        This property holds the optional row labels for the array.

        Indexes in this array match the row indexes in the data array. If the
        list is shorter than the number of rows, all rows will not get labels.

        **Access functions:**

        QStringList **rowLabels** () const
        void **setRowLabels** (const
        QStringList & **labels** )

        **Notifier signal:**

        void **rowLabelsChanged** ()
        """
        ...

    @overload
    def setRows(
        self, rowIndex: int, rows: List[List[PySide6.QtDataVisualization.QBarDataItem]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#setRows

        **void QBarDataProxy::setRows(int rowIndex , const QBarDataArray & rows
        )**

        Changes existing rows by replacing the rows starting at the position
        **rowIndex** with the new rows specifies by **rows**. Existing row
        labels are not affected. The rows in the **rows** array can be the same
        as the existing rows already stored at **rowIndex**.
        """
        ...

    @overload
    def setRows(
        self,
        rowIndex: int,
        rows: List[List[PySide6.QtDataVisualization.QBarDataItem]],
        labels: Sequence[str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#setRows-1

        **void QBarDataProxy::setRows(int rowIndex , const QBarDataArray & rows
        , const QStringList & labels )**

        Changes existing rows by replacing the rows starting at the position
        **rowIndex** with the new rows specifies by **rows**. The row labels are
        changed to **labels**. The rows in the **rows** array can be the same as
        the existing rows already stored at **rowIndex**.
        """
        ...

    @property
    def arrayReset(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#arrayReset

        **[signal] void QBarDataProxy::arrayReset()**

        This signal is emitted when the data array is reset. If the contents of
        the whole array are changed without calling **resetArray** (), this
        signal needs to be emitted to update the graph.
        """
        ...

    @property
    def columnLabelsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#itemChanged

        **[signal] void QBarDataProxy::itemChanged(int rowIndex , int
        columnIndex )**

        This signal is emitted when the item at the position specified by
        **rowIndex** and **columnIndex** changes. If the item is changed in the
        array without calling **setItem** (), this signal needs to be emitted to
        update the graph.
        """
        ...

    @property
    def rowCountChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowLabelsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowsAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowsAdded

        **[signal] void QBarDataProxy::rowsAdded(int startIndex , int count )**

        This signal is emitted when the number of rows specified by **count** is
        added starting at the position **startIndex**. If rows are added to the
        array without calling **addRow** () or **addRows** (), this signal needs
        to be emitted to update the graph.
        """
        ...

    @property
    def rowsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowsChanged

        **[signal] void QBarDataProxy::rowsChanged(int startIndex , int count
        )**

        This signal is emitted when the number of rows specified by **count** is
        changed starting at the position **startIndex**. If rows are changed in
        the array without calling **setRow** () or **setRows** (), this signal
        needs to be emitted to update the graph.
        """
        ...

    @property
    def rowsInserted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowsInserted

        **[signal] void QBarDataProxy::rowsInserted(int startIndex , int count
        )**

        This signal is emitted when the number of rows specified by **count** is
        inserted at the position **startIndex**.

        If rows are inserted into the array without calling **insertRow** () or
        **insertRows** (), this signal needs to be emitted to update the graph.
        """
        ...

    @property
    def rowsRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbardataproxy.html#rowsRemoved

        **[signal] void QBarDataProxy::rowsRemoved(int startIndex , int count
        )**

        This signal is emitted when the number of rows specified by **count** is
        removed starting at the position **startIndex**.

        The index is the current array size if the rows were removed from the
        end of the array. If rows are removed from the array without calling
        **removeRows** (), this signal needs to be emitted to update the graph.
        """
        ...

    @property
    def seriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
