"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QBarDataItem(object):
    """
    https://doc.qt.io/qt-6/qbardataitem.html

    **Detailed Description**

    A bar data item holds the data for a single rendered bar in a graph. Bar
    data proxies parse data into QBarDataItem instances for visualization.

    **See also** **QBarDataProxy**  and **Qt Data Visualization C++ Classes** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#QBarDataItem

        **QBarDataItem::QBarDataItem()**

        Constructs a bar data item.
        """
        ...

    @overload
    def __init__(
        self, other: Union[PySide6.QtDataVisualization.QBarDataItem, float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#QBarDataItem-1

        **QBarDataItem::QBarDataItem(float value )**

        Constructs a bar data item with the value **value**.
        """
        ...

    @overload
    def __init__(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#QBarDataItem-2

        **QBarDataItem::QBarDataItem(float value , float angle )**

        Constructs a bar data item with the value **value** and angle **angle**.
        """
        ...

    @overload
    def __init__(self, value: float, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#QBarDataItem-3

        **QBarDataItem::QBarDataItem(const QBarDataItem & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def createExtraData(self) -> None:
        ...

    def rotation(self) -> float:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#rotation

        **float QBarDataItem::rotation() const**

        Returns the rotation angle in degrees for this data item.

        **See also** **setRotation** ().
        """
        ...

    def setRotation(self, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#setRotation

        **void QBarDataItem::setRotation(float angle )**

        Sets the rotation angle **angle** in degrees for this data item.

        **See also** **rotation** ().
        """
        ...

    def setValue(self, val: float) -> None:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#setValue

        **void QBarDataItem::setValue(float val )**

        Sets the value **val** to this data item.

        **See also** **value** ().
        """
        ...

    def value(self) -> float:
        """
        https://doc.qt.io/qt-6/qbardataitem.html#value

        **float QBarDataItem::value() const**

        Returns the value of this data item.

        **See also** **setValue** ().
        """
        ...
