"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QAbstract3DInputHandler(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstract3dinputhandler.html

    **Detailed Description**

    QAbstract3DInputHandler is the base class that is subclassed by different
    input handling implementations that take input events and translate those to
    camera and light movements. Input handlers also translate raw input events
    to slicing and selection events in the scene.
    """

    InputViewNone: QAbstract3DInputHandler.InputView = ...
    InputViewOnPrimary: QAbstract3DInputHandler.InputView = ...
    InputViewOnSecondary: QAbstract3DInputHandler.InputView = ...

    class InputView(Enum):
        InputViewNone: QAbstract3DInputHandler.InputView = ...
        InputViewOnPrimary: QAbstract3DInputHandler.InputView = ...
        InputViewOnSecondary: QAbstract3DInputHandler.InputView = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#QAbstract3DInputHand
        ler

        **[protected] QAbstract3DInputHandler::QAbstract3DInputHandler(QObject *
        parent = nullptr)**

        Constructs the base class. An optional **parent** parameter can be given
        and is then passed to **QObject**  constructor.
        """
        ...

    def inputPosition(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#inputPosition-prop

        **inputPosition : QPoint**

        This property holds the last input position based on the processed input
        events.

        **Access functions:**

        QPoint **inputPosition** () const
        void **setInputPosition** (const
        QPoint & **position** )

        **Notifier signal:**

        void **positionChanged** (const QPoint & **position** )
        """
        ...

    def inputView(
        self,
    ) -> PySide6.QtDataVisualization.QAbstract3DInputHandler.InputView:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#inputView-prop

        **inputView : InputView**

        This property holds the current enumerated input view based on the view
        of the processed input events.

        One of the **InputView**  enum values.

        When the view changes, the `inputViewChanged` signal is emitted.

        **Access functions:**

        QAbstract3DInputHandler::InputView **inputView** () const
        void
        **setInputView** (QAbstract3DInputHandler::InputView **inputView** )

        **Notifier signal:**

        void **inputViewChanged** (QAbstract3DInputHandler::InputView **view** )

        **See also** **InputView** .
        """
        ...

    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#mouseDoubleClickEven
        t

        **[virtual] void
        QAbstract3DInputHandler::mouseDoubleClickEvent(QMouseEvent * event )**

        Override this to handle mouse double click events. Mouse double click
        event is given in the **event**.
        """
        ...

    def mouseMoveEvent(
        self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#mouseMoveEvent

        **[virtual] void QAbstract3DInputHandler::mouseMoveEvent(QMouseEvent *
        event , const QPoint & mousePos )**

        Override this to handle mouse move events. Mouse move event is given in
        the **event** and the mouse position in **mousePos**.
        """
        ...

    def mousePressEvent(
        self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#mousePressEvent

        **[virtual] void QAbstract3DInputHandler::mousePressEvent(QMouseEvent *
        event , const QPoint & mousePos )**

        Override this to handle mouse press events. Mouse press event is given
        in the **event** and the mouse position in **mousePos**.
        """
        ...

    def mouseReleaseEvent(
        self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#mouseReleaseEvent

        **[virtual] void QAbstract3DInputHandler::mouseReleaseEvent(QMouseEvent
        * event , const QPoint & mousePos )**

        Override this to handle mouse release events. Mouse release event is
        given in the **event** and the mouse position in **mousePos**.
        """
        ...

    def prevDistance(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#prevDistance

        **[protected] int QAbstract3DInputHandler::prevDistance() const**

        Returns the manhattan length between last two input positions.

        **See also** **setPrevDistance** ().
        """
        ...

    def previousInputPos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#previousInputPos

        **[protected] QPoint QAbstract3DInputHandler::previousInputPos() const**

        Returns the previous input position.

        **See also** **setPreviousInputPos** ().
        """
        ...

    def scene(self) -> PySide6.QtDataVisualization.Q3DScene:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#scene-prop

        **scene : Q3DScene***

        This property holds the 3D scene this abstract input handler is
        controlling.

        One input handler can control one scene. Setting a scene to an input
        handler does not transfer the ownership of the scene.

        **Access functions:**

        Q3DScene * **scene** () const
        void **setScene** (Q3DScene * **scene**
        )

        **Notifier signal:**

        void **sceneChanged** (Q3DScene * **scene** )

        **Member Function Documentation**
        """
        ...

    def setInputPosition(self, position: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#inputPosition-prop

        **inputPosition : QPoint**

        This property holds the last input position based on the processed input
        events.

        **Access functions:**

        QPoint **inputPosition** () const
        void **setInputPosition** (const
        QPoint & **position** )

        **Notifier signal:**

        void **positionChanged** (const QPoint & **position** )
        """
        ...

    def setInputView(
        self, inputView: PySide6.QtDataVisualization.QAbstract3DInputHandler.InputView
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#inputView-prop

        **inputView : InputView**

        This property holds the current enumerated input view based on the view
        of the processed input events.

        One of the **InputView**  enum values.

        When the view changes, the `inputViewChanged` signal is emitted.

        **Access functions:**

        QAbstract3DInputHandler::InputView **inputView** () const
        void
        **setInputView** (QAbstract3DInputHandler::InputView **inputView** )

        **Notifier signal:**

        void **inputViewChanged** (QAbstract3DInputHandler::InputView **view** )

        **See also** **InputView** .
        """
        ...

    def setPrevDistance(self, distance: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#setPrevDistance

        **[protected] void QAbstract3DInputHandler::setPrevDistance(int distance
        )**

        Sets the **distance** (manhattan length) between last two input
        positions.

        **See also** **prevDistance** ().
        """
        ...

    def setPreviousInputPos(self, position: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#setPreviousInputPos

        **[protected] void QAbstract3DInputHandler::setPreviousInputPos(const
        QPoint & position )**

        Sets the previous input position to the point given by **position**.

        **See also** **previousInputPos** ().
        """
        ...

    def setScene(self, scene: PySide6.QtDataVisualization.Q3DScene) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#scene-prop

        **scene : Q3DScene***

        This property holds the 3D scene this abstract input handler is
        controlling.

        One input handler can control one scene. Setting a scene to an input
        handler does not transfer the ownership of the scene.

        **Access functions:**

        Q3DScene * **scene** () const
        void **setScene** (Q3DScene * **scene**
        )

        **Notifier signal:**

        void **sceneChanged** (Q3DScene * **scene** )

        **Member Function Documentation**
        """
        ...

    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#touchEvent

        **[virtual] void QAbstract3DInputHandler::touchEvent(QTouchEvent * event
        )**

        Override this to handle touch input events. Touch event is given in the
        **event**.
        """
        ...

    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dinputhandler.html#wheelEvent

        **[virtual] void QAbstract3DInputHandler::wheelEvent(QWheelEvent * event
        )**

        Override this to handle wheel events. Wheel event is given in the
        **event**.
        """
        ...

    @property
    def inputViewChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def positionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def sceneChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
