"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QAbstract3DAxis(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstract3daxis.html

    **Detailed Description**

    This class specifies the enumerations, properties, and functions shared by
    graph axes. It should not be used directly, but one of its subclasses should
    be used instead.

    **See also** **QCategory3DAxis**  and **QValue3DAxis** .
    """

    AxisOrientationNone: QAbstract3DAxis.AxisOrientation = ...
    AxisOrientationX: QAbstract3DAxis.AxisOrientation = ...
    AxisOrientationY: QAbstract3DAxis.AxisOrientation = ...
    AxisOrientationZ: QAbstract3DAxis.AxisOrientation = ...
    AxisTypeNone: QAbstract3DAxis.AxisType = ...
    AxisTypeCategory: QAbstract3DAxis.AxisType = ...
    AxisTypeValue: QAbstract3DAxis.AxisType = ...

    class AxisOrientation(Enum):
        AxisOrientationNone: QAbstract3DAxis.AxisOrientation = ...
        AxisOrientationX: QAbstract3DAxis.AxisOrientation = ...
        AxisOrientationY: QAbstract3DAxis.AxisOrientation = ...
        AxisOrientationZ: QAbstract3DAxis.AxisOrientation = ...

    class AxisType(Enum):
        AxisTypeNone: QAbstract3DAxis.AxisType = ...
        AxisTypeCategory: QAbstract3DAxis.AxisType = ...
        AxisTypeValue: QAbstract3DAxis.AxisType = ...

    def isAutoAdjustRange(self) -> bool:
        ...

    def isTitleFixed(self) -> bool:
        ...

    def isTitleVisible(self) -> bool:
        ...

    def labelAutoRotation(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#labelAutoRotation-prop

        **labelAutoRotation : float**

        This property holds the maximum angle the labels can autorotate when the
        camera angle changes.

        The angle can be between 0 and 90, inclusive. The default value is 0. If
        the value is 0, axis labels do not automatically rotate. If the value is
        greater than zero, labels attempt to orient themselves toward the
        camera, up to the specified angle.

        **Access functions:**

        float **labelAutoRotation** () const
        void **setLabelAutoRotation**
        (float **angle** )

        **Notifier signal:**

        void **labelAutoRotationChanged** (float **angle** )
        """
        ...

    def labels(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#labels-prop

        **labels : QStringList**

        This property holds the labels for the axis.

        **Note:** Setting this property for **QValue3DAxis**  does nothing, as
        it generates labels automatically.

        **Access functions:**

        QStringList **labels** () const
        void **setLabels** (const QStringList
        & **labels** )

        **Notifier signal:**

        void **labelsChanged** ()
        """
        ...

    def max(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#max-prop

        **max : float**

        This property holds the maximum value on the axis.

        When setting this property, the minimum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Note:** For **QCategory3DAxis** , specifies the index of the last row
        or column to show.

        **Access functions:**

        float **max** () const
        void **setMax** (float **max** )

        **Notifier signal:**

        void **maxChanged** (float **value** )
        """
        ...

    def min(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#min-prop

        **min : float**

        This property holds the minimum value on the axis.

        When setting this property, the maximum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Note:** For **QCategory3DAxis** , specifies the index of the first row
        or column to show.

        **Access functions:**

        float **min** () const
        void **setMin** (float **min** )

        **Notifier signal:**

        void **minChanged** (float **value** )
        """
        ...

    def orientation(
        self,
    ) -> PySide6.QtDataVisualization.QAbstract3DAxis.AxisOrientation:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#orientation-prop

        **[read-only] orientation : const AxisOrientation**

        This property holds the orientation of the axis.

        The value is one of **AxisOrientation**  values.

        **Access functions:**

        QAbstract3DAxis::AxisOrientation **orientation** () const

        **Notifier signal:**

        void **orientationChanged** (QAbstract3DAxis::AxisOrientation
        **orientation** )
        """
        ...

    def setAutoAdjustRange(self, autoAdjust: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#autoAdjustRange-prop

        **autoAdjustRange : bool**

        This property holds whether the axis will automatically adjust the range
        so that all data fits in it.

        **Access functions:**

        bool **isAutoAdjustRange** () const
        void **setAutoAdjustRange** (bool
        **autoAdjust** )

        **Notifier signal:**

        void **autoAdjustRangeChanged** (bool **autoAdjust** )

        **See also** **setRange** (), **setMin** (), and **setMax** ().
        """
        ...

    def setLabelAutoRotation(self, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#labelAutoRotation-prop

        **labelAutoRotation : float**

        This property holds the maximum angle the labels can autorotate when the
        camera angle changes.

        The angle can be between 0 and 90, inclusive. The default value is 0. If
        the value is 0, axis labels do not automatically rotate. If the value is
        greater than zero, labels attempt to orient themselves toward the
        camera, up to the specified angle.

        **Access functions:**

        float **labelAutoRotation** () const
        void **setLabelAutoRotation**
        (float **angle** )

        **Notifier signal:**

        void **labelAutoRotationChanged** (float **angle** )
        """
        ...

    def setLabels(self, labels: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#labels-prop

        **labels : QStringList**

        This property holds the labels for the axis.

        **Note:** Setting this property for **QValue3DAxis**  does nothing, as
        it generates labels automatically.

        **Access functions:**

        QStringList **labels** () const
        void **setLabels** (const QStringList
        & **labels** )

        **Notifier signal:**

        void **labelsChanged** ()
        """
        ...

    def setMax(self, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#max-prop

        **max : float**

        This property holds the maximum value on the axis.

        When setting this property, the minimum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Note:** For **QCategory3DAxis** , specifies the index of the last row
        or column to show.

        **Access functions:**

        float **max** () const
        void **setMax** (float **max** )

        **Notifier signal:**

        void **maxChanged** (float **value** )
        """
        ...

    def setMin(self, min: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#min-prop

        **min : float**

        This property holds the minimum value on the axis.

        When setting this property, the maximum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Note:** For **QCategory3DAxis** , specifies the index of the first row
        or column to show.

        **Access functions:**

        float **min** () const
        void **setMin** (float **min** )

        **Notifier signal:**

        void **minChanged** (float **value** )
        """
        ...

    def setRange(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#setRange

        **void QAbstract3DAxis::setRange(float min , float max )**

        Sets the value range of the axis from **min** to **max**. When setting
        the range, the maximum value is adjusted if necessary, to ensure that
        the range remains valid.

        **Note:** For **QCategory3DAxis** , specifies the index range of rows or
        columns to show.
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#title-prop

        **title : QString**

        This property holds the title for the axis.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **Notifier signal:**

        void **titleChanged** (const QString & **newTitle** )

        **See also** **titleVisible**  and **titleFixed** .
        """
        ...

    def setTitleFixed(self, fixed: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#titleFixed-prop

        **titleFixed : bool**

        This property holds the rotation of the axis titles.

        If `true`, axis titles in the primary graph view will be rotated towards
        the camera similarly to the axis labels. If `false`, axis titles are
        only rotated around their axis but are not otherwise oriented towards
        the camera. This property does not have any effect if the
        **labelAutoRotation**  property value is zero. Default value is `true`.

        **Access functions:**

        bool **isTitleFixed** () const
        void **setTitleFixed** (bool **fixed**
        )

        **Notifier signal:**

        void **titleFixedChanged** (bool **fixed** )

        **See also** **labelAutoRotation** , **title** , and **titleVisible** .
        """
        ...

    def setTitleVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#titleVisible-prop

        **titleVisible : bool**

        This property holds whether the axis title is visible in the primary
        graph view.

        The default value is `false`.

        **Access functions:**

        bool **isTitleVisible** () const
        void **setTitleVisible** (bool
        **visible** )

        **Notifier signal:**

        void **titleVisibilityChanged** (bool **visible** )

        **See also** **title**  and **titleFixed** .
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#title-prop

        **title : QString**

        This property holds the title for the axis.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **Notifier signal:**

        void **titleChanged** (const QString & **newTitle** )

        **See also** **titleVisible**  and **titleFixed** .
        """
        ...

    def type(self) -> PySide6.QtDataVisualization.QAbstract3DAxis.AxisType:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#type-prop

        **[read-only] type : const AxisType**

        This property holds the type of the axis.

        The value is one of **AxisType**  values.

        **Access functions:**

        QAbstract3DAxis::AxisType **type** () const

        **Member Function Documentation**
        """
        ...

    @property
    def autoAdjustRangeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def labelAutoRotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def labelsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maxChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def minChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def orientationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rangeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstract3daxis.html#rangeChanged

        **[signal] void QAbstract3DAxis::rangeChanged(float min , float max )**

        Emits the minimum and maximum values of the range, **min** and **max** ,
        when the range changes.
        """
        ...

    @property
    def titleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def titleFixedChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def titleVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
