"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DTheme(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/q3dtheme.html

    **Detailed Description**

    Specifies visual properties that affect the whole graph. There are several
    built-in themes that can be used as is or modified freely.

    The following properties can be overridden by using **QAbstract3DSeries**
    properties to set them explicitly in the series: **baseColors** ,
    **baseGradients** , and **colorStyle** .

    Themes can be created from scratch using the **ThemeUserDefined**  enum
    value. Creating a theme using the default constructor produces a new user-
    defined theme.

    **Default Theme**

    The following table lists the properties controlled by themes and the
    default values for **ThemeUserDefined** .

    PropertyDefault Value
    **ambientLightStrength** 0.25
    **backgroundColor**
    **Qt::black**
    **backgroundEnabled** `true`
    **baseColors** **Qt::black**
    **baseGradients** **QLinearGradient** . Essentially fully black.
    **colorStyle** **ColorStyleUniform**
    **font** **QFont**
    **gridEnabled**
    `true`
    **gridLineColor** **Qt::white**
    **highlightLightStrength** 7.5
    **labelBackgroundColor** **Qt::gray**
    **labelBackgroundEnabled** `true`
    **labelBorderEnabled** `true`
    **labelTextColor** **Qt::white**
    **lightColor** **Qt::white**
    **lightStrength** 5.0
    **multiHighlightColor** **Qt::blue**
    **multiHighlightGradient**
    **QLinearGradient** . Essentially fully black.
    **singleHighlightColor**
    **Qt::red**
    **singleHighlightGradient** **QLinearGradient** . Essentially
    fully black.
    **windowColor** **Qt::black**

    **Usage Examples**

    Creating a built-in theme without any modifications:

    **Q3DTheme**  *theme = new **Q3DTheme** (**Q3DTheme** ::ThemeQt);

    Creating a built-in theme and modifying some properties:

    **Q3DTheme**  *theme = new **Q3DTheme** (**Q3DTheme** ::ThemeQt);
    theme->setBackgroundEnabled(false);
    theme->setLabelBackgroundEnabled(false);

    Creating a user-defined theme:

    **Q3DTheme**  *theme = new **Q3DTheme** ();
    theme->setAmbientLightStrength(0.3f);
    theme->setBackgroundColor(**QColor** (**QRgb** (0x99ca53)));
    theme->setBackgroundEnabled(true);
        theme->setBaseColor(**QColor**
    (**QRgb** (0x209fdf)));
        theme->setColorStyle(**Q3DTheme**
    ::ColorStyleUniform);
        theme->setFont(**QFont** (**QStringLiteral**
    ("Impact"), 35));
        theme->setGridEnabled(true);
    theme->setGridLineColor(**QColor** (**QRgb** (0x99ca53)));
    theme->setHighlightLightStrength(7.0f);
    theme->setLabelBackgroundColor(**QColor** (0xf6, 0xa6, 0x25, 0xa0));
    theme->setLabelBackgroundEnabled(true);
    theme->setLabelBorderEnabled(true);
        theme->setLabelTextColor(**QColor**
    (**QRgb** (0x404044)));
        theme->setLightColor(Qt::white);
    theme->setLightStrength(6.0f);
        theme->setMultiHighlightColor(**QColor**
    (**QRgb** (0x6d5fd5)));
        theme->setSingleHighlightColor(**QColor**
    (**QRgb** (0xf6a625)));
        theme->setWindowColor(**QColor** (**QRgb**
    (0xffffff)));

    Creating a built-in theme and modifying some properties after it has been
    set:

    **Q3DBars**  *graph = new **Q3DBars** ();
    graph->activeTheme()->setType(**Q3DTheme** ::ThemePrimaryColors);
    graph->activeTheme()->setBaseColor(Qt::red);
    graph->activeTheme()->setSingleHighlightColor(Qt::yellow);
    """

    ColorStyleUniform: Q3DTheme.ColorStyle = ...
    ColorStyleObjectGradient: Q3DTheme.ColorStyle = ...
    ColorStyleRangeGradient: Q3DTheme.ColorStyle = ...
    ThemeQt: Q3DTheme.Theme = ...
    ThemePrimaryColors: Q3DTheme.Theme = ...
    ThemeDigia: Q3DTheme.Theme = ...
    ThemeStoneMoss: Q3DTheme.Theme = ...
    ThemeArmyBlue: Q3DTheme.Theme = ...
    ThemeRetro: Q3DTheme.Theme = ...
    ThemeEbony: Q3DTheme.Theme = ...
    ThemeIsabelle: Q3DTheme.Theme = ...
    ThemeUserDefined: Q3DTheme.Theme = ...

    class ColorStyle(Enum):
        ColorStyleUniform: Q3DTheme.ColorStyle = ...
        ColorStyleObjectGradient: Q3DTheme.ColorStyle = ...
        ColorStyleRangeGradient: Q3DTheme.ColorStyle = ...

    class Theme(Enum):
        ThemeQt: Q3DTheme.Theme = ...
        ThemePrimaryColors: Q3DTheme.Theme = ...
        ThemeDigia: Q3DTheme.Theme = ...
        ThemeStoneMoss: Q3DTheme.Theme = ...
        ThemeArmyBlue: Q3DTheme.Theme = ...
        ThemeRetro: Q3DTheme.Theme = ...
        ThemeEbony: Q3DTheme.Theme = ...
        ThemeIsabelle: Q3DTheme.Theme = ...
        ThemeUserDefined: Q3DTheme.Theme = ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#Q3DTheme

        **Q3DTheme::Q3DTheme(QObject * parent = nullptr)**

        Constructs a new theme of type **ThemeUserDefined** . An optional
        **parent** parameter can be given and is then passed to **QObject**
        constructor.
        """
        ...

    @overload
    def __init__(
        self,
        themeType: PySide6.QtDataVisualization.Q3DTheme.Theme,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#Q3DTheme-1

        **Q3DTheme::Q3DTheme(Q3DTheme::Theme themeType , QObject * parent =
        nullptr)**

        Constructs a new theme with **themeType** , which can be one of the
        built-in themes from **Theme** . An optional **parent** parameter can be
        given and is then passed to **QObject**  constructor.
        """
        ...

    def ambientLightStrength(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#ambientLightStrength-prop

        **ambientLightStrength : float**

        This property holds the ambient light strength for the whole graph.

        This value determines how evenly and brightly the colors are shown
        throughout the graph regardless of the light position.

        The value must be between `0.0f` and `1.0f`.

        **Access functions:**

        float **ambientLightStrength** () const
        void
        **setAmbientLightStrength** (float **strength** )

        **Notifier signal:**

        void **ambientLightStrengthChanged** (float **strength** )
        """
        ...

    def backgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#backgroundColor-prop

        **backgroundColor : QColor**

        This property holds the color of the graph background.

        **Access functions:**

        QColor **backgroundColor** () const
        void **setBackgroundColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **backgroundColorChanged** (const QColor & **color** )
        """
        ...

    def baseColors(self) -> List[PySide6.QtGui.QColor]:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#baseColors-prop

        **baseColors : QList<QColor>**

        This property holds the list of base colors to be used for all the
        objects in the graph, series by series.

        If there are more series than colors, the color list wraps and starts
        again with the first color in the list.

        Has no immediate effect if **colorStyle**  is not **ColorStyleUniform**
        .

        This value can be overridden by setting the **baseColor**  explicitly in
        the series.

        **Access functions:**

        QList<QColor> **baseColors** () const
        void **setBaseColors** (const
        QList<QColor> & **colors** )

        **Notifier signal:**

        void **baseColorsChanged** (const QList<QColor> & **colors** )
        """
        ...

    def baseGradients(self) -> List[PySide6.QtGui.QLinearGradient]:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#baseGradients-prop

        **baseGradients : QList<QLinearGradient>**

        This property holds the list of base gradients to be used for all the
        objects in the graph, series by series.

        If there are more series than gradients, the gradient list wraps and
        starts again with the first gradient in the list

        Has no immediate effect if **colorStyle**  is **ColorStyleUniform** .

        This value can be overridden by setting the **baseGradient**  explicitly
        in the series.

        **Access functions:**

        QList<QLinearGradient> **baseGradients** () const
        void
        **setBaseGradients** (const QList<QLinearGradient> & **gradients** )

        **Notifier signal:**

        void **baseGradientsChanged** (const QList<QLinearGradient> &
        **gradients** )
        """
        ...

    def colorStyle(self) -> PySide6.QtDataVisualization.Q3DTheme.ColorStyle:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#colorStyle-prop

        **colorStyle : ColorStyle**

        This property holds the style of the graph colors.

        One of the **ColorStyle**  enum values.

        This value can be overridden by setting **colorStyle**  explicitly in
        the series.

        **Access functions:**

        Q3DTheme::ColorStyle **colorStyle** () const
        void **setColorStyle**
        (Q3DTheme::ColorStyle **style** )

        **Notifier signal:**

        void **colorStyleChanged** (Q3DTheme::ColorStyle **style** )
        """
        ...

    def font(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#font-prop

        **font : QFont**

        This property holds the font to be used for labels.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **Notifier signal:**

        void **fontChanged** (const QFont & **font** )
        """
        ...

    def gridLineColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#gridLineColor-prop

        **gridLineColor : QColor**

        This property holds the color of the grid lines.

        **Access functions:**

        QColor **gridLineColor** () const
        void **setGridLineColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **gridLineColorChanged** (const QColor & **color** )
        """
        ...

    def highlightLightStrength(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#highlightLightStrength-prop

        **highlightLightStrength : float**

        This property holds the specular light strength for selected objects.

        The value must be between `0.0f` and `10.0f`.

        **Access functions:**

        float **highlightLightStrength** () const
        void
        **setHighlightLightStrength** (float **strength** )

        **Notifier signal:**

        void **highlightLightStrengthChanged** (float **strength** )
        """
        ...

    def isBackgroundEnabled(self) -> bool:
        ...

    def isGridEnabled(self) -> bool:
        ...

    def isLabelBackgroundEnabled(self) -> bool:
        ...

    def isLabelBorderEnabled(self) -> bool:
        ...

    def labelBackgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#labelBackgroundColor-prop

        **labelBackgroundColor : QColor**

        This property holds the color of the label backgrounds.

        Has no effect if **labelBackgroundEnabled**  is `false`.

        **Access functions:**

        QColor **labelBackgroundColor** () const
        void
        **setLabelBackgroundColor** (const QColor & **color** )

        **Notifier signal:**

        void **labelBackgroundColorChanged** (const QColor & **color** )
        """
        ...

    def labelTextColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#labelTextColor-prop

        **labelTextColor : QColor**

        This property holds the color of the font used for labels.

        **Access functions:**

        QColor **labelTextColor** () const
        void **setLabelTextColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **labelTextColorChanged** (const QColor & **color** )
        """
        ...

    def lightColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#lightColor-prop

        **lightColor : QColor**

        This property holds the color for the ambient and specular light.

        This value affects the light specified in **Q3DScene** .

        **Access functions:**

        QColor **lightColor** () const
        void **setLightColor** (const QColor &
        **color** )

        **Notifier signal:**

        void **lightColorChanged** (const QColor & **color** )
        """
        ...

    def lightStrength(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#lightStrength-prop

        **lightStrength : float**

        This property holds the specular light strength for the whole graph.

        The value must be between `0.0f` and `10.0f`.

        This value affects the light specified in **Q3DScene** .

        **Access functions:**

        float **lightStrength** () const
        void **setLightStrength** (float
        **strength** )

        **Notifier signal:**

        void **lightStrengthChanged** (float **strength** )
        """
        ...

    def multiHighlightColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#multiHighlightColor-prop

        **multiHighlightColor : QColor**

        This property holds the highlight color for selected objects.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionRow` or
        `QAbstract3DGraph::SelectionColumn` flag set.

        **Access functions:**

        QColor **multiHighlightColor** () const
        void
        **setMultiHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **multiHighlightColorChanged** (const QColor & **color** )
        """
        ...

    def multiHighlightGradient(self) -> PySide6.QtGui.QLinearGradient:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#multiHighlightGradient-prop

        **multiHighlightGradient : QLinearGradient**

        This property holds the highlight gradient for selected objects.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionRow` or
        `QAbstract3DGraph::SelectionColumn` flag set.

        **Access functions:**

        QLinearGradient **multiHighlightGradient** () const
        void
        **setMultiHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **multiHighlightGradientChanged** (const QLinearGradient &
        **gradient** )
        """
        ...

    def setAmbientLightStrength(self, strength: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#ambientLightStrength-prop

        **ambientLightStrength : float**

        This property holds the ambient light strength for the whole graph.

        This value determines how evenly and brightly the colors are shown
        throughout the graph regardless of the light position.

        The value must be between `0.0f` and `1.0f`.

        **Access functions:**

        float **ambientLightStrength** () const
        void
        **setAmbientLightStrength** (float **strength** )

        **Notifier signal:**

        void **ambientLightStrengthChanged** (float **strength** )
        """
        ...

    def setBackgroundColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#backgroundColor-prop

        **backgroundColor : QColor**

        This property holds the color of the graph background.

        **Access functions:**

        QColor **backgroundColor** () const
        void **setBackgroundColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **backgroundColorChanged** (const QColor & **color** )
        """
        ...

    def setBackgroundEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#backgroundEnabled-prop

        **backgroundEnabled : bool**

        This property holds whether the background is visible.

        The background is drawn by using the value of **backgroundColor** .

        **Access functions:**

        bool **isBackgroundEnabled** () const
        void **setBackgroundEnabled**
        (bool **enabled** )

        **Notifier signal:**

        void **backgroundEnabledChanged** (bool **enabled** )
        """
        ...

    def setBaseColors(self, colors: Sequence[PySide6.QtGui.QColor]) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#baseColors-prop

        **baseColors : QList<QColor>**

        This property holds the list of base colors to be used for all the
        objects in the graph, series by series.

        If there are more series than colors, the color list wraps and starts
        again with the first color in the list.

        Has no immediate effect if **colorStyle**  is not **ColorStyleUniform**
        .

        This value can be overridden by setting the **baseColor**  explicitly in
        the series.

        **Access functions:**

        QList<QColor> **baseColors** () const
        void **setBaseColors** (const
        QList<QColor> & **colors** )

        **Notifier signal:**

        void **baseColorsChanged** (const QList<QColor> & **colors** )
        """
        ...

    def setBaseGradients(
        self, gradients: Sequence[PySide6.QtGui.QLinearGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#baseGradients-prop

        **baseGradients : QList<QLinearGradient>**

        This property holds the list of base gradients to be used for all the
        objects in the graph, series by series.

        If there are more series than gradients, the gradient list wraps and
        starts again with the first gradient in the list

        Has no immediate effect if **colorStyle**  is **ColorStyleUniform** .

        This value can be overridden by setting the **baseGradient**  explicitly
        in the series.

        **Access functions:**

        QList<QLinearGradient> **baseGradients** () const
        void
        **setBaseGradients** (const QList<QLinearGradient> & **gradients** )

        **Notifier signal:**

        void **baseGradientsChanged** (const QList<QLinearGradient> &
        **gradients** )
        """
        ...

    def setColorStyle(
        self, style: PySide6.QtDataVisualization.Q3DTheme.ColorStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#colorStyle-prop

        **colorStyle : ColorStyle**

        This property holds the style of the graph colors.

        One of the **ColorStyle**  enum values.

        This value can be overridden by setting **colorStyle**  explicitly in
        the series.

        **Access functions:**

        Q3DTheme::ColorStyle **colorStyle** () const
        void **setColorStyle**
        (Q3DTheme::ColorStyle **style** )

        **Notifier signal:**

        void **colorStyleChanged** (Q3DTheme::ColorStyle **style** )
        """
        ...

    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#font-prop

        **font : QFont**

        This property holds the font to be used for labels.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **Notifier signal:**

        void **fontChanged** (const QFont & **font** )
        """
        ...

    def setGridEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#gridEnabled-prop

        **gridEnabled : bool**

        This property holds whether the grid lines are drawn.

        This value affects all grid lines.

        **Access functions:**

        bool **isGridEnabled** () const
        void **setGridEnabled** (bool
        **enabled** )

        **Notifier signal:**

        void **gridEnabledChanged** (bool **enabled** )
        """
        ...

    def setGridLineColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#gridLineColor-prop

        **gridLineColor : QColor**

        This property holds the color of the grid lines.

        **Access functions:**

        QColor **gridLineColor** () const
        void **setGridLineColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **gridLineColorChanged** (const QColor & **color** )
        """
        ...

    def setHighlightLightStrength(self, strength: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#highlightLightStrength-prop

        **highlightLightStrength : float**

        This property holds the specular light strength for selected objects.

        The value must be between `0.0f` and `10.0f`.

        **Access functions:**

        float **highlightLightStrength** () const
        void
        **setHighlightLightStrength** (float **strength** )

        **Notifier signal:**

        void **highlightLightStrengthChanged** (float **strength** )
        """
        ...

    def setLabelBackgroundColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#labelBackgroundColor-prop

        **labelBackgroundColor : QColor**

        This property holds the color of the label backgrounds.

        Has no effect if **labelBackgroundEnabled**  is `false`.

        **Access functions:**

        QColor **labelBackgroundColor** () const
        void
        **setLabelBackgroundColor** (const QColor & **color** )

        **Notifier signal:**

        void **labelBackgroundColorChanged** (const QColor & **color** )
        """
        ...

    def setLabelBackgroundEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#labelBackgroundEnabled-prop

        **labelBackgroundEnabled : bool**

        This property holds whether the label is drawn with a color background
        or with a fully transparent background.

        The **labelBackgroundColor**  value (including alpha) is used for
        drawing the background.

        Labels with a background are drawn to equal sizes per axis based on the
        longest label, and the text is centered in them. Labels without a
        background are drawn as is and are left or right aligned based on their
        position in the graph.

        **Access functions:**

        bool **isLabelBackgroundEnabled** () const
        void
        **setLabelBackgroundEnabled** (bool **enabled** )

        **Notifier signal:**

        void **labelBackgroundEnabledChanged** (bool **enabled** )
        """
        ...

    def setLabelBorderEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#labelBorderEnabled-prop

        **labelBorderEnabled : bool**

        This property holds whether label borders are drawn for labels that have
        a background.

        Has no effect if **labelBackgroundEnabled**  is `false`.

        **Access functions:**

        bool **isLabelBorderEnabled** () const
        void **setLabelBorderEnabled**
        (bool **enabled** )

        **Notifier signal:**

        void **labelBorderEnabledChanged** (bool **enabled** )
        """
        ...

    def setLabelTextColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#labelTextColor-prop

        **labelTextColor : QColor**

        This property holds the color of the font used for labels.

        **Access functions:**

        QColor **labelTextColor** () const
        void **setLabelTextColor** (const
        QColor & **color** )

        **Notifier signal:**

        void **labelTextColorChanged** (const QColor & **color** )
        """
        ...

    def setLightColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#lightColor-prop

        **lightColor : QColor**

        This property holds the color for the ambient and specular light.

        This value affects the light specified in **Q3DScene** .

        **Access functions:**

        QColor **lightColor** () const
        void **setLightColor** (const QColor &
        **color** )

        **Notifier signal:**

        void **lightColorChanged** (const QColor & **color** )
        """
        ...

    def setLightStrength(self, strength: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#lightStrength-prop

        **lightStrength : float**

        This property holds the specular light strength for the whole graph.

        The value must be between `0.0f` and `10.0f`.

        This value affects the light specified in **Q3DScene** .

        **Access functions:**

        float **lightStrength** () const
        void **setLightStrength** (float
        **strength** )

        **Notifier signal:**

        void **lightStrengthChanged** (float **strength** )
        """
        ...

    def setMultiHighlightColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#multiHighlightColor-prop

        **multiHighlightColor : QColor**

        This property holds the highlight color for selected objects.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionRow` or
        `QAbstract3DGraph::SelectionColumn` flag set.

        **Access functions:**

        QColor **multiHighlightColor** () const
        void
        **setMultiHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **multiHighlightColorChanged** (const QColor & **color** )
        """
        ...

    def setMultiHighlightGradient(
        self, gradient: PySide6.QtGui.QLinearGradient
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#multiHighlightGradient-prop

        **multiHighlightGradient : QLinearGradient**

        This property holds the highlight gradient for selected objects.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionRow` or
        `QAbstract3DGraph::SelectionColumn` flag set.

        **Access functions:**

        QLinearGradient **multiHighlightGradient** () const
        void
        **setMultiHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **multiHighlightGradientChanged** (const QLinearGradient &
        **gradient** )
        """
        ...

    def setSingleHighlightColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#singleHighlightColor-prop

        **singleHighlightColor : QColor**

        This property holds the highlight color for a selected object.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionItem`
        flag set.

        **Access functions:**

        QColor **singleHighlightColor** () const
        void
        **setSingleHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **singleHighlightColorChanged** (const QColor & **color** )
        """
        ...

    def setSingleHighlightGradient(
        self, gradient: PySide6.QtGui.QLinearGradient
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#singleHighlightGradient-prop

        **singleHighlightGradient : QLinearGradient**

        This property holds the highlight gradient for a selected object.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionItem`
        flag set.

        **Access functions:**

        QLinearGradient **singleHighlightGradient** () const
        void
        **setSingleHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **singleHighlightGradientChanged** (const QLinearGradient &
        **gradient** )
        """
        ...

    def setType(self, themeType: PySide6.QtDataVisualization.Q3DTheme.Theme) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#type-prop

        **type : Theme**

        This property holds the type of the theme.

        The type is automatically set when constructing a theme, but can also be
        changed later. Changing the theme type will change all other properties
        of the theme to what the predefined theme specifies. Changing the theme
        type of the active theme of the graph will also reset all attached
        series to use the new theme.

        **Access functions:**

        Q3DTheme::Theme **type** () const
        void **setType** (Q3DTheme::Theme
        **themeType** )

        **Notifier signal:**

        void **typeChanged** (Q3DTheme::Theme **themeType** )
        """
        ...

    def setWindowColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#windowColor-prop

        **windowColor : QColor**

        This property holds the color of the application window the graph is
        drawn into.

        **Access functions:**

        QColor **windowColor** () const
        void **setWindowColor** (const QColor
        & **color** )

        **Notifier signal:**

        void **windowColorChanged** (const QColor & **color** )

        **Member Function Documentation**
        """
        ...

    def singleHighlightColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#singleHighlightColor-prop

        **singleHighlightColor : QColor**

        This property holds the highlight color for a selected object.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionItem`
        flag set.

        **Access functions:**

        QColor **singleHighlightColor** () const
        void
        **setSingleHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **singleHighlightColorChanged** (const QColor & **color** )
        """
        ...

    def singleHighlightGradient(self) -> PySide6.QtGui.QLinearGradient:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#singleHighlightGradient-prop

        **singleHighlightGradient : QLinearGradient**

        This property holds the highlight gradient for a selected object.

        Used if **selectionMode**  has the `QAbstract3DGraph::SelectionItem`
        flag set.

        **Access functions:**

        QLinearGradient **singleHighlightGradient** () const
        void
        **setSingleHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **singleHighlightGradientChanged** (const QLinearGradient &
        **gradient** )
        """
        ...

    def type(self) -> PySide6.QtDataVisualization.Q3DTheme.Theme:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#type-prop

        **type : Theme**

        This property holds the type of the theme.

        The type is automatically set when constructing a theme, but can also be
        changed later. Changing the theme type will change all other properties
        of the theme to what the predefined theme specifies. Changing the theme
        type of the active theme of the graph will also reset all attached
        series to use the new theme.

        **Access functions:**

        Q3DTheme::Theme **type** () const
        void **setType** (Q3DTheme::Theme
        **themeType** )

        **Notifier signal:**

        void **typeChanged** (Q3DTheme::Theme **themeType** )
        """
        ...

    def windowColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/q3dtheme.html#windowColor-prop

        **windowColor : QColor**

        This property holds the color of the application window the graph is
        drawn into.

        **Access functions:**

        QColor **windowColor** () const
        void **setWindowColor** (const QColor
        & **color** )

        **Notifier signal:**

        void **windowColorChanged** (const QColor & **color** )

        **Member Function Documentation**
        """
        ...

    @property
    def ambientLightStrengthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def backgroundColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def backgroundEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def baseColorsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def baseGradientsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def colorStyleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def fontChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def gridEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def gridLineColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def highlightLightStrengthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def labelBackgroundColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def labelBackgroundEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def labelBorderEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def labelTextColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def lightColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def lightStrengthChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiHighlightColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiHighlightGradientChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def singleHighlightColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def singleHighlightGradientChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def typeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def windowColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
