"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DSurface(PySide6.QtDataVisualization.QAbstract3DGraph):
    """
    https://doc.qt.io/qt-6/q3dsurface.html

    **Detailed Description**

    This class enables developers to render 3D surface plots and to view them by
    rotating the scene freely. The visual properties of the surface such as draw
    mode and shading can be controlled via **QSurface3DSeries** .

    The Q3DSurface supports selection by showing a highlighted ball on the data
    point where the user has clicked with left mouse button (when default input
    handler is in use) or selected via **QSurface3DSeries** . The selection
    pointer is accompanied with a label which in default case shows the value of
    the data point and the coordinates of the point.

    The value range and the label format shown on the axis can be controlled
    through **QValue3DAxis** .

    To rotate the graph, hold down the right mouse button and move the mouse.
    Zooming is done using mouse wheel. Both assume the default input handler is
    in use.

    If no axes are set explicitly to Q3DSurface, temporary default axes with no
    labels are created. These default axes can be modified via axis accessors,
    but as soon any axis is set explicitly for the orientation, the default axis
    for that orientation is destroyed.

    **How to construct a minimal Q3DSurface graph**

    First, construct Q3DSurface. Since we are running the graph as top level
    window in this example, we need to clear the `Qt::FramelessWindowHint` flag,
    which gets set by default:

    **Q3DSurface**  surface;
        surface.setFlags(surface.flags() ^
    Qt::FramelessWindowHint);

    Now Q3DSurface is ready to receive data to be rendered. Create data elements
    to receive values:

    **QSurfaceDataArray**  *data = new **QSurfaceDataArray** ;
    **QSurfaceDataRow**  *dataRow1 = new **QSurfaceDataRow** ;
    **QSurfaceDataRow**  *dataRow2 = new **QSurfaceDataRow** ;

    First feed the data to the row elements and then add their pointers to the
    data element:

    *dataRow1 << QVector3D(0.0f, 0.1f, 0.5f) << QVector3D(1.0f, 0.5f, 0.5f);
    *dataRow2 << QVector3D(0.0f, 1.8f, 1.0f) << QVector3D(1.0f, 1.2f, 1.0f);
    *data << dataRow1 << dataRow2;

    Create a new series and set data to it:

    QSurface3DSeries *series = new QSurface3DSeries;
    series->dataProxy()->resetArray(data);
        surface.addSeries(series);

    Finally you will need to set it visible:

    surface.show();

    The complete code needed to create and display this graph is:

    #include <QtDataVisualization>

        int main(int argc, char **argv)
    {
            qputenv("QSG_RHI_BACKEND", "opengl");
            **QGuiApplication**
    app(argc, argv);

            **Q3DSurface**  surface;
    surface.setFlags(surface.flags() ^ Qt::FramelessWindowHint);
    **QSurfaceDataArray**  *data = new **QSurfaceDataArray** ;
    **QSurfaceDataRow**  *dataRow1 = new **QSurfaceDataRow** ;
    **QSurfaceDataRow**  *dataRow2 = new **QSurfaceDataRow** ;
    *dataRow1 << QVector3D(0.0f, 0.1f, 0.5f) << QVector3D(1.0f, 0.5f, 0.5f);
    *dataRow2 << QVector3D(0.0f, 1.8f, 1.0f) << QVector3D(1.0f, 1.2f, 1.0f);
    *data << dataRow1 << dataRow2;

            QSurface3DSeries *series = new
    QSurface3DSeries;
            series->dataProxy()->resetArray(data);
    surface.addSeries(series);
            surface.show();

            return
    app.exec();
        }

    And this is what those few lines of code produce:

    ![](images/q3dsurface-minimal.png)

    The scene can be rotated, zoomed into, and a surface point can be selected
    to view its position, but no other interaction is included in this minimal
    code example. You can learn more by familiarizing yourself with the examples
    provided, like the **Surface Example** .

    **See also** **Q3DBars** , **Q3DScatter** , and **Qt Data Visualization C++
    Classes** .
    """

    def __init__(
        self,
        format: Union[
            PySide6.QtGui.QSurfaceFormat,
            PySide6.QtGui.QSurfaceFormat.FormatOptions,
            NoneType,
        ] = ...,
        parent: Optional[PySide6.QtGui.QWindow] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#Q3DSurface

        **Q3DSurface::Q3DSurface(const QSurfaceFormat * format = nullptr,
        QWindow * parent = nullptr)**

        Constructs a new 3D surface graph with optional **parent** window and
        surface **format**.
        """
        ...

    def addAxis(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#addAxis

        **void Q3DSurface::addAxis(QValue3DAxis * axis )**

        Adds **axis** to the graph. The axes added via addAxis are not yet taken
        to use, addAxis is simply used to give the ownership of the **axis** to
        the graph. The **axis** must not be null or added to another graph.

        **See also** **releaseAxis** (), **setAxisX** (), **setAxisY** (), and
        **setAxisZ** ().
        """
        ...

    def addSeries(self, series: PySide6.QtDataVisualization.QSurface3DSeries) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#addSeries

        **void Q3DSurface::addSeries(QSurface3DSeries * series )**

        Adds the **series** to the graph. A graph can contain multiple series,
        but has only one set of axes. If the newly added series has specified a
        selected item, it will be highlighted and any existing selection will be
        cleared. Only one added series can have an active selection.
        """
        ...

    def axes(self) -> List[PySide6.QtDataVisualization.QValue3DAxis]:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#axes

        **QList<QValue3DAxis *> Q3DSurface::axes() const**

        Returns the list of all added axes.

        **See also** **addAxis** ().
        """
        ...

    def axisX(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#axisX-prop

        **axisX : QValue3DAxis***

        This property holds the active x-axis.

        **Access functions:**

        QValue3DAxis * **axisX** () const
        void ****setAxisX** ** (QValue3DAxis
        * **axis** )

        **Notifier signal:**

        void **axisXChanged** (QValue3DAxis * **axis** )
        """
        ...

    def axisY(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#axisY-prop

        **axisY : QValue3DAxis***

        This property holds the active y-axis.

        **Access functions:**

        QValue3DAxis * **axisY** () const
        void ****setAxisY** ** (QValue3DAxis
        * **axis** )

        **Notifier signal:**

        void **axisYChanged** (QValue3DAxis * **axis** )
        """
        ...

    def axisZ(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#axisZ-prop

        **axisZ : QValue3DAxis***

        This property holds the active z-axis.

        **Access functions:**

        QValue3DAxis * **axisZ** () const
        void ****setAxisZ** ** (QValue3DAxis
        * **axis** )

        **Notifier signal:**

        void **axisZChanged** (QValue3DAxis * **axis** )
        """
        ...

    def flipHorizontalGrid(self) -> bool:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#flipHorizontalGrid-prop

        **[since QtDataVisualization 1.2] flipHorizontalGrid : bool**

        This property holds whether the horizontal axis grid is displayed on top
        of the graph rather than on the bottom.

        In some use cases the horizontal axis grid is mostly covered by the
        surface, so it can be more useful to display the horizontal axis grid on
        top of the graph rather than on the bottom. A typical use case for this
        is showing 2D spectrograms using orthoGraphic projection with a top-down
        viewpoint.

        If `false`, the horizontal axis grid and labels are drawn on the
        horizontal background of the graph. If `true`, the horizontal axis grid
        and labels are drawn on the opposite side of the graph from the
        horizontal background. Defaults to `false`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **flipHorizontalGrid** () const
        void **setFlipHorizontalGrid**
        (bool **flip** )

        **Notifier signal:**

        void **flipHorizontalGridChanged** (bool **flip** )
        """
        ...

    def releaseAxis(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#releaseAxis

        **void Q3DSurface::releaseAxis(QValue3DAxis * axis )**

        Releases the ownership of the **axis** back to the caller, if it is
        added to this graph. If the released **axis** is in use, a new default
        axis will be created and set active.

        If the default axis is released and added back later, it behaves as any
        other axis would.

        **See also** **addAxis** (), **setAxisX** (), **setAxisY** (), and
        **setAxisZ** ().
        """
        ...

    def removeSeries(
        self, series: PySide6.QtDataVisualization.QSurface3DSeries
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#removeSeries

        **void Q3DSurface::removeSeries(QSurface3DSeries * series )**

        Removes the **series** from the graph.
        """
        ...

    def selectedSeries(self) -> PySide6.QtDataVisualization.QSurface3DSeries:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#selectedSeries-prop

        **[read-only] selectedSeries : QSurface3DSeries* const**

        This property holds the selected series or null.

        If selectionMode has `SelectionMultiSeries` set, this property holds the
        series which owns the selected point.

        **Access functions:**

        QSurface3DSeries * **selectedSeries** () const

        **Notifier signal:**

        void **selectedSeriesChanged** (QSurface3DSeries * **series** )

        **Member Function Documentation**
        """
        ...

    def seriesList(self) -> List[PySide6.QtDataVisualization.QSurface3DSeries]:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#seriesList

        **QList<QSurface3DSeries *> Q3DSurface::seriesList() const**

        Returns the list of series added to this graph.
        """
        ...

    def setAxisX(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#setAxisX

        **void Q3DSurface::setAxisX(QValue3DAxis * axis )**

        Sets **axis** as the active x-axis. Implicitly calls **addAxis** () to
        transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created.

        This temporary axis is destroyed if another axis is set explicitly to
        the same orientation.

        **Note:** Setter function for property **axisX** .

        **See also** **axisX** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setAxisY(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#setAxisY

        **void Q3DSurface::setAxisY(QValue3DAxis * axis )**

        Sets **axis** as the active y-axis. Implicitly calls **addAxis** () to
        transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created.

        This temporary axis is destroyed if another axis is set explicitly to
        the same orientation.

        **Note:** Setter function for property **axisY** .

        **See also** **axisY** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setAxisZ(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#setAxisZ

        **void Q3DSurface::setAxisZ(QValue3DAxis * axis )**

        Sets **axis** as the active z-axis. Implicitly calls **addAxis** () to
        transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created.

        This temporary axis is destroyed if another axis is set explicitly to
        the same orientation.

        **Note:** Setter function for property **axisZ** .

        **See also** **axisZ** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setFlipHorizontalGrid(self, flip: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dsurface.html#flipHorizontalGrid-prop

        **[since QtDataVisualization 1.2] flipHorizontalGrid : bool**

        This property holds whether the horizontal axis grid is displayed on top
        of the graph rather than on the bottom.

        In some use cases the horizontal axis grid is mostly covered by the
        surface, so it can be more useful to display the horizontal axis grid on
        top of the graph rather than on the bottom. A typical use case for this
        is showing 2D spectrograms using orthoGraphic projection with a top-down
        viewpoint.

        If `false`, the horizontal axis grid and labels are drawn on the
        horizontal background of the graph. If `true`, the horizontal axis grid
        and labels are drawn on the opposite side of the graph from the
        horizontal background. Defaults to `false`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **flipHorizontalGrid** () const
        void **setFlipHorizontalGrid**
        (bool **flip** )

        **Notifier signal:**

        void **flipHorizontalGridChanged** (bool **flip** )
        """
        ...

    @property
    def axisXChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def axisYChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def axisZChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def flipHorizontalGridChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedSeriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
