"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DObject(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/q3dobject.html

    **Detailed Description**

    Contains position information for an object in a 3D scene. The object is
    considered to be a single point in the coordinate space without dimensions.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/q3dobject.html#Q3DObject

        **Q3DObject::Q3DObject(QObject * parent = nullptr)**

        Constructs a new 3D object with the position set to origin by default.
        An optional **parent** parameter can be given and is then passed to the
        **QObject**  constructor.
        """
        ...

    def copyValuesFrom(self, source: PySide6.QtDataVisualization.Q3DObject) -> None:
        """
        https://doc.qt.io/qt-6/q3dobject.html#copyValuesFrom

        **[virtual] void Q3DObject::copyValuesFrom(const Q3DObject & source )**

        Copies the 3D object position from the given **source** 3D object to
        this 3D object instance.
        """
        ...

    def isDirty(self) -> bool:
        """
        https://doc.qt.io/qt-6/q3dobject.html#isDirty

        **[protected] bool Q3DObject::isDirty() const**

        Returns whether the 3D object has changed.
        """
        ...

    def parentScene(self) -> PySide6.QtDataVisualization.Q3DScene:
        """
        https://doc.qt.io/qt-6/q3dobject.html#parentScene-prop

        **[read-only] parentScene : Q3DScene* const**

        This property holds the parent scene as a read only value.

        If the object has no parent scene, the value is 0.

        **Access functions:**

        Q3DScene * **parentScene** ()
        """
        ...

    def position(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/q3dobject.html#position-prop

        **position : QVector3D**

        This property holds the 3D position of the object.

        **Note:** Currently setting this property has no effect for
        **Q3DCamera** , as the position is handled internally.

        **Access functions:**

        QVector3D **position** () const
        void **setPosition** (const QVector3D
        & **position** )

        **Notifier signal:**

        void **positionChanged** (const QVector3D & **position** )

        **Member Function Documentation**
        """
        ...

    def setDirty(self, dirty: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dobject.html#setDirty

        **[protected] void Q3DObject::setDirty(bool dirty )**

        Sets **dirty** to `true` if the 3D object has changed since the last
        update.

        **See also** **isDirty** ().
        """
        ...

    def setPosition(self, position: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/q3dobject.html#position-prop

        **position : QVector3D**

        This property holds the 3D position of the object.

        **Note:** Currently setting this property has no effect for
        **Q3DCamera** , as the position is handled internally.

        **Access functions:**

        QVector3D **position** () const
        void **setPosition** (const QVector3D
        & **position** )

        **Notifier signal:**

        void **positionChanged** (const QVector3D & **position** )

        **Member Function Documentation**
        """
        ...

    @property
    def positionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
