"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DCamera(PySide6.QtDataVisualization.Q3DObject):
    """
    https://doc.qt.io/qt-6/q3dcamera.html

    **Detailed Description**

    Q3DCamera represents a basic orbit around centerpoint 3D camera that is used
    when rendering the data visualization. The class offers simple methods for
    rotating the camera around the origin and setting zoom level.
    """

    CameraPresetNone: Q3DCamera.CameraPreset = ...
    CameraPresetFrontLow: Q3DCamera.CameraPreset = ...
    CameraPresetFront: Q3DCamera.CameraPreset = ...
    CameraPresetFrontHigh: Q3DCamera.CameraPreset = ...
    CameraPresetLeftLow: Q3DCamera.CameraPreset = ...
    CameraPresetLeft: Q3DCamera.CameraPreset = ...
    CameraPresetLeftHigh: Q3DCamera.CameraPreset = ...
    CameraPresetRightLow: Q3DCamera.CameraPreset = ...
    CameraPresetRight: Q3DCamera.CameraPreset = ...
    CameraPresetRightHigh: Q3DCamera.CameraPreset = ...
    CameraPresetBehindLow: Q3DCamera.CameraPreset = ...
    CameraPresetBehind: Q3DCamera.CameraPreset = ...
    CameraPresetBehindHigh: Q3DCamera.CameraPreset = ...
    CameraPresetIsometricLeft: Q3DCamera.CameraPreset = ...
    CameraPresetIsometricLeftHigh: Q3DCamera.CameraPreset = ...
    CameraPresetIsometricRight: Q3DCamera.CameraPreset = ...
    CameraPresetIsometricRightHigh: Q3DCamera.CameraPreset = ...
    CameraPresetDirectlyAbove: Q3DCamera.CameraPreset = ...
    CameraPresetDirectlyAboveCW45: Q3DCamera.CameraPreset = ...
    CameraPresetDirectlyAboveCCW45: Q3DCamera.CameraPreset = ...
    CameraPresetFrontBelow: Q3DCamera.CameraPreset = ...
    CameraPresetLeftBelow: Q3DCamera.CameraPreset = ...
    CameraPresetRightBelow: Q3DCamera.CameraPreset = ...
    CameraPresetBehindBelow: Q3DCamera.CameraPreset = ...
    CameraPresetDirectlyBelow: Q3DCamera.CameraPreset = ...

    class CameraPreset(Enum):
        CameraPresetNone: Q3DCamera.CameraPreset = ...
        CameraPresetFrontLow: Q3DCamera.CameraPreset = ...
        CameraPresetFront: Q3DCamera.CameraPreset = ...
        CameraPresetFrontHigh: Q3DCamera.CameraPreset = ...
        CameraPresetLeftLow: Q3DCamera.CameraPreset = ...
        CameraPresetLeft: Q3DCamera.CameraPreset = ...
        CameraPresetLeftHigh: Q3DCamera.CameraPreset = ...
        CameraPresetRightLow: Q3DCamera.CameraPreset = ...
        CameraPresetRight: Q3DCamera.CameraPreset = ...
        CameraPresetRightHigh: Q3DCamera.CameraPreset = ...
        CameraPresetBehindLow: Q3DCamera.CameraPreset = ...
        CameraPresetBehind: Q3DCamera.CameraPreset = ...
        CameraPresetBehindHigh: Q3DCamera.CameraPreset = ...
        CameraPresetIsometricLeft: Q3DCamera.CameraPreset = ...
        CameraPresetIsometricLeftHigh: Q3DCamera.CameraPreset = ...
        CameraPresetIsometricRight: Q3DCamera.CameraPreset = ...
        CameraPresetIsometricRightHigh: Q3DCamera.CameraPreset = ...
        CameraPresetDirectlyAbove: Q3DCamera.CameraPreset = ...
        CameraPresetDirectlyAboveCW45: Q3DCamera.CameraPreset = ...
        CameraPresetDirectlyAboveCCW45: Q3DCamera.CameraPreset = ...
        CameraPresetFrontBelow: Q3DCamera.CameraPreset = ...
        CameraPresetLeftBelow: Q3DCamera.CameraPreset = ...
        CameraPresetRightBelow: Q3DCamera.CameraPreset = ...
        CameraPresetBehindBelow: Q3DCamera.CameraPreset = ...
        CameraPresetDirectlyBelow: Q3DCamera.CameraPreset = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#Q3DCamera

        **Q3DCamera::Q3DCamera(QObject * parent = nullptr)**

        Constructs a new 3D camera with position set to origin, up direction
        facing towards the Y-axis and looking at origin by default. An optional
        **parent** parameter can be given and is then passed to **QObject**
        constructor.
        """
        ...

    def cameraPreset(self) -> PySide6.QtDataVisualization.Q3DCamera.CameraPreset:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#cameraPreset-prop

        **cameraPreset : CameraPreset**

        This property holds the currently active camera preset.

        If no **CameraPreset**  value is set, **CameraPresetNone**  is used by
        default.

        **Access functions:**

        Q3DCamera::CameraPreset **cameraPreset** () const
        void
        **setCameraPreset** (Q3DCamera::CameraPreset **preset** )

        **Notifier signal:**

        void **cameraPresetChanged** (Q3DCamera::CameraPreset **preset** )
        """
        ...

    def copyValuesFrom(self, source: PySide6.QtDataVisualization.Q3DObject) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#copyValuesFrom

        **[override virtual] void Q3DCamera::copyValuesFrom(const Q3DObject &
        source )**

        Reimplements: **Q3DObject::copyValuesFrom** (const Q3DObject &source).

        Copies the 3D camera's properties from the given source camera. Values
        are copied from the **source** to this object.
        """
        ...

    def maxZoomLevel(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#maxZoomLevel-prop

        **maxZoomLevel : float**

        This property holds the maximum allowed camera zoom level.

        If the maximum level is set to a new value that is lower than the
        existing minimum level, the minimum level is adjusted to the new maximum
        as well. If the current **zoomLevel**  is outside the new bounds, it is
        adjusted as well. Defaults to `500.0f`.

        **Access functions:**

        float **maxZoomLevel** () const
        void **setMaxZoomLevel** (float
        **zoomLevel** )

        **Notifier signal:**

        void **maxZoomLevelChanged** (float **zoomLevel** )

        **See also** **zoomLevel**  and **minZoomLevel** .
        """
        ...

    def minZoomLevel(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#minZoomLevel-prop

        **minZoomLevel : float**

        This property holds the minimum allowed camera zoom level.

        If the minimum level is set to a new value that is higher than the
        existing maximum level, the maximum level is adjusted to the new minimum
        as well. If the current **zoomLevel**  is outside the new bounds, it is
        adjusted as well. The minZoomLevel cannot be set below `1.0f`. Defaults
        to `10.0f`.

        **Access functions:**

        float **minZoomLevel** () const
        void **setMinZoomLevel** (float
        **zoomLevel** )

        **Notifier signal:**

        void **minZoomLevelChanged** (float **zoomLevel** )

        **See also** **zoomLevel**  and **maxZoomLevel** .
        """
        ...

    def setCameraPosition(
        self, horizontal: float, vertical: float, zoom: float = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#setCameraPosition

        **void Q3DCamera::setCameraPosition(float horizontal , float vertical ,
        float zoom = 100.0f)**

        Utility function that sets the camera rotations and distance.
        **horizontal** and **vertical** define the camera rotations to be used.
        Optional **zoom** parameter can be given to set the zoom percentage of
        the camera within the bounds defined by **minZoomLevel**  and
        **maxZoomLevel**  properties.
        """
        ...

    def setCameraPreset(
        self, preset: PySide6.QtDataVisualization.Q3DCamera.CameraPreset
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#cameraPreset-prop

        **cameraPreset : CameraPreset**

        This property holds the currently active camera preset.

        If no **CameraPreset**  value is set, **CameraPresetNone**  is used by
        default.

        **Access functions:**

        Q3DCamera::CameraPreset **cameraPreset** () const
        void
        **setCameraPreset** (Q3DCamera::CameraPreset **preset** )

        **Notifier signal:**

        void **cameraPresetChanged** (Q3DCamera::CameraPreset **preset** )
        """
        ...

    def setMaxZoomLevel(self, zoomLevel: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#maxZoomLevel-prop

        **maxZoomLevel : float**

        This property holds the maximum allowed camera zoom level.

        If the maximum level is set to a new value that is lower than the
        existing minimum level, the minimum level is adjusted to the new maximum
        as well. If the current **zoomLevel**  is outside the new bounds, it is
        adjusted as well. Defaults to `500.0f`.

        **Access functions:**

        float **maxZoomLevel** () const
        void **setMaxZoomLevel** (float
        **zoomLevel** )

        **Notifier signal:**

        void **maxZoomLevelChanged** (float **zoomLevel** )

        **See also** **zoomLevel**  and **minZoomLevel** .
        """
        ...

    def setMinZoomLevel(self, zoomLevel: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#minZoomLevel-prop

        **minZoomLevel : float**

        This property holds the minimum allowed camera zoom level.

        If the minimum level is set to a new value that is higher than the
        existing maximum level, the maximum level is adjusted to the new minimum
        as well. If the current **zoomLevel**  is outside the new bounds, it is
        adjusted as well. The minZoomLevel cannot be set below `1.0f`. Defaults
        to `10.0f`.

        **Access functions:**

        float **minZoomLevel** () const
        void **setMinZoomLevel** (float
        **zoomLevel** )

        **Notifier signal:**

        void **minZoomLevelChanged** (float **zoomLevel** )

        **See also** **zoomLevel**  and **maxZoomLevel** .
        """
        ...

    def setTarget(self, target: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#target-prop

        **[since QtDataVisualization 1.2] target : QVector3D**

        This property holds the camera target as a vector or vertex in the 3D
        space.

        Defaults to `QVector3D(0.0, 0.0, 0.0)`.

        Valid coordinate values are between `-1.0...1.0`, where the edge values
        indicate the edges of the corresponding axis range. Any values outside
        this range are clamped to the edge.

        **Note:** For bar graphs, the Y-coordinate is ignored and camera always
        targets a point on the horizontal background.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        QVector3D **target** () const
        void **setTarget** (const QVector3D &
        **target** )

        **Notifier signal:**

        void **targetChanged** (const QVector3D & **target** )
        """
        ...

    def setWrapXRotation(self, isEnabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#wrapXRotation-prop

        **wrapXRotation : bool**

        This property holds the behavior of the minimum and maximum limits in
        the X-rotation.

        If set to `true`, the X-rotation of the camera is wrapped from minimum
        to maximum and from maximum to minimum. If set to `false`, the
        X-rotation of the camera is limited to the sector determined by the
        minimum and maximum values. Set to `true` by default.

        **Access functions:**

        bool **wrapXRotation** () const
        void **setWrapXRotation** (bool
        **isEnabled** )

        **Notifier signal:**

        void **wrapXRotationChanged** (bool **isEnabled** )
        """
        ...

    def setWrapYRotation(self, isEnabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#wrapYRotation-prop

        **wrapYRotation : bool**

        This property holds the behavior of the minimum and maximum limits in
        the Y-rotation.

        If `true`, the Y-rotation of the camera is wrapped from minimum to
        maximum and from maximum to minimum. If `false`, the Y-rotation of the
        camera is limited to the sector determined by the minimum and maximum
        values. Set to `true` by default.

        **Access functions:**

        bool **wrapYRotation** () const
        void **setWrapYRotation** (bool
        **isEnabled** )

        **Notifier signal:**

        void **wrapYRotationChanged** (bool **isEnabled** )
        """
        ...

    def setXRotation(self, rotation: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#xRotation-prop

        **xRotation : float**

        This property holds the X-rotation angle of the camera around the target
        point in degrees.

        **Access functions:**

        float **xRotation** () const
        void **setXRotation** (float **rotation**
        )

        **Notifier signal:**

        void **xRotationChanged** (float **rotation** )
        """
        ...

    def setYRotation(self, rotation: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#yRotation-prop

        **yRotation : float**

        This property holds the Y-rotation angle of the camera around the target
        point in degrees.

        **Access functions:**

        float **yRotation** () const
        void **setYRotation** (float **rotation**
        )

        **Notifier signal:**

        void **yRotationChanged** (float **rotation** )
        """
        ...

    def setZoomLevel(self, zoomLevel: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#zoomLevel-prop

        **zoomLevel : float**

        This property holds the camera zoom level in percentage.

        The default value of `100.0f` means there is no zoom in or out set in
        the camera. The value is limited by the **minZoomLevel**  and
        **maxZoomLevel**  properties.

        **Access functions:**

        float **zoomLevel** () const
        void **setZoomLevel** (float
        **zoomLevel** )

        **Notifier signal:**

        void **zoomLevelChanged** (float **zoomLevel** )

        **See also** **minZoomLevel**  and **maxZoomLevel** .

        **Member Function Documentation**
        """
        ...

    def target(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#target-prop

        **[since QtDataVisualization 1.2] target : QVector3D**

        This property holds the camera target as a vector or vertex in the 3D
        space.

        Defaults to `QVector3D(0.0, 0.0, 0.0)`.

        Valid coordinate values are between `-1.0...1.0`, where the edge values
        indicate the edges of the corresponding axis range. Any values outside
        this range are clamped to the edge.

        **Note:** For bar graphs, the Y-coordinate is ignored and camera always
        targets a point on the horizontal background.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        QVector3D **target** () const
        void **setTarget** (const QVector3D &
        **target** )

        **Notifier signal:**

        void **targetChanged** (const QVector3D & **target** )
        """
        ...

    def wrapXRotation(self) -> bool:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#wrapXRotation-prop

        **wrapXRotation : bool**

        This property holds the behavior of the minimum and maximum limits in
        the X-rotation.

        If set to `true`, the X-rotation of the camera is wrapped from minimum
        to maximum and from maximum to minimum. If set to `false`, the
        X-rotation of the camera is limited to the sector determined by the
        minimum and maximum values. Set to `true` by default.

        **Access functions:**

        bool **wrapXRotation** () const
        void **setWrapXRotation** (bool
        **isEnabled** )

        **Notifier signal:**

        void **wrapXRotationChanged** (bool **isEnabled** )
        """
        ...

    def wrapYRotation(self) -> bool:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#wrapYRotation-prop

        **wrapYRotation : bool**

        This property holds the behavior of the minimum and maximum limits in
        the Y-rotation.

        If `true`, the Y-rotation of the camera is wrapped from minimum to
        maximum and from maximum to minimum. If `false`, the Y-rotation of the
        camera is limited to the sector determined by the minimum and maximum
        values. Set to `true` by default.

        **Access functions:**

        bool **wrapYRotation** () const
        void **setWrapYRotation** (bool
        **isEnabled** )

        **Notifier signal:**

        void **wrapYRotationChanged** (bool **isEnabled** )
        """
        ...

    def xRotation(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#xRotation-prop

        **xRotation : float**

        This property holds the X-rotation angle of the camera around the target
        point in degrees.

        **Access functions:**

        float **xRotation** () const
        void **setXRotation** (float **rotation**
        )

        **Notifier signal:**

        void **xRotationChanged** (float **rotation** )
        """
        ...

    def yRotation(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#yRotation-prop

        **yRotation : float**

        This property holds the Y-rotation angle of the camera around the target
        point in degrees.

        **Access functions:**

        float **yRotation** () const
        void **setYRotation** (float **rotation**
        )

        **Notifier signal:**

        void **yRotationChanged** (float **rotation** )
        """
        ...

    def zoomLevel(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dcamera.html#zoomLevel-prop

        **zoomLevel : float**

        This property holds the camera zoom level in percentage.

        The default value of `100.0f` means there is no zoom in or out set in
        the camera. The value is limited by the **minZoomLevel**  and
        **maxZoomLevel**  properties.

        **Access functions:**

        float **zoomLevel** () const
        void **setZoomLevel** (float
        **zoomLevel** )

        **Notifier signal:**

        void **zoomLevelChanged** (float **zoomLevel** )

        **See also** **minZoomLevel**  and **maxZoomLevel** .

        **Member Function Documentation**
        """
        ...

    @property
    def cameraPresetChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maxZoomLevelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def minZoomLevelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def targetChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def wrapXRotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def wrapYRotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xRotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yRotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zoomLevelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
