"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DBars(PySide6.QtDataVisualization.QAbstract3DGraph):
    """
    https://doc.qt.io/qt-6/q3dbars.html

    **Detailed Description**

    This class enables developers to render bar graphs in 3D and to view them by
    rotating the scene freely. Rotation is done by holding down the right mouse
    button and moving the mouse. Zooming is done by mouse wheel. Selection, if
    enabled, is done by left mouse button. The scene can be reset to default
    camera view by clicking mouse wheel. In touch devices rotation is done by
    tap-and-move, selection by tap-and-hold and zoom by pinch.

    If no axes are set explicitly to Q3DBars, temporary default axes with no
    labels are created. These default axes can be modified via axis accessors,
    but as soon any axis is set explicitly for the orientation, the default axis
    for that orientation is destroyed.

    Q3DBars supports more than one series visible at the same time. It is not
    necessary for all series to have the same amount of rows and columns. Row
    and column labels are taken from the first added series, unless explicitly
    defined to row and column axes.

    **How to construct a minimal Q3DBars graph**

    First, construct an instance of Q3DBars. Since we are running the graph as
    top level window in this example, we need to clear the
    `Qt::FramelessWindowHint` flag, which gets set by default:

    **Q3DBars**  bars;
        bars.setFlags(bars.flags() ^
    Qt::FramelessWindowHint);

    After constructing Q3DBars, you can set the data window by changing the
    range on the row and column axes. It is not mandatory, as data window will
    default to showing all of the data in the series. If the amount of data is
    large, it is usually preferable to show just a portion of it. For the
    example, let's set the data window to show first five rows and columns:

    bars.rowAxis()->setRange(0, 4);
        bars.columnAxis()->setRange(0, 4);

    Now Q3DBars is ready to receive data to be rendered. Create a series with
    one row of 5 values:

    QBar3DSeries *series = new QBar3DSeries;
        **QBarDataRow**  *data = new
    **QBarDataRow** ;
        *data << 1.0f << 3.0f << 7.5f << 5.0f << 2.2f;
    series->dataProxy()->addRow(data);
        bars.addSeries(series);

    **Note:** We set the data window to 5 x 5, but we are adding only one row of
    data. This is ok, the rest of the rows will just be blank.

    Finally you will need to set it visible:

    bars.show();

    The complete code needed to create and display this graph is:

    #include <QtDataVisualization>

        int main(int argc, char **argv)
    {
            qputenv("QSG_RHI_BACKEND", "opengl");
            **QGuiApplication**
    app(argc, argv);

            **Q3DBars**  bars;
    bars.setFlags(bars.flags() ^ Qt::FramelessWindowHint);
    bars.rowAxis()->setRange(0, 4);
            bars.columnAxis()->setRange(0, 4);
    QBar3DSeries *series = new QBar3DSeries;
            **QBarDataRow**  *data =
    new **QBarDataRow** ;
            *data << 1.0f << 3.0f << 7.5f << 5.0f << 2.2f;
    series->dataProxy()->addRow(data);
            bars.addSeries(series);
    bars.show();

            return app.exec();
        }

    And this is what those few lines of code produce:

    ![](images/q3dbars-minimal.png)

    The scene can be rotated, zoomed into, and a bar can be selected to view its
    value, but no other interaction is included in this minimal code example.
    You can learn more by familiarizing yourself with the examples provided,
    like the **Bars Example** .

    **See also** **Q3DScatter** , **Q3DSurface** , and **Qt Data Visualization
    C++ Classes** .
    """

    def __init__(
        self,
        format: Union[
            PySide6.QtGui.QSurfaceFormat,
            PySide6.QtGui.QSurfaceFormat.FormatOptions,
            NoneType,
        ] = ...,
        parent: Optional[PySide6.QtGui.QWindow] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#Q3DBars

        **Q3DBars::Q3DBars(const QSurfaceFormat * format = nullptr, QWindow *
        parent = nullptr)**

        Constructs a new 3D bar graph with optional **parent** window and
        surface **format**.
        """
        ...

    def addAxis(self, axis: PySide6.QtDataVisualization.QAbstract3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#addAxis

        **void Q3DBars::addAxis(QAbstract3DAxis * axis )**

        Adds **axis** to the graph. The axes added via addAxis are not yet taken
        to use, addAxis is simply used to give the ownership of the **axis** to
        the graph. The **axis** must not be null or added to another graph.

        **See also** **releaseAxis** (), **setValueAxis** (), **setRowAxis** (),
        and **setColumnAxis** ().
        """
        ...

    def addSeries(self, series: PySide6.QtDataVisualization.QBar3DSeries) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#addSeries

        **void Q3DBars::addSeries(QBar3DSeries * series )**

        Adds the **series** to the graph. A graph can contain multiple series,
        but only one set of axes, so the rows and columns of all series must
        match for the visualized data to be meaningful. If the graph has
        multiple visible series, only the primary series will generate the row
        or column labels on the axes in cases where the labels are not
        explicitly set to the axes. If the newly added series has specified a
        selected bar, it will be highlighted and any existing selection will be
        cleared. Only one added series can have an active selection.

        **See also** **seriesList** () and **primarySeries** .
        """
        ...

    def axes(self) -> List[PySide6.QtDataVisualization.QAbstract3DAxis]:
        """
        https://doc.qt.io/qt-6/q3dbars.html#axes

        **QList<QAbstract3DAxis *> Q3DBars::axes() const**

        Returns the list of all added axes.

        **See also** **addAxis** ().
        """
        ...

    def barSpacing(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/q3dbars.html#barSpacing-prop

        **barSpacing : QSizeF**

        Bar spacing in the X and Z dimensions.

        Preset to `(1.0, 1.0)` by default. Spacing is affected by the
        **barSpacingRelative**  property.

        **Access functions:**

        QSizeF **barSpacing** () const
        void **setBarSpacing** (const QSizeF &
        **spacing** )

        **Notifier signal:**

        void **barSpacingChanged** (const QSizeF & **spacing** )

        **See also** **barSpacingRelative**  and **multiSeriesUniform** .
        """
        ...

    def barThickness(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dbars.html#barThickness-prop

        **barThickness : float**

        This property holds the bar thickness ratio between the X and Z
        dimensions.

        The value `1.0` means that the bars are as wide as they are deep,
        whereas `0.5` makes them twice as deep as they are wide. Preset to `1.0`
        by default.

        **Access functions:**

        float **barThickness** () const
        void **setBarThickness** (float
        **thicknessRatio** )

        **Notifier signal:**

        void **barThicknessChanged** (float **thicknessRatio** )
        """
        ...

    def columnAxis(self) -> PySide6.QtDataVisualization.QCategory3DAxis:
        """
        https://doc.qt.io/qt-6/q3dbars.html#columnAxis-prop

        **columnAxis : QCategory3DAxis***

        This property holds the axis attached to the active column.

        **Access functions:**

        QCategory3DAxis * **columnAxis** () const
        void ****setColumnAxis** **
        (QCategory3DAxis * **axis** )

        **Notifier signal:**

        void **columnAxisChanged** (QCategory3DAxis * **axis** )
        """
        ...

    def floorLevel(self) -> float:
        """
        https://doc.qt.io/qt-6/q3dbars.html#floorLevel-prop

        **floorLevel : float**

        This property holds the floor level for the bar graph in Y-axis data
        coordinates.

        The actual floor level will be restricted by the Y-axis minimum and
        maximum values. Defaults to zero.

        **Access functions:**

        float **floorLevel** () const
        void **setFloorLevel** (float **level**
        )

        **Notifier signal:**

        void **floorLevelChanged** (float **level** )
        """
        ...

    def insertSeries(
        self, index: int, series: PySide6.QtDataVisualization.QBar3DSeries
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#insertSeries

        **void Q3DBars::insertSeries(int index , QBar3DSeries * series )**

        Inserts the **series** into the position **index** in the series list.
        If the **series** has already been added to the list, it is moved to the
        new **index**.

        **Note:** When moving a series to a new **index** that is after its old
        index, the new position in list is calculated as if the series was still
        in its old index, so the final index is actually the **index**
        decremented by one.

        **See also** **addSeries** () and **seriesList** ().
        """
        ...

    def isBarSpacingRelative(self) -> bool:
        ...

    def isMultiSeriesUniform(self) -> bool:
        ...

    def primarySeries(self) -> PySide6.QtDataVisualization.QBar3DSeries:
        """
        https://doc.qt.io/qt-6/q3dbars.html#primarySeries-prop

        **primarySeries : QBar3DSeries***

        This property holds the primary series of the graph.

        **Access functions:**

        QBar3DSeries * **primarySeries** () const
        void ****setPrimarySeries**
        ** (QBar3DSeries * **series** )

        **Notifier signal:**

        void **primarySeriesChanged** (QBar3DSeries * **series** )
        """
        ...

    def releaseAxis(self, axis: PySide6.QtDataVisualization.QAbstract3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#releaseAxis

        **void Q3DBars::releaseAxis(QAbstract3DAxis * axis )**

        Releases the ownership of the **axis** back to the caller, if it is
        added to this graph. If the released **axis** is in use, a new default
        axis will be created and set active.

        If the default axis is released and added back later, it behaves as any
        other axis would.

        **See also** **addAxis** (), **setValueAxis** (), **setRowAxis** (), and
        **setColumnAxis** ().
        """
        ...

    def removeSeries(self, series: PySide6.QtDataVisualization.QBar3DSeries) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#removeSeries

        **void Q3DBars::removeSeries(QBar3DSeries * series )**

        Removes the **series** from the graph.
        """
        ...

    def rowAxis(self) -> PySide6.QtDataVisualization.QCategory3DAxis:
        """
        https://doc.qt.io/qt-6/q3dbars.html#rowAxis-prop

        **rowAxis : QCategory3DAxis***

        This property holds the axis attached to the active row.

        **Access functions:**

        QCategory3DAxis * **rowAxis** () const
        void ****setRowAxis** **
        (QCategory3DAxis * **axis** )

        **Notifier signal:**

        void **rowAxisChanged** (QCategory3DAxis * **axis** )
        """
        ...

    def selectedSeries(self) -> PySide6.QtDataVisualization.QBar3DSeries:
        """
        https://doc.qt.io/qt-6/q3dbars.html#selectedSeries-prop

        **[read-only] selectedSeries : QBar3DSeries* const**

        This property holds the selected series or a null value.

        If selectionMode has the `SelectionMultiSeries` flag set, this property
        holds the series that owns the selected bar.

        **Access functions:**

        QBar3DSeries * **selectedSeries** () const

        **Notifier signal:**

        void **selectedSeriesChanged** (QBar3DSeries * **series** )
        """
        ...

    def seriesList(self) -> List[PySide6.QtDataVisualization.QBar3DSeries]:
        """
        https://doc.qt.io/qt-6/q3dbars.html#seriesList

        **QList<QBar3DSeries *> Q3DBars::seriesList() const**

        Returns the list of series added to this graph.
        """
        ...

    def setBarSpacing(
        self, spacing: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#barSpacing-prop

        **barSpacing : QSizeF**

        Bar spacing in the X and Z dimensions.

        Preset to `(1.0, 1.0)` by default. Spacing is affected by the
        **barSpacingRelative**  property.

        **Access functions:**

        QSizeF **barSpacing** () const
        void **setBarSpacing** (const QSizeF &
        **spacing** )

        **Notifier signal:**

        void **barSpacingChanged** (const QSizeF & **spacing** )

        **See also** **barSpacingRelative**  and **multiSeriesUniform** .
        """
        ...

    def setBarSpacingRelative(self, relative: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#barSpacingRelative-prop

        **barSpacingRelative : bool**

        This property holds whether spacing is absolute or relative to bar
        thickness.

        If it is `true`, the value of `0.0` means that the bars are placed side-
        to-side, `1.0` means that a space as wide as the thickness of one bar is
        left between the bars, and so on. Preset to `true`.

        **Access functions:**

        bool **isBarSpacingRelative** () const
        void **setBarSpacingRelative**
        (bool **relative** )

        **Notifier signal:**

        void **barSpacingRelativeChanged** (bool **relative** )
        """
        ...

    def setBarThickness(self, thicknessRatio: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#barThickness-prop

        **barThickness : float**

        This property holds the bar thickness ratio between the X and Z
        dimensions.

        The value `1.0` means that the bars are as wide as they are deep,
        whereas `0.5` makes them twice as deep as they are wide. Preset to `1.0`
        by default.

        **Access functions:**

        float **barThickness** () const
        void **setBarThickness** (float
        **thicknessRatio** )

        **Notifier signal:**

        void **barThicknessChanged** (float **thicknessRatio** )
        """
        ...

    def setColumnAxis(self, axis: PySide6.QtDataVisualization.QCategory3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#setColumnAxis

        **void Q3DBars::setColumnAxis(QCategory3DAxis * axis )**

        Sets the axis of the active column to **axis**. Implicitly calls
        **addAxis** () to transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels is created.
        This temporary axis is destroyed if another axis is set explicitly to
        the same orientation.

        **Note:** Setter function for property **columnAxis** .

        **See also** **columnAxis** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setFloorLevel(self, level: float) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#floorLevel-prop

        **floorLevel : float**

        This property holds the floor level for the bar graph in Y-axis data
        coordinates.

        The actual floor level will be restricted by the Y-axis minimum and
        maximum values. Defaults to zero.

        **Access functions:**

        float **floorLevel** () const
        void **setFloorLevel** (float **level**
        )

        **Notifier signal:**

        void **floorLevelChanged** (float **level** )
        """
        ...

    def setMultiSeriesUniform(self, uniform: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#multiSeriesUniform-prop

        **multiSeriesUniform : bool**

        This property holds whether bars are to be scaled with proportions set
        to a single series bar even if there are multiple series displayed.

        If set to `true`, **bar spacing**  will be correctly applied only to the
        X-axis. Preset to `false` by default.

        **Access functions:**

        bool **isMultiSeriesUniform** () const
        void **setMultiSeriesUniform**
        (bool **uniform** )

        **Notifier signal:**

        void **multiSeriesUniformChanged** (bool **uniform** )
        """
        ...

    def setPrimarySeries(
        self, series: PySide6.QtDataVisualization.QBar3DSeries
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#setPrimarySeries

        **void Q3DBars::setPrimarySeries(QBar3DSeries * series )**

        Sets **series** as the primary series of the graph. The primary series
        determines the row and column axis labels when the labels are not
        explicitly set to the axes.

        If the specified series is not yet added to the graph, setting it as the
        primary series will also implicitly add it to the graph.

        If the primary series itself is removed from the graph, this property
        resets to default.

        If **series** is null, this property resets to default. Defaults to the
        first added series or zero if no series are added to the graph.

        **Note:** Setter function for property **primarySeries** .

        **See also** **primarySeries** ().
        """
        ...

    def setRowAxis(self, axis: PySide6.QtDataVisualization.QCategory3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#setRowAxis

        **void Q3DBars::setRowAxis(QCategory3DAxis * axis )**

        Sets the axis of the active row to **axis**. Implicitly calls
        **addAxis** () to transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels is created.
        This temporary axis is destroyed if another axis is set explicitly to
        the same orientation.

        **Note:** Setter function for property **rowAxis** .

        **See also** **rowAxis** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setValueAxis(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dbars.html#valueAxis-prop

        **valueAxis : QValue3DAxis***

        Sets the active value axis (the Y-axis) to **axis**. Implicitly calls
        **addAxis** () to transfer the ownership of **axis** to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created. This temporary axis is
        destroyed if another axis is set explicitly to the same orientation.

        **Access functions:**

        QValue3DAxis * **valueAxis** () const
        void **setValueAxis**
        (QValue3DAxis * **axis** )

        **Notifier signal:**

        void **valueAxisChanged** (QValue3DAxis * **axis** )

        **See also** **addAxis** () and **releaseAxis** ().

        **Member Function Documentation**
        """
        ...

    def valueAxis(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dbars.html#valueAxis-prop

        **valueAxis : QValue3DAxis***

        Sets the active value axis (the Y-axis) to **axis**. Implicitly calls
        **addAxis** () to transfer the ownership of **axis** to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created. This temporary axis is
        destroyed if another axis is set explicitly to the same orientation.

        **Access functions:**

        QValue3DAxis * **valueAxis** () const
        void **setValueAxis**
        (QValue3DAxis * **axis** )

        **Notifier signal:**

        void **valueAxisChanged** (QValue3DAxis * **axis** )

        **See also** **addAxis** () and **releaseAxis** ().

        **Member Function Documentation**
        """
        ...

    @property
    def barSpacingChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def barSpacingRelativeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def barThicknessChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnAxisChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def floorLevelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiSeriesUniformChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def primarySeriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowAxisChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedSeriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def valueAxisChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
