"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, overload
import PySide6.QtCore

bytes = str


class QXmlStreamAttributes(object):
    """
    https://doc.qt.io/qt-6/qxmlstreamattributes.html

    **Detailed Description**

    Attributes are returned by a **QXmlStreamReader**  in **attributes** () when
    the reader reports a **start element** . The class can also be used with a
    **QXmlStreamWriter**  as an argument to **writeAttributes** ().

    The convenience function **value** () loops over the vector and returns an
    attribute value for a given namespaceUri and an attribute's name.

    New attributes can be added with **append** ().
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#QXmlStreamAttributes

        **QXmlStreamAttributes::QXmlStreamAttributes()**

        A constructor for QXmlStreamAttributes.
        """
        ...

    @overload
    def __init__(
        self, QXmlStreamAttributes: PySide6.QtCore.QXmlStreamAttributes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#QXmlStreamAttributes

        **QXmlStreamAttributes::QXmlStreamAttributes()**

        A constructor for QXmlStreamAttributes.
        """
        ...

    def __add__(
        self, l: Sequence[PySide6.QtCore.QXmlStreamAttribute]
    ) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, l: Sequence[PySide6.QtCore.QXmlStreamAttribute]
    ) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    @overload
    def append(self, arg__1: PySide6.QtCore.QXmlStreamAttribute) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#append

        **void QXmlStreamAttributes::append(const QString & namespaceUri , const
        QString & name , const QString & value )**

        Appends a new attribute with **name** in the namespace described with
        **namespaceUri** , and value **value**. The **namespaceUri** can be
        empty.
        """
        ...

    @overload
    def append(self, l: Sequence[PySide6.QtCore.QXmlStreamAttribute]) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#append-1

        **void QXmlStreamAttributes::append(const QString & qualifiedName ,
        const QString & value )**

        This is an overloaded function.

        Appends a new attribute with qualified name **qualifiedName** and value
        **value**.
        """
        ...

    @overload
    def append(self, namespaceUri: str, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#append

        **void QXmlStreamAttributes::append(const QString & namespaceUri , const
        QString & name , const QString & value )**

        Appends a new attribute with **name** in the namespace described with
        **namespaceUri** , and value **value**. The **namespaceUri** can be
        empty.
        """
        ...

    @overload
    def append(self, qualifiedName: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#append

        **void QXmlStreamAttributes::append(const QString & namespaceUri , const
        QString & name , const QString & value )**

        Appends a new attribute with **name** in the namespace described with
        **namespaceUri** , and value **value**. The **namespaceUri** can be
        empty.
        """
        ...

    def at(self, i: int) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def back(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def capacity(self) -> int:
        ...

    def clear(self) -> None:
        ...

    def constData(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def constFirst(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def constLast(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def count(self) -> int:
        ...

    def data(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def empty(self) -> bool:
        ...

    @overload
    def first(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    @overload
    def first(self, n: int) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    @staticmethod
    def fromVector(
        vector: Sequence[PySide6.QtCore.QXmlStreamAttribute],
    ) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    def front(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    @overload
    def hasAttribute(self, namespaceUri: str, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#hasAttribute

        **bool QXmlStreamAttributes::hasAttribute(const QString & qualifiedName
        ) const**

        Returns `true` if this **QXmlStreamAttributes**  has an attribute whose
        qualified name is **qualifiedName** ; otherwise returns `false`.

        Note that this is not namespace aware. For instance, if this
        **QXmlStreamAttributes**  contains an attribute whose lexical name is
        "xlink:href" this doesn't tell that an attribute named `href` in the
        XLink namespace is present, since the `xlink` prefix can be bound to any
        namespace. Use the overload that takes a namespace URI and a local name
        as parameter, for namespace aware code.
        """
        ...

    @overload
    def hasAttribute(self, qualifiedName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#hasAttribute-1

        **bool QXmlStreamAttributes::hasAttribute(QLatin1String qualifiedName )
        const**

        This is an overloaded function.
        """
        ...

    def insert(self, arg__1: int, arg__2: PySide6.QtCore.QXmlStreamAttribute) -> None:
        ...

    def isEmpty(self) -> bool:
        ...

    def isSharedWith(self, other: Sequence[PySide6.QtCore.QXmlStreamAttribute]) -> bool:
        ...

    @overload
    def last(self) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    @overload
    def last(self, n: int) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    def length(self) -> int:
        ...

    def mid(self, pos: int, len: int = ...) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    def move(self, from_: int, to: int) -> None:
        ...

    def prepend(self, arg__1: PySide6.QtCore.QXmlStreamAttribute) -> None:
        ...

    def push_back(self, arg__1: PySide6.QtCore.QXmlStreamAttribute) -> None:
        ...

    def push_front(self, arg__1: PySide6.QtCore.QXmlStreamAttribute) -> None:
        ...

    def remove(self, i: int, n: int = ...) -> None:
        ...

    def removeAll(self, arg__1: PySide6.QtCore.QXmlStreamAttribute) -> None:
        ...

    def removeAt(self, i: int) -> None:
        ...

    def removeFirst(self) -> None:
        ...

    def removeLast(self) -> None:
        ...

    def removeOne(self, arg__1: PySide6.QtCore.QXmlStreamAttribute) -> None:
        ...

    def reserve(self, size: int) -> None:
        ...

    def resize(self, size: int) -> None:
        ...

    def shrink_to_fit(self) -> None:
        ...

    def size(self) -> int:
        ...

    @overload
    def sliced(self, pos: int) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    @overload
    def sliced(self, pos: int, n: int) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    def squeeze(self) -> None:
        ...

    def swap(self, other: Sequence[PySide6.QtCore.QXmlStreamAttribute]) -> None:
        ...

    def swapItemsAt(self, i: int, j: int) -> None:
        ...

    def takeAt(self, i: int) -> PySide6.QtCore.QXmlStreamAttribute:
        ...

    def toVector(self) -> List[PySide6.QtCore.QXmlStreamAttribute]:
        ...

    @overload
    def value(self, namespaceUri: str, name: str) -> str:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#value

        **QStringView QXmlStreamAttributes::value(const QString & namespaceUri ,
        const QString & name ) const**

        Returns the value of the attribute **name** in the namespace described
        with **namespaceUri** , or an empty string reference if the attribute is
        not defined. The **namespaceUri** can be empty.
        """
        ...

    @overload
    def value(self, qualifiedName: str) -> str:
        """
        https://doc.qt.io/qt-6/qxmlstreamattributes.html#value-1

        **QStringView QXmlStreamAttributes::value(const QString & namespaceUri ,
        QLatin1String name ) const**

        This is an overloaded function.

        Returns the value of the attribute **name** in the namespace described
        with **namespaceUri** , or an empty string reference if the attribute is
        not defined. The **namespaceUri** can be empty.
        """
        ...
