"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore

bytes = str


class QTimeZone(object):
    """
    https://doc.qt.io/qt-6/qtimezone.html

    **Detailed Description**

    This class provides a stateless calculator for time zone conversions between
    UTC and the local time in a specific time zone. By default it uses the host
    system time zone data to perform these conversions.

    This class is primarily designed for use in **QDateTime** ; most
    applications will not need to access this class directly and should instead
    use **QDateTime**  with a **Qt::TimeSpec**  of **Qt::TimeZone** .

    **Note:** For consistency with **QDateTime** , QTimeZone does not account
    for leap seconds.

    **Remarks**

    **IANA Time Zone IDs**

    QTimeZone uses the IANA time zone IDs as defined in the IANA Time Zone
    Database (http://www.iana.org/time-zones). This is to ensure a standard ID
    across all supported platforms. Most platforms support the IANA IDs and the
    IANA Database natively, but for Windows a mapping is required to the native
    IDs. See below for more details.

    The IANA IDs can and do change on a regular basis, and can vary depending on
    how recently the host system data was updated. As such you cannot rely on
    any given ID existing on any host system. You must use
    **availableTimeZoneIds** () to determine what IANA IDs are available.

    The IANA IDs and database are also know as the Olson IDs and database, named
    after their creator.

    **UTC Offset Time Zones**

    A default UTC time zone backend is provided which is always guaranteed to be
    available. This provides a set of generic Offset From UTC time zones in the
    range UTC-14:00 to UTC+14:00. These time zones can be created using either
    the standard ISO format names "UTC+00:00" as listed by
    **availableTimeZoneIds** (), or using the number of offset seconds.

    **Windows Time Zones**

    Windows native time zone support is severely limited compared to the
    standard IANA TZ Database. Windows time zones cover larger geographic areas
    and are thus less accurate in their conversions. They also do not support as
    much historic conversion data and so may only be accurate for the current
    year.

    QTimeZone uses a conversion table derived form the Unicode CLDR data to map
    between IANA IDs and Windows IDs. Depending on your version of Windows and
    Qt, this table may not be able to provide a valid conversion, in which "UTC"
    will be returned.

    QTimeZone provides a public API to use this conversion table. The Windows ID
    used is the Windows Registry Key for the time zone which is also the MS
    Exchange EWS ID as well, but is different to the Time Zone Name (TZID) and
    COD code used by MS Exchange in versions before 2007.

    **System Time Zone**

    QTimeZone does not support any concept of a system or default time zone. If
    you require a **QDateTime**  that uses the current system time zone at any
    given moment then you should use a **Qt::TimeSpec**  of **Qt::LocalTime** .

    The method **systemTimeZoneId** () returns the current system IANA time zone
    ID which on Unix-like systems will always be correct. On Windows this ID is
    translated from the Windows system ID using an internal translation table
    and the user's selected country. As a consequence there is a small chance
    any Windows install may have IDs not known by Qt, in which case "UTC" will
    be returned.

    Creating a new QTimeZone instance using the system time zone ID will only
    produce a fixed named copy of the time zone, it will not change if the
    system time zone changes.

    **Time Zone Offsets**

    The difference between UTC and the local time in a time zone is expressed as
    an offset in seconds from UTC, i.e. the number of seconds to add to UTC to
    obtain the local time. The total offset is comprised of two component parts,
    the standard time offset and the daylight-saving time offset. The standard
    time offset is the number of seconds to add to UTC to obtain standard time
    in the time zone. The daylight-saving time offset is the number of seconds
    to add to the standard time offset to obtain daylight-saving time
    (abbreviated DST and sometimes called "daylight time" or "summer time") in
    the time zone.

    Note that the standard and DST offsets for a time zone may change over time
    as countries have changed DST laws or even their standard time offset.

    **License**

    This class includes data obtained from the CLDR data files under the terms
    of the Unicode Data Files and Software License. See **Unicode Common Locale
    Data Repository (CLDR)**  for details.

    **See also** **QDateTime** .
    """

    DefaultName: QTimeZone.NameType = ...
    LongName: QTimeZone.NameType = ...
    ShortName: QTimeZone.NameType = ...
    OffsetName: QTimeZone.NameType = ...
    StandardTime: QTimeZone.TimeType = ...
    DaylightTime: QTimeZone.TimeType = ...
    GenericTime: QTimeZone.TimeType = ...

    class NameType(Enum):
        DefaultName: QTimeZone.NameType = ...
        LongName: QTimeZone.NameType = ...
        ShortName: QTimeZone.NameType = ...
        OffsetName: QTimeZone.NameType = ...

    class OffsetData(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, OffsetData: PySide6.QtCore.QTimeZone.OffsetData) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class TimeType(Enum):
        StandardTime: QTimeZone.TimeType = ...
        DaylightTime: QTimeZone.TimeType = ...
        GenericTime: QTimeZone.TimeType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtimezone.html#QTimeZone

        **QTimeZone::QTimeZone()**

        Create a null/invalid time zone instance.
        """
        ...

    @overload
    def __init__(self, ianaId: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qtimezone.html#QTimeZone-1

        **QTimeZone::QTimeZone(const QByteArray & ianaId )**

        Creates an instance of the requested time zone **ianaId**.

        The ID must be one of the available system IDs or a valid UTC-with-
        offset ID, otherwise an invalid time zone will be returned.

        **See also** **availableTimeZoneIds** ().
        """
        ...

    @overload
    def __init__(self, offsetSeconds: int) -> None:
        """
        https://doc.qt.io/qt-6/qtimezone.html#QTimeZone-2

        **QTimeZone::QTimeZone(int offsetSeconds )**

        Creates an instance of a time zone with the requested Offset from UTC of
        **offsetSeconds**.

        The **offsetSeconds** from UTC must be in the range -14 hours to +14
        hours otherwise an invalid time zone will be returned.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtCore.QTimeZone) -> None:
        """
        https://doc.qt.io/qt-6/qtimezone.html#QTimeZone-3

        **QTimeZone::QTimeZone(const QByteArray & ianaId , int offsetSeconds ,
        const QString & name , const QString & abbreviation , QLocale::Territory
        territory = QLocale::AnyTerritory, const QString & comment =
        QString())**

        Creates a custom time zone with an ID of **ianaId** and an offset from
        UTC of **offsetSeconds**. The **name** will be the name used by
        **displayName** () for the **LongName** , the **abbreviation** will be
        used by **displayName** () for the **ShortName**  and by
        **abbreviation** (), and the optional **territory** will be used by
        **territory** (). The **comment** is an optional note that may be
        displayed in a GUI to assist users in selecting a time zone.

        The **ianaId** must not be one of the available system IDs returned by
        **availableTimeZoneIds** (). The **offsetSeconds** from UTC must be in
        the range -14 hours to +14 hours.

        If the custom time zone does not have a specific territory then set it
        to the default value of **QLocale::AnyTerritory** .
        """
        ...

    @overload
    def __init__(
        self,
        zoneId: Union[PySide6.QtCore.QByteArray, bytes],
        offsetSeconds: int,
        name: str,
        abbreviation: str,
        territory: PySide6.QtCore.QLocale.Country = ...,
        comment: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtimezone.html#QTimeZone-4

        **QTimeZone::QTimeZone(const QTimeZone & other )**

        Copy constructor, copy **other** to this.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def abbreviation(self, atDateTime: PySide6.QtCore.QDateTime) -> str:
        """
        https://doc.qt.io/qt-6/qtimezone.html#abbreviation

        **QString QTimeZone::abbreviation(const QDateTime & atDateTime ) const**

        Returns the time zone abbreviation at the given **atDateTime**. The
        abbreviation may change depending on DST or even historical events.

        Note that the abbreviation is not guaranteed to be unique to this time
        zone and should not be used in place of the ID or display name.

        **See also** **displayName** ().
        """
        ...

    @overload
    @staticmethod
    def availableTimeZoneIds() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qtimezone.html#availableTimeZoneIds

        **[static] QList<QByteArray> QTimeZone::availableTimeZoneIds()**

        Returns a list of all available IANA time zone IDs on this system.

        **See also** **isTimeZoneIdAvailable** ().
        """
        ...

    @overload
    @staticmethod
    def availableTimeZoneIds(offsetSeconds: int) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qtimezone.html#availableTimeZoneIds-1

        **[static] QList<QByteArray>
        QTimeZone::availableTimeZoneIds(QLocale::Territory territory )**

        Returns a list of all available IANA time zone IDs for a given
        **territory**.

        As a special case, a **territory** of Qt::AnyTerritory returns those
        time zones that do not have any territory related to them, such as UTC.
        If you require a list of all time zone IDs for all countries then use
        the standard availableTimeZoneIds() method.

        **See also** **isTimeZoneIdAvailable** ().
        """
        ...

    @overload
    @staticmethod
    def availableTimeZoneIds(
        territory: PySide6.QtCore.QLocale.Country,
    ) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qtimezone.html#availableTimeZoneIds-2

        **[static] QList<QByteArray> QTimeZone::availableTimeZoneIds(int
        offsetSeconds )**

        Returns a list of all available IANA time zone IDs with a given standard
        time offset of **offsetSeconds**.

        **See also** **isTimeZoneIdAvailable** ().
        """
        ...

    def comment(self) -> str:
        """
        https://doc.qt.io/qt-6/qtimezone.html#comment

        **QString QTimeZone::comment() const**

        Returns any comment for the time zone.

        A comment may be provided by the host platform to assist users in
        choosing the correct time zone. Depending on the platform this may not
        be localized.
        """
        ...

    def country(self) -> PySide6.QtCore.QLocale.Country:
        ...

    def daylightTimeOffset(self, atDateTime: PySide6.QtCore.QDateTime) -> int:
        """
        https://doc.qt.io/qt-6/qtimezone.html#daylightTimeOffset

        **int QTimeZone::daylightTimeOffset(const QDateTime & atDateTime )
        const**

        Returns the daylight-saving time offset at the given **atDateTime** ,
        i.e. the number of seconds to add to the standard time offset to obtain
        the local daylight-saving time.

        For example, for the time zone "Europe/Berlin" the DST offset is +3600
        seconds. During standard time daylightTimeOffset() will return 0, and
        when daylight-saving is in effect it will return +3600.

        **See also** **offsetFromUtc** () and **standardTimeOffset** ().
        """
        ...

    @overload
    def displayName(
        self,
        atDateTime: PySide6.QtCore.QDateTime,
        nameType: PySide6.QtCore.QTimeZone.NameType = ...,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language] = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qtimezone.html#displayName

        **QString QTimeZone::displayName(const QDateTime & atDateTime ,
        QTimeZone::NameType nameType = QTimeZone::DefaultName, const QLocale &
        locale = QLocale()) const**

        Returns the localized time zone display name at the given **atDateTime**
        for the given **nameType** in the given **locale**. The **nameType** and
        **locale** requested may not be supported on all platforms, in which
        case the best available option will be returned.

        If the **locale** is not provided then the application default locale
        will be used.

        The display name may change depending on DST or historical events.

        **See also** **abbreviation** ().
        """
        ...

    @overload
    def displayName(
        self,
        timeType: PySide6.QtCore.QTimeZone.TimeType,
        nameType: PySide6.QtCore.QTimeZone.NameType = ...,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language] = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qtimezone.html#displayName-1

        **QString QTimeZone::displayName(QTimeZone::TimeType timeType ,
        QTimeZone::NameType nameType = QTimeZone::DefaultName, const QLocale &
        locale = QLocale()) const**

        Returns the localized time zone display name for the given **timeType**
        and **nameType** in the given **locale**. The **nameType** and
        **locale** requested may not be supported on all platforms, in which
        case the best available option will be returned.

        If the **locale** is not provided then the application default locale
        will be used.

        Where the time zone display names have changed over time then the most
        recent names will be used.

        **See also** **abbreviation** ().
        """
        ...

    def hasDaylightTime(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtimezone.html#hasDaylightTime

        **bool QTimeZone::hasDaylightTime() const**

        Returns `true` if the time zone has practiced daylight-saving at any
        time.

        **See also** **isDaylightTime** () and **daylightTimeOffset** ().
        """
        ...

    def hasTransitions(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtimezone.html#hasTransitions

        **bool QTimeZone::hasTransitions() const**

        Returns `true` if the system backend supports obtaining transitions.

        Transitions are changes in the time-zone: these happen when DST turns on
        or off and when authorities alter the offsets for the time-zone.

        **See also** **nextTransition** (), **previousTransition** (), and
        **transitions** ().
        """
        ...

    @staticmethod
    def ianaIdToWindowsId(
        ianaId: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qtimezone.html#ianaIdToWindowsId

        **[static] QByteArray QTimeZone::ianaIdToWindowsId(const QByteArray &
        ianaId )**

        Returns the Windows ID equivalent to the given **ianaId**.

        **See also** **windowsIdToDefaultIanaId** () and **windowsIdToIanaIds**
        ().
        """
        ...

    def id(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qtimezone.html#id

        **QByteArray QTimeZone::id() const**

        Returns the IANA ID for the time zone.

        IANA IDs are used on all platforms. On Windows these are translated from
        the Windows ID into the closest IANA ID for the time zone and territory.
        """
        ...

    def isDaylightTime(self, atDateTime: PySide6.QtCore.QDateTime) -> bool:
        """
        https://doc.qt.io/qt-6/qtimezone.html#isDaylightTime

        **bool QTimeZone::isDaylightTime(const QDateTime & atDateTime ) const**

        Returns `true` if daylight-saving was in effect at the given
        **atDateTime**.

        **See also** **hasDaylightTime** () and **daylightTimeOffset** ().
        """
        ...

    @staticmethod
    def isTimeZoneIdAvailable(ianaId: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qtimezone.html#isTimeZoneIdAvailable

        **[static] bool QTimeZone::isTimeZoneIdAvailable(const QByteArray &
        ianaId )**

        Returns `true` if a given time zone **ianaId** is available on this
        system.

        **See also** **availableTimeZoneIds** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtimezone.html#isValid

        **bool QTimeZone::isValid() const**

        Returns `true` if this time zone is valid.
        """
        ...

    def nextTransition(
        self, afterDateTime: PySide6.QtCore.QDateTime
    ) -> PySide6.QtCore.QTimeZone.OffsetData:
        """
        https://doc.qt.io/qt-6/qtimezone.html#nextTransition

        **QTimeZone::OffsetData QTimeZone::nextTransition(const QDateTime &
        afterDateTime ) const**

        Returns the first time zone Transition after the given
        **afterDateTime**. This is most useful when you have a Transition time
        and wish to find the Transition after it.

        If there is no transition after the given **afterDateTime** then an
        invalid **OffsetData**  will be returned with an invalid **QDateTime** .

        The given **afterDateTime** is exclusive.

        **See also** **hasTransitions** (), **previousTransition** (), and
        **transitions** ().
        """
        ...

    def offsetData(
        self, forDateTime: PySide6.QtCore.QDateTime
    ) -> PySide6.QtCore.QTimeZone.OffsetData:
        """
        https://doc.qt.io/qt-6/qtimezone.html#offsetData

        **QTimeZone::OffsetData QTimeZone::offsetData(const QDateTime &
        forDateTime ) const**

        Returns the effective offset details at the given **forDateTime**. This
        is the equivalent of calling **offsetFromUtc** (), **abbreviation** (),
        etc individually but is more efficient.

        **See also** **offsetFromUtc** (), **standardTimeOffset** (),
        **daylightTimeOffset** (), and **abbreviation** ().
        """
        ...

    def offsetFromUtc(self, atDateTime: PySide6.QtCore.QDateTime) -> int:
        """
        https://doc.qt.io/qt-6/qtimezone.html#offsetFromUtc

        **int QTimeZone::offsetFromUtc(const QDateTime & atDateTime ) const**

        Returns the total effective offset at the given **atDateTime** , i.e.
        the number of seconds to add to UTC to obtain the local time. This
        includes any DST offset that may be in effect, i.e. it is the sum of
        **standardTimeOffset** () and **daylightTimeOffset** () for the given
        datetime.

        For example, for the time zone "Europe/Berlin" the standard time offset
        is +3600 seconds and the DST offset is +3600 seconds. During standard
        time offsetFromUtc() will return +3600 (UTC+01:00), and during DST it
        will return +7200 (UTC+02:00).

        **See also** **standardTimeOffset** () and **daylightTimeOffset** ().
        """
        ...

    def previousTransition(
        self, beforeDateTime: PySide6.QtCore.QDateTime
    ) -> PySide6.QtCore.QTimeZone.OffsetData:
        """
        https://doc.qt.io/qt-6/qtimezone.html#previousTransition

        **QTimeZone::OffsetData QTimeZone::previousTransition(const QDateTime &
        beforeDateTime ) const**

        Returns the first time zone Transition before the given
        **beforeDateTime**. This is most useful when you have a Transition time
        and wish to find the Transition before it.

        If there is no transition before the given **beforeDateTime** then an
        invalid **OffsetData**  will be returned with an invalid **QDateTime** .

        The given **beforeDateTime** is exclusive.

        **See also** **hasTransitions** (), **nextTransition** (), and
        **transitions** ().
        """
        ...

    def standardTimeOffset(self, atDateTime: PySide6.QtCore.QDateTime) -> int:
        """
        https://doc.qt.io/qt-6/qtimezone.html#standardTimeOffset

        **int QTimeZone::standardTimeOffset(const QDateTime & atDateTime )
        const**

        Returns the standard time offset at the given **atDateTime** , i.e. the
        number of seconds to add to UTC to obtain the local Standard Time. This
        excludes any DST offset that may be in effect.

        For example, for the time zone "Europe/Berlin" the standard time offset
        is +3600 seconds. During both standard and DST **offsetFromUtc** () will
        return +3600 (UTC+01:00).

        **See also** **offsetFromUtc** () and **daylightTimeOffset** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QTimeZone) -> None:
        """
        https://doc.qt.io/qt-6/qtimezone.html#swap

        **void QTimeZone::swap(QTimeZone & other )**

        Swaps this time zone instance with **other**. This function is very fast
        and never fails.
        """
        ...

    @staticmethod
    def systemTimeZone() -> PySide6.QtCore.QTimeZone:
        """
        https://doc.qt.io/qt-6/qtimezone.html#systemTimeZone

        **[static, since 5.5] QTimeZone QTimeZone::systemTimeZone()**

        Returns a **QTimeZone**  object that refers to the local system time, as
        specified by **systemTimeZoneId** ().

        This function was introduced in Qt 5.5.

        **See also** **utc** ().
        """
        ...

    @staticmethod
    def systemTimeZoneId() -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qtimezone.html#systemTimeZoneId

        **[static] QByteArray QTimeZone::systemTimeZoneId()**

        Returns the current system time zone IANA ID.

        On Windows this ID is translated from the Windows ID using an internal
        translation table and the user's selected country. As a consequence
        there is a small chance any Windows install may have IDs not known by
        Qt, in which case "UTC" will be returned.
        """
        ...

    def territory(self) -> PySide6.QtCore.QLocale.Country:
        """
        https://doc.qt.io/qt-6/qtimezone.html#territory

        **[since 6.2] QLocale::Territory QTimeZone::territory() const**

        Returns the territory for the time zone.

        This function was introduced in Qt 6.2.
        """
        ...

    def transitions(
        self,
        fromDateTime: PySide6.QtCore.QDateTime,
        toDateTime: PySide6.QtCore.QDateTime,
    ) -> List[PySide6.QtCore.QTimeZone.OffsetData]:
        """
        https://doc.qt.io/qt-6/qtimezone.html#transitions

        **QTimeZone::OffsetDataList QTimeZone::transitions(const QDateTime &
        fromDateTime , const QDateTime & toDateTime ) const**

        Returns a list of all time zone transitions between the given datetimes.

        The given **fromDateTime** and **toDateTime** are inclusive.

        **See also** **hasTransitions** (), **nextTransition** (), and
        **previousTransition** ().
        """
        ...

    @staticmethod
    def utc() -> PySide6.QtCore.QTimeZone:
        """
        https://doc.qt.io/qt-6/qtimezone.html#utc

        **[static, since 5.5] QTimeZone QTimeZone::utc()**

        Returns a **QTimeZone**  object that refers to UTC (Universal Time
        Coordinated).

        This function was introduced in Qt 5.5.

        **See also** **systemTimeZone** ().
        """
        ...

    @overload
    @staticmethod
    def windowsIdToDefaultIanaId(
        windowsId: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qtimezone.html#windowsIdToDefaultIanaId

        **[static] QByteArray QTimeZone::windowsIdToDefaultIanaId(const
        QByteArray & windowsId )**

        Returns the default IANA ID for a given **windowsId**.

        Because a Windows ID can cover several IANA IDs in several different
        countries, this function returns the most frequently used IANA ID with
        no regard for the country and should thus be used with care. It is
        usually best to request the default for a specific country.

        **See also** **ianaIdToWindowsId** () and **windowsIdToIanaIds** ().
        """
        ...

    @overload
    @staticmethod
    def windowsIdToDefaultIanaId(
        windowsId: Union[PySide6.QtCore.QByteArray, bytes],
        territory: PySide6.QtCore.QLocale.Country,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qtimezone.html#windowsIdToDefaultIanaId-1

        **[static] QByteArray QTimeZone::windowsIdToDefaultIanaId(const
        QByteArray & windowsId , QLocale::Territory territory )**

        Returns the default IANA ID for a given **windowsId** and **territory**.

        Because a Windows ID can cover several IANA IDs within a given
        territory, the most frequently used IANA ID in that territory is
        returned.

        As a special case, **QLocale::AnyTerritory**  returns the default of
        those IANA IDs that do not have any specific territory.

        **See also** **ianaIdToWindowsId** () and **windowsIdToIanaIds** ().
        """
        ...

    @overload
    @staticmethod
    def windowsIdToIanaIds(
        windowsId: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qtimezone.html#windowsIdToIanaIds

        **[static] QList<QByteArray> QTimeZone::windowsIdToIanaIds(const
        QByteArray & windowsId )**

        Returns all the IANA IDs for a given **windowsId**.

        The returned list is sorted alphabetically.

        **See also** **ianaIdToWindowsId** () and **windowsIdToDefaultIanaId**
        ().
        """
        ...

    @overload
    @staticmethod
    def windowsIdToIanaIds(
        windowsId: Union[PySide6.QtCore.QByteArray, bytes],
        territory: PySide6.QtCore.QLocale.Country,
    ) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qtimezone.html#windowsIdToIanaIds-1

        **[static] QList<QByteArray> QTimeZone::windowsIdToIanaIds(const
        QByteArray & windowsId , QLocale::Territory territory )**

        Returns all the IANA IDs for a given **windowsId** and **territory**.

        As a special case **QLocale::AnyTerritory**  returns those IANA IDs that
        do not have any specific territory.

        The returned list is in order of frequency of usage, i.e. larger zones
        within a territory are listed first.

        **See also** **ianaIdToWindowsId** () and **windowsIdToDefaultIanaId**
        ().
        """
        ...
