"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore

bytes = str


class QThread(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qthread.html

    **Detailed Description**

    A QThread object manages one thread of control within the program. QThreads
    begin executing in **run** (). By default, **run** () starts the event loop
    by calling **exec** () and runs a Qt event loop inside the thread.

    You can use worker objects by moving them to the thread using
    **QObject::moveToThread** ().

    class Worker : public **QObject**
        {
            Q_OBJECT

        public
    slots:
            void doWork(const **QString**  &parameter) {
    **QString**  result;
                /* ... here is the expensive or blocking
    operation ... */
                emit resultReady(result);
            }
    signals:
            void resultReady(const **QString**  &result);
        };
    class Controller : public **QObject**
        {
            Q_OBJECT
    **QThread**  workerThread;
        public:
            Controller() {
    Worker *worker = new Worker;
    worker->moveToThread(&workerThread);
                connect(&workerThread,
    &**QThread** ::finished, worker, &**QObject** ::deleteLater);
    connect(this, &Controller::operate, worker, &Worker::doWork);
    connect(worker, &Worker::resultReady, this, &Controller::handleResults);
    workerThread.start();
            }
            ~Controller() {
    workerThread.quit();
                workerThread.wait();
            }
        public
    slots:
            void handleResults(const **QString**  &);
        signals:
    void operate(const **QString**  &);
        };

    The code inside the Worker's slot would then execute in a separate thread.
    However, you are free to connect the Worker's slots to any signal, from any
    object, in any thread. It is safe to connect signals and slots across
    different threads, thanks to a mechanism called **queued connections** .

    Another way to make code run in a separate thread, is to subclass QThread
    and reimplement **run** (). For example:

    class WorkerThread : public **QThread**
        {
            Q_OBJECT
            void
    run() override {
                **QString**  result;
                /* ... here is
    the expensive or blocking operation ... */
                emit
    resultReady(result);
            }
        signals:
            void resultReady(const
    **QString**  &s);
        };

        void MyObject::startWorkInAThread()
        {
    WorkerThread *workerThread = new WorkerThread(this);
    connect(workerThread, &WorkerThread::resultReady, this,
    &MyObject::handleResults);
            connect(workerThread,
    &WorkerThread::finished, workerThread, &**QObject** ::deleteLater);
    workerThread->start();
        }

    In that example, the thread will exit after the run function has returned.
    There will not be any event loop running in the thread unless you call
    **exec** ().

    It is important to remember that a QThread instance **lives in**  the old
    thread that instantiated it, not in the new thread that calls **run** ().
    This means that all of QThread's queued slots and **invoked methods**  will
    execute in the old thread. Thus, a developer who wishes to invoke slots in
    the new thread must use the worker-object approach; new slots should not be
    implemented directly into a subclassed QThread.

    Unlike queued slots or invoked methods, methods called directly on the
    QThread object will execute in the thread that calls the method. When
    subclassing QThread, keep in mind that the constructor executes in the old
    thread while **run** () executes in the new thread. If a member variable is
    accessed from both functions, then the variable is accessed from two
    different threads. Check that it is safe to do so.

    **Note:** Care must be taken when interacting with objects across different
    threads. As a general rule, functions can only be called from the thread
    that created the QThread object itself (e.g. **setPriority** ()), unless the
    documentation says otherwise. See **Synchronizing Threads**  for details.

    **Managing Threads**

    QThread will notify you via a signal when the thread is **started** () and
    **finished** (), or you can use **isFinished** () and **isRunning** () to
    query the state of the thread.

    You can stop the thread by calling **exit** () or **quit** (). In extreme
    cases, you may want to forcibly **terminate** () an executing thread.
    However, doing so is dangerous and discouraged. Please read the
    documentation for **terminate** () and **setTerminationEnabled** () for
    detailed information.

    From Qt 4.8 onwards, it is possible to deallocate objects that live in a
    thread that has just ended, by connecting the **finished** () signal to
    **QObject::deleteLater** ().

    Use **wait** () to block the calling thread, until the other thread has
    finished execution (or until a specified time has passed).

    QThread also provides static, platform independent sleep functions:
    **sleep** (), **msleep** (), and **usleep** () allow full second,
    millisecond, and microsecond resolution respectively. These functions were
    made public in Qt 5.0.

    **Note:****wait** () and the **sleep** () functions should be unnecessary in
    general, since Qt is an event-driven framework. Instead of **wait** (),
    consider listening for the **finished** () signal. Instead of the **sleep**
    () functions, consider using **QTimer** .

    The static functions **currentThreadId** () and **currentThread** () return
    identifiers for the currently executing thread. The former returns a
    platform specific ID for the thread; the latter returns a QThread pointer.

    To choose the name that your thread will be given (as identified by the
    command `ps -L` on Linux, for example), you can call **setObjectName** ()
    before starting the thread. If you don't call **setObjectName** (), the name
    given to your thread will be the class name of the runtime type of your
    thread object (for example, `"RenderThread"` in the case of the **Mandelbrot
    Example** , as that is the name of the QThread subclass). Note that this is
    currently not available with release builds on Windows.

    **See also** **Thread Support in Qt** , **QThreadStorage** , **Synchronizing
    Threads** , **Mandelbrot Example** , **Semaphores Example** , and **Wait
    Conditions Example** .
    """

    IdlePriority: QThread.Priority = ...
    LowestPriority: QThread.Priority = ...
    LowPriority: QThread.Priority = ...
    NormalPriority: QThread.Priority = ...
    HighPriority: QThread.Priority = ...
    HighestPriority: QThread.Priority = ...
    TimeCriticalPriority: QThread.Priority = ...
    InheritPriority: QThread.Priority = ...

    class Priority(Enum):
        IdlePriority: QThread.Priority = ...
        LowestPriority: QThread.Priority = ...
        LowPriority: QThread.Priority = ...
        NormalPriority: QThread.Priority = ...
        HighPriority: QThread.Priority = ...
        HighestPriority: QThread.Priority = ...
        TimeCriticalPriority: QThread.Priority = ...
        InheritPriority: QThread.Priority = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#QThread

        **QThread::QThread(QObject * parent = nullptr)**

        Constructs a new QThread to manage a new thread. The **parent** takes
        ownership of the QThread. The thread does not begin executing until
        **start** () is called.

        **See also** **start** ().
        """
        ...

    @staticmethod
    def currentThread() -> PySide6.QtCore.QThread:
        """
        https://doc.qt.io/qt-6/qthread.html#currentThread

        **[static] QThread *QThread::currentThread()**

        Returns a pointer to a **QThread**  which manages the currently
        executing thread.
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qthread.html#event

        **[override virtual] bool QThread::event(QEvent * event )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def eventDispatcher(self) -> PySide6.QtCore.QAbstractEventDispatcher:
        """
        https://doc.qt.io/qt-6/qthread.html#eventDispatcher

        **[since 5.0] QAbstractEventDispatcher *QThread::eventDispatcher()
        const**

        Returns a pointer to the event dispatcher object for the thread. If no
        event dispatcher exists for the thread, this function returns `nullptr`.

        This function was introduced in Qt 5.0.

        **See also** **setEventDispatcher** ().
        """
        ...

    def exec(self) -> int:
        """
        https://doc.qt.io/qt-6/qthread.html#exec

        **[protected] int QThread::exec()**

        Enters the event loop and waits until **exit** () is called, returning
        the value that was passed to **exit** (). The value returned is 0 if
        **exit** () is called via **quit** ().

        This function is meant to be called from within **run** (). It is
        necessary to call this function to start event handling.

        **Note:** This can only be called within the thread itself, i.e. when it
        is the current thread.

        **See also** **quit** () and **exit** ().
        """
        ...

    def exec_(self) -> int:
        """
        https://doc.qt.io/qt-6/qthread.html#exec

        **[protected] int QThread::exec()**

        Enters the event loop and waits until **exit** () is called, returning
        the value that was passed to **exit** (). The value returned is 0 if
        **exit** () is called via **quit** ().

        This function is meant to be called from within **run** (). It is
        necessary to call this function to start event handling.

        **Note:** This can only be called within the thread itself, i.e. when it
        is the current thread.

        **See also** **quit** () and **exit** ().
        """
        ...

    def exit(self, retcode: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#exit

        **[slot] void QThread::exit(int returnCode = 0)**

        Tells the thread's event loop to exit with a return code.

        After calling this function, the thread leaves the event loop and
        returns from the call to **QEventLoop::exec** (). The
        **QEventLoop::exec** () function returns **returnCode**.

        By convention, a **returnCode** of 0 means success, any non-zero value
        indicates an error.

        Note that unlike the C library function of the same name, this function
        **does** return to the caller -- it is event processing that stops.

        No QEventLoops will be started anymore in this thread until
        **QThread::exec** () has been called again. If the eventloop in
        **QThread::exec** () is not running then the next call to
        **QThread::exec** () will also return immediately.

        **Note:** This function is **thread-safe** .

        **See also** **quit** () and **QEventLoop** .
        """
        ...

    @staticmethod
    def idealThreadCount() -> int:
        """
        https://doc.qt.io/qt-6/qthread.html#idealThreadCount

        **[static] int QThread::idealThreadCount()**

        Returns the ideal number of threads that can be run on the system. This
        is done querying the number of processor cores, both real and logical,
        in the system. This function returns 1 if the number of processor cores
        could not be detected.
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qthread.html#isFinished

        **bool QThread::isFinished() const**

        Returns `true` if the thread is finished; otherwise returns `false`.

        **Note:** This function is **thread-safe** .

        **See also** **isRunning** ().
        """
        ...

    def isInterruptionRequested(self) -> bool:
        """
        https://doc.qt.io/qt-6/qthread.html#isInterruptionRequested

        **[since 5.2] bool QThread::isInterruptionRequested() const**

        Return true if the task running on this thread should be stopped. An
        interruption can be requested by **requestInterruption** ().

        This function can be used to make long running tasks cleanly
        interruptible. Never checking or acting on the value returned by this
        function is safe, however it is advisable do so regularly in long
        running functions. Take care not to call it too often, to keep the
        overhead low.

        void long_task() {
                 forever {
                    if ( **QThread**
        ::currentThread()->isInterruptionRequested() ) {
                        return;
        }
                }
            }

        **Note:** This can only be called within the thread itself, i.e. when it
        is the current thread.

        This function was introduced in Qt 5.2.

        **See also** **currentThread** () and **requestInterruption** ().
        """
        ...

    def isRunning(self) -> bool:
        """
        https://doc.qt.io/qt-6/qthread.html#isRunning

        **bool QThread::isRunning() const**

        Returns `true` if the thread is running; otherwise returns `false`.

        **Note:** This function is **thread-safe** .

        **See also** **isFinished** ().
        """
        ...

    def loopLevel(self) -> int:
        """
        https://doc.qt.io/qt-6/qthread.html#loopLevel

        **[since 5.5] int QThread::loopLevel() const**

        Returns the current event loop level for the thread.

        **Note:** This can only be called within the thread itself, i.e. when it
        is the current thread.

        This function was introduced in Qt 5.5.
        """
        ...

    @staticmethod
    def msleep(arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#msleep

        **[static] void QThread::msleep(unsigned long msecs )**

        Forces the current thread to sleep for **msecs** milliseconds.

        Avoid using this function if you need to wait for a given condition to
        change. Instead, connect a slot to the signal that indicates the change
        or use an event handler (see **QObject::event** ()).

        **Note:** This function does not guarantee accuracy. The application may
        sleep longer than **msecs** under heavy load conditions. Some OSes might
        round **msecs** up to 10 ms or 15 ms.

        **See also** **sleep** () and **usleep** ().
        """
        ...

    def priority(self) -> PySide6.QtCore.QThread.Priority:
        """
        https://doc.qt.io/qt-6/qthread.html#priority

        **QThread::Priority QThread::priority() const**

        Returns the priority for a running thread. If the thread is not running,
        this function returns `InheritPriority`.

        **See also** **Priority** , **setPriority** (), and **start** ().
        """
        ...

    def quit(self) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#quit

        **[slot] void QThread::quit()**

        Tells the thread's event loop to exit with return code 0 (success).
        Equivalent to calling **QThread::exit** (0).

        This function does nothing if the thread does not have an event loop.

        **Note:** This function is **thread-safe** .

        **See also** **exit** () and **QEventLoop** .
        """
        ...

    def requestInterruption(self) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#requestInterruption

        **[since 5.2] void QThread::requestInterruption()**

        Request the interruption of the thread. That request is advisory and it
        is up to code running on the thread to decide if and how it should act
        upon such request. This function does not stop any event loop running on
        the thread and does not terminate it in any way.

        **Note:** This function is **thread-safe** .

        This function was introduced in Qt 5.2.

        **See also** **isInterruptionRequested** ().
        """
        ...

    def run(self) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#run

        **[virtual protected] void QThread::run()**

        The starting point for the thread. After calling **start** (), the newly
        created thread calls this function. The default implementation simply
        calls **exec** ().

        You can reimplement this function to facilitate advanced thread
        management. Returning from this method will end the execution of the
        thread.

        **See also** **start** () and **wait** ().
        """
        ...

    def setEventDispatcher(
        self, eventDispatcher: PySide6.QtCore.QAbstractEventDispatcher
    ) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#setEventDispatcher

        **[since 5.0] void QThread::setEventDispatcher(QAbstractEventDispatcher
        * eventDispatcher )**

        Sets the event dispatcher for the thread to **eventDispatcher**. This is
        only possible as long as there is no event dispatcher installed for the
        thread yet. That is, before the thread has been started with **start**
        () or, in case of the main thread, before **QCoreApplication**  has been
        instantiated. This method takes ownership of the object.

        This function was introduced in Qt 5.0.

        **See also** **eventDispatcher** ().
        """
        ...

    def setPriority(self, priority: PySide6.QtCore.QThread.Priority) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#setPriority

        **void QThread::setPriority(QThread::Priority priority )**

        This function sets the **priority** for a running thread. If the thread
        is not running, this function does nothing and returns immediately. Use
        **start** () to start a thread with a specific priority.

        The **priority** argument can be any value in the `QThread::Priority`
        enum except for `InheritPriority`.

        The effect of the **priority** parameter is dependent on the operating
        system's scheduling policy. In particular, the **priority** will be
        ignored on systems that do not support thread priorities (such as on
        Linux, see http://linux.die.net/man/2/sched_setscheduler for more
        details).

        **See also** **Priority** , **priority** (), and **start** ().
        """
        ...

    def setStackSize(self, stackSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#setStackSize

        **void QThread::setStackSize(uint stackSize )**

        Sets the maximum stack size for the thread to **stackSize**. If
        **stackSize** is greater than zero, the maximum stack size is set to
        **stackSize** bytes, otherwise the maximum stack size is automatically
        determined by the operating system.

        **Warning:** Most operating systems place minimum and maximum limits on
        thread stack sizes. The thread will fail to start if the stack size is
        outside these limits.

        **See also** **stackSize** ().
        """
        ...

    @staticmethod
    def setTerminationEnabled(enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#setTerminationEnabled

        **[static protected] void QThread::setTerminationEnabled(bool enabled =
        true)**

        Enables or disables termination of the current thread based on the
        **enabled** parameter. The thread must have been started by **QThread**
        .

        When **enabled** is false, termination is disabled. Future calls to
        **QThread::terminate** () will return immediately without effect.
        Instead, the termination is deferred until termination is enabled.

        When **enabled** is true, termination is enabled. Future calls to
        **QThread::terminate** () will terminate the thread normally. If
        termination has been deferred (i.e. **QThread::terminate** () was called
        with termination disabled), this function will terminate the calling
        thread **immediately**. Note that this function will not return in this
        case.

        **See also** **terminate** ().
        """
        ...

    @staticmethod
    def sleep(arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#sleep

        **[static] void QThread::sleep(unsigned long secs )**

        Forces the current thread to sleep for **secs** seconds.

        Avoid using this function if you need to wait for a given condition to
        change. Instead, connect a slot to the signal that indicates the change
        or use an event handler (see **QObject::event** ()).

        **Note:** This function does not guarantee accuracy. The application may
        sleep longer than **secs** under heavy load conditions.

        **See also** **msleep** () and **usleep** ().
        """
        ...

    def stackSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qthread.html#stackSize

        **uint QThread::stackSize() const**

        Returns the maximum stack size for the thread (if set with
        **setStackSize** ()); otherwise returns zero.

        **See also** **setStackSize** ().
        """
        ...

    def start(self, priority: PySide6.QtCore.QThread.Priority = ...) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#start

        **[slot] void QThread::start(QThread::Priority priority =
        InheritPriority)**

        Begins execution of the thread by calling **run** (). The operating
        system will schedule the thread according to the **priority** parameter.
        If the thread is already running, this function does nothing.

        The effect of the **priority** parameter is dependent on the operating
        system's scheduling policy. In particular, the **priority** will be
        ignored on systems that do not support thread priorities (such as on
        Linux, see the **sched_setscheduler**  documentation for more details).

        **See also** **run** () and **terminate** ().
        """
        ...

    def terminate(self) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#terminate

        **[slot] void QThread::terminate()**

        Terminates the execution of the thread. The thread may or may not be
        terminated immediately, depending on the operating system's scheduling
        policies. Use **QThread::wait** () after terminate(), to be sure.

        When the thread is terminated, all threads waiting for the thread to
        finish will be woken up.

        **Warning:** This function is dangerous and its use is discouraged. The
        thread can be terminated at any point in its code path. Threads can be
        terminated while modifying data. There is no chance for the thread to
        clean up after itself, unlock any held mutexes, etc. In short, use this
        function only if absolutely necessary.

        Termination can be explicitly enabled or disabled by calling
        **QThread::setTerminationEnabled** (). Calling this function while
        termination is disabled results in the termination being deferred, until
        termination is re-enabled. See the documentation of
        **QThread::setTerminationEnabled** () for more information.

        **Note:** This function is **thread-safe** .

        **See also** **setTerminationEnabled** ().
        """
        ...

    @staticmethod
    def usleep(arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#usleep

        **[static] void QThread::usleep(unsigned long usecs )**

        Forces the current thread to sleep for **usecs** microseconds.

        Avoid using this function if you need to wait for a given condition to
        change. Instead, connect a slot to the signal that indicates the change
        or use an event handler (see **QObject::event** ()).

        **Note:** This function does not guarantee accuracy. The application may
        sleep longer than **usecs** under heavy load conditions. Some OSes might
        round **usecs** up to 10 ms or 15 ms; on Windows, it will be rounded up
        to a multiple of 1 ms.

        **See also** **sleep** () and **msleep** ().
        """
        ...

    @overload
    def wait(
        self,
        deadline: Union[
            PySide6.QtCore.QDeadlineTimer,
            PySide6.QtCore.QDeadlineTimer.ForeverConstant,
            PySide6.QtCore.Qt.TimerType,
            int,
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qthread.html#wait

        **[since 5.15] bool QThread::wait(QDeadlineTimer deadline =
        QDeadlineTimer(QDeadlineTimer::Forever))**

        Blocks the thread until either of these conditions is met:

        * The thread associated with this **QThread**  object has finished
        execution (i.e. when it returns from **run** ()). This function will
        return true if the thread has finished. It also returns true if the
        thread has not been started yet.
          * The **deadline** is reached. This
        function will return false if the deadline is reached.

        A deadline timer set to `QDeadlineTimer::Forever` (the default) will
        never time out: in this case, the function only returns when the thread
        returns from **run** () or if the thread has not yet started.

        This provides similar functionality to the POSIX `pthread_join()`
        function.

        This function was introduced in Qt 5.15.

        **See also** **sleep** () and **terminate** ().
        """
        ...

    @overload
    def wait(self, time: int) -> bool:
        """
        https://doc.qt.io/qt-6/qthread.html#wait-1

        **bool QThread::wait(unsigned long time )**

        This is an overloaded function.

        **time** is the time to wait in milliseconds. If **time** is ULONG_MAX,
        then the wait will never timeout.
        """
        ...

    @staticmethod
    def yieldCurrentThread() -> None:
        """
        https://doc.qt.io/qt-6/qthread.html#yieldCurrentThread

        **[static] void QThread::yieldCurrentThread()**

        Yields execution of the current thread to another runnable thread, if
        any. Note that the operating system decides to which thread to switch.
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qthread.html#finished

        **[private signal] void QThread::finished()**

        This signal is emitted from the associated thread right before it
        finishes executing.

        When this signal is emitted, the event loop has already stopped running.
        No more events will be processed in the thread, except for deferred
        deletion events. This signal can be connected to
        **QObject::deleteLater** (), to free objects in that thread.

        **Note:** If the associated thread was terminated using **terminate**
        (), it is undefined from which thread this signal is emitted.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **started** ().
        """
        ...

    @property
    def started(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qthread.html#started

        **[private signal] void QThread::started()**

        This signal is emitted from the associated thread when it starts
        executing, before the **run** () function is called.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **finished** ().
        """
        ...
