"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore

bytes = str


class QTextStream(PySide6.QtCore.QIODeviceBase):
    """
    https://doc.qt.io/qt-6/qtextstream.html

    **Detailed Description**

    QTextStream can operate on a **QIODevice** , a **QByteArray**  or a
    **QString** . Using QTextStream's streaming operators, you can conveniently
    read and write words, lines and numbers. For generating text, QTextStream
    supports formatting options for field padding and alignment, and formatting
    of numbers. Example:

    **QFile**  data("output.txt");
        if (data.open(**QFile** ::WriteOnly |
    **QFile** ::Truncate)) {
            **QTextStream**  out(&data);
            out <<
    "Result: " << **qSetFieldWidth** (10) << left << 3.14 << 2.7;
            //
    writes "Result: 3.14      2.7       "
        }

    It's also common to use QTextStream to read console input and write console
    output. QTextStream is locale aware, and will automatically decode standard
    input using the correct encoding. Example:

    **QTextStream**  stream(stdin);
        **QString**  line;
        while
    (stream.readLineInto(&line)) {
            ...
        }

    Besides using QTextStream's constructors, you can also set the device or
    string QTextStream operates on by calling **setDevice** () or **setString**
    (). You can seek to a position by calling **seek** (), and **atEnd** () will
    return true when there is no data left to be read. If you call **flush** (),
    QTextStream will empty all data from its write buffer into the device and
    call **flush** () on the device.

    Internally, QTextStream uses a Unicode based buffer, and
    **QStringConverter**  is used by QTextStream to automatically support
    different encodings. By default, UTF-8 is used for reading and writing, but
    you can also set the encoding by calling **setEncoding** (). Automatic
    Unicode detection is also supported. When this feature is enabled (the
    default behavior), QTextStream will detect the UTF-8, UTF-16 or the UTF-32
    BOM (Byte Order Mark) and switch to the appropriate UTF encoding when
    reading. QTextStream does not write a BOM by default, but you can enable
    this by calling **setGenerateByteOrderMark** (true). When QTextStream
    operates on a **QString**  directly, the encoding is disabled.

    There are three general ways to use QTextStream when reading text files:

    * Chunk by chunk, by calling **readLine** () or **readAll** ().
      * Word by
    word. QTextStream supports streaming into **QString** s, **QByteArray** s
    and char* buffers. Words are delimited by space, and leading white space is
    automatically skipped.
      * Character by character, by streaming into
    **QChar**  or char types. This method is often used for convenient input
    handling when parsing files, independent of character encoding and end-of-
    line semantics. To skip white space, call **skipWhiteSpace** ().

    Since the text stream uses a buffer, you should not read from the stream
    using the implementation of a superclass. For instance, if you have a
    **QFile**  and read from it directly using **QFile::readLine** () instead of
    using the stream, the text stream's internal position will be out of sync
    with the file's position.

    By default, when reading numbers from a stream of text, QTextStream will
    automatically detect the number's base representation. For example, if the
    number starts with "0x", it is assumed to be in hexadecimal form. If it
    starts with the digits 1-9, it is assumed to be in decimal form, and so on.
    You can set the integer base, thereby disabling the automatic detection, by
    calling **setIntegerBase** (). Example:

    **QTextStream**  in("0x50 0x20");
        int firstNumber, secondNumber;
    in >> firstNumber;             // firstNumber == 80
        in >> dec >>
    secondNumber;     // secondNumber == 0

        char ch;
        in >> ch;
    // ch == 'x'

    QTextStream supports many formatting options for generating text. You can
    set the field width and pad character by calling **setFieldWidth** () and
    **setPadChar** (). Use **setFieldAlignment** () to set the alignment within
    each field. For real numbers, call **setRealNumberNotation** () and
    **setRealNumberPrecision** () to set the notation (**SmartNotation** ,
    **ScientificNotation** , **FixedNotation** ) and precision in digits of the
    generated number. Some extra number formatting options are also available
    through **setNumberFlags** ().

    Like `<iostream>` in the standard C++ library, QTextStream also defines
    several global manipulator functions:

    ManipulatorDescription
    **Qt::bin** Same as **setIntegerBase** (2).
    **Qt::oct** Same as **setIntegerBase** (8).
    **Qt::dec** Same as
    **setIntegerBase** (10).
    **Qt::hex** Same as **setIntegerBase** (16).
    **Qt::showbase** Same as **setNumberFlags** (**numberFlags** () |
    **ShowBase** ).
    **Qt::forcesign** Same as **setNumberFlags**
    (**numberFlags** () | **ForceSign** ).
    **Qt::forcepoint** Same as
    **setNumberFlags** (**numberFlags** () | **ForcePoint** ).
    **Qt::noshowbase** Same as **setNumberFlags** (**numberFlags** () &
    ~**ShowBase** ).
    **Qt::noforcesign** Same as **setNumberFlags**
    (**numberFlags** () & ~**ForceSign** ).
    **Qt::noforcepoint** Same as
    **setNumberFlags** (**numberFlags** () & ~**ForcePoint** ).
    **Qt::uppercasebase** Same as **setNumberFlags** (**numberFlags** () |
    **UppercaseBase** ).
    **Qt::uppercasedigits** Same as **setNumberFlags**
    (**numberFlags** () | **UppercaseDigits** ).
    **Qt::lowercasebase** Same as
    **setNumberFlags** (**numberFlags** () & ~**UppercaseBase** ).
    **Qt::lowercasedigits** Same as **setNumberFlags** (**numberFlags** () &
    ~**UppercaseDigits** ).
    **Qt::fixed** Same as **setRealNumberNotation**
    (**FixedNotation** ).
    **Qt::scientific** Same as **setRealNumberNotation**
    (**ScientificNotation** ).
    **Qt::left** Same as **setFieldAlignment**
    (**AlignLeft** ).
    **Qt::right** Same as **setFieldAlignment**
    (**AlignRight** ).
    **Qt::center** Same as **setFieldAlignment**
    (**AlignCenter** ).
    **Qt::endl** Same as operator<<('\\n') and **flush**
    ().
    **Qt::flush** Same as **flush** ().
    **Qt::reset** Same as **reset**
    ().
    **Qt::ws** Same as **skipWhiteSpace** ().
    **Qt::bom** Same as
    **setGenerateByteOrderMark** (true).

    In addition, Qt provides three global manipulators that take a parameter:
    **qSetFieldWidth** (), **qSetPadChar** (), and **qSetRealNumberPrecision**
    ().

    **See also** **QDataStream** , **QIODevice** , **QFile** , **QBuffer** , and
    **QTcpSocket** .
    """

    AlignLeft: QTextStream.FieldAlignment = ...
    AlignRight: QTextStream.FieldAlignment = ...
    AlignCenter: QTextStream.FieldAlignment = ...
    AlignAccountingStyle: QTextStream.FieldAlignment = ...
    ShowBase: QTextStream.NumberFlag = ...
    ForcePoint: QTextStream.NumberFlag = ...
    ForceSign: QTextStream.NumberFlag = ...
    UppercaseBase: QTextStream.NumberFlag = ...
    UppercaseDigits: QTextStream.NumberFlag = ...
    SmartNotation: QTextStream.RealNumberNotation = ...
    FixedNotation: QTextStream.RealNumberNotation = ...
    ScientificNotation: QTextStream.RealNumberNotation = ...
    Ok: QTextStream.Status = ...
    ReadPastEnd: QTextStream.Status = ...
    ReadCorruptData: QTextStream.Status = ...
    WriteFailed: QTextStream.Status = ...

    class FieldAlignment(Enum):
        AlignLeft: QTextStream.FieldAlignment = ...
        AlignRight: QTextStream.FieldAlignment = ...
        AlignCenter: QTextStream.FieldAlignment = ...
        AlignAccountingStyle: QTextStream.FieldAlignment = ...

    class NumberFlag(Enum):
        ShowBase: QTextStream.NumberFlag = ...
        ForcePoint: QTextStream.NumberFlag = ...
        ForceSign: QTextStream.NumberFlag = ...
        UppercaseBase: QTextStream.NumberFlag = ...
        UppercaseDigits: QTextStream.NumberFlag = ...

    class NumberFlags(object):
        ...

    class RealNumberNotation(Enum):
        SmartNotation: QTextStream.RealNumberNotation = ...
        FixedNotation: QTextStream.RealNumberNotation = ...
        ScientificNotation: QTextStream.RealNumberNotation = ...

    class Status(Enum):
        Ok: QTextStream.Status = ...
        ReadPastEnd: QTextStream.Status = ...
        ReadCorruptData: QTextStream.Status = ...
        WriteFailed: QTextStream.Status = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#QTextStream

        **QTextStream::QTextStream()**

        Constructs a QTextStream. Before you can use it for reading or writing,
        you must assign a device or a string.

        **See also** **setDevice** () and **setString** ().
        """
        ...

    @overload
    def __init__(
        self,
        array: Union[PySide6.QtCore.QByteArray, bytes],
        openMode: PySide6.QtCore.QIODeviceBase.OpenMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#QTextStream-1

        **QTextStream::QTextStream(QIODevice * device )**

        Constructs a QTextStream that operates on **device**.
        """
        ...

    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#QTextStream-2

        **QTextStream::QTextStream(FILE * fileHandle , QIODeviceBase::OpenMode
        openMode = ReadWrite)**

        Constructs a QTextStream that operates on **fileHandle** , using
        **openMode** to define the open mode. Internally, a **QFile**  is
        created to handle the FILE pointer.

        This constructor is useful for working directly with the common FILE
        based input and output streams: stdin, stdout and stderr. Example:

        **QString**  str;
            **QTextStream**  in(stdin);
            in >> str;
        """
        ...

    @overload
    def __lshift__(
        self, array: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(self, ch: str) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(self, ch: int) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(self, f: float) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(self, i: int) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(self, i: int) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(
        self, m: PySide6.QtCore.QTextStreamManipulator
    ) -> PySide6.QtCore.QTextStream:
        ...

    @overload
    def __lshift__(self, s: str) -> PySide6.QtCore.QTextStream:
        ...

    def __rshift__(
        self, array: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QTextStream:
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextstream.html#atEnd

        **bool QTextStream::atEnd() const**

        Returns `true` if there is no more data to be read from the
        **QTextStream** ; otherwise returns `false`. This is similar to, but not
        the same as calling **QIODevice::atEnd** (), as **QTextStream**  also
        takes into account its internal Unicode buffer.
        """
        ...

    def autoDetectUnicode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextstream.html#autoDetectUnicode

        **bool QTextStream::autoDetectUnicode() const**

        Returns `true` if automatic Unicode detection is enabled, otherwise
        returns `false`. Automatic Unicode detection is enabled by default.

        **See also** **setAutoDetectUnicode** () and **setEncoding** ().
        """
        ...

    def device(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qtextstream.html#device

        **QIODevice *QTextStream::device() const**

        Returns the current device associated with the **QTextStream** , or
        `nullptr` if no device has been assigned.

        **See also** **setDevice** () and **string** ().
        """
        ...

    def encoding(self) -> PySide6.QtCore.QStringConverter.Encoding:
        """
        https://doc.qt.io/qt-6/qtextstream.html#encoding

        **QStringConverter::Encoding QTextStream::encoding() const**

        Returns the encoding that is current assigned to the stream.

        **See also** **setEncoding** (), **setAutoDetectUnicode** (), and
        **locale** ().
        """
        ...

    def fieldAlignment(self) -> PySide6.QtCore.QTextStream.FieldAlignment:
        """
        https://doc.qt.io/qt-6/qtextstream.html#fieldAlignment

        **QTextStream::FieldAlignment QTextStream::fieldAlignment() const**

        Returns the current field alignment.

        **See also** **setFieldAlignment** () and **fieldWidth** ().
        """
        ...

    def fieldWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextstream.html#fieldWidth

        **int QTextStream::fieldWidth() const**

        Returns the current field width.

        **See also** **setFieldWidth** ().
        """
        ...

    def flush(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#flush

        **void QTextStream::flush()**

        Flushes any buffered data waiting to be written to the device.

        If **QTextStream**  operates on a string, this function does nothing.
        """
        ...

    def generateByteOrderMark(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextstream.html#generateByteOrderMark

        **bool QTextStream::generateByteOrderMark() const**

        Returns `true` if **QTextStream**  is set to generate the UTF BOM (Byte
        Order Mark) when using a UTF encoding; otherwise returns `false`. UTF
        BOM generation is set to false by default.

        **See also** **setGenerateByteOrderMark** ().
        """
        ...

    def integerBase(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextstream.html#integerBase

        **int QTextStream::integerBase() const**

        Returns the current base of integers. 0 means that the base is detected
        when reading, or 10 (decimal) when generating numbers.

        **See also** **setIntegerBase** (), **QString::number** (), and
        **numberFlags** ().
        """
        ...

    def locale(self) -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qtextstream.html#locale

        **QLocale QTextStream::locale() const**

        Returns the locale for this stream. The default locale is C.

        **See also** **setLocale** ().
        """
        ...

    def numberFlags(self) -> PySide6.QtCore.QTextStream.NumberFlags:
        """
        https://doc.qt.io/qt-6/qtextstream.html#numberFlags

        **QTextStream::NumberFlags QTextStream::numberFlags() const**

        Returns the current number flags.

        **See also** **setNumberFlags** (), **integerBase** (), and
        **realNumberNotation** ().
        """
        ...

    def padChar(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextstream.html#padChar

        **QChar QTextStream::padChar() const**

        Returns the current pad character.

        **See also** **setPadChar** () and **setFieldWidth** ().
        """
        ...

    def pos(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextstream.html#pos

        **qint64 QTextStream::pos() const**

        Returns the device position corresponding to the current position of the
        stream, or -1 if an error occurs (e.g., if there is no device or string,
        or if there's a device error).

        Because **QTextStream**  is buffered, this function may have to seek the
        device to reconstruct a valid device position. This operation can be
        expensive, so you may want to avoid calling this function in a tight
        loop.

        **See also** **seek** ().
        """
        ...

    def read(self, maxlen: int) -> str:
        """
        https://doc.qt.io/qt-6/qtextstream.html#read

        **QString QTextStream::read(qint64 maxlen )**

        Reads at most **maxlen** characters from the stream, and returns the
        data read as a **QString** .

        **See also** **readAll** (), **readLine** (), and **QIODevice::read**
        ().
        """
        ...

    def readAll(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextstream.html#readAll

        **QString QTextStream::readAll()**

        Reads the entire content of the stream, and returns it as a **QString**
        . Avoid this function when working on large files, as it will consume a
        significant amount of memory.

        Calling **readLine** () is better if you do not know how much data is
        available.

        **See also** **readLine** ().
        """
        ...

    def readLine(self, maxlen: int = ...) -> str:
        """
        https://doc.qt.io/qt-6/qtextstream.html#readLine

        **QString QTextStream::readLine(qint64 maxlen = 0)**

        Reads one line of text from the stream, and returns it as a **QString**
        . The maximum allowed line length is set to **maxlen**. If the stream
        contains lines longer than this, then the lines will be split after
        **maxlen** characters and returned in parts.

        If **maxlen** is 0, the lines can be of any length.

        The returned line has no trailing end-of-line characters ("\\n" or
        "\\r\\n"), so calling **QString::trimmed** () can be unnecessary.

        If the stream has read to the end of the file, readLine() will return a
        null **QString** . For strings, or for devices that support it, you can
        explicitly test for the end of the stream using **atEnd** ().

        **See also** **readAll** () and **QIODevice::readLine** ().
        """
        ...

    def realNumberNotation(self) -> PySide6.QtCore.QTextStream.RealNumberNotation:
        """
        https://doc.qt.io/qt-6/qtextstream.html#realNumberNotation

        **QTextStream::RealNumberNotation QTextStream::realNumberNotation()
        const**

        Returns the current real number notation.

        **See also** **setRealNumberNotation** (), **realNumberPrecision** (),
        **numberFlags** (), and **integerBase** ().
        """
        ...

    def realNumberPrecision(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextstream.html#realNumberPrecision

        **int QTextStream::realNumberPrecision() const**

        Returns the current real number precision, or the number of fraction
        digits **QTextStream**  will write when generating real numbers.

        **See also** **setRealNumberPrecision** (), **setRealNumberNotation**
        (), **realNumberNotation** (), **numberFlags** (), and **integerBase**
        ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#reset

        **void QTextStream::reset()**

        Resets **QTextStream** 's formatting options, bringing it back to its
        original constructed state. The device, string and any buffered data is
        left untouched.
        """
        ...

    def resetStatus(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#resetStatus

        **void QTextStream::resetStatus()**

        Resets the status of the text stream.

        **See also** **QTextStream::Status** , **status** (), and **setStatus**
        ().
        """
        ...

    def seek(self, pos: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtextstream.html#seek

        **bool QTextStream::seek(qint64 pos )**

        Seeks to the position **pos** in the device. Returns `true` on success;
        otherwise returns `false`.
        """
        ...

    def setAutoDetectUnicode(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setAutoDetectUnicode

        **void QTextStream::setAutoDetectUnicode(bool enabled )**

        If **enabled** is true, **QTextStream**  will attempt to detect Unicode
        encoding by peeking into the stream data to see if it can find the
        UTF-8, UTF-16, or UTF-32 Byte Order Mark (BOM). If this mark is found,
        **QTextStream**  will replace the current encoding with the UTF
        encoding.

        This function can be used together with **setEncoding** (). It is common
        to set the encoding to UTF-8, and then enable UTF-16 detection.

        **See also** **autoDetectUnicode** () and **setEncoding** ().
        """
        ...

    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setDevice

        **void QTextStream::setDevice(QIODevice * device )**

        Sets the current device to **device**. If a device has already been
        assigned, **QTextStream**  will call **flush** () before the old device
        is replaced.

        **Note:** This function resets locale to the default locale ('C') and
        encoding to the default encoding, UTF-8.

        **See also** **device** () and **setString** ().
        """
        ...

    def setEncoding(self, encoding: PySide6.QtCore.QStringConverter.Encoding) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setEncoding

        **void QTextStream::setEncoding(QStringConverter::Encoding encoding )**

        Sets the encoding for this stream to **encoding**. The encoding is used
        for decoding any data that is read from the assigned device, and for
        encoding any data that is written. By default,
        **QStringConverter::Utf8**  is used, and automatic unicode detection is
        enabled.

        If **QTextStream**  operates on a string, this function does nothing.

        **Warning:** If you call this function while the text stream is reading
        from an open sequential socket, the internal buffer may still contain
        text decoded using the old encoding.

        **See also** **encoding** (), **setAutoDetectUnicode** (), and
        **setLocale** ().
        """
        ...

    def setFieldAlignment(
        self, alignment: PySide6.QtCore.QTextStream.FieldAlignment
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setFieldAlignment

        **void QTextStream::setFieldAlignment(QTextStream::FieldAlignment mode
        )**

        Sets the field alignment to **mode**. When used together with
        **setFieldWidth** (), this function allows you to generate formatted
        output with text aligned to the left, to the right or center aligned.

        **See also** **fieldAlignment** () and **setFieldWidth** ().
        """
        ...

    def setFieldWidth(self, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setFieldWidth

        **void QTextStream::setFieldWidth(int width )**

        Sets the current field width to **width**. If **width** is 0 (the
        default), the field width is equal to the length of the generated text.

        **Note:** The field width applies to every element appended to this
        stream after this function has been called (e.g., it also pads endl).
        This behavior is different from similar classes in the STL, where the
        field width only applies to the next element.

        **See also** **fieldWidth** () and **setPadChar** ().
        """
        ...

    def setGenerateByteOrderMark(self, generate: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setGenerateByteOrderMark

        **void QTextStream::setGenerateByteOrderMark(bool generate )**

        If **generate** is true and a UTF encoding is used, **QTextStream**
        will insert the BOM (Byte Order Mark) before any data has been written
        to the device. If **generate** is false, no BOM will be inserted. This
        function must be called before any data is written. Otherwise, it does
        nothing.

        **See also** **generateByteOrderMark** () and **bom** ().
        """
        ...

    def setIntegerBase(self, base: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setIntegerBase

        **void QTextStream::setIntegerBase(int base )**

        Sets the base of integers to **base** , both for reading and for
        generating numbers. **base** can be either 2 (binary), 8 (octal), 10
        (decimal) or 16 (hexadecimal). If **base** is 0, **QTextStream**  will
        attempt to detect the base by inspecting the data on the stream. When
        generating numbers, **QTextStream**  assumes base is 10 unless the base
        has been set explicitly.

        **See also** **integerBase** (), **QString::number** (), and
        **setNumberFlags** ().
        """
        ...

    def setLocale(
        self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setLocale

        **void QTextStream::setLocale(const QLocale & locale )**

        Sets the locale for this stream to **locale**. The specified locale is
        used for conversions between numbers and their string representations.

        The default locale is C and it is a special case - the thousands group
        separator is not used for backward compatibility reasons.

        **See also** **locale** ().
        """
        ...

    def setNumberFlags(self, flags: PySide6.QtCore.QTextStream.NumberFlags) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setNumberFlags

        **void QTextStream::setNumberFlags(QTextStream::NumberFlags flags )**

        Sets the current number flags to **flags**. **flags** is a set of flags
        from the **NumberFlag**  enum, and describes options for formatting
        generated code (e.g., whether or not to always write the base or sign of
        a number).

        **See also** **numberFlags** (), **setIntegerBase** (), and
        **setRealNumberNotation** ().
        """
        ...

    def setPadChar(self, ch: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setPadChar

        **void QTextStream::setPadChar(QChar ch )**

        Sets the pad character to **ch**. The default value is the ASCII space
        character (' '), or **QChar** (0x20). This character is used to fill in
        the space in fields when generating text.

        Example:

        **QString**  s;
            **QTextStream**  out(&s);
            out.setFieldWidth(10);
        out.setFieldAlignment(**QTextStream** ::AlignCenter);
        out.setPadChar('-');
            out << "Qt" << "rocks!";

        The string `s` contains:

        ----Qt------rocks!--

        **See also** **padChar** () and **setFieldWidth** ().
        """
        ...

    def setRealNumberNotation(
        self, notation: PySide6.QtCore.QTextStream.RealNumberNotation
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setRealNumberNotation

        **void
        QTextStream::setRealNumberNotation(QTextStream::RealNumberNotation
        notation )**

        Sets the real number notation to **notation** (**SmartNotation** ,
        **FixedNotation** , **ScientificNotation** ). When reading and
        generating numbers, **QTextStream**  uses this value to detect the
        formatting of real numbers.

        **See also** **realNumberNotation** (), **setRealNumberPrecision** (),
        **setNumberFlags** (), and **setIntegerBase** ().
        """
        ...

    def setRealNumberPrecision(self, precision: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setRealNumberPrecision

        **void QTextStream::setRealNumberPrecision(int precision )**

        Sets the precision of real numbers to **precision**. This value
        describes the number of fraction digits **QTextStream**  should write
        when generating real numbers.

        The precision cannot be a negative value. The default value is 6.

        **See also** **realNumberPrecision** () and **setRealNumberNotation**
        ().
        """
        ...

    def setStatus(self, status: PySide6.QtCore.QTextStream.Status) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#setStatus

        **void QTextStream::setStatus(QTextStream::Status status )**

        Sets the status of the text stream to the **status** given.

        Subsequent calls to setStatus() are ignored until **resetStatus** () is
        called.

        **See also** **Status** , **status** (), and **resetStatus** ().
        """
        ...

    def skipWhiteSpace(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextstream.html#skipWhiteSpace

        **void QTextStream::skipWhiteSpace()**

        Reads and discards whitespace from the stream until either a non-space
        character is detected, or until **atEnd** () returns true. This function
        is useful when reading a stream character by character.

        Whitespace characters are all characters for which **QChar::isSpace** ()
        returns `true`.

        **See also** **operator>>** ().
        """
        ...

    def status(self) -> PySide6.QtCore.QTextStream.Status:
        """
        https://doc.qt.io/qt-6/qtextstream.html#status

        **QTextStream::Status QTextStream::status() const**

        Returns the status of the text stream.

        **See also** **QTextStream::Status** , **setStatus** (), and
        **resetStatus** ().
        """
        ...

    def string(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qtextstream.html#string

        **QString *QTextStream::string() const**

        Returns the current string assigned to the **QTextStream** , or
        `nullptr` if no string has been assigned.

        **See also** **setString** () and **device** ().
        """
        ...
