"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore

bytes = str


class QStringConverter(PySide6.QtCore.QStringConverterBase):
    """
    https://doc.qt.io/qt-6/qstringconverter.html

    **Detailed Description**

    Qt uses UTF-16 to store, draw and manipulate strings. In many situations you
    may wish to deal with data that uses a different encoding. Most text data
    transferred over files and network connections is encoded in UTF-8.

    The QStringConverter class is a base class for the **QStringEncoder**  and
    **QStringDecoder**  classes that help with converting between different text
    encodings. **QStringDecoder**  can decode a string from an encoded
    representation into UTF-16, the format Qt uses internally.
    **QStringEncoder**  does the opposite operation, encoding UTF-16 encoded
    data (usually in the form of a **QString** ) to the requested encoding.

    The supported encodings are:

    * UTF-8
      * UTF-16
      * UTF-16BE
      * UTF-16LE
      * UTF-32
      * UTF-32BE
      *
    UTF-32LE
      * ISO-8859-1 (Latin-1)
      * The system encoding

    **QStringConverter** s can be used as follows to convert some encoded string
    to and from UTF-16.

    Suppose you have some string encoded in UTF-8, and want to convert it to a
    **QString** . The simple way to do it is to use a **QStringDecoder**  like
    this:

    **QByteArray**  encodedString = "...";
        auto toUtf16 = **QStringDecoder**
    (**QStringDecoder** ::Utf8);
        **QString**  string =
    toUtf16(encodedString);

    After this, `string` holds the text in decoded form. Converting a string
    from Unicode to the local encoding is just as easy using the
    **QStringEncoder**  class:

    **QString**  string = "...";
        auto fromUtf16 = **QStringEncoder**
    (**QStringEncoder** ::Utf8);
        **QByteArray**  encodedString =
    fromUtf16(string);

    To read or write text files in various encodings, use **QTextStream**  and
    its **setEncoding** () function.

    Some care must be taken when trying to convert the data in chunks, for
    example, when receiving it over a network. In such cases it is possible that
    a multi-byte character will be split over two chunks. At best this might
    result in the loss of a character and at worst cause the entire conversion
    to fail.

    Both **QStringEncoder**  and **QStringDecoder**  make this easy, by tracking
    this in an internal state. So simply calling the encoder or decoder again
    with the next chunk of data will automatically continue encoding or decoding
    the data correctly:

    auto toUtf16 = **QStringDecoder** (**QStringDecoder** ::Utf8);
    **QString**  string;
        while (new_data_available()) {
    **QByteArray**  chunk = get_new_data();
            string += toUtf16(chunk);
    }

    The **QStringDecoder**  object maintains state between chunks and therefore
    works correctly even if a multi-byte character is split between chunks.

    QStringConverter objects can't be copied because of their internal state,
    but can be moved.

    **See also** **QTextStream** , **QStringDecoder** , and **QStringEncoder** .
    """

    Utf8: QStringConverter.Encoding = ...
    Utf16: QStringConverter.Encoding = ...
    Utf16LE: QStringConverter.Encoding = ...
    Utf16BE: QStringConverter.Encoding = ...
    Utf32: QStringConverter.Encoding = ...
    Utf32LE: QStringConverter.Encoding = ...
    Utf32BE: QStringConverter.Encoding = ...
    Latin1: QStringConverter.Encoding = ...
    LastEncoding: QStringConverter.Encoding = ...
    System: QStringConverter.Encoding = ...

    class Encoding(Enum):
        Utf8: QStringConverter.Encoding = ...
        Utf16: QStringConverter.Encoding = ...
        Utf16LE: QStringConverter.Encoding = ...
        Utf16BE: QStringConverter.Encoding = ...
        Utf32: QStringConverter.Encoding = ...
        Utf32LE: QStringConverter.Encoding = ...
        Utf32BE: QStringConverter.Encoding = ...
        Latin1: QStringConverter.Encoding = ...
        LastEncoding: QStringConverter.Encoding = ...
        System: QStringConverter.Encoding = ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(
        self,
        encoding: PySide6.QtCore.QStringConverter.Encoding,
        f: PySide6.QtCore.QStringConverterBase.Flags,
    ) -> None:
        ...

    @overload
    def __init__(
        self, name: bytes, f: PySide6.QtCore.QStringConverterBase.Flags
    ) -> None:
        ...

    def hasError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qstringconverter.html#hasError

        **bool QStringConverter::hasError() const**

        Returns true if a conversion could not correctly convert a character.
        This could for example get triggered by an invalid UTF-8 sequence or
        when a character can't get converted due to limitations in the target
        encoding.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qstringconverter.html#isValid

        **bool QStringConverter::isValid() const**

        Returns true if this is a valid string converter that can be used for
        encoding or decoding text.

        Default constructed string converters or converters constructed with an
        unsupported name are not valid.
        """
        ...

    def name(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qstringconverter.html#name

        **const char *QStringConverter::name() const**

        Returns the canonical name of the encoding this **QStringConverter**
        can encode or decode. Returns a nullptr if the converter is not valid.

        **See also** **isValid** ().
        """
        ...

    @staticmethod
    def nameForEncoding(e: PySide6.QtCore.QStringConverter.Encoding) -> bytes:
        """
        https://doc.qt.io/qt-6/qstringconverter.html#nameForEncoding

        **[static] const char
        *QStringConverter::nameForEncoding(QStringConverter::Encoding e )**

        Returns the canonical name for encoding **e**.
        """
        ...

    def resetState(self) -> None:
        """
        https://doc.qt.io/qt-6/qstringconverter.html#resetState

        **void QStringConverter::resetState()**

        Resets the internal state of the converter, clearing potential errors or
        partial conversions.
        """
        ...
