"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore

bytes = str


class QSocketNotifier(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsocketnotifier.html

    **Detailed Description**

    The QSocketNotifier makes it possible to integrate Qt's event loop with
    other event loops based on file descriptors. File descriptor action is
    detected in Qt's main event loop (**QCoreApplication::exec** ()).

    Once you have opened a device using a low-level (usually platform-specific)
    API, you can create a socket notifier to monitor the file descriptor. If the
    descriptor is passed to the notifier's constructor, the socket notifier is
    enabled by default, i.e. it emits the **activated** () signal whenever a
    socket event corresponding to its type occurs. Connect the **activated** ()
    signal to the slot you want to be called when an event corresponding to your
    socket notifier's type occurs.

    You can create a socket notifier with no descriptor assigned. In this case,
    you should call the **setSocket** () function after the descriptor has been
    obtained.

    There are three types of socket notifiers: read, write, and exception. The
    type is described by the **Type**  enum, and must be specified when
    constructing the socket notifier. After construction it can be determined
    using the **type** () function. Note that if you need to monitor both reads
    and writes for the same file descriptor, you must create two socket
    notifiers. Note also that it is not possible to install two socket notifiers
    of the same type (**Read** , **Write** , **Exception** ) on the same socket.

    The **setEnabled** () function allows you to disable as well as enable the
    socket notifier. It is generally advisable to explicitly enable or disable
    the socket notifier, especially for write notifiers. A disabled notifier
    ignores socket events (the same effect as not creating the socket notifier).
    Use the **isEnabled** () function to determine the notifier's current
    status.

    Finally, you can use the **socket** () function to retrieve the socket
    identifier. Although the class is called QSocketNotifier, it is normally
    used for other types of devices than sockets. **QTcpSocket**  and
    **QUdpSocket**  provide notification through signals, so there is normally
    no need to use a QSocketNotifier on them.

    **See also** **QFile** , **QProcess** , **QTcpSocket** , and **QUdpSocket**
    .
    """

    Read: QSocketNotifier.Type = ...
    Write: QSocketNotifier.Type = ...
    Exception: QSocketNotifier.Type = ...

    class Type(Enum):
        Read: QSocketNotifier.Type = ...
        Write: QSocketNotifier.Type = ...
        Exception: QSocketNotifier.Type = ...

    @overload
    def __init__(
        self,
        arg__1: object,
        arg__2: PySide6.QtCore.QSocketNotifier.Type,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#QSocketNotifier

        **[since 6.1] QSocketNotifier::QSocketNotifier(QSocketNotifier::Type
        type , QObject * parent = nullptr)**

        Constructs a socket notifier with the given **type** that has no
        descriptor assigned. The **parent** argument is passed to **QObject** 's
        constructor.

        Call the **setSocket** () function to set the descriptor for monitoring.

        This function was introduced in Qt 6.1.

        **See also** **setSocket** (), **isValid** (), and **isEnabled** ().
        """
        ...

    @overload
    def __init__(
        self,
        arg__1: PySide6.QtCore.QSocketNotifier.Type,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#QSocketNotifier-1

        **QSocketNotifier::QSocketNotifier(qintptr socket ,
        QSocketNotifier::Type type , QObject * parent = nullptr)**

        Constructs a socket notifier with the given **parent**. It enables the
        **socket** , and watches for events of the given **type**.

        It is generally advisable to explicitly enable or disable the socket
        notifier, especially for write notifiers.

        **Note for Windows users:** The socket passed to QSocketNotifier will
        become non-blocking, even if it was created as a blocking socket.

        **See also** **setEnabled** () and **isEnabled** ().
        """
        ...

    @overload
    def __init__(
        self,
        socket: int,
        arg__2: PySide6.QtCore.QSocketNotifier.Type,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#QSocketNotifier

        **[since 6.1] QSocketNotifier::QSocketNotifier(QSocketNotifier::Type
        type , QObject * parent = nullptr)**

        Constructs a socket notifier with the given **type** that has no
        descriptor assigned. The **parent** argument is passed to **QObject** 's
        constructor.

        Call the **setSocket** () function to set the descriptor for monitoring.

        This function was introduced in Qt 6.1.

        **See also** **setSocket** (), **isValid** (), and **isEnabled** ().
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#event

        **[override virtual protected] bool QSocketNotifier::event(QEvent * e
        )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def isEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#isEnabled

        **bool QSocketNotifier::isEnabled() const**

        Returns `true` if the notifier is enabled; otherwise returns `false`.

        **See also** **setEnabled** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#isValid

        **[since 6.1] bool QSocketNotifier::isValid() const**

        Returns `true` if the notifier is valid (that is, it has a descriptor
        assigned); otherwise returns `false`.

        This function was introduced in Qt 6.1.

        **See also** **setSocket** ().
        """
        ...

    def setEnabled(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#setEnabled

        **[slot] void QSocketNotifier::setEnabled(bool enable )**

        If **enable** is true, the notifier is enabled; otherwise the notifier
        is disabled.

        When the notifier is enabled, it emits the **activated** () signal
        whenever a socket event corresponding to its **type**  occurs. When it
        is disabled, it ignores socket events (the same effect as not creating
        the socket notifier).

        Write notifiers should normally be disabled immediately after the
        **activated** () signal has been emitted

        **See also** **isEnabled** () and **activated** ().
        """
        ...

    def setSocket(self, socket: int) -> None:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#setSocket

        **[since 6.1] void QSocketNotifier::setSocket(qintptr socket )**

        Assigns the **socket** to this notifier.

        **Note:** The notifier will be disabled as a side effect and needs to be
        re-enabled.

        This function was introduced in Qt 6.1.

        **See also** **socket** (), **setEnabled** (), and **isValid** ().
        """
        ...

    def socket(self) -> int:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#socket

        **qintptr QSocketNotifier::socket() const**

        Returns the socket identifier assigned to this object.

        **See also** **setSocket** (), **isValid** (), and **type** ().
        """
        ...

    def type(self) -> PySide6.QtCore.QSocketNotifier.Type:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#type

        **QSocketNotifier::Type QSocketNotifier::type() const**

        Returns the socket event type specified to the constructor.

        **See also** **socket** ().
        """
        ...

    @property
    def activated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsocketnotifier.html#activated

        **[private signal, since 5.15] void
        QSocketNotifier::activated(QSocketDescriptor socket ,
        QSocketNotifier::Type type )**

        This signal is emitted whenever the socket notifier is enabled and a
        socket event corresponding to its **type** occurs.

        The socket identifier is passed in the **socket** parameter.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Signal **activated** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(socketNotifier, QOverload<QSocketDescriptor, **QSocketNotifier**
        ::Type>::of(&**QSocketNotifier** ::activated),
        [=](QSocketDescriptor socket, **QSocketNotifier** ::Type type){ /* ...
        */ });

        This function was introduced in Qt 5.15.

        **See also** **type** () and **socket** ().
        """
        ...
