"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore

bytes = str


class QSignalMapper(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsignalmapper.html

    **Detailed Description**

    This class collects a set of parameterless signals, and re-emits them with
    integer, string or widget parameters corresponding to the object that sent
    the signal. Note that in most cases you can use lambdas for passing custom
    parameters to slots. This is less costly and will simplify the code.

    The class supports the mapping of particular strings, integers, objects and
    widgets with particular objects using **setMapping** (). The objects'
    signals can then be connected to the **map** () slot which will emit a
    signal (it could be **mappedInt** (), **mappedString** () and
    **mappedObject** ()) with a value associated with the original signalling
    object. Mappings can be removed later using **removeMappings** ().

    Example: Suppose we want to create a custom widget that contains a group of
    buttons (like a tool palette). One approach is to connect each button's
    `clicked()` signal to its own custom slot; but in this example we want to
    connect all the buttons to a single slot and parameterize the slot by the
    button that was clicked.

    Here's the definition of a simple custom widget that has a single signal,
    `clicked()`, which is emitted with the text of the button that was clicked:

    class ButtonWidget : public **QWidget**
        {
            Q_OBJECT
    public:
            ButtonWidget(const **QStringList**  &texts, **QWidget**
    *parent = nullptr);

        signals:
            void clicked(const **QString**
    &text);

        private:
            **QSignalMapper**  *signalMapper;
        };

    The only function that we need to implement is the constructor:

    ButtonWidget::ButtonWidget(const **QStringList**  &texts, **QWidget**
    *parent)
            : **QWidget** (parent)
        {
            signalMapper = new
    **QSignalMapper** (this);

            **QGridLayout**  *gridLayout = new
    **QGridLayout** ;
            for (int i = 0; i < texts.size(); ++i) {
    **QPushButton**  *button = new **QPushButton** (texts[i]);
    connect(button, &**QPushButton** ::clicked, signalMapper, &**QSignalMapper**
    ::map);
                signalMapper->setMapping(button, texts[i]);
    gridLayout->addWidget(button, i / 3, i % 3);
            }
    connect(signalMapper, &**QSignalMapper** ::mappedString,
    this, &ButtonWidget::clicked);

            setLayout(gridLayout);
        }

    A list of texts is passed to the constructor. A signal mapper is constructed
    and for each text in the list a **QPushButton**  is created. We connect each
    button's `clicked()` signal to the signal mapper's **map** () slot, and
    create a mapping in the signal mapper from each button to the button's text.
    Finally we connect the signal mapper's **mappedString** () signal to the
    custom widget's `clicked()` signal. When the user clicks a button, the
    custom widget will emit a single `clicked()` signal whose argument is the
    text of the button the user clicked.

    This class was mostly useful before lambda functions could be used as slots.
    The example above can be rewritten simpler without QSignalMapper by
    connecting to a lambda function.

    ButtonWidget::ButtonWidget(const **QStringList**  &texts, **QWidget**
    *parent)
            : **QWidget** (parent)
        {
            **QGridLayout**
    *gridLayout = new **QGridLayout** ;
            for (int i = 0; i <
    texts.size(); ++i) {
                **QString**  text = texts[i];
    **QPushButton**  *button = new **QPushButton** (text);
    connect(button, &**QPushButton** ::clicked, [this, text] { clicked(text);
    });
                gridLayout->addWidget(button, i / 3, i % 3);
            }
    setLayout(gridLayout);
        }

    **See also** **QObject** , **QButtonGroup** , and **QActionGroup** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#QSignalMapper

        **QSignalMapper::QSignalMapper(QObject * parent = nullptr)**

        Constructs a QSignalMapper with parent **parent**.
        """
        ...

    @overload
    def map(self) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#map

        **[slot] void QSignalMapper::map()**

        This slot emits signals based on which object sends signals to it.
        """
        ...

    @overload
    def map(self, sender: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#map-1

        **[slot] void QSignalMapper::map(QObject * sender )**

        This slot emits signals based on the **sender** object.
        """
        ...

    @overload
    def mapping(self, id: int) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#mapping

        **QObject *QSignalMapper::mapping(int id ) const**

        Returns the sender **QObject**  that is associated with the **id**.

        **See also** **setMapping** ().
        """
        ...

    @overload
    def mapping(self, object: PySide6.QtCore.QObject) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#mapping-1

        **QObject *QSignalMapper::mapping(const QString & id ) const**

        This function overloads mapping().
        """
        ...

    @overload
    def mapping(self, text: str) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#mapping-2

        **QObject *QSignalMapper::mapping(QObject * object ) const**

        This function overloads mapping().

        Returns the sender **QObject**  that is associated with the **object**.
        """
        ...

    def removeMappings(self, sender: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#removeMappings

        **void QSignalMapper::removeMappings(QObject * sender )**

        Removes all mappings for **sender**.

        This is done automatically when mapped objects are destroyed.

        **Note:** This does not disconnect any signals. If **sender** is not
        destroyed then this will need to be done explicitly if required.
        """
        ...

    @overload
    def setMapping(self, sender: PySide6.QtCore.QObject, id: int) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#setMapping

        **void QSignalMapper::setMapping(QObject * sender , int id )**

        Adds a mapping so that when **map** () is signalled from the given
        **sender** , the signal **mappedInt** ( **id** ) is emitted.

        There may be at most one integer ID for each sender.

        **See also** **mapping** ().
        """
        ...

    @overload
    def setMapping(
        self, sender: PySide6.QtCore.QObject, object: PySide6.QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#setMapping-1

        **void QSignalMapper::setMapping(QObject * sender , const QString & text
        )**

        Adds a mapping so that when **map** () is signalled from the **sender**
        , the signal **mappedString** ( **text** ) is emitted.

        There may be at most one text for each sender.
        """
        ...

    @overload
    def setMapping(self, sender: PySide6.QtCore.QObject, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#setMapping-2

        **void QSignalMapper::setMapping(QObject * sender , QObject * object )**

        Adds a mapping so that when **map** () is signalled from the **sender**
        , the signal **mappedObject** ( **object** ) is emitted.

        There may be at most one object for each sender.
        """
        ...

    @property
    def mappedInt(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#mappedInt

        **[signal, since 5.15] void QSignalMapper::mappedInt(int i )**

        This signal is emitted when **map** () is signalled from an object that
        has an integer mapping set. The object's mapped integer is passed in
        **i**.

        This function was introduced in Qt 5.15.

        **See also** **setMapping** ().
        """
        ...

    @property
    def mappedObject(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#mappedObject

        **[signal, since 5.15] void QSignalMapper::mappedObject(QObject * object
        )**

        This signal is emitted when **map** () is signalled from an object that
        has an object mapping set. The object provided by the map is passed in
        **object**.

        This function was introduced in Qt 5.15.

        **See also** **setMapping** ().
        """
        ...

    @property
    def mappedString(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsignalmapper.html#mappedString

        **[signal, since 5.15] void QSignalMapper::mappedString(const QString &
        text )**

        This signal is emitted when **map** () is signalled from an object that
        has a string mapping set. The object's mapped string is passed in
        **text**.

        This function was introduced in Qt 5.15.

        **See also** **setMapping** ().
        """
        ...
