"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
import PySide6.QtCore

bytes = str


class QSignalBlocker(object):
    """
    https://doc.qt.io/qt-6/qsignalblocker.html

    **Detailed Description**

    QSignalBlocker can be used wherever you would otherwise use a pair of calls
    to blockSignals(). It blocks signals in its constructor and in the
    destructor it resets the state to what it was before the constructor ran.

    {
        const **QSignalBlocker**  blocker(someQObject);
        // no signals here
    }

    is thus equivalent to

    const bool wasBlocked = someQObject->blockSignals(true);
        // no signals
    here
        someQObject->blockSignals(wasBlocked);

    except the code using QSignalBlocker is safe in the face of exceptions.

    **See also** **QMutexLocker**  and **QEventLoopLocker** .
    """

    def __init__(self, o: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qsignalblocker.html#QSignalBlocker

        **QSignalBlocker::QSignalBlocker(QObject * object )**

        Constructor. Calls **object** ->blockSignals(true).
        """
        ...

    def __enter__(self) -> None:
        ...

    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None:
        ...

    def reblock(self) -> None:
        """
        https://doc.qt.io/qt-6/qsignalblocker.html#reblock

        **void QSignalBlocker::reblock()**

        Re-blocks signals after a previous **unblock** ().

        The numbers of reblock() and **unblock** () calls are not counted, so
        every reblock() undoes any number of **unblock** () calls.
        """
        ...

    def unblock(self) -> None:
        """
        https://doc.qt.io/qt-6/qsignalblocker.html#unblock

        **void QSignalBlocker::unblock()**

        Temporarily restores the **QObject::signalsBlocked** () state to what it
        was before this **QSignalBlocker** 's constructor ran. To undo, use
        **reblock** ().

        The numbers of **reblock** () and unblock() calls are not counted, so
        every unblock() undoes any number of **reblock** () calls.
        """
        ...
