"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QSemaphoreReleaser(object):
    """
    https://doc.qt.io/qt-6/qsemaphorereleaser.html

    **Detailed Description**

    QSemaphoreReleaser can be used wherever you would otherwise use
    **QSemaphore::release** (). Constructing a QSemaphoreReleaser defers the
    release() call on the semaphore until the QSemaphoreReleaser is destroyed
    (see **RAII pattern** ).

    You can use this to reliably release a semaphore to avoid dead-lock in the
    face of exceptions or early returns:

    // ... do something that may throw or return early
        sem.release();

    If an early return is taken or an exception is thrown before the
    `sem.release()` call is reached, the semaphore is not released, possibly
    preventing the thread waiting in the corresponding `sem.acquire()` call from
    ever continuing execution.

    When using RAII instead:

    const **QSemaphoreReleaser**  releaser(sem);
        // ... do something that
    may throw or early return
        // implicitly calls sem.release() here and at
    every other return in between

    this can no longer happen, because the compiler will make sure that the
    QSemaphoreReleaser destructor is always called, and therefore the semaphore
    is always released.

    QSemaphoreReleaser is move-enabled and can therefore be returned from
    functions to transfer responsibility for releasing a semaphore out of a
    function or a scope:

    { // some scope
            **QSemaphoreReleaser**  releaser; // does nothing
    // ...
            if (someCondition) {
                releaser =
    **QSemaphoreReleaser** (sem);
                // ...
            }
            // ...
    } // conditionally calls sem.release(), depending on someCondition

    A QSemaphoreReleaser can be canceled by a call to **cancel** (). A canceled
    semaphore releaser will no longer call **QSemaphore::release** () in its
    destructor.

    **See also** **QMutexLocker** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsemaphorereleaser.html#QSemaphoreReleaser

        **QSemaphoreReleaser::QSemaphoreReleaser()**

        Default constructor. Creates a QSemaphoreReleaser that does nothing.
        """
        ...

    @overload
    def __init__(self, sem: PySide6.QtCore.QSemaphore, n: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsemaphorereleaser.html#QSemaphoreReleaser-1

        **QSemaphoreReleaser::QSemaphoreReleaser(QSemaphore & sem , int n = 1)**

        Constructor. Stores the arguments and calls **sem**.release( **n** ) in
        the destructor.
        """
        ...

    def cancel(self) -> PySide6.QtCore.QSemaphore:
        """
        https://doc.qt.io/qt-6/qsemaphorereleaser.html#cancel

        **QSemaphore *QSemaphoreReleaser::cancel()**

        Cancels this **QSemaphoreReleaser**  such that the destructor will no
        longer call `semaphore()->release()`. Returns the value of **semaphore**
        () before this call. After this call, **semaphore** () will return
        `nullptr`.

        To enable again, assign a new **QSemaphoreReleaser** :

        releaser.cancel(); // avoid releasing old semaphore()
            releaser =
        **QSemaphoreReleaser** (sem, 42);
            // now will call sem.release(42)
        when 'releaser' is destroyed
        """
        ...

    def semaphore(self) -> PySide6.QtCore.QSemaphore:
        """
        https://doc.qt.io/qt-6/qsemaphorereleaser.html#semaphore

        **QSemaphore *QSemaphoreReleaser::semaphore() const**

        Returns a pointer to the **QSemaphore**  object provided to the
        constructor, or by the last move assignment, if any. Otherwise, returns
        `nullptr`.
        """
        ...

    def swap(self, other: PySide6.QtCore.QSemaphoreReleaser) -> None:
        """
        https://doc.qt.io/qt-6/qsemaphorereleaser.html#swap

        **void QSemaphoreReleaser::swap(QSemaphoreReleaser & other )**

        Exchanges the responsibilities of `*this` and **other**.

        Unlike move assignment, neither of the two objects ever releases its
        semaphore, if any, as a consequence of swapping.

        Therefore this function is very fast and never fails.
        """
        ...
