"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore

bytes = str


class QRegularExpressionMatch(object):
    """
    https://doc.qt.io/qt-6/qregularexpressionmatch.html

    **Detailed Description**

    A QRegularExpressionMatch object can be obtained by calling the
    **QRegularExpression::match** () function, or as a single result of a global
    match from a **QRegularExpressionMatchIterator** .

    The success or the failure of a match attempt can be inspected by calling
    the **hasMatch** () function. QRegularExpressionMatch also reports a
    successful partial match through the **hasPartialMatch** () function.

    In addition, QRegularExpressionMatch returns the substrings captured by the
    capturing groups in the pattern string. The implicit capturing group with
    index 0 captures the result of the whole match. The **captured** () function
    returns each substring captured, either by the capturing group's index or by
    its name:

    **QRegularExpression**  re("(\\\\d\\\\d) (?<name>\\\\w+)");
    **QRegularExpressionMatch**  match = re.match("23 Jordan");
        if
    (match.hasMatch()) {
            **QString**  number = match.captured(1); //
    first == "23"
            **QString**  name = match.captured("name"); // name ==
    "Jordan"
        }

    For each captured substring it is possible to query its starting and ending
    offsets in the subject string by calling the **capturedStart** () and the
    **capturedEnd** () function, respectively. The length of each captured
    substring is available using the **capturedLength** () function.

    The convenience function **capturedTexts** () will return **all** the
    captured substrings at once (including the substring matched by the entire
    pattern) in the order they have been captured by capturing groups; that is,
    `captured(i) == capturedTexts().at(i)`.

    You can retrieve the **QRegularExpression**  object the subject string was
    matched against by calling the **regularExpression** () function; the match
    type and the match options are available as well by calling the
    **matchType** () and the **matchOptions** () respectively.

    Please refer to the **QRegularExpression**  documentation for more
    information about the Qt regular expression classes.

    **See also** **QRegularExpression** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#QRegularExpressionMa
        tch

        **[since 5.1] QRegularExpressionMatch::QRegularExpressionMatch()**

        Constructs a valid, empty QRegularExpressionMatch object. The regular
        expression is set to a default-constructed one; the match type to
        **QRegularExpression::NoMatch**  and the match options to
        **QRegularExpression::NoMatchOption** .

        The object will report no match through the **hasMatch** () and the
        **hasPartialMatch** () member functions.

        This function was introduced in Qt 5.1.
        """
        ...

    @overload
    def __init__(self, match: PySide6.QtCore.QRegularExpressionMatch) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#QRegularExpressionMa
        tch-1

        **QRegularExpressionMatch::QRegularExpressionMatch(const
        QRegularExpressionMatch & match )**

        Constructs a match result by copying the result of the given **match**.

        **See also** **operator=** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    def captured(self, name: str) -> str:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#captured

        **QString QRegularExpressionMatch::captured(int nth = 0) const**

        Returns the substring captured by the **nth** capturing group.

        If the **nth** capturing group did not capture a string, or if there is
        no such capturing group, returns a null **QString** .

        **Note:** The implicit capturing group number 0 captures the substring
        matched by the entire pattern.

        **See also** **capturedView** (), **lastCapturedIndex** (),
        **capturedStart** (), **capturedEnd** (), **capturedLength** (), and
        **QString::isNull** ().
        """
        ...

    @overload
    def captured(self, nth: int = ...) -> str:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#captured-1

        **QString QRegularExpressionMatch::captured(const QString & name )
        const**

        Returns the substring captured by the capturing group named **name**.

        If the named capturing group **name** did not capture a string, or if
        there is no capturing group named **name** , returns a null **QString**
        .

        **See also** **capturedView** (), **capturedStart** (), **capturedEnd**
        (), **capturedLength** (), and **QString::isNull** ().
        """
        ...

    @overload
    def capturedEnd(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedEnd

        **qsizetype QRegularExpressionMatch::capturedEnd(int nth = 0) const**

        Returns the offset inside the subject string immediately after the
        ending position of the substring captured by the **nth** capturing
        group. If the **nth** capturing group did not capture a string or
        doesn't exist, returns -1.

        **See also** **capturedStart** (), **capturedLength** (), and
        **captured** ().
        """
        ...

    @overload
    def capturedEnd(self, nth: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedEnd-1

        **qsizetype QRegularExpressionMatch::capturedEnd(const QString & name )
        const**

        Returns the offset inside the subject string immediately after the
        ending position of the substring captured by the capturing group named
        **name**. If the capturing group named **name** did not capture a string
        or doesn't exist, returns -1.

        **See also** **capturedStart** (), **capturedLength** (), and
        **captured** ().
        """
        ...

    @overload
    def capturedLength(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedLength

        **qsizetype QRegularExpressionMatch::capturedLength(int nth = 0) const**

        Returns the length of the substring captured by the **nth** capturing
        group.

        **Note:** This function returns 0 if the **nth** capturing group did not
        capture a string or doesn't exist.

        **See also** **capturedStart** (), **capturedEnd** (), and **captured**
        ().
        """
        ...

    @overload
    def capturedLength(self, nth: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedLength-1

        **qsizetype QRegularExpressionMatch::capturedLength(const QString & name
        ) const**

        Returns the length of the substring captured by the capturing group
        named **name**.

        **Note:** This function returns 0 if the capturing group named **name**
        did not capture a string or doesn't exist.

        **See also** **capturedStart** (), **capturedEnd** (), and **captured**
        ().
        """
        ...

    @overload
    def capturedStart(self, name: str) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedStart

        **qsizetype QRegularExpressionMatch::capturedStart(int nth = 0) const**

        Returns the offset inside the subject string corresponding to the
        starting position of the substring captured by the **nth** capturing
        group. If the **nth** capturing group did not capture a string or
        doesn't exist, returns -1.

        **See also** **capturedEnd** (), **capturedLength** (), and **captured**
        ().
        """
        ...

    @overload
    def capturedStart(self, nth: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedStart-1

        **qsizetype QRegularExpressionMatch::capturedStart(const QString & name
        ) const**

        Returns the offset inside the subject string corresponding to the
        starting position of the substring captured by the capturing group named
        **name**. If the capturing group named **name** did not capture a string
        or doesn't exist, returns -1.

        **See also** **capturedEnd** (), **capturedLength** (), and **captured**
        ().
        """
        ...

    def capturedTexts(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedTexts

        **QStringList QRegularExpressionMatch::capturedTexts() const**

        Returns a list of all strings captured by capturing groups, in the order
        the groups themselves appear in the pattern string. The list includes
        the implicit capturing group number 0, capturing the substring matched
        by the entire pattern.
        """
        ...

    @overload
    def capturedView(self, name: str) -> str:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedView

        **[since 5.10] QStringView QRegularExpressionMatch::capturedView(int nth
        = 0) const**

        Returns a view of the substring captured by the **nth** capturing group.

        If the **nth** capturing group did not capture a string, or if there is
        no such capturing group, returns a null **QStringView** .

        **Note:** The implicit capturing group number 0 captures the substring
        matched by the entire pattern.

        This function was introduced in Qt 5.10.

        **See also** **captured** (), **lastCapturedIndex** (),
        **capturedStart** (), **capturedEnd** (), **capturedLength** (), and
        **QStringView::isNull** ().
        """
        ...

    @overload
    def capturedView(self, nth: int = ...) -> str:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#capturedView-1

        **[since 5.10] QStringView
        QRegularExpressionMatch::capturedView(QStringView name ) const**

        Returns a view of the string captured by the capturing group named
        **name**.

        If the named capturing group **name** did not capture a string, or if
        there is no capturing group named **name** , returns a null
        **QStringView** .

        This function was introduced in Qt 5.10.

        **See also** **captured** (), **capturedStart** (), **capturedEnd** (),
        **capturedLength** (), and **QStringView::isNull** ().
        """
        ...

    def hasMatch(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#hasMatch

        **bool QRegularExpressionMatch::hasMatch() const**

        Returns `true` if the regular expression matched against the subject
        string, or false otherwise.

        **See also** **QRegularExpression::match** () and **hasPartialMatch**
        ().
        """
        ...

    def hasPartialMatch(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#hasPartialMatch

        **bool QRegularExpressionMatch::hasPartialMatch() const**

        Returns `true` if the regular expression partially matched against the
        subject string, or false otherwise.

        **Note:** Only a match that explicitly used the one of the partial match
        types can yield a partial match. Still, if such a match succeeds
        totally, this function will return false, while **hasMatch** () will
        return true.

        **See also** **QRegularExpression::match** (),
        **QRegularExpression::MatchType** , and **hasMatch** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#isValid

        **bool QRegularExpressionMatch::isValid() const**

        Returns `true` if the match object was obtained as a result from the
        **QRegularExpression::match** () function invoked on a valid
        **QRegularExpression**  object; returns `false` if the
        **QRegularExpression**  was invalid.

        **See also** **QRegularExpression::match** () and
        **QRegularExpression::isValid** ().
        """
        ...

    def lastCapturedIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#lastCapturedIndex

        **int QRegularExpressionMatch::lastCapturedIndex() const**

        Returns the index of the last capturing group that captured something,
        including the implicit capturing group 0. This can be used to extract
        all the substrings that were captured:

        **QRegularExpressionMatch**  match = re.match(string);
            for (int i =
        0; i <= match.lastCapturedIndex(); ++i) {
                **QString**  captured
        = match.captured(i);
                // ...
            }

        Note that some of the capturing groups with an index less than
        lastCapturedIndex() could have not matched, and therefore captured
        nothing.

        If the regular expression did not match, this function returns -1.

        **See also** **captured** (), **capturedStart** (), **capturedEnd** (),
        and **capturedLength** ().
        """
        ...

    def matchOptions(self) -> PySide6.QtCore.QRegularExpression.MatchOptions:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#matchOptions

        **QRegularExpression::MatchOptions
        QRegularExpressionMatch::matchOptions() const**

        Returns the match options that were used to get this
        **QRegularExpressionMatch**  object, that is, the match options that
        were passed to **QRegularExpression::match** () or
        **QRegularExpression::globalMatch** ().

        **See also** **QRegularExpression::match** (), **regularExpression** (),
        and **matchType** ().
        """
        ...

    def matchType(self) -> PySide6.QtCore.QRegularExpression.MatchType:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#matchType

        **QRegularExpression::MatchType QRegularExpressionMatch::matchType()
        const**

        Returns the match type that was used to get this
        **QRegularExpressionMatch**  object, that is, the match type that was
        passed to **QRegularExpression::match** () or
        **QRegularExpression::globalMatch** ().

        **See also** **QRegularExpression::match** (), **regularExpression** (),
        and **matchOptions** ().
        """
        ...

    def regularExpression(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#regularExpression

        **QRegularExpression QRegularExpressionMatch::regularExpression()
        const**

        Returns the **QRegularExpression**  object whose match() function
        returned this object.

        **See also** **QRegularExpression::match** (), **matchType** (), and
        **matchOptions** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QRegularExpressionMatch) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatch.html#swap

        **void QRegularExpressionMatch::swap(QRegularExpressionMatch & other )**

        Swaps the match result **other** with this match result. This operation
        is very fast and never fails.
        """
        ...
