"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Sequence, Tuple, overload
import PySide6.QtCore

bytes = str


class QProcess(PySide6.QtCore.QIODevice):
    """
    https://doc.qt.io/qt-6/qprocess.html

    **Detailed Description**

    **Running a Process**

    To start a process, pass the name and command line arguments of the program
    you want to run as arguments to **start** (). Arguments are supplied as
    individual strings in a **QStringList** .

    Alternatively, you can set the program to run with **setProgram** () and
    **setArguments** (), and then call **start** () or **open** ().

    For example, the following code snippet runs the analog clock example in the
    Fusion style on X11 platforms by passing strings containing "-style" and
    "fusion" as two items in the list of arguments:

    **QObject**  *parent;
            ...
            **QString**  program =
    "./path/to/Qt/examples/widgets/analogclock";
            **QStringList**
    arguments;
            arguments << "-style" << "fusion";
    **QProcess**  *myProcess = new **QProcess** (parent);
    myProcess->start(program, arguments);

    QProcess then enters the **Starting**  state, and when the program has
    started, QProcess enters the **Running**  state and emits **started** ().

    QProcess allows you to treat a process as a sequential I/O device. You can
    write to and read from the process just as you would access a network
    connection using **QTcpSocket** . You can then write to the process's
    standard input by calling **write** (), and read the standard output by
    calling **read** (), **readLine** (), and **getChar** (). Because it
    inherits **QIODevice** , QProcess can also be used as an input source for
    **QXmlReader** , or for generating data to be uploaded using
    **QNetworkAccessManager** .

    When the process exits, QProcess reenters the **NotRunning**  state (the
    initial state), and emits **finished** ().

    The **finished** () signal provides the exit code and exit status of the
    process as arguments, and you can also call **exitCode** () to obtain the
    exit code of the last process that finished, and **exitStatus** () to obtain
    its exit status. If an error occurs at any point in time, QProcess will emit
    the **errorOccurred** () signal. You can also call **error** () to find the
    type of error that occurred last, and **state** () to find the current
    process state.

    **Note:** QProcess is not supported on VxWorks, iOS, tvOS, or watchOS.

    **Communicating via Channels**

    Processes have two predefined output channels: The standard output channel
    (`stdout`) supplies regular console output, and the standard error channel
    (`stderr`) usually supplies the errors that are printed by the process.
    These channels represent two separate streams of data. You can toggle
    between them by calling **setReadChannel** (). QProcess emits **readyRead**
    () when data is available on the current read channel. It also emits
    **readyReadStandardOutput** () when new standard output data is available,
    and when new standard error data is available, **readyReadStandardError** ()
    is emitted. Instead of calling **read** (), **readLine** (), or **getChar**
    (), you can explicitly read all data from either of the two channels by
    calling **readAllStandardOutput** () or **readAllStandardError** ().

    The terminology for the channels can be misleading. Be aware that the
    process's output channels correspond to QProcess's **read** channels,
    whereas the process's input channels correspond to QProcess's **write**
    channels. This is because what we read using QProcess is the process's
    output, and what we write becomes the process's input.

    QProcess can merge the two output channels, so that standard output and
    standard error data from the running process both use the standard output
    channel. Call **setProcessChannelMode** () with **MergedChannels**  before
    starting the process to activate this feature. You also have the option of
    forwarding the output of the running process to the calling, main process,
    by passing **ForwardedChannels**  as the argument. It is also possible to
    forward only one of the output channels - typically one would use
    **ForwardedErrorChannel** , but **ForwardedOutputChannel**  also exists.
    Note that using channel forwarding is typically a bad idea in GUI
    applications - you should present errors graphically instead.

    Certain processes need special environment settings in order to operate. You
    can set environment variables for your process by calling
    **setProcessEnvironment** (). To set a working directory, call
    **setWorkingDirectory** (). By default, processes are run in the current
    working directory of the calling process.

    The positioning and the screen Z-order of windows belonging to GUI
    applications started with QProcess are controlled by the underlying
    windowing system. For Qt 5 applications, the positioning can be specified
    using the `-qwindowgeometry` command line option; X11 applications generally
    accept a `-geometry` command line option.

    **Note:** On QNX, setting the working directory may cause all application
    threads, with the exception of the QProcess caller thread, to temporarily
    freeze during the spawning process, owing to a limitation in the operating
    system.

    **Synchronous Process API**

    QProcess provides a set of functions which allow it to be used without an
    event loop, by suspending the calling thread until certain signals are
    emitted:

    * **waitForStarted** () blocks until the process has started.
      *
    **waitForReadyRead** () blocks until new data is available for reading on
    the current read channel.
      * **waitForBytesWritten** () blocks until one
    payload of data has been written to the process.
      * **waitForFinished** ()
    blocks until the process has finished.

    Calling these functions from the main thread (the thread that calls
    **QApplication::exec** ()) may cause your user interface to freeze.

    The following example runs `gzip` to compress the string "Qt rocks!",
    without an event loop:

    **QProcess**  gzip;
            gzip.start("gzip", **QStringList** () << "-c");
    if (!gzip.waitForStarted())
                return false;
    gzip.write("Qt rocks!");
            gzip.closeWriteChannel();

            if
    (!gzip.waitForFinished())
                return false;
    **QByteArray**  result = gzip.readAll();

    **Notes for Windows Users**

    Some Windows commands (for example, `dir`) are not provided by separate
    applications, but by the command interpreter itself. If you attempt to use
    QProcess to execute these commands directly, it won't work. One possible
    solution is to execute the command interpreter itself (`cmd.exe` on some
    Windows systems), and ask the interpreter to execute the desired command.

    **See also** **QBuffer** , **QFile** , and **QTcpSocket** .
    """

    NormalExit: QProcess.ExitStatus = ...
    CrashExit: QProcess.ExitStatus = ...
    ManagedInputChannel: QProcess.InputChannelMode = ...
    ForwardedInputChannel: QProcess.InputChannelMode = ...
    StandardOutput: QProcess.ProcessChannel = ...
    StandardError: QProcess.ProcessChannel = ...
    SeparateChannels: QProcess.ProcessChannelMode = ...
    MergedChannels: QProcess.ProcessChannelMode = ...
    ForwardedChannels: QProcess.ProcessChannelMode = ...
    ForwardedOutputChannel: QProcess.ProcessChannelMode = ...
    ForwardedErrorChannel: QProcess.ProcessChannelMode = ...
    FailedToStart: QProcess.ProcessError = ...
    Crashed: QProcess.ProcessError = ...
    Timedout: QProcess.ProcessError = ...
    ReadError: QProcess.ProcessError = ...
    WriteError: QProcess.ProcessError = ...
    UnknownError: QProcess.ProcessError = ...
    NotRunning: QProcess.ProcessState = ...
    Starting: QProcess.ProcessState = ...
    Running: QProcess.ProcessState = ...

    class ExitStatus(Enum):
        NormalExit: QProcess.ExitStatus = ...
        CrashExit: QProcess.ExitStatus = ...

    class InputChannelMode(Enum):
        ManagedInputChannel: QProcess.InputChannelMode = ...
        ForwardedInputChannel: QProcess.InputChannelMode = ...

    class ProcessChannel(Enum):
        StandardOutput: QProcess.ProcessChannel = ...
        StandardError: QProcess.ProcessChannel = ...

    class ProcessChannelMode(Enum):
        SeparateChannels: QProcess.ProcessChannelMode = ...
        MergedChannels: QProcess.ProcessChannelMode = ...
        ForwardedChannels: QProcess.ProcessChannelMode = ...
        ForwardedOutputChannel: QProcess.ProcessChannelMode = ...
        ForwardedErrorChannel: QProcess.ProcessChannelMode = ...

    class ProcessError(Enum):
        FailedToStart: QProcess.ProcessError = ...
        Crashed: QProcess.ProcessError = ...
        Timedout: QProcess.ProcessError = ...
        ReadError: QProcess.ProcessError = ...
        WriteError: QProcess.ProcessError = ...
        UnknownError: QProcess.ProcessError = ...

    class ProcessState(Enum):
        NotRunning: QProcess.ProcessState = ...
        Starting: QProcess.ProcessState = ...
        Running: QProcess.ProcessState = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#QProcess

        **QProcess::QProcess(QObject * parent = nullptr)**

        Constructs a QProcess object with the given **parent**.
        """
        ...

    def arguments(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qprocess.html#arguments

        **[since 5.0] QStringList QProcess::arguments() const**

        Returns the command line arguments the process was last started with.

        This function was introduced in Qt 5.0.

        **See also** **setArguments** () and **start** ().
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-6/qprocess.html#bytesToWrite

        **[override virtual] qint64 QProcess::bytesToWrite() const**

        Reimplements: **QIODevice::bytesToWrite() const** .
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#close

        **[override virtual] void QProcess::close()**

        Reimplements: **QIODevice::close** ().

        Closes all communication with the process and kills it. After calling
        this function, **QProcess**  will no longer emit **readyRead** (), and
        data can no longer be read or written.
        """
        ...

    def closeReadChannel(self, channel: PySide6.QtCore.QProcess.ProcessChannel) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#closeReadChannel

        **void QProcess::closeReadChannel(QProcess::ProcessChannel channel )**

        Closes the read channel **channel**. After calling this function,
        **QProcess**  will no longer receive data on the channel. Any data that
        has already been received is still available for reading.

        Call this function to save memory, if you are not interested in the
        output of the process.

        **See also** **closeWriteChannel** () and **setReadChannel** ().
        """
        ...

    def closeWriteChannel(self) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#closeWriteChannel

        **void QProcess::closeWriteChannel()**

        Schedules the write channel of **QProcess**  to be closed. The channel
        will close once all data has been written to the process. After calling
        this function, any attempts to write to the process will fail.

        Closing the write channel is necessary for programs that read input data
        until the channel has been closed. For example, the program "more" is
        used to display text data in a console on both Unix and Windows. But it
        will not display the text data until **QProcess** 's write channel has
        been closed. Example:

        **QProcess**  more;
            more.start("more");
            more.write("Text to
        display");
            more.closeWriteChannel();
            // QProcess will emit
        readyRead() once "more" starts printing

        The write channel is implicitly opened when **start** () is called.

        **See also** **closeReadChannel** ().
        """
        ...

    def environment(self) -> List[str]:
        ...

    def error(self) -> PySide6.QtCore.QProcess.ProcessError:
        """
        https://doc.qt.io/qt-6/qprocess.html#error

        **QProcess::ProcessError QProcess::error() const**

        Returns the type of error that occurred last.

        **See also** **state** ().
        """
        ...

    @staticmethod
    def execute(program: str, arguments: Sequence[str] = ...) -> int:
        """
        https://doc.qt.io/qt-6/qprocess.html#execute

        **[static] int QProcess::execute(const QString & program , const
        QStringList & arguments = {})**

        Starts the program **program** with the arguments **arguments** in a new
        process, waits for it to finish, and then returns the exit code of the
        process. Any data the new process writes to the console is forwarded to
        the calling process.

        The environment and working directory are inherited from the calling
        process.

        Argument handling is identical to the respective **start** () overload.

        If the process cannot be started, -2 is returned. If the process
        crashes, -1 is returned. Otherwise, the process' exit code is returned.

        **See also** **start** ().
        """
        ...

    def exitCode(self) -> int:
        """
        https://doc.qt.io/qt-6/qprocess.html#exitCode

        **int QProcess::exitCode() const**

        Returns the exit code of the last process that finished.

        This value is not valid unless **exitStatus** () returns **NormalExit**
        .
        """
        ...

    def exitStatus(self) -> PySide6.QtCore.QProcess.ExitStatus:
        """
        https://doc.qt.io/qt-6/qprocess.html#exitStatus

        **QProcess::ExitStatus QProcess::exitStatus() const**

        Returns the exit status of the last process that finished.

        On Windows, if the process was terminated with TerminateProcess() from
        another application, this function will still return **NormalExit**
        unless the exit code is less than 0.
        """
        ...

    def inputChannelMode(self) -> PySide6.QtCore.QProcess.InputChannelMode:
        """
        https://doc.qt.io/qt-6/qprocess.html#inputChannelMode

        **[since 5.2] QProcess::InputChannelMode QProcess::inputChannelMode()
        const**

        Returns the channel mode of the **QProcess**  standard input channel.

        This function was introduced in Qt 5.2.

        **See also** **setInputChannelMode** () and **InputChannelMode** .
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprocess.html#isSequential

        **[override virtual] bool QProcess::isSequential() const**

        Reimplements: **QIODevice::isSequential() const** .
        """
        ...

    def kill(self) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#kill

        **[slot] void QProcess::kill()**

        Kills the current process, causing it to exit immediately.

        On Windows, kill() uses TerminateProcess, and on Unix and macOS, the
        SIGKILL signal is sent to the process.

        **See also** **terminate** ().
        """
        ...

    def nativeArguments(self) -> str:
        """
        https://doc.qt.io/qt-6/qprocess.html#nativeArguments

        **QString QProcess::nativeArguments() const**

        Returns the additional native command line arguments for the program.

        **Note:** This function is available only on the Windows platform.

        **See also** **setNativeArguments** ().
        """
        ...

    @staticmethod
    def nullDevice() -> str:
        """
        https://doc.qt.io/qt-6/qprocess.html#nullDevice

        **[static, since 5.2] QString QProcess::nullDevice()**

        The null device of the operating system.

        The returned file path uses native directory separators.

        This function was introduced in Qt 5.2.

        **See also** **QProcess::setStandardInputFile** (),
        **QProcess::setStandardOutputFile** (), and
        **QProcess::setStandardErrorFile** ().
        """
        ...

    def open(self, mode: PySide6.QtCore.QIODeviceBase.OpenMode = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qprocess.html#open

        **[override virtual] bool QProcess::open(QIODeviceBase::OpenMode mode =
        ReadWrite)**

        Reimplements: **QIODevice::open** (QIODeviceBase::OpenMode mode).

        Starts the program set by **setProgram** () with arguments set by
        **setArguments** (). The OpenMode is set to **mode**.

        This method is an alias for **start** (), and exists only to fully
        implement the interface defined by **QIODevice** .

        Returns `true` if the program has been started.

        **See also** **start** (), **setProgram** (), and **setArguments** ().
        """
        ...

    def processChannelMode(self) -> PySide6.QtCore.QProcess.ProcessChannelMode:
        """
        https://doc.qt.io/qt-6/qprocess.html#processChannelMode

        **QProcess::ProcessChannelMode QProcess::processChannelMode() const**

        Returns the channel mode of the **QProcess**  standard output and
        standard error channels.

        **See also** **setProcessChannelMode** (), **ProcessChannelMode** , and
        **setReadChannel** ().
        """
        ...

    def processEnvironment(self) -> PySide6.QtCore.QProcessEnvironment:
        """
        https://doc.qt.io/qt-6/qprocess.html#processEnvironment

        **QProcessEnvironment QProcess::processEnvironment() const**

        Returns the environment that **QProcess**  will pass to its child
        process, or an empty object if no environment has been set using
        setEnvironment() or **setProcessEnvironment** (). If no environment has
        been set, the environment of the calling process will be used.

        **See also** **setProcessEnvironment** (), **setEnvironment** (), and
        **QProcessEnvironment::isEmpty** ().
        """
        ...

    def processId(self) -> int:
        """
        https://doc.qt.io/qt-6/qprocess.html#processId

        **[since 5.3] qint64 QProcess::processId() const**

        Returns the native process identifier for the running process, if
        available. If no process is currently running, `0` is returned.

        This function was introduced in Qt 5.3.
        """
        ...

    def program(self) -> str:
        """
        https://doc.qt.io/qt-6/qprocess.html#program

        **[since 5.0] QString QProcess::program() const**

        Returns the program the process was last started with.

        This function was introduced in Qt 5.0.

        **See also** **setProgram** () and **start** ().
        """
        ...

    def readAllStandardError(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qprocess.html#readAllStandardError

        **QByteArray QProcess::readAllStandardError()**

        Regardless of the current read channel, this function returns all data
        available from the standard error of the process as a **QByteArray** .

        **See also** **readyReadStandardError** (), **readAllStandardOutput**
        (), **readChannel** (), and **setReadChannel** ().
        """
        ...

    def readAllStandardOutput(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qprocess.html#readAllStandardOutput

        **QByteArray QProcess::readAllStandardOutput()**

        Regardless of the current read channel, this function returns all data
        available from the standard output of the process as a **QByteArray** .

        **See also** **readyReadStandardOutput** (), **readAllStandardError**
        (), **readChannel** (), and **setReadChannel** ().
        """
        ...

    def readChannel(self) -> PySide6.QtCore.QProcess.ProcessChannel:
        """
        https://doc.qt.io/qt-6/qprocess.html#readChannel

        **QProcess::ProcessChannel QProcess::readChannel() const**

        Returns the current read channel of the **QProcess** .

        **See also** **setReadChannel** ().
        """
        ...

    def readData(self, data: bytes, maxlen: int) -> object:
        """
        https://doc.qt.io/qt-6/qprocess.html#readData

        **[override virtual protected] qint64 QProcess::readData(char * data ,
        qint64 maxlen )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def setArguments(self, arguments: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setArguments

        **[since 5.1] void QProcess::setArguments(const QStringList & arguments
        )**

        Set the **arguments** to pass to the called program when starting the
        process. This function must be called before **start** ().

        This function was introduced in Qt 5.1.

        **See also** **start** (), **setProgram** (), and **arguments** ().
        """
        ...

    def setEnvironment(self, environment: Sequence[str]) -> None:
        ...

    def setInputChannelMode(
        self, mode: PySide6.QtCore.QProcess.InputChannelMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setInputChannelMode

        **[since 5.2] void
        QProcess::setInputChannelMode(QProcess::InputChannelMode mode )**

        Sets the channel mode of the **QProcess**  standard input channel to the
        **mode** specified. This mode will be used the next time **start** () is
        called.

        This function was introduced in Qt 5.2.

        **See also** **inputChannelMode** () and **InputChannelMode** .
        """
        ...

    def setNativeArguments(self, arguments: str) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setNativeArguments

        **void QProcess::setNativeArguments(const QString & arguments )**

        This is an overloaded function.

        Sets additional native command line **arguments** for the program.

        On operating systems where the system API for passing command line
        **arguments** to a subprocess natively uses a single string, one can
        conceive command lines which cannot be passed via **QProcess** 's
        portable list-based API. In such cases this function must be used to set
        a string which is **appended** to the string composed from the usual
        argument list, with a delimiting space.

        **Note:** This function is available only on the Windows platform.

        **See also** **nativeArguments** ().
        """
        ...

    def setProcessChannelMode(
        self, mode: PySide6.QtCore.QProcess.ProcessChannelMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setProcessChannelMode

        **void QProcess::setProcessChannelMode(QProcess::ProcessChannelMode mode
        )**

        Sets the channel mode of the **QProcess**  standard output and standard
        error channels to the **mode** specified. This mode will be used the
        next time **start** () is called. For example:

        **QProcess**  builder;
            builder.setProcessChannelMode(**QProcess**
        ::MergedChannels);
            builder.start("make", **QStringList** () <<
        "-j2");

            if (!builder.waitForFinished())
                **qDebug** ()
        << "Make failed:" << builder.errorString();
            else
                **qDebug**
        () << "Make output:" << builder.readAll();

        **See also** **processChannelMode** (), **ProcessChannelMode** , and
        **setReadChannel** ().
        """
        ...

    def setProcessEnvironment(
        self, environment: PySide6.QtCore.QProcessEnvironment
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setProcessEnvironment

        **void QProcess::setProcessEnvironment(const QProcessEnvironment &
        environment )**

        Sets the **environment** that **QProcess**  will pass to the child
        process.

        For example, the following code adds the environment variable `TMPDIR`:

        **QProcess**  process;
            **QProcessEnvironment**  env =
        **QProcessEnvironment** ::systemEnvironment();
            env.insert("TMPDIR",
        "C:\\\\MyApp\\\\temp"); // Add an environment variable
        process.setProcessEnvironment(env);
            process.start("myapp");

        Note how, on Windows, environment variable names are case-insensitive.

        **See also** **processEnvironment** (),
        **QProcessEnvironment::systemEnvironment** (), and **setEnvironment**
        ().
        """
        ...

    def setProcessState(self, state: PySide6.QtCore.QProcess.ProcessState) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setProcessState

        **[protected] void QProcess::setProcessState(QProcess::ProcessState
        state )**

        Sets the current state of the **QProcess**  to the **state** specified.

        **See also** **state** ().
        """
        ...

    def setProgram(self, program: str) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setProgram

        **[since 5.1] void QProcess::setProgram(const QString & program )**

        Set the **program** to use when starting the process. This function must
        be called before **start** ().

        This function was introduced in Qt 5.1.

        **See also** **start** (), **setArguments** (), and **program** ().
        """
        ...

    def setReadChannel(self, channel: PySide6.QtCore.QProcess.ProcessChannel) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setReadChannel

        **void QProcess::setReadChannel(QProcess::ProcessChannel channel )**

        Sets the current read channel of the **QProcess**  to the given
        **channel**. The current input channel is used by the functions **read**
        (), **readAll** (), **readLine** (), and **getChar** (). It also
        determines which channel triggers **QProcess**  to emit **readyRead**
        ().

        **See also** **readChannel** ().
        """
        ...

    def setStandardErrorFile(
        self, fileName: str, mode: PySide6.QtCore.QIODeviceBase.OpenMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setStandardErrorFile

        **void QProcess::setStandardErrorFile(const QString & fileName ,
        QIODeviceBase::OpenMode mode = Truncate)**

        Redirects the process' standard error to the file **fileName**. When the
        redirection is in place, the standard error read channel is closed:
        reading from it using **read** () will always fail, as will
        **readAllStandardError** (). The file will be appended to if **mode** is
        Append, otherwise, it will be truncated.

        See **setStandardOutputFile** () for more information on how the file is
        opened.

        Note: if **setProcessChannelMode** () was called with an argument of
        **QProcess::MergedChannels** , this function has no effect.

        **See also** **setStandardInputFile** (), **setStandardOutputFile** (),
        and **setStandardOutputProcess** ().
        """
        ...

    def setStandardInputFile(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setStandardInputFile

        **void QProcess::setStandardInputFile(const QString & fileName )**

        Redirects the process' standard input to the file indicated by
        **fileName**. When an input redirection is in place, the **QProcess**
        object will be in read-only mode (calling **write** () will result in
        error).

        To make the process read EOF right away, pass **nullDevice** () here.
        This is cleaner than using **closeWriteChannel** () before writing any
        data, because it can be set up prior to starting the process.

        If the file **fileName** does not exist at the moment **start** () is
        called or is not readable, starting the process will fail.

        Calling setStandardInputFile() after the process has started has no
        effect.

        **See also** **setStandardOutputFile** (), **setStandardErrorFile** (),
        and **setStandardOutputProcess** ().
        """
        ...

    def setStandardOutputFile(
        self, fileName: str, mode: PySide6.QtCore.QIODeviceBase.OpenMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setStandardOutputFile

        **void QProcess::setStandardOutputFile(const QString & fileName ,
        QIODeviceBase::OpenMode mode = Truncate)**

        Redirects the process' standard output to the file **fileName**. When
        the redirection is in place, the standard output read channel is closed:
        reading from it using **read** () will always fail, as will
        **readAllStandardOutput** ().

        To discard all standard output from the process, pass **nullDevice** ()
        here. This is more efficient than simply never reading the standard
        output, as no **QProcess**  buffers are filled.

        If the file **fileName** doesn't exist at the moment **start** () is
        called, it will be created. If it cannot be created, the starting will
        fail.

        If the file exists and **mode** is QIODevice::Truncate, the file will be
        truncated. Otherwise (if **mode** is QIODevice::Append), the file will
        be appended to.

        Calling setStandardOutputFile() after the process has started has no
        effect.

        **See also** **setStandardInputFile** (), **setStandardErrorFile** (),
        and **setStandardOutputProcess** ().
        """
        ...

    def setStandardOutputProcess(self, destination: PySide6.QtCore.QProcess) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setStandardOutputProcess

        **void QProcess::setStandardOutputProcess(QProcess * destination )**

        Pipes the standard output stream of this process to the **destination**
        process' standard input.

        The following shell command:

        command1 | command2

        Can be accomplished with **QProcess**  with the following code:

        **QProcess**  process1;
            **QProcess**  process2;
        process1.setStandardOutputProcess(&process2);
        process1.start("command1");
            process2.start("command2");
        """
        ...

    def setWorkingDirectory(self, dir: str) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#setWorkingDirectory

        **void QProcess::setWorkingDirectory(const QString & dir )**

        Sets the working directory to **dir**. **QProcess**  will start the
        process in this directory. The default behavior is to start the process
        in the working directory of the calling process.

        **Note:** On QNX, this may cause all application threads to temporarily
        freeze.

        **See also** **workingDirectory** () and **start** ().
        """
        ...

    @staticmethod
    def splitCommand(command: str) -> List[str]:
        """
        https://doc.qt.io/qt-6/qprocess.html#splitCommand

        **[static, since 5.15] QStringList QProcess::splitCommand(QStringView
        command )**

        Splits the string **command** into a list of tokens, and returns the
        list.

        Tokens with spaces can be surrounded by double quotes; three consecutive
        double quotes represent the quote character itself.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def start(self, mode: PySide6.QtCore.QIODeviceBase.OpenMode = ...) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#start

        **void QProcess::start(const QString & program , const QStringList &
        arguments = {}, QIODeviceBase::OpenMode mode = ReadWrite)**

        Starts the given **program** in a new process, passing the command line
        arguments in **arguments**.

        The **QProcess**  object will immediately enter the Starting state. If
        the process starts successfully, **QProcess**  will emit **started** ();
        otherwise, **errorOccurred** () will be emitted.

        **Note:** Processes are started asynchronously, which means the
        **started** () and **errorOccurred** () signals may be delayed. Call
        **waitForStarted** () to make sure the process has started (or has
        failed to start) and those signals have been emitted.

        **Note:** No further splitting of the arguments is performed.

        **Windows:** The arguments are quoted and joined into a command line
        that is compatible with the `CommandLineToArgvW()` Windows function. For
        programs that have different command line quoting requirements, you need
        to use **setNativeArguments** (). One notable program that does not
        follow the `CommandLineToArgvW()` rules is cmd.exe and, by consequence,
        all batch scripts.

        The OpenMode is set to **mode**.

        If the **QProcess**  object is already running a process, a warning may
        be printed at the console, and the existing process will continue
        running unaffected.

        **See also** **processId** (), **started** (), **waitForStarted** (),
        and **setNativeArguments** ().
        """
        ...

    @overload
    def start(
        self,
        program: str,
        arguments: Sequence[str] = ...,
        mode: PySide6.QtCore.QIODeviceBase.OpenMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#start-1

        **[since 5.1] void QProcess::start(QIODeviceBase::OpenMode mode =
        ReadWrite)**

        This is an overloaded function.

        Starts the program set by **setProgram** () with arguments set by
        **setArguments** (). The OpenMode is set to **mode**.

        This function was introduced in Qt 5.1.

        **See also** **open** (), **setProgram** (), and **setArguments** ().
        """
        ...

    def startCommand(
        self, command: str, mode: PySide6.QtCore.QIODeviceBase.OpenMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#startCommand

        **[since 6.0] void QProcess::startCommand(const QString & command ,
        QIODeviceBase::OpenMode mode = ReadWrite)**

        Starts the command **command** in a new process. The OpenMode is set to
        **mode**.

        **command** is a single string of text containing both the program name
        and its arguments. The arguments are separated by one or more spaces.
        For example:

        **QProcess**  process;
            process.startCommand("del /s *.txt");
            //
        same as process.start("del", QStringList() << "/s" << "*.txt");
            ...

        Arguments containing spaces must be quoted to be correctly supplied to
        the new process. For example:

        **QProcess**  process;
            process.startCommand("dir \\"My Documents\\"");

        Literal quotes in the **command** string are represented by triple
        quotes. For example:

        **QProcess**  process;
            process.startCommand("dir \\"Epic 12\\"\\"\\"
        Singles\\"");

        After the **command** string has been split and unquoted, this function
        behaves like **start** ().

        On operating systems where the system API for passing command line
        arguments to a subprocess natively uses a single string (Windows), one
        can conceive command lines which cannot be passed via **QProcess** 's
        portable list-based API. In these rare cases you need to use
        **setProgram** () and **setNativeArguments** () instead of this
        function.

        This function was introduced in Qt 6.0.

        **See also** **splitCommand** () and **start** ().
        """
        ...

    @overload
    @staticmethod
    def startDetached(
        program: str, arguments: Sequence[str] = ..., workingDirectory: str = ...
    ) -> Tuple[Tuple, int]:
        """
        https://doc.qt.io/qt-6/qprocess.html#startDetached

        **[since 5.10] bool QProcess::startDetached(qint64 * pid = nullptr)**

        Starts the program set by **setProgram** () with arguments set by
        **setArguments** () in a new process, and detaches from it. Returns
        `true` on success; otherwise returns `false`. If the calling process
        exits, the detached process will continue to run unaffected.

        **Unix:** The started process will run in its own session and act like a
        daemon.

        The process will be started in the directory set by
        **setWorkingDirectory** (). If **workingDirectory** () is empty, the
        working directory is inherited from the calling process.

        **Note:** On QNX, this may cause all application threads to temporarily
        freeze.

        If the function is successful then * **pid** is set to the process
        identifier of the started process; otherwise, it's set to -1. Note that
        the child process may exit and the PID may become invalid without
        notice. Furthermore, after the child process exits, the same PID may be
        recycled and used by a completely different process. User code should be
        careful when using this variable, especially if one intends to forcibly
        terminate the process by operating system means.

        Only the following property setters are supported by startDetached():

        * **setArguments** ()
          * **setCreateProcessArgumentsModifier** ()
          *
        **setNativeArguments** ()
          * **setProcessEnvironment** ()
          *
        **setProgram** ()
          * **setStandardErrorFile** ()
          *
        **setStandardInputFile** ()
          * **setStandardOutputFile** ()
          *
        **setProcessChannelMode** (**QProcess::MergedChannels** )
          *
        **setStandardOutputProcess** ()
          * **setWorkingDirectory** ()

        All other properties of the **QProcess**  object are ignored.

        **Note:** The called process inherits the console window of the calling
        process. To suppress console output, redirect standard/error output to
        **QProcess::nullDevice** ().

        This function was introduced in Qt 5.10.

        **See also** **start** () and **startDetached** (const QString &program,
        const QStringList &arguments, const QString &workingDirectory, qint64
        *pid).
        """
        ...

    @overload
    def startDetached(self) -> Tuple[bool, int]:
        """
        https://doc.qt.io/qt-6/qprocess.html#startDetached-1

        **[static] bool QProcess::startDetached(const QString & program , const
        QStringList & arguments = {}, const QString & workingDirectory =
        QString(), qint64 * pid = nullptr)**

        This function overloads startDetached().

        Starts the program **program** with the arguments **arguments** in a new
        process, and detaches from it. Returns `true` on success; otherwise
        returns `false`. If the calling process exits, the detached process will
        continue to run unaffected.

        Argument handling is identical to the respective **start** () overload.

        The process will be started in the directory **workingDirectory**. If
        **workingDirectory** is empty, the working directory is inherited from
        the calling process.

        If the function is successful then * **pid** is set to the process
        identifier of the started process.

        **See also** **start** ().
        """
        ...

    def state(self) -> PySide6.QtCore.QProcess.ProcessState:
        """
        https://doc.qt.io/qt-6/qprocess.html#state

        **QProcess::ProcessState QProcess::state() const**

        Returns the current state of the process.

        **See also** **stateChanged** () and **error** ().
        """
        ...

    @staticmethod
    def systemEnvironment() -> List[str]:
        """
        https://doc.qt.io/qt-6/qprocess.html#systemEnvironment

        **[static] QStringList QProcess::systemEnvironment()**

        Returns the environment of the calling process as a list of key=value
        pairs. Example:

        **QStringList**  environment = **QProcess** ::systemEnvironment();
        // environment = {"PATH=/usr/bin:/usr/local/bin",
            //
        "USER=greg", "HOME=/home/greg"}

        This function does not cache the system environment. Therefore, it's
        possible to obtain an updated version of the environment if low-level C
        library functions like `setenv` or `putenv` have been called.

        However, note that repeated calls to this function will recreate the
        list of environment variables, which is a non-trivial operation.

        **Note:** For new code, it is recommended to use
        **QProcessEnvironment::systemEnvironment** ()

        **See also** **QProcessEnvironment::systemEnvironment** () and
        **setProcessEnvironment** ().
        """
        ...

    def terminate(self) -> None:
        """
        https://doc.qt.io/qt-6/qprocess.html#terminate

        **[slot] void QProcess::terminate()**

        Attempts to terminate the process.

        The process may not exit as a result of calling this function (it is
        given the chance to prompt the user for any unsaved files, etc).

        On Windows, terminate() posts a WM_CLOSE message to all top-level
        windows of the process and then to the main thread of the process
        itself. On Unix and macOS the `SIGTERM` signal is sent.

        Console applications on Windows that do not run an event loop, or whose
        event loop does not handle the WM_CLOSE message, can only be terminated
        by calling **kill** ().

        **See also** **kill** ().
        """
        ...

    def waitForBytesWritten(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qprocess.html#waitForBytesWritten

        **[override virtual] bool QProcess::waitForBytesWritten(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForBytesWritten** (int msecs).
        """
        ...

    def waitForFinished(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qprocess.html#waitForFinished

        **bool QProcess::waitForFinished(int msecs = 30000)**

        Blocks until the process has finished and the **finished** () signal has
        been emitted, or until **msecs** milliseconds have passed.

        Returns `true` if the process finished; otherwise returns `false` (if
        the operation timed out, if an error occurred, or if this **QProcess**
        is already finished).

        This function can operate without an event loop. It is useful when
        writing non-GUI applications and when performing I/O operations in a
        non-GUI thread.

        **Warning:** Calling this function from the main (GUI) thread might
        cause your user interface to freeze.

        If msecs is -1, this function will not time out.

        **See also** **finished** (), **waitForStarted** (),
        **waitForReadyRead** (), and **waitForBytesWritten** ().
        """
        ...

    def waitForReadyRead(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qprocess.html#waitForReadyRead

        **[override virtual] bool QProcess::waitForReadyRead(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForReadyRead** (int msecs).
        """
        ...

    def waitForStarted(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qprocess.html#waitForStarted

        **bool QProcess::waitForStarted(int msecs = 30000)**

        Blocks until the process has started and the **started** () signal has
        been emitted, or until **msecs** milliseconds have passed.

        Returns `true` if the process was started successfully; otherwise
        returns `false` (if the operation timed out or if an error occurred).

        This function can operate without an event loop. It is useful when
        writing non-GUI applications and when performing I/O operations in a
        non-GUI thread.

        **Warning:** Calling this function from the main (GUI) thread might
        cause your user interface to freeze.

        If msecs is -1, this function will not time out.

        **Note:** On some UNIX operating systems, this function may return true
        but the process may later report a **QProcess::FailedToStart**  error.

        **See also** **started** (), **waitForReadyRead** (),
        **waitForBytesWritten** (), and **waitForFinished** ().
        """
        ...

    def workingDirectory(self) -> str:
        """
        https://doc.qt.io/qt-6/qprocess.html#workingDirectory

        **QString QProcess::workingDirectory() const**

        If **QProcess**  has been assigned a working directory, this function
        returns the working directory that the **QProcess**  will enter before
        the program has started. Otherwise, (i.e., no directory has been
        assigned,) an empty string is returned, and **QProcess**  will use the
        application's current working directory instead.

        **See also** **setWorkingDirectory** ().
        """
        ...

    def writeData(self, data: bytes, len: int) -> int:
        """
        https://doc.qt.io/qt-6/qprocess.html#writeData

        **[override virtual protected] qint64 QProcess::writeData(const char *
        data , qint64 len )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprocess.html#errorOccurred

        **[signal, since 5.6] void
        QProcess::errorOccurred(QProcess::ProcessError error )**

        This signal is emitted when an error occurs with the process. The
        specified **error** describes the type of error that occurred.

        This function was introduced in Qt 5.6.
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprocess.html#finished

        **[signal] void QProcess::finished(int exitCode , QProcess::ExitStatus
        exitStatus = NormalExit)**

        This signal is emitted when the process finishes. **exitCode** is the
        exit code of the process (only valid for normal exits), and
        **exitStatus** is the exit status. After the process has finished, the
        buffers in **QProcess**  are still intact. You can still read any data
        that the process may have written before it finished.

        **See also** **exitStatus** ().
        """
        ...

    @property
    def readyReadStandardError(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprocess.html#readyReadStandardError

        **[private signal] void QProcess::readyReadStandardError()**

        This signal is emitted when the process has made new data available
        through its standard error channel (`stderr`). It is emitted regardless
        of the current **read channel** .

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **readAllStandardError** () and **readChannel** ().
        """
        ...

    @property
    def readyReadStandardOutput(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprocess.html#readyReadStandardOutput

        **[private signal] void QProcess::readyReadStandardOutput()**

        This signal is emitted when the process has made new data available
        through its standard output channel (`stdout`). It is emitted regardless
        of the current **read channel** .

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **readAllStandardOutput** () and **readChannel** ().
        """
        ...

    @property
    def started(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprocess.html#started

        **[private signal] void QProcess::started()**

        This signal is emitted by **QProcess**  when the process has started,
        and **state** () returns **Running** .

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.
        """
        ...

    @property
    def stateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprocess.html#stateChanged

        **[private signal] void QProcess::stateChanged(QProcess::ProcessState
        newState )**

        This signal is emitted whenever the state of **QProcess**  changes. The
        **newState** argument is the state **QProcess**  changed to.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.
        """
        ...
