"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QMarginsF(object):
    """
    https://doc.qt.io/qt-6/qmarginsf.html

    **Detailed Description**

    QMarginsF defines a set of four margins; left, top, right, and bottom, that
    describe the finite size of the borders surrounding a rectangle.

    The **isNull** () function returns `true` only if all margins are very close
    to zero.

    QMarginsF objects can be streamed as well as compared.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#QMarginsF

        **QMarginsF::QMarginsF()**

        Constructs a margins object with all margins set to 0.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(
        self, QMarginsF: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#QMarginsF-1

        **QMarginsF::QMarginsF(qreal left , qreal top , qreal right , qreal
        bottom )**

        Constructs margins with the given **left** , **top** , **right** , and
        **bottom**. All parameters must be finite.

        **See also** **setLeft** (), **setRight** (), **setTop** (), and
        **setBottom** ().
        """
        ...

    @overload
    def __init__(self, left: float, top: float, right: float, bottom: float) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#QMarginsF-2

        **QMarginsF::QMarginsF(const QMargins & margins )**

        Constructs margins copied from the given **margins**
        """
        ...

    @overload
    def __init__(self, margins: PySide6.QtCore.QMargins) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#QMarginsF

        **QMarginsF::QMarginsF()**

        Constructs a margins object with all margins set to 0.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __add__(self, lhs: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __add__(self, rhs: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __add__(
        self, rhs: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QMarginsF:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    def __iadd__(self, addend: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __iadd__(
        self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QMarginsF:
        ...

    def __imul__(self, factor: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __isub__(
        self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __isub__(self, subtrahend: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __mul__(self, lhs: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __mul__(self, rhs: float) -> PySide6.QtCore.QMarginsF:
        ...

    def __neg__(self) -> PySide6.QtCore.QMarginsF:
        ...

    def __or__(
        self, m2: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QMarginsF:
        ...

    def __pos__(self) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __sub__(self, rhs: float) -> PySide6.QtCore.QMarginsF:
        ...

    @overload
    def __sub__(
        self, rhs: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QMarginsF:
        ...

    def bottom(self) -> float:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#bottom

        **qreal QMarginsF::bottom() const**

        Returns the bottom margin.

        **See also** **setBottom** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#isNull

        **bool QMarginsF::isNull() const**

        Returns `true` if all margins are very close to 0; otherwise returns
        false.

        **See also** **qFuzzyIsNull** .
        """
        ...

    def left(self) -> float:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#left

        **qreal QMarginsF::left() const**

        Returns the left margin.

        **See also** **setLeft** ().
        """
        ...

    def right(self) -> float:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#right

        **qreal QMarginsF::right() const**

        Returns the right margin.

        **See also** **setRight** ().
        """
        ...

    def setBottom(self, abottom: float) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#setBottom

        **void QMarginsF::setBottom(qreal abottom )**

        Sets the bottom margin to **abottom** (which must be finite).

        **See also** **bottom** ().
        """
        ...

    def setLeft(self, aleft: float) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#setLeft

        **void QMarginsF::setLeft(qreal aleft )**

        Sets the left margin to **aleft** (which must be finite).

        **See also** **left** ().
        """
        ...

    def setRight(self, aright: float) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#setRight

        **void QMarginsF::setRight(qreal aright )**

        Sets the right margin to **aright** (which must be finite).

        **See also** **right** ().
        """
        ...

    def setTop(self, atop: float) -> None:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#setTop

        **void QMarginsF::setTop(qreal atop )**

        Sets the top margin to **atop** (which must be finite).

        **See also** **top** ().
        """
        ...

    def toMargins(self) -> PySide6.QtCore.QMargins:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#toMargins

        **QMargins QMarginsF::toMargins() const**

        Returns an integer-based copy of this margins object.

        Note that the components in the returned margins will be rounded to the
        nearest integer.

        **See also** **QMarginsF** ().
        """
        ...

    def top(self) -> float:
        """
        https://doc.qt.io/qt-6/qmarginsf.html#top

        **qreal QMarginsF::top() const**

        Returns the top margin.

        **See also** **setTop** ().
        """
        ...
