"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Tuple, Union, overload
import PySide6.QtCore

bytes = str


class QLocale(object):
    """
    https://doc.qt.io/qt-6/qlocale.html

    **Detailed Description**

    QLocale is constructed for a specified language, optional script and
    territory. It offers various facilities for formatting data as text,
    localized appropriately, and for reading data out of localized text.

    Example:

    **QLocale**  egyptian(**QLocale** ::Arabic, **QLocale** ::Egypt);
    **QString**  s1 = egyptian.toString(1.571429E+07, 'e');
        **QString**  s2
    = egyptian.toString(10);

        double d = egyptian.toDouble(s1);
        int
    i = egyptian.toInt(s2);

    QLocale supports the concept of a default locale, which is determined from
    the system's locale settings at application startup. The default locale can
    be changed by calling the static member **setDefault** (). Setting the
    default locale has the following effects:

    * If a QLocale object is constructed with the default constructor, it will
    use the default locale's settings.
      * **QString::arg** () uses the default
    locale to format a number when its position specifier in the format string
    contains an 'L', e.g. "%L1".

    The following example illustrates how to use QLocale directly:

    bool ok;
        double d;

        **QLocale** ::setDefault(**QLocale** ::C);
    // uses '.' as a decimal point
        **QLocale**  cLocale;
    // default-constructed C locale
        d = cLocale.toDouble("1234,56", &ok); //
    ok == false, d == 0
        d = cLocale.toDouble("1234.56", &ok); // ok == true,
    d == 1234.56

        **QLocale** ::setDefault(**QLocale** ::German); //
    uses ',' as a decimal point
        **QLocale**  german;
    // default-constructed German locale
        d = german.toDouble("1234,56",
    &ok);  // ok == true,  d == 1234.56
        d = german.toDouble("1234.56", &ok);
    // ok == false, d == 0

        **QLocale** ::setDefault(**QLocale**
    ::English);
        // Default locale now uses ',' as a group separator.
    **QString**  str = **QString** ("%1 %L2
    %L3").arg(12345).arg(12345).arg(12345, 0, 16);
        // str == "12345 12,345
    3039"

    An alternative method for constructing a QLocale object is by specifying the
    locale name.

    **QLocale**  korean("ko");
        **QLocale**  swiss("de_CH");

    This constructor reads the language, script and/or territory from the given
    name, accepting either uderscore or dash as separator (and ignoring any
    trailing `.codeset` or `@variant` suffix).

    **Note:** For the current keyboard input locale take a look at
    **QInputMethod::locale** ().

    QLocale's data is based on Common Locale Data Repository v40.

    **Matching combinations of language, script and territory**

    QLocale has data, derived from CLDR, for many combinations of language,
    script and territory, but not all. If it is constructed with all three of
    these key values specified (treating `AnyLanguage`, `AnyScript` or
    `AnyTerritory` as unspecified) and QLocale has data for the given
    combination, this data is used. Otherwise, QLocale does its best to find a
    sensible combination of language, script and territory, for which it does
    have data, that matches those that were specified.

    The CLDR provides tables of likely combinations, which are used to fill in
    any unspecified key or keys; if QLocale has data for the result of such a
    likely combination, that is used. If no language is specified, and none can
    be determined from script and territory, or if QLocale has no data for the
    language, the "C" locale (when reading the keys from a string) or default
    locale (otherwise) is used.

    When QLocale has no data for the keys specified, with likely keys filled in
    where unspecified, but does have data for the resulting language, a fall-
    back is sought, based on ignoring either territory, script or both (in that
    order). This results in a QLocale which may not match what was asked for,
    but provides localization that's as suitable as the available data permits,
    for the keys specified.

    Use **language** (), **script** () and **territory** () to determine the
    actual keys used.

    **See also** **QString::arg** () and **QInputMethod::locale** ().
    """

    AnyCountry: QLocale.Country = ...
    AnyTerritory: QLocale.Country = ...
    Afghanistan: QLocale.Country = ...
    AlandIslands: QLocale.Country = ...
    Albania: QLocale.Country = ...
    Algeria: QLocale.Country = ...
    AmericanSamoa: QLocale.Country = ...
    Andorra: QLocale.Country = ...
    Angola: QLocale.Country = ...
    Anguilla: QLocale.Country = ...
    Antarctica: QLocale.Country = ...
    AntiguaAndBarbuda: QLocale.Country = ...
    Argentina: QLocale.Country = ...
    Armenia: QLocale.Country = ...
    Aruba: QLocale.Country = ...
    AscensionIsland: QLocale.Country = ...
    Australia: QLocale.Country = ...
    Austria: QLocale.Country = ...
    Azerbaijan: QLocale.Country = ...
    Bahamas: QLocale.Country = ...
    Bahrain: QLocale.Country = ...
    Bangladesh: QLocale.Country = ...
    Barbados: QLocale.Country = ...
    Belarus: QLocale.Country = ...
    Belgium: QLocale.Country = ...
    Belize: QLocale.Country = ...
    Benin: QLocale.Country = ...
    Bermuda: QLocale.Country = ...
    Bhutan: QLocale.Country = ...
    Bolivia: QLocale.Country = ...
    BosniaAndHerzegovina: QLocale.Country = ...
    BosniaAndHerzegowina: QLocale.Country = ...
    Botswana: QLocale.Country = ...
    BouvetIsland: QLocale.Country = ...
    Brazil: QLocale.Country = ...
    BritishIndianOceanTerritory: QLocale.Country = ...
    BritishVirginIslands: QLocale.Country = ...
    Brunei: QLocale.Country = ...
    Bulgaria: QLocale.Country = ...
    BurkinaFaso: QLocale.Country = ...
    Burundi: QLocale.Country = ...
    Cambodia: QLocale.Country = ...
    Cameroon: QLocale.Country = ...
    Canada: QLocale.Country = ...
    CanaryIslands: QLocale.Country = ...
    CapeVerde: QLocale.Country = ...
    Bonaire: QLocale.Country = ...
    CaribbeanNetherlands: QLocale.Country = ...
    CaymanIslands: QLocale.Country = ...
    CentralAfricanRepublic: QLocale.Country = ...
    CeutaAndMelilla: QLocale.Country = ...
    Chad: QLocale.Country = ...
    Chile: QLocale.Country = ...
    China: QLocale.Country = ...
    ChristmasIsland: QLocale.Country = ...
    ClippertonIsland: QLocale.Country = ...
    CocosIslands: QLocale.Country = ...
    Colombia: QLocale.Country = ...
    Comoros: QLocale.Country = ...
    CongoBrazzaville: QLocale.Country = ...
    PeoplesRepublicOfCongo: QLocale.Country = ...
    CongoKinshasa: QLocale.Country = ...
    DemocraticRepublicOfCongo: QLocale.Country = ...
    CookIslands: QLocale.Country = ...
    CostaRica: QLocale.Country = ...
    Croatia: QLocale.Country = ...
    Cuba: QLocale.Country = ...
    CuraSao: QLocale.Country = ...
    Curacao: QLocale.Country = ...
    Cyprus: QLocale.Country = ...
    CzechRepublic: QLocale.Country = ...
    Czechia: QLocale.Country = ...
    Denmark: QLocale.Country = ...
    DiegoGarcia: QLocale.Country = ...
    Djibouti: QLocale.Country = ...
    Dominica: QLocale.Country = ...
    DominicanRepublic: QLocale.Country = ...
    Ecuador: QLocale.Country = ...
    Egypt: QLocale.Country = ...
    ElSalvador: QLocale.Country = ...
    EquatorialGuinea: QLocale.Country = ...
    Eritrea: QLocale.Country = ...
    Estonia: QLocale.Country = ...
    Eswatini: QLocale.Country = ...
    Swaziland: QLocale.Country = ...
    Ethiopia: QLocale.Country = ...
    Europe: QLocale.Country = ...
    EuropeanUnion: QLocale.Country = ...
    FalklandIslands: QLocale.Country = ...
    FaroeIslands: QLocale.Country = ...
    Fiji: QLocale.Country = ...
    Finland: QLocale.Country = ...
    France: QLocale.Country = ...
    FrenchGuiana: QLocale.Country = ...
    FrenchPolynesia: QLocale.Country = ...
    FrenchSouthernTerritories: QLocale.Country = ...
    Gabon: QLocale.Country = ...
    Gambia: QLocale.Country = ...
    Georgia: QLocale.Country = ...
    Germany: QLocale.Country = ...
    Ghana: QLocale.Country = ...
    Gibraltar: QLocale.Country = ...
    Greece: QLocale.Country = ...
    Greenland: QLocale.Country = ...
    Grenada: QLocale.Country = ...
    Guadeloupe: QLocale.Country = ...
    Guam: QLocale.Country = ...
    Guatemala: QLocale.Country = ...
    Guernsey: QLocale.Country = ...
    GuineaBissau: QLocale.Country = ...
    Guinea: QLocale.Country = ...
    Guyana: QLocale.Country = ...
    Haiti: QLocale.Country = ...
    HeardAndMcDonaldIslands: QLocale.Country = ...
    Honduras: QLocale.Country = ...
    HongKong: QLocale.Country = ...
    Hungary: QLocale.Country = ...
    Iceland: QLocale.Country = ...
    India: QLocale.Country = ...
    Indonesia: QLocale.Country = ...
    Iran: QLocale.Country = ...
    Iraq: QLocale.Country = ...
    Ireland: QLocale.Country = ...
    IsleOfMan: QLocale.Country = ...
    Israel: QLocale.Country = ...
    Italy: QLocale.Country = ...
    IvoryCoast: QLocale.Country = ...
    Jamaica: QLocale.Country = ...
    Japan: QLocale.Country = ...
    Jersey: QLocale.Country = ...
    Jordan: QLocale.Country = ...
    Kazakhstan: QLocale.Country = ...
    Kenya: QLocale.Country = ...
    Kiribati: QLocale.Country = ...
    Kosovo: QLocale.Country = ...
    Kuwait: QLocale.Country = ...
    Kyrgyzstan: QLocale.Country = ...
    Laos: QLocale.Country = ...
    LatinAmerica: QLocale.Country = ...
    LatinAmericaAndTheCaribbean: QLocale.Country = ...
    Latvia: QLocale.Country = ...
    Lebanon: QLocale.Country = ...
    Lesotho: QLocale.Country = ...
    Liberia: QLocale.Country = ...
    Libya: QLocale.Country = ...
    Liechtenstein: QLocale.Country = ...
    Lithuania: QLocale.Country = ...
    Luxembourg: QLocale.Country = ...
    Macao: QLocale.Country = ...
    Macau: QLocale.Country = ...
    Macedonia: QLocale.Country = ...
    Madagascar: QLocale.Country = ...
    Malawi: QLocale.Country = ...
    Malaysia: QLocale.Country = ...
    Maldives: QLocale.Country = ...
    Mali: QLocale.Country = ...
    Malta: QLocale.Country = ...
    MarshallIslands: QLocale.Country = ...
    Martinique: QLocale.Country = ...
    Mauritania: QLocale.Country = ...
    Mauritius: QLocale.Country = ...
    Mayotte: QLocale.Country = ...
    Mexico: QLocale.Country = ...
    Micronesia: QLocale.Country = ...
    Moldova: QLocale.Country = ...
    Monaco: QLocale.Country = ...
    Mongolia: QLocale.Country = ...
    Montenegro: QLocale.Country = ...
    Montserrat: QLocale.Country = ...
    Morocco: QLocale.Country = ...
    Mozambique: QLocale.Country = ...
    Myanmar: QLocale.Country = ...
    Namibia: QLocale.Country = ...
    NauruCountry: QLocale.Country = ...
    NauruTerritory: QLocale.Country = ...
    Nepal: QLocale.Country = ...
    Netherlands: QLocale.Country = ...
    NewCaledonia: QLocale.Country = ...
    NewZealand: QLocale.Country = ...
    Nicaragua: QLocale.Country = ...
    Nigeria: QLocale.Country = ...
    Niger: QLocale.Country = ...
    Niue: QLocale.Country = ...
    NorfolkIsland: QLocale.Country = ...
    NorthernMarianaIslands: QLocale.Country = ...
    DemocraticRepublicOfKorea: QLocale.Country = ...
    NorthKorea: QLocale.Country = ...
    Norway: QLocale.Country = ...
    Oman: QLocale.Country = ...
    OutlyingOceania: QLocale.Country = ...
    Pakistan: QLocale.Country = ...
    Palau: QLocale.Country = ...
    PalestinianTerritories: QLocale.Country = ...
    Panama: QLocale.Country = ...
    PapuaNewGuinea: QLocale.Country = ...
    Paraguay: QLocale.Country = ...
    Peru: QLocale.Country = ...
    Philippines: QLocale.Country = ...
    Pitcairn: QLocale.Country = ...
    Poland: QLocale.Country = ...
    Portugal: QLocale.Country = ...
    PuertoRico: QLocale.Country = ...
    Qatar: QLocale.Country = ...
    Reunion: QLocale.Country = ...
    Romania: QLocale.Country = ...
    Russia: QLocale.Country = ...
    RussianFederation: QLocale.Country = ...
    Rwanda: QLocale.Country = ...
    SaintBarthelemy: QLocale.Country = ...
    SaintHelena: QLocale.Country = ...
    SaintKittsAndNevis: QLocale.Country = ...
    SaintLucia: QLocale.Country = ...
    SaintMartin: QLocale.Country = ...
    SaintPierreAndMiquelon: QLocale.Country = ...
    SaintVincentAndGrenadines: QLocale.Country = ...
    SaintVincentAndTheGrenadines: QLocale.Country = ...
    Samoa: QLocale.Country = ...
    SanMarino: QLocale.Country = ...
    SaoTomeAndPrincipe: QLocale.Country = ...
    SaudiArabia: QLocale.Country = ...
    Senegal: QLocale.Country = ...
    Serbia: QLocale.Country = ...
    Seychelles: QLocale.Country = ...
    SierraLeone: QLocale.Country = ...
    Singapore: QLocale.Country = ...
    SintMaarten: QLocale.Country = ...
    Slovakia: QLocale.Country = ...
    Slovenia: QLocale.Country = ...
    SolomonIslands: QLocale.Country = ...
    Somalia: QLocale.Country = ...
    SouthAfrica: QLocale.Country = ...
    SouthGeorgiaAndSouthSandwichIslands: QLocale.Country = ...
    SouthGeorgiaAndTheSouthSandwichIslands: QLocale.Country = ...
    RepublicOfKorea: QLocale.Country = ...
    SouthKorea: QLocale.Country = ...
    SouthSudan: QLocale.Country = ...
    Spain: QLocale.Country = ...
    SriLanka: QLocale.Country = ...
    Sudan: QLocale.Country = ...
    Suriname: QLocale.Country = ...
    SvalbardAndJanMayen: QLocale.Country = ...
    SvalbardAndJanMayenIslands: QLocale.Country = ...
    Sweden: QLocale.Country = ...
    Switzerland: QLocale.Country = ...
    Syria: QLocale.Country = ...
    SyrianArabRepublic: QLocale.Country = ...
    Taiwan: QLocale.Country = ...
    Tajikistan: QLocale.Country = ...
    Tanzania: QLocale.Country = ...
    Thailand: QLocale.Country = ...
    EastTimor: QLocale.Country = ...
    TimorLeste: QLocale.Country = ...
    Togo: QLocale.Country = ...
    TokelauCountry: QLocale.Country = ...
    TokelauTerritory: QLocale.Country = ...
    Tonga: QLocale.Country = ...
    TrinidadAndTobago: QLocale.Country = ...
    TristanDaCunha: QLocale.Country = ...
    Tunisia: QLocale.Country = ...
    Turkey: QLocale.Country = ...
    Turkmenistan: QLocale.Country = ...
    TurksAndCaicosIslands: QLocale.Country = ...
    TuvaluCountry: QLocale.Country = ...
    TuvaluTerritory: QLocale.Country = ...
    Uganda: QLocale.Country = ...
    Ukraine: QLocale.Country = ...
    UnitedArabEmirates: QLocale.Country = ...
    UnitedKingdom: QLocale.Country = ...
    UnitedStatesMinorOutlyingIslands: QLocale.Country = ...
    UnitedStatesOutlyingIslands: QLocale.Country = ...
    UnitedStates: QLocale.Country = ...
    UnitedStatesVirginIslands: QLocale.Country = ...
    Uruguay: QLocale.Country = ...
    Uzbekistan: QLocale.Country = ...
    Vanuatu: QLocale.Country = ...
    VaticanCity: QLocale.Country = ...
    VaticanCityState: QLocale.Country = ...
    Venezuela: QLocale.Country = ...
    Vietnam: QLocale.Country = ...
    WallisAndFutuna: QLocale.Country = ...
    WallisAndFutunaIslands: QLocale.Country = ...
    WesternSahara: QLocale.Country = ...
    World: QLocale.Country = ...
    Yemen: QLocale.Country = ...
    Zambia: QLocale.Country = ...
    LastCountry: QLocale.Country = ...
    LastTerritory: QLocale.Country = ...
    Zimbabwe: QLocale.Country = ...
    CurrencyIsoCode: QLocale.CurrencySymbolFormat = ...
    CurrencySymbol: QLocale.CurrencySymbolFormat = ...
    CurrencyDisplayName: QLocale.CurrencySymbolFormat = ...
    DataSizeIecFormat: QLocale.DataSizeFormat = ...
    DataSizeBase1000: QLocale.DataSizeFormat = ...
    DataSizeSIQuantifiers: QLocale.DataSizeFormat = ...
    DataSizeTraditionalFormat: QLocale.DataSizeFormat = ...
    DataSizeSIFormat: QLocale.DataSizeFormat = ...
    FloatingPointShortest: QLocale.FloatingPointPrecisionOption = ...
    LongFormat: QLocale.FormatType = ...
    ShortFormat: QLocale.FormatType = ...
    NarrowFormat: QLocale.FormatType = ...
    AnyLanguage: QLocale.Language = ...
    C: QLocale.Language = ...
    Abkhazian: QLocale.Language = ...
    Afar: QLocale.Language = ...
    Afrikaans: QLocale.Language = ...
    Aghem: QLocale.Language = ...
    Akan: QLocale.Language = ...
    Akkadian: QLocale.Language = ...
    Akoose: QLocale.Language = ...
    Albanian: QLocale.Language = ...
    AmericanSignLanguage: QLocale.Language = ...
    Amharic: QLocale.Language = ...
    AncientEgyptian: QLocale.Language = ...
    AncientGreek: QLocale.Language = ...
    Arabic: QLocale.Language = ...
    Aragonese: QLocale.Language = ...
    Aramaic: QLocale.Language = ...
    Armenian: QLocale.Language = ...
    Assamese: QLocale.Language = ...
    Asturian: QLocale.Language = ...
    Asu: QLocale.Language = ...
    Atsam: QLocale.Language = ...
    Avaric: QLocale.Language = ...
    Avestan: QLocale.Language = ...
    Aymara: QLocale.Language = ...
    Azerbaijani: QLocale.Language = ...
    Bafia: QLocale.Language = ...
    Balinese: QLocale.Language = ...
    Bambara: QLocale.Language = ...
    Bamun: QLocale.Language = ...
    Bangla: QLocale.Language = ...
    Bengali: QLocale.Language = ...
    Basaa: QLocale.Language = ...
    Bashkir: QLocale.Language = ...
    Basque: QLocale.Language = ...
    BatakToba: QLocale.Language = ...
    Belarusian: QLocale.Language = ...
    Byelorussian: QLocale.Language = ...
    Bemba: QLocale.Language = ...
    Bena: QLocale.Language = ...
    Bhojpuri: QLocale.Language = ...
    Bislama: QLocale.Language = ...
    Blin: QLocale.Language = ...
    Bodo: QLocale.Language = ...
    Bosnian: QLocale.Language = ...
    Breton: QLocale.Language = ...
    Buginese: QLocale.Language = ...
    Bulgarian: QLocale.Language = ...
    Burmese: QLocale.Language = ...
    Cantonese: QLocale.Language = ...
    Catalan: QLocale.Language = ...
    Cebuano: QLocale.Language = ...
    CentralAtlasTamazight: QLocale.Language = ...
    CentralMoroccoTamazight: QLocale.Language = ...
    CentralKurdish: QLocale.Language = ...
    Chakma: QLocale.Language = ...
    Chamorro: QLocale.Language = ...
    Chechen: QLocale.Language = ...
    Cherokee: QLocale.Language = ...
    Chickasaw: QLocale.Language = ...
    Chiga: QLocale.Language = ...
    Chinese: QLocale.Language = ...
    Church: QLocale.Language = ...
    Chuvash: QLocale.Language = ...
    Colognian: QLocale.Language = ...
    Coptic: QLocale.Language = ...
    Cornish: QLocale.Language = ...
    Corsican: QLocale.Language = ...
    Cree: QLocale.Language = ...
    Croatian: QLocale.Language = ...
    Czech: QLocale.Language = ...
    Danish: QLocale.Language = ...
    Divehi: QLocale.Language = ...
    Dogri: QLocale.Language = ...
    Duala: QLocale.Language = ...
    Dutch: QLocale.Language = ...
    Bhutani: QLocale.Language = ...
    Dzongkha: QLocale.Language = ...
    Embu: QLocale.Language = ...
    English: QLocale.Language = ...
    Erzya: QLocale.Language = ...
    Esperanto: QLocale.Language = ...
    Estonian: QLocale.Language = ...
    Ewe: QLocale.Language = ...
    Ewondo: QLocale.Language = ...
    Faroese: QLocale.Language = ...
    Fijian: QLocale.Language = ...
    Filipino: QLocale.Language = ...
    Finnish: QLocale.Language = ...
    French: QLocale.Language = ...
    Friulian: QLocale.Language = ...
    Fulah: QLocale.Language = ...
    Gaelic: QLocale.Language = ...
    Ga: QLocale.Language = ...
    Galician: QLocale.Language = ...
    Ganda: QLocale.Language = ...
    Geez: QLocale.Language = ...
    Georgian: QLocale.Language = ...
    German: QLocale.Language = ...
    Gothic: QLocale.Language = ...
    Greek: QLocale.Language = ...
    Guarani: QLocale.Language = ...
    Gujarati: QLocale.Language = ...
    Gusii: QLocale.Language = ...
    Haitian: QLocale.Language = ...
    Hausa: QLocale.Language = ...
    Hawaiian: QLocale.Language = ...
    Hebrew: QLocale.Language = ...
    Herero: QLocale.Language = ...
    Hindi: QLocale.Language = ...
    HiriMotu: QLocale.Language = ...
    Hungarian: QLocale.Language = ...
    Icelandic: QLocale.Language = ...
    Ido: QLocale.Language = ...
    Igbo: QLocale.Language = ...
    InariSami: QLocale.Language = ...
    Indonesian: QLocale.Language = ...
    Ingush: QLocale.Language = ...
    Interlingua: QLocale.Language = ...
    Interlingue: QLocale.Language = ...
    Inuktitut: QLocale.Language = ...
    Inupiak: QLocale.Language = ...
    Inupiaq: QLocale.Language = ...
    Irish: QLocale.Language = ...
    Italian: QLocale.Language = ...
    Japanese: QLocale.Language = ...
    Javanese: QLocale.Language = ...
    Jju: QLocale.Language = ...
    JolaFonyi: QLocale.Language = ...
    Kabuverdianu: QLocale.Language = ...
    Kabyle: QLocale.Language = ...
    Kako: QLocale.Language = ...
    Greenlandic: QLocale.Language = ...
    Kalaallisut: QLocale.Language = ...
    Kalenjin: QLocale.Language = ...
    Kamba: QLocale.Language = ...
    Kannada: QLocale.Language = ...
    Kanuri: QLocale.Language = ...
    Kashmiri: QLocale.Language = ...
    Kazakh: QLocale.Language = ...
    Kenyang: QLocale.Language = ...
    Cambodian: QLocale.Language = ...
    Khmer: QLocale.Language = ...
    Kiche: QLocale.Language = ...
    Kikuyu: QLocale.Language = ...
    Kinyarwanda: QLocale.Language = ...
    Komi: QLocale.Language = ...
    Kongo: QLocale.Language = ...
    Konkani: QLocale.Language = ...
    Korean: QLocale.Language = ...
    Koro: QLocale.Language = ...
    KoyraboroSenni: QLocale.Language = ...
    KoyraChiini: QLocale.Language = ...
    Kpelle: QLocale.Language = ...
    Kuanyama: QLocale.Language = ...
    Kwanyama: QLocale.Language = ...
    Kurdish: QLocale.Language = ...
    Kwasio: QLocale.Language = ...
    Kirghiz: QLocale.Language = ...
    Kyrgyz: QLocale.Language = ...
    Lakota: QLocale.Language = ...
    Langi: QLocale.Language = ...
    Lao: QLocale.Language = ...
    Latin: QLocale.Language = ...
    Latvian: QLocale.Language = ...
    Lezghian: QLocale.Language = ...
    Limburgish: QLocale.Language = ...
    Lingala: QLocale.Language = ...
    LiteraryChinese: QLocale.Language = ...
    Lithuanian: QLocale.Language = ...
    Lojban: QLocale.Language = ...
    LowerSorbian: QLocale.Language = ...
    LowGerman: QLocale.Language = ...
    LubaKatanga: QLocale.Language = ...
    LuleSami: QLocale.Language = ...
    Luo: QLocale.Language = ...
    Luxembourgish: QLocale.Language = ...
    Luyia: QLocale.Language = ...
    Macedonian: QLocale.Language = ...
    Machame: QLocale.Language = ...
    Maithili: QLocale.Language = ...
    MakhuwaMeetto: QLocale.Language = ...
    Makonde: QLocale.Language = ...
    Malagasy: QLocale.Language = ...
    Malayalam: QLocale.Language = ...
    Malay: QLocale.Language = ...
    Maltese: QLocale.Language = ...
    Mandingo: QLocale.Language = ...
    Manipuri: QLocale.Language = ...
    Manx: QLocale.Language = ...
    Maori: QLocale.Language = ...
    Mapuche: QLocale.Language = ...
    Marathi: QLocale.Language = ...
    Marshallese: QLocale.Language = ...
    Masai: QLocale.Language = ...
    Mazanderani: QLocale.Language = ...
    Mende: QLocale.Language = ...
    Meru: QLocale.Language = ...
    Meta: QLocale.Language = ...
    Mohawk: QLocale.Language = ...
    Mongolian: QLocale.Language = ...
    Morisyen: QLocale.Language = ...
    Mundang: QLocale.Language = ...
    Muscogee: QLocale.Language = ...
    Nama: QLocale.Language = ...
    NauruLanguage: QLocale.Language = ...
    Navaho: QLocale.Language = ...
    Navajo: QLocale.Language = ...
    Ndonga: QLocale.Language = ...
    Nepali: QLocale.Language = ...
    Newari: QLocale.Language = ...
    Ngiemboon: QLocale.Language = ...
    Ngomba: QLocale.Language = ...
    NigerianPidgin: QLocale.Language = ...
    Nko: QLocale.Language = ...
    NorthernLuri: QLocale.Language = ...
    NorthernSami: QLocale.Language = ...
    NorthernSotho: QLocale.Language = ...
    NorthNdebele: QLocale.Language = ...
    NorwegianBokmal: QLocale.Language = ...
    NorwegianNynorsk: QLocale.Language = ...
    Nuer: QLocale.Language = ...
    Chewa: QLocale.Language = ...
    Nyanja: QLocale.Language = ...
    Nyankole: QLocale.Language = ...
    Occitan: QLocale.Language = ...
    Odia: QLocale.Language = ...
    Oriya: QLocale.Language = ...
    Ojibwa: QLocale.Language = ...
    OldIrish: QLocale.Language = ...
    OldNorse: QLocale.Language = ...
    OldPersian: QLocale.Language = ...
    Afan: QLocale.Language = ...
    Oromo: QLocale.Language = ...
    Osage: QLocale.Language = ...
    Ossetic: QLocale.Language = ...
    Pahlavi: QLocale.Language = ...
    Palauan: QLocale.Language = ...
    Pali: QLocale.Language = ...
    Papiamento: QLocale.Language = ...
    Pashto: QLocale.Language = ...
    Persian: QLocale.Language = ...
    Phoenician: QLocale.Language = ...
    Polish: QLocale.Language = ...
    Portuguese: QLocale.Language = ...
    Prussian: QLocale.Language = ...
    Punjabi: QLocale.Language = ...
    Quechua: QLocale.Language = ...
    Romanian: QLocale.Language = ...
    RhaetoRomance: QLocale.Language = ...
    Romansh: QLocale.Language = ...
    Rombo: QLocale.Language = ...
    Kurundi: QLocale.Language = ...
    Rundi: QLocale.Language = ...
    Russian: QLocale.Language = ...
    Rwa: QLocale.Language = ...
    Saho: QLocale.Language = ...
    Sakha: QLocale.Language = ...
    Samburu: QLocale.Language = ...
    Samoan: QLocale.Language = ...
    Sango: QLocale.Language = ...
    Sangu: QLocale.Language = ...
    Sanskrit: QLocale.Language = ...
    Santali: QLocale.Language = ...
    Sardinian: QLocale.Language = ...
    Saurashtra: QLocale.Language = ...
    Sena: QLocale.Language = ...
    Serbian: QLocale.Language = ...
    Shambala: QLocale.Language = ...
    Shona: QLocale.Language = ...
    SichuanYi: QLocale.Language = ...
    Sicilian: QLocale.Language = ...
    Sidamo: QLocale.Language = ...
    Silesian: QLocale.Language = ...
    Sindhi: QLocale.Language = ...
    Sinhala: QLocale.Language = ...
    SkoltSami: QLocale.Language = ...
    Slovak: QLocale.Language = ...
    Slovenian: QLocale.Language = ...
    Soga: QLocale.Language = ...
    Somali: QLocale.Language = ...
    SouthernKurdish: QLocale.Language = ...
    SouthernSami: QLocale.Language = ...
    SouthernSotho: QLocale.Language = ...
    SouthNdebele: QLocale.Language = ...
    Spanish: QLocale.Language = ...
    StandardMoroccanTamazight: QLocale.Language = ...
    Sundanese: QLocale.Language = ...
    Swahili: QLocale.Language = ...
    Swati: QLocale.Language = ...
    Swedish: QLocale.Language = ...
    SwissGerman: QLocale.Language = ...
    Syriac: QLocale.Language = ...
    Tachelhit: QLocale.Language = ...
    Tahitian: QLocale.Language = ...
    TaiDam: QLocale.Language = ...
    Taita: QLocale.Language = ...
    Tajik: QLocale.Language = ...
    Tamil: QLocale.Language = ...
    Taroko: QLocale.Language = ...
    Tasawaq: QLocale.Language = ...
    Tatar: QLocale.Language = ...
    Telugu: QLocale.Language = ...
    Teso: QLocale.Language = ...
    Thai: QLocale.Language = ...
    Tibetan: QLocale.Language = ...
    Tigre: QLocale.Language = ...
    Tigrinya: QLocale.Language = ...
    TokelauLanguage: QLocale.Language = ...
    TokPisin: QLocale.Language = ...
    Tongan: QLocale.Language = ...
    Tsonga: QLocale.Language = ...
    Tswana: QLocale.Language = ...
    Turkish: QLocale.Language = ...
    Turkmen: QLocale.Language = ...
    TuvaluLanguage: QLocale.Language = ...
    Tyap: QLocale.Language = ...
    Ugaritic: QLocale.Language = ...
    Ukrainian: QLocale.Language = ...
    UpperSorbian: QLocale.Language = ...
    Urdu: QLocale.Language = ...
    Uighur: QLocale.Language = ...
    Uigur: QLocale.Language = ...
    Uyghur: QLocale.Language = ...
    Uzbek: QLocale.Language = ...
    Vai: QLocale.Language = ...
    Venda: QLocale.Language = ...
    Vietnamese: QLocale.Language = ...
    Volapuk: QLocale.Language = ...
    Vunjo: QLocale.Language = ...
    Walloon: QLocale.Language = ...
    Walser: QLocale.Language = ...
    Warlpiri: QLocale.Language = ...
    Welsh: QLocale.Language = ...
    WesternBalochi: QLocale.Language = ...
    Frisian: QLocale.Language = ...
    WesternFrisian: QLocale.Language = ...
    Walamo: QLocale.Language = ...
    Wolaytta: QLocale.Language = ...
    Wolof: QLocale.Language = ...
    Xhosa: QLocale.Language = ...
    Yangben: QLocale.Language = ...
    Yiddish: QLocale.Language = ...
    Yoruba: QLocale.Language = ...
    Zarma: QLocale.Language = ...
    Zhuang: QLocale.Language = ...
    LastLanguage: QLocale.Language = ...
    Zulu: QLocale.Language = ...
    MetricSystem: QLocale.MeasurementSystem = ...
    ImperialSystem: QLocale.MeasurementSystem = ...
    ImperialUSSystem: QLocale.MeasurementSystem = ...
    ImperialUKSystem: QLocale.MeasurementSystem = ...
    DefaultNumberOptions: QLocale.NumberOption = ...
    OmitGroupSeparator: QLocale.NumberOption = ...
    RejectGroupSeparator: QLocale.NumberOption = ...
    OmitLeadingZeroInExponent: QLocale.NumberOption = ...
    RejectLeadingZeroInExponent: QLocale.NumberOption = ...
    IncludeTrailingZeroesAfterDot: QLocale.NumberOption = ...
    RejectTrailingZeroesAfterDot: QLocale.NumberOption = ...
    StandardQuotation: QLocale.QuotationStyle = ...
    AlternateQuotation: QLocale.QuotationStyle = ...
    AnyScript: QLocale.Script = ...
    AdlamScript: QLocale.Script = ...
    AhomScript: QLocale.Script = ...
    AnatolianHieroglyphsScript: QLocale.Script = ...
    ArabicScript: QLocale.Script = ...
    ArmenianScript: QLocale.Script = ...
    AvestanScript: QLocale.Script = ...
    BalineseScript: QLocale.Script = ...
    BamumScript: QLocale.Script = ...
    BanglaScript: QLocale.Script = ...
    BengaliScript: QLocale.Script = ...
    BassaVahScript: QLocale.Script = ...
    BatakScript: QLocale.Script = ...
    BhaiksukiScript: QLocale.Script = ...
    BopomofoScript: QLocale.Script = ...
    BrahmiScript: QLocale.Script = ...
    BrailleScript: QLocale.Script = ...
    BugineseScript: QLocale.Script = ...
    BuhidScript: QLocale.Script = ...
    CanadianAboriginalScript: QLocale.Script = ...
    CarianScript: QLocale.Script = ...
    CaucasianAlbanianScript: QLocale.Script = ...
    ChakmaScript: QLocale.Script = ...
    ChamScript: QLocale.Script = ...
    CherokeeScript: QLocale.Script = ...
    CopticScript: QLocale.Script = ...
    CuneiformScript: QLocale.Script = ...
    CypriotScript: QLocale.Script = ...
    CyrillicScript: QLocale.Script = ...
    DeseretScript: QLocale.Script = ...
    DevanagariScript: QLocale.Script = ...
    DuployanScript: QLocale.Script = ...
    EgyptianHieroglyphsScript: QLocale.Script = ...
    ElbasanScript: QLocale.Script = ...
    EthiopicScript: QLocale.Script = ...
    FraserScript: QLocale.Script = ...
    GeorgianScript: QLocale.Script = ...
    GlagoliticScript: QLocale.Script = ...
    GothicScript: QLocale.Script = ...
    GranthaScript: QLocale.Script = ...
    GreekScript: QLocale.Script = ...
    GujaratiScript: QLocale.Script = ...
    GurmukhiScript: QLocale.Script = ...
    HangulScript: QLocale.Script = ...
    HanScript: QLocale.Script = ...
    HanunooScript: QLocale.Script = ...
    HanWithBopomofoScript: QLocale.Script = ...
    HatranScript: QLocale.Script = ...
    HebrewScript: QLocale.Script = ...
    HiraganaScript: QLocale.Script = ...
    ImperialAramaicScript: QLocale.Script = ...
    InscriptionalPahlaviScript: QLocale.Script = ...
    InscriptionalParthianScript: QLocale.Script = ...
    JamoScript: QLocale.Script = ...
    JapaneseScript: QLocale.Script = ...
    JavaneseScript: QLocale.Script = ...
    KaithiScript: QLocale.Script = ...
    KannadaScript: QLocale.Script = ...
    KatakanaScript: QLocale.Script = ...
    KayahLiScript: QLocale.Script = ...
    KharoshthiScript: QLocale.Script = ...
    KhmerScript: QLocale.Script = ...
    KhojkiScript: QLocale.Script = ...
    KhudawadiScript: QLocale.Script = ...
    KoreanScript: QLocale.Script = ...
    LannaScript: QLocale.Script = ...
    LaoScript: QLocale.Script = ...
    LatinScript: QLocale.Script = ...
    LepchaScript: QLocale.Script = ...
    LimbuScript: QLocale.Script = ...
    LinearAScript: QLocale.Script = ...
    LinearBScript: QLocale.Script = ...
    LycianScript: QLocale.Script = ...
    LydianScript: QLocale.Script = ...
    MahajaniScript: QLocale.Script = ...
    MalayalamScript: QLocale.Script = ...
    MandaeanScript: QLocale.Script = ...
    ManichaeanScript: QLocale.Script = ...
    MarchenScript: QLocale.Script = ...
    MeiteiMayekScript: QLocale.Script = ...
    MendeKikakuiScript: QLocale.Script = ...
    MendeScript: QLocale.Script = ...
    MeroiticCursiveScript: QLocale.Script = ...
    MeroiticScript: QLocale.Script = ...
    ModiScript: QLocale.Script = ...
    MongolianScript: QLocale.Script = ...
    MroScript: QLocale.Script = ...
    MultaniScript: QLocale.Script = ...
    MyanmarScript: QLocale.Script = ...
    NabataeanScript: QLocale.Script = ...
    NewaScript: QLocale.Script = ...
    NewTaiLueScript: QLocale.Script = ...
    NkoScript: QLocale.Script = ...
    OdiaScript: QLocale.Script = ...
    OriyaScript: QLocale.Script = ...
    OghamScript: QLocale.Script = ...
    OlChikiScript: QLocale.Script = ...
    OldHungarianScript: QLocale.Script = ...
    OldItalicScript: QLocale.Script = ...
    OldNorthArabianScript: QLocale.Script = ...
    OldPermicScript: QLocale.Script = ...
    OldPersianScript: QLocale.Script = ...
    OldSouthArabianScript: QLocale.Script = ...
    OrkhonScript: QLocale.Script = ...
    OsageScript: QLocale.Script = ...
    OsmanyaScript: QLocale.Script = ...
    PahawhHmongScript: QLocale.Script = ...
    PalmyreneScript: QLocale.Script = ...
    PauCinHauScript: QLocale.Script = ...
    PhagsPaScript: QLocale.Script = ...
    PhoenicianScript: QLocale.Script = ...
    PollardPhoneticScript: QLocale.Script = ...
    PsalterPahlaviScript: QLocale.Script = ...
    RejangScript: QLocale.Script = ...
    RunicScript: QLocale.Script = ...
    SamaritanScript: QLocale.Script = ...
    SaurashtraScript: QLocale.Script = ...
    SharadaScript: QLocale.Script = ...
    ShavianScript: QLocale.Script = ...
    SiddhamScript: QLocale.Script = ...
    SignWritingScript: QLocale.Script = ...
    SimplifiedChineseScript: QLocale.Script = ...
    SimplifiedHanScript: QLocale.Script = ...
    SinhalaScript: QLocale.Script = ...
    SoraSompengScript: QLocale.Script = ...
    SundaneseScript: QLocale.Script = ...
    SylotiNagriScript: QLocale.Script = ...
    SyriacScript: QLocale.Script = ...
    TagalogScript: QLocale.Script = ...
    TagbanwaScript: QLocale.Script = ...
    TaiLeScript: QLocale.Script = ...
    TaiVietScript: QLocale.Script = ...
    TakriScript: QLocale.Script = ...
    TamilScript: QLocale.Script = ...
    TangutScript: QLocale.Script = ...
    TeluguScript: QLocale.Script = ...
    ThaanaScript: QLocale.Script = ...
    ThaiScript: QLocale.Script = ...
    TibetanScript: QLocale.Script = ...
    TifinaghScript: QLocale.Script = ...
    TirhutaScript: QLocale.Script = ...
    TraditionalChineseScript: QLocale.Script = ...
    TraditionalHanScript: QLocale.Script = ...
    UgariticScript: QLocale.Script = ...
    VaiScript: QLocale.Script = ...
    VarangKshitiScript: QLocale.Script = ...
    LastScript: QLocale.Script = ...
    YiScript: QLocale.Script = ...

    class Country(Enum):
        AnyCountry: QLocale.Country = ...
        AnyTerritory: QLocale.Country = ...
        Afghanistan: QLocale.Country = ...
        AlandIslands: QLocale.Country = ...
        Albania: QLocale.Country = ...
        Algeria: QLocale.Country = ...
        AmericanSamoa: QLocale.Country = ...
        Andorra: QLocale.Country = ...
        Angola: QLocale.Country = ...
        Anguilla: QLocale.Country = ...
        Antarctica: QLocale.Country = ...
        AntiguaAndBarbuda: QLocale.Country = ...
        Argentina: QLocale.Country = ...
        Armenia: QLocale.Country = ...
        Aruba: QLocale.Country = ...
        AscensionIsland: QLocale.Country = ...
        Australia: QLocale.Country = ...
        Austria: QLocale.Country = ...
        Azerbaijan: QLocale.Country = ...
        Bahamas: QLocale.Country = ...
        Bahrain: QLocale.Country = ...
        Bangladesh: QLocale.Country = ...
        Barbados: QLocale.Country = ...
        Belarus: QLocale.Country = ...
        Belgium: QLocale.Country = ...
        Belize: QLocale.Country = ...
        Benin: QLocale.Country = ...
        Bermuda: QLocale.Country = ...
        Bhutan: QLocale.Country = ...
        Bolivia: QLocale.Country = ...
        BosniaAndHerzegovina: QLocale.Country = ...
        BosniaAndHerzegowina: QLocale.Country = ...
        Botswana: QLocale.Country = ...
        BouvetIsland: QLocale.Country = ...
        Brazil: QLocale.Country = ...
        BritishIndianOceanTerritory: QLocale.Country = ...
        BritishVirginIslands: QLocale.Country = ...
        Brunei: QLocale.Country = ...
        Bulgaria: QLocale.Country = ...
        BurkinaFaso: QLocale.Country = ...
        Burundi: QLocale.Country = ...
        Cambodia: QLocale.Country = ...
        Cameroon: QLocale.Country = ...
        Canada: QLocale.Country = ...
        CanaryIslands: QLocale.Country = ...
        CapeVerde: QLocale.Country = ...
        Bonaire: QLocale.Country = ...
        CaribbeanNetherlands: QLocale.Country = ...
        CaymanIslands: QLocale.Country = ...
        CentralAfricanRepublic: QLocale.Country = ...
        CeutaAndMelilla: QLocale.Country = ...
        Chad: QLocale.Country = ...
        Chile: QLocale.Country = ...
        China: QLocale.Country = ...
        ChristmasIsland: QLocale.Country = ...
        ClippertonIsland: QLocale.Country = ...
        CocosIslands: QLocale.Country = ...
        Colombia: QLocale.Country = ...
        Comoros: QLocale.Country = ...
        CongoBrazzaville: QLocale.Country = ...
        PeoplesRepublicOfCongo: QLocale.Country = ...
        CongoKinshasa: QLocale.Country = ...
        DemocraticRepublicOfCongo: QLocale.Country = ...
        CookIslands: QLocale.Country = ...
        CostaRica: QLocale.Country = ...
        Croatia: QLocale.Country = ...
        Cuba: QLocale.Country = ...
        CuraSao: QLocale.Country = ...
        Curacao: QLocale.Country = ...
        Cyprus: QLocale.Country = ...
        CzechRepublic: QLocale.Country = ...
        Czechia: QLocale.Country = ...
        Denmark: QLocale.Country = ...
        DiegoGarcia: QLocale.Country = ...
        Djibouti: QLocale.Country = ...
        Dominica: QLocale.Country = ...
        DominicanRepublic: QLocale.Country = ...
        Ecuador: QLocale.Country = ...
        Egypt: QLocale.Country = ...
        ElSalvador: QLocale.Country = ...
        EquatorialGuinea: QLocale.Country = ...
        Eritrea: QLocale.Country = ...
        Estonia: QLocale.Country = ...
        Eswatini: QLocale.Country = ...
        Swaziland: QLocale.Country = ...
        Ethiopia: QLocale.Country = ...
        Europe: QLocale.Country = ...
        EuropeanUnion: QLocale.Country = ...
        FalklandIslands: QLocale.Country = ...
        FaroeIslands: QLocale.Country = ...
        Fiji: QLocale.Country = ...
        Finland: QLocale.Country = ...
        France: QLocale.Country = ...
        FrenchGuiana: QLocale.Country = ...
        FrenchPolynesia: QLocale.Country = ...
        FrenchSouthernTerritories: QLocale.Country = ...
        Gabon: QLocale.Country = ...
        Gambia: QLocale.Country = ...
        Georgia: QLocale.Country = ...
        Germany: QLocale.Country = ...
        Ghana: QLocale.Country = ...
        Gibraltar: QLocale.Country = ...
        Greece: QLocale.Country = ...
        Greenland: QLocale.Country = ...
        Grenada: QLocale.Country = ...
        Guadeloupe: QLocale.Country = ...
        Guam: QLocale.Country = ...
        Guatemala: QLocale.Country = ...
        Guernsey: QLocale.Country = ...
        GuineaBissau: QLocale.Country = ...
        Guinea: QLocale.Country = ...
        Guyana: QLocale.Country = ...
        Haiti: QLocale.Country = ...
        HeardAndMcDonaldIslands: QLocale.Country = ...
        Honduras: QLocale.Country = ...
        HongKong: QLocale.Country = ...
        Hungary: QLocale.Country = ...
        Iceland: QLocale.Country = ...
        India: QLocale.Country = ...
        Indonesia: QLocale.Country = ...
        Iran: QLocale.Country = ...
        Iraq: QLocale.Country = ...
        Ireland: QLocale.Country = ...
        IsleOfMan: QLocale.Country = ...
        Israel: QLocale.Country = ...
        Italy: QLocale.Country = ...
        IvoryCoast: QLocale.Country = ...
        Jamaica: QLocale.Country = ...
        Japan: QLocale.Country = ...
        Jersey: QLocale.Country = ...
        Jordan: QLocale.Country = ...
        Kazakhstan: QLocale.Country = ...
        Kenya: QLocale.Country = ...
        Kiribati: QLocale.Country = ...
        Kosovo: QLocale.Country = ...
        Kuwait: QLocale.Country = ...
        Kyrgyzstan: QLocale.Country = ...
        Laos: QLocale.Country = ...
        LatinAmerica: QLocale.Country = ...
        LatinAmericaAndTheCaribbean: QLocale.Country = ...
        Latvia: QLocale.Country = ...
        Lebanon: QLocale.Country = ...
        Lesotho: QLocale.Country = ...
        Liberia: QLocale.Country = ...
        Libya: QLocale.Country = ...
        Liechtenstein: QLocale.Country = ...
        Lithuania: QLocale.Country = ...
        Luxembourg: QLocale.Country = ...
        Macao: QLocale.Country = ...
        Macau: QLocale.Country = ...
        Macedonia: QLocale.Country = ...
        Madagascar: QLocale.Country = ...
        Malawi: QLocale.Country = ...
        Malaysia: QLocale.Country = ...
        Maldives: QLocale.Country = ...
        Mali: QLocale.Country = ...
        Malta: QLocale.Country = ...
        MarshallIslands: QLocale.Country = ...
        Martinique: QLocale.Country = ...
        Mauritania: QLocale.Country = ...
        Mauritius: QLocale.Country = ...
        Mayotte: QLocale.Country = ...
        Mexico: QLocale.Country = ...
        Micronesia: QLocale.Country = ...
        Moldova: QLocale.Country = ...
        Monaco: QLocale.Country = ...
        Mongolia: QLocale.Country = ...
        Montenegro: QLocale.Country = ...
        Montserrat: QLocale.Country = ...
        Morocco: QLocale.Country = ...
        Mozambique: QLocale.Country = ...
        Myanmar: QLocale.Country = ...
        Namibia: QLocale.Country = ...
        NauruCountry: QLocale.Country = ...
        NauruTerritory: QLocale.Country = ...
        Nepal: QLocale.Country = ...
        Netherlands: QLocale.Country = ...
        NewCaledonia: QLocale.Country = ...
        NewZealand: QLocale.Country = ...
        Nicaragua: QLocale.Country = ...
        Nigeria: QLocale.Country = ...
        Niger: QLocale.Country = ...
        Niue: QLocale.Country = ...
        NorfolkIsland: QLocale.Country = ...
        NorthernMarianaIslands: QLocale.Country = ...
        DemocraticRepublicOfKorea: QLocale.Country = ...
        NorthKorea: QLocale.Country = ...
        Norway: QLocale.Country = ...
        Oman: QLocale.Country = ...
        OutlyingOceania: QLocale.Country = ...
        Pakistan: QLocale.Country = ...
        Palau: QLocale.Country = ...
        PalestinianTerritories: QLocale.Country = ...
        Panama: QLocale.Country = ...
        PapuaNewGuinea: QLocale.Country = ...
        Paraguay: QLocale.Country = ...
        Peru: QLocale.Country = ...
        Philippines: QLocale.Country = ...
        Pitcairn: QLocale.Country = ...
        Poland: QLocale.Country = ...
        Portugal: QLocale.Country = ...
        PuertoRico: QLocale.Country = ...
        Qatar: QLocale.Country = ...
        Reunion: QLocale.Country = ...
        Romania: QLocale.Country = ...
        Russia: QLocale.Country = ...
        RussianFederation: QLocale.Country = ...
        Rwanda: QLocale.Country = ...
        SaintBarthelemy: QLocale.Country = ...
        SaintHelena: QLocale.Country = ...
        SaintKittsAndNevis: QLocale.Country = ...
        SaintLucia: QLocale.Country = ...
        SaintMartin: QLocale.Country = ...
        SaintPierreAndMiquelon: QLocale.Country = ...
        SaintVincentAndGrenadines: QLocale.Country = ...
        SaintVincentAndTheGrenadines: QLocale.Country = ...
        Samoa: QLocale.Country = ...
        SanMarino: QLocale.Country = ...
        SaoTomeAndPrincipe: QLocale.Country = ...
        SaudiArabia: QLocale.Country = ...
        Senegal: QLocale.Country = ...
        Serbia: QLocale.Country = ...
        Seychelles: QLocale.Country = ...
        SierraLeone: QLocale.Country = ...
        Singapore: QLocale.Country = ...
        SintMaarten: QLocale.Country = ...
        Slovakia: QLocale.Country = ...
        Slovenia: QLocale.Country = ...
        SolomonIslands: QLocale.Country = ...
        Somalia: QLocale.Country = ...
        SouthAfrica: QLocale.Country = ...
        SouthGeorgiaAndSouthSandwichIslands: QLocale.Country = ...
        SouthGeorgiaAndTheSouthSandwichIslands: QLocale.Country = ...
        RepublicOfKorea: QLocale.Country = ...
        SouthKorea: QLocale.Country = ...
        SouthSudan: QLocale.Country = ...
        Spain: QLocale.Country = ...
        SriLanka: QLocale.Country = ...
        Sudan: QLocale.Country = ...
        Suriname: QLocale.Country = ...
        SvalbardAndJanMayen: QLocale.Country = ...
        SvalbardAndJanMayenIslands: QLocale.Country = ...
        Sweden: QLocale.Country = ...
        Switzerland: QLocale.Country = ...
        Syria: QLocale.Country = ...
        SyrianArabRepublic: QLocale.Country = ...
        Taiwan: QLocale.Country = ...
        Tajikistan: QLocale.Country = ...
        Tanzania: QLocale.Country = ...
        Thailand: QLocale.Country = ...
        EastTimor: QLocale.Country = ...
        TimorLeste: QLocale.Country = ...
        Togo: QLocale.Country = ...
        TokelauCountry: QLocale.Country = ...
        TokelauTerritory: QLocale.Country = ...
        Tonga: QLocale.Country = ...
        TrinidadAndTobago: QLocale.Country = ...
        TristanDaCunha: QLocale.Country = ...
        Tunisia: QLocale.Country = ...
        Turkey: QLocale.Country = ...
        Turkmenistan: QLocale.Country = ...
        TurksAndCaicosIslands: QLocale.Country = ...
        TuvaluCountry: QLocale.Country = ...
        TuvaluTerritory: QLocale.Country = ...
        Uganda: QLocale.Country = ...
        Ukraine: QLocale.Country = ...
        UnitedArabEmirates: QLocale.Country = ...
        UnitedKingdom: QLocale.Country = ...
        UnitedStatesMinorOutlyingIslands: QLocale.Country = ...
        UnitedStatesOutlyingIslands: QLocale.Country = ...
        UnitedStates: QLocale.Country = ...
        UnitedStatesVirginIslands: QLocale.Country = ...
        Uruguay: QLocale.Country = ...
        Uzbekistan: QLocale.Country = ...
        Vanuatu: QLocale.Country = ...
        VaticanCity: QLocale.Country = ...
        VaticanCityState: QLocale.Country = ...
        Venezuela: QLocale.Country = ...
        Vietnam: QLocale.Country = ...
        WallisAndFutuna: QLocale.Country = ...
        WallisAndFutunaIslands: QLocale.Country = ...
        WesternSahara: QLocale.Country = ...
        World: QLocale.Country = ...
        Yemen: QLocale.Country = ...
        Zambia: QLocale.Country = ...
        LastCountry: QLocale.Country = ...
        LastTerritory: QLocale.Country = ...
        Zimbabwe: QLocale.Country = ...

    class CurrencySymbolFormat(Enum):
        CurrencyIsoCode: QLocale.CurrencySymbolFormat = ...
        CurrencySymbol: QLocale.CurrencySymbolFormat = ...
        CurrencyDisplayName: QLocale.CurrencySymbolFormat = ...

    class DataSizeFormat(Enum):
        DataSizeIecFormat: QLocale.DataSizeFormat = ...
        DataSizeBase1000: QLocale.DataSizeFormat = ...
        DataSizeSIQuantifiers: QLocale.DataSizeFormat = ...
        DataSizeTraditionalFormat: QLocale.DataSizeFormat = ...
        DataSizeSIFormat: QLocale.DataSizeFormat = ...

    class DataSizeFormats(object):
        ...

    class FloatingPointPrecisionOption(Enum):
        FloatingPointShortest: QLocale.FloatingPointPrecisionOption = ...

    class FormatType(Enum):
        LongFormat: QLocale.FormatType = ...
        ShortFormat: QLocale.FormatType = ...
        NarrowFormat: QLocale.FormatType = ...

    class Language(Enum):
        AnyLanguage: QLocale.Language = ...
        C: QLocale.Language = ...
        Abkhazian: QLocale.Language = ...
        Afar: QLocale.Language = ...
        Afrikaans: QLocale.Language = ...
        Aghem: QLocale.Language = ...
        Akan: QLocale.Language = ...
        Akkadian: QLocale.Language = ...
        Akoose: QLocale.Language = ...
        Albanian: QLocale.Language = ...
        AmericanSignLanguage: QLocale.Language = ...
        Amharic: QLocale.Language = ...
        AncientEgyptian: QLocale.Language = ...
        AncientGreek: QLocale.Language = ...
        Arabic: QLocale.Language = ...
        Aragonese: QLocale.Language = ...
        Aramaic: QLocale.Language = ...
        Armenian: QLocale.Language = ...
        Assamese: QLocale.Language = ...
        Asturian: QLocale.Language = ...
        Asu: QLocale.Language = ...
        Atsam: QLocale.Language = ...
        Avaric: QLocale.Language = ...
        Avestan: QLocale.Language = ...
        Aymara: QLocale.Language = ...
        Azerbaijani: QLocale.Language = ...
        Bafia: QLocale.Language = ...
        Balinese: QLocale.Language = ...
        Bambara: QLocale.Language = ...
        Bamun: QLocale.Language = ...
        Bangla: QLocale.Language = ...
        Bengali: QLocale.Language = ...
        Basaa: QLocale.Language = ...
        Bashkir: QLocale.Language = ...
        Basque: QLocale.Language = ...
        BatakToba: QLocale.Language = ...
        Belarusian: QLocale.Language = ...
        Byelorussian: QLocale.Language = ...
        Bemba: QLocale.Language = ...
        Bena: QLocale.Language = ...
        Bhojpuri: QLocale.Language = ...
        Bislama: QLocale.Language = ...
        Blin: QLocale.Language = ...
        Bodo: QLocale.Language = ...
        Bosnian: QLocale.Language = ...
        Breton: QLocale.Language = ...
        Buginese: QLocale.Language = ...
        Bulgarian: QLocale.Language = ...
        Burmese: QLocale.Language = ...
        Cantonese: QLocale.Language = ...
        Catalan: QLocale.Language = ...
        Cebuano: QLocale.Language = ...
        CentralAtlasTamazight: QLocale.Language = ...
        CentralMoroccoTamazight: QLocale.Language = ...
        CentralKurdish: QLocale.Language = ...
        Chakma: QLocale.Language = ...
        Chamorro: QLocale.Language = ...
        Chechen: QLocale.Language = ...
        Cherokee: QLocale.Language = ...
        Chickasaw: QLocale.Language = ...
        Chiga: QLocale.Language = ...
        Chinese: QLocale.Language = ...
        Church: QLocale.Language = ...
        Chuvash: QLocale.Language = ...
        Colognian: QLocale.Language = ...
        Coptic: QLocale.Language = ...
        Cornish: QLocale.Language = ...
        Corsican: QLocale.Language = ...
        Cree: QLocale.Language = ...
        Croatian: QLocale.Language = ...
        Czech: QLocale.Language = ...
        Danish: QLocale.Language = ...
        Divehi: QLocale.Language = ...
        Dogri: QLocale.Language = ...
        Duala: QLocale.Language = ...
        Dutch: QLocale.Language = ...
        Bhutani: QLocale.Language = ...
        Dzongkha: QLocale.Language = ...
        Embu: QLocale.Language = ...
        English: QLocale.Language = ...
        Erzya: QLocale.Language = ...
        Esperanto: QLocale.Language = ...
        Estonian: QLocale.Language = ...
        Ewe: QLocale.Language = ...
        Ewondo: QLocale.Language = ...
        Faroese: QLocale.Language = ...
        Fijian: QLocale.Language = ...
        Filipino: QLocale.Language = ...
        Finnish: QLocale.Language = ...
        French: QLocale.Language = ...
        Friulian: QLocale.Language = ...
        Fulah: QLocale.Language = ...
        Gaelic: QLocale.Language = ...
        Ga: QLocale.Language = ...
        Galician: QLocale.Language = ...
        Ganda: QLocale.Language = ...
        Geez: QLocale.Language = ...
        Georgian: QLocale.Language = ...
        German: QLocale.Language = ...
        Gothic: QLocale.Language = ...
        Greek: QLocale.Language = ...
        Guarani: QLocale.Language = ...
        Gujarati: QLocale.Language = ...
        Gusii: QLocale.Language = ...
        Haitian: QLocale.Language = ...
        Hausa: QLocale.Language = ...
        Hawaiian: QLocale.Language = ...
        Hebrew: QLocale.Language = ...
        Herero: QLocale.Language = ...
        Hindi: QLocale.Language = ...
        HiriMotu: QLocale.Language = ...
        Hungarian: QLocale.Language = ...
        Icelandic: QLocale.Language = ...
        Ido: QLocale.Language = ...
        Igbo: QLocale.Language = ...
        InariSami: QLocale.Language = ...
        Indonesian: QLocale.Language = ...
        Ingush: QLocale.Language = ...
        Interlingua: QLocale.Language = ...
        Interlingue: QLocale.Language = ...
        Inuktitut: QLocale.Language = ...
        Inupiak: QLocale.Language = ...
        Inupiaq: QLocale.Language = ...
        Irish: QLocale.Language = ...
        Italian: QLocale.Language = ...
        Japanese: QLocale.Language = ...
        Javanese: QLocale.Language = ...
        Jju: QLocale.Language = ...
        JolaFonyi: QLocale.Language = ...
        Kabuverdianu: QLocale.Language = ...
        Kabyle: QLocale.Language = ...
        Kako: QLocale.Language = ...
        Greenlandic: QLocale.Language = ...
        Kalaallisut: QLocale.Language = ...
        Kalenjin: QLocale.Language = ...
        Kamba: QLocale.Language = ...
        Kannada: QLocale.Language = ...
        Kanuri: QLocale.Language = ...
        Kashmiri: QLocale.Language = ...
        Kazakh: QLocale.Language = ...
        Kenyang: QLocale.Language = ...
        Cambodian: QLocale.Language = ...
        Khmer: QLocale.Language = ...
        Kiche: QLocale.Language = ...
        Kikuyu: QLocale.Language = ...
        Kinyarwanda: QLocale.Language = ...
        Komi: QLocale.Language = ...
        Kongo: QLocale.Language = ...
        Konkani: QLocale.Language = ...
        Korean: QLocale.Language = ...
        Koro: QLocale.Language = ...
        KoyraboroSenni: QLocale.Language = ...
        KoyraChiini: QLocale.Language = ...
        Kpelle: QLocale.Language = ...
        Kuanyama: QLocale.Language = ...
        Kwanyama: QLocale.Language = ...
        Kurdish: QLocale.Language = ...
        Kwasio: QLocale.Language = ...
        Kirghiz: QLocale.Language = ...
        Kyrgyz: QLocale.Language = ...
        Lakota: QLocale.Language = ...
        Langi: QLocale.Language = ...
        Lao: QLocale.Language = ...
        Latin: QLocale.Language = ...
        Latvian: QLocale.Language = ...
        Lezghian: QLocale.Language = ...
        Limburgish: QLocale.Language = ...
        Lingala: QLocale.Language = ...
        LiteraryChinese: QLocale.Language = ...
        Lithuanian: QLocale.Language = ...
        Lojban: QLocale.Language = ...
        LowerSorbian: QLocale.Language = ...
        LowGerman: QLocale.Language = ...
        LubaKatanga: QLocale.Language = ...
        LuleSami: QLocale.Language = ...
        Luo: QLocale.Language = ...
        Luxembourgish: QLocale.Language = ...
        Luyia: QLocale.Language = ...
        Macedonian: QLocale.Language = ...
        Machame: QLocale.Language = ...
        Maithili: QLocale.Language = ...
        MakhuwaMeetto: QLocale.Language = ...
        Makonde: QLocale.Language = ...
        Malagasy: QLocale.Language = ...
        Malayalam: QLocale.Language = ...
        Malay: QLocale.Language = ...
        Maltese: QLocale.Language = ...
        Mandingo: QLocale.Language = ...
        Manipuri: QLocale.Language = ...
        Manx: QLocale.Language = ...
        Maori: QLocale.Language = ...
        Mapuche: QLocale.Language = ...
        Marathi: QLocale.Language = ...
        Marshallese: QLocale.Language = ...
        Masai: QLocale.Language = ...
        Mazanderani: QLocale.Language = ...
        Mende: QLocale.Language = ...
        Meru: QLocale.Language = ...
        Meta: QLocale.Language = ...
        Mohawk: QLocale.Language = ...
        Mongolian: QLocale.Language = ...
        Morisyen: QLocale.Language = ...
        Mundang: QLocale.Language = ...
        Muscogee: QLocale.Language = ...
        Nama: QLocale.Language = ...
        NauruLanguage: QLocale.Language = ...
        Navaho: QLocale.Language = ...
        Navajo: QLocale.Language = ...
        Ndonga: QLocale.Language = ...
        Nepali: QLocale.Language = ...
        Newari: QLocale.Language = ...
        Ngiemboon: QLocale.Language = ...
        Ngomba: QLocale.Language = ...
        NigerianPidgin: QLocale.Language = ...
        Nko: QLocale.Language = ...
        NorthernLuri: QLocale.Language = ...
        NorthernSami: QLocale.Language = ...
        NorthernSotho: QLocale.Language = ...
        NorthNdebele: QLocale.Language = ...
        NorwegianBokmal: QLocale.Language = ...
        NorwegianNynorsk: QLocale.Language = ...
        Nuer: QLocale.Language = ...
        Chewa: QLocale.Language = ...
        Nyanja: QLocale.Language = ...
        Nyankole: QLocale.Language = ...
        Occitan: QLocale.Language = ...
        Odia: QLocale.Language = ...
        Oriya: QLocale.Language = ...
        Ojibwa: QLocale.Language = ...
        OldIrish: QLocale.Language = ...
        OldNorse: QLocale.Language = ...
        OldPersian: QLocale.Language = ...
        Afan: QLocale.Language = ...
        Oromo: QLocale.Language = ...
        Osage: QLocale.Language = ...
        Ossetic: QLocale.Language = ...
        Pahlavi: QLocale.Language = ...
        Palauan: QLocale.Language = ...
        Pali: QLocale.Language = ...
        Papiamento: QLocale.Language = ...
        Pashto: QLocale.Language = ...
        Persian: QLocale.Language = ...
        Phoenician: QLocale.Language = ...
        Polish: QLocale.Language = ...
        Portuguese: QLocale.Language = ...
        Prussian: QLocale.Language = ...
        Punjabi: QLocale.Language = ...
        Quechua: QLocale.Language = ...
        Romanian: QLocale.Language = ...
        RhaetoRomance: QLocale.Language = ...
        Romansh: QLocale.Language = ...
        Rombo: QLocale.Language = ...
        Kurundi: QLocale.Language = ...
        Rundi: QLocale.Language = ...
        Russian: QLocale.Language = ...
        Rwa: QLocale.Language = ...
        Saho: QLocale.Language = ...
        Sakha: QLocale.Language = ...
        Samburu: QLocale.Language = ...
        Samoan: QLocale.Language = ...
        Sango: QLocale.Language = ...
        Sangu: QLocale.Language = ...
        Sanskrit: QLocale.Language = ...
        Santali: QLocale.Language = ...
        Sardinian: QLocale.Language = ...
        Saurashtra: QLocale.Language = ...
        Sena: QLocale.Language = ...
        Serbian: QLocale.Language = ...
        Shambala: QLocale.Language = ...
        Shona: QLocale.Language = ...
        SichuanYi: QLocale.Language = ...
        Sicilian: QLocale.Language = ...
        Sidamo: QLocale.Language = ...
        Silesian: QLocale.Language = ...
        Sindhi: QLocale.Language = ...
        Sinhala: QLocale.Language = ...
        SkoltSami: QLocale.Language = ...
        Slovak: QLocale.Language = ...
        Slovenian: QLocale.Language = ...
        Soga: QLocale.Language = ...
        Somali: QLocale.Language = ...
        SouthernKurdish: QLocale.Language = ...
        SouthernSami: QLocale.Language = ...
        SouthernSotho: QLocale.Language = ...
        SouthNdebele: QLocale.Language = ...
        Spanish: QLocale.Language = ...
        StandardMoroccanTamazight: QLocale.Language = ...
        Sundanese: QLocale.Language = ...
        Swahili: QLocale.Language = ...
        Swati: QLocale.Language = ...
        Swedish: QLocale.Language = ...
        SwissGerman: QLocale.Language = ...
        Syriac: QLocale.Language = ...
        Tachelhit: QLocale.Language = ...
        Tahitian: QLocale.Language = ...
        TaiDam: QLocale.Language = ...
        Taita: QLocale.Language = ...
        Tajik: QLocale.Language = ...
        Tamil: QLocale.Language = ...
        Taroko: QLocale.Language = ...
        Tasawaq: QLocale.Language = ...
        Tatar: QLocale.Language = ...
        Telugu: QLocale.Language = ...
        Teso: QLocale.Language = ...
        Thai: QLocale.Language = ...
        Tibetan: QLocale.Language = ...
        Tigre: QLocale.Language = ...
        Tigrinya: QLocale.Language = ...
        TokelauLanguage: QLocale.Language = ...
        TokPisin: QLocale.Language = ...
        Tongan: QLocale.Language = ...
        Tsonga: QLocale.Language = ...
        Tswana: QLocale.Language = ...
        Turkish: QLocale.Language = ...
        Turkmen: QLocale.Language = ...
        TuvaluLanguage: QLocale.Language = ...
        Tyap: QLocale.Language = ...
        Ugaritic: QLocale.Language = ...
        Ukrainian: QLocale.Language = ...
        UpperSorbian: QLocale.Language = ...
        Urdu: QLocale.Language = ...
        Uighur: QLocale.Language = ...
        Uigur: QLocale.Language = ...
        Uyghur: QLocale.Language = ...
        Uzbek: QLocale.Language = ...
        Vai: QLocale.Language = ...
        Venda: QLocale.Language = ...
        Vietnamese: QLocale.Language = ...
        Volapuk: QLocale.Language = ...
        Vunjo: QLocale.Language = ...
        Walloon: QLocale.Language = ...
        Walser: QLocale.Language = ...
        Warlpiri: QLocale.Language = ...
        Welsh: QLocale.Language = ...
        WesternBalochi: QLocale.Language = ...
        Frisian: QLocale.Language = ...
        WesternFrisian: QLocale.Language = ...
        Walamo: QLocale.Language = ...
        Wolaytta: QLocale.Language = ...
        Wolof: QLocale.Language = ...
        Xhosa: QLocale.Language = ...
        Yangben: QLocale.Language = ...
        Yiddish: QLocale.Language = ...
        Yoruba: QLocale.Language = ...
        Zarma: QLocale.Language = ...
        Zhuang: QLocale.Language = ...
        LastLanguage: QLocale.Language = ...
        Zulu: QLocale.Language = ...

    class MeasurementSystem(Enum):
        MetricSystem: QLocale.MeasurementSystem = ...
        ImperialSystem: QLocale.MeasurementSystem = ...
        ImperialUSSystem: QLocale.MeasurementSystem = ...
        ImperialUKSystem: QLocale.MeasurementSystem = ...

    class NumberOption(Enum):
        DefaultNumberOptions: QLocale.NumberOption = ...
        OmitGroupSeparator: QLocale.NumberOption = ...
        RejectGroupSeparator: QLocale.NumberOption = ...
        OmitLeadingZeroInExponent: QLocale.NumberOption = ...
        RejectLeadingZeroInExponent: QLocale.NumberOption = ...
        IncludeTrailingZeroesAfterDot: QLocale.NumberOption = ...
        RejectTrailingZeroesAfterDot: QLocale.NumberOption = ...

    class NumberOptions(object):
        ...

    class QuotationStyle(Enum):
        StandardQuotation: QLocale.QuotationStyle = ...
        AlternateQuotation: QLocale.QuotationStyle = ...

    class Script(Enum):
        AnyScript: QLocale.Script = ...
        AdlamScript: QLocale.Script = ...
        AhomScript: QLocale.Script = ...
        AnatolianHieroglyphsScript: QLocale.Script = ...
        ArabicScript: QLocale.Script = ...
        ArmenianScript: QLocale.Script = ...
        AvestanScript: QLocale.Script = ...
        BalineseScript: QLocale.Script = ...
        BamumScript: QLocale.Script = ...
        BanglaScript: QLocale.Script = ...
        BengaliScript: QLocale.Script = ...
        BassaVahScript: QLocale.Script = ...
        BatakScript: QLocale.Script = ...
        BhaiksukiScript: QLocale.Script = ...
        BopomofoScript: QLocale.Script = ...
        BrahmiScript: QLocale.Script = ...
        BrailleScript: QLocale.Script = ...
        BugineseScript: QLocale.Script = ...
        BuhidScript: QLocale.Script = ...
        CanadianAboriginalScript: QLocale.Script = ...
        CarianScript: QLocale.Script = ...
        CaucasianAlbanianScript: QLocale.Script = ...
        ChakmaScript: QLocale.Script = ...
        ChamScript: QLocale.Script = ...
        CherokeeScript: QLocale.Script = ...
        CopticScript: QLocale.Script = ...
        CuneiformScript: QLocale.Script = ...
        CypriotScript: QLocale.Script = ...
        CyrillicScript: QLocale.Script = ...
        DeseretScript: QLocale.Script = ...
        DevanagariScript: QLocale.Script = ...
        DuployanScript: QLocale.Script = ...
        EgyptianHieroglyphsScript: QLocale.Script = ...
        ElbasanScript: QLocale.Script = ...
        EthiopicScript: QLocale.Script = ...
        FraserScript: QLocale.Script = ...
        GeorgianScript: QLocale.Script = ...
        GlagoliticScript: QLocale.Script = ...
        GothicScript: QLocale.Script = ...
        GranthaScript: QLocale.Script = ...
        GreekScript: QLocale.Script = ...
        GujaratiScript: QLocale.Script = ...
        GurmukhiScript: QLocale.Script = ...
        HangulScript: QLocale.Script = ...
        HanScript: QLocale.Script = ...
        HanunooScript: QLocale.Script = ...
        HanWithBopomofoScript: QLocale.Script = ...
        HatranScript: QLocale.Script = ...
        HebrewScript: QLocale.Script = ...
        HiraganaScript: QLocale.Script = ...
        ImperialAramaicScript: QLocale.Script = ...
        InscriptionalPahlaviScript: QLocale.Script = ...
        InscriptionalParthianScript: QLocale.Script = ...
        JamoScript: QLocale.Script = ...
        JapaneseScript: QLocale.Script = ...
        JavaneseScript: QLocale.Script = ...
        KaithiScript: QLocale.Script = ...
        KannadaScript: QLocale.Script = ...
        KatakanaScript: QLocale.Script = ...
        KayahLiScript: QLocale.Script = ...
        KharoshthiScript: QLocale.Script = ...
        KhmerScript: QLocale.Script = ...
        KhojkiScript: QLocale.Script = ...
        KhudawadiScript: QLocale.Script = ...
        KoreanScript: QLocale.Script = ...
        LannaScript: QLocale.Script = ...
        LaoScript: QLocale.Script = ...
        LatinScript: QLocale.Script = ...
        LepchaScript: QLocale.Script = ...
        LimbuScript: QLocale.Script = ...
        LinearAScript: QLocale.Script = ...
        LinearBScript: QLocale.Script = ...
        LycianScript: QLocale.Script = ...
        LydianScript: QLocale.Script = ...
        MahajaniScript: QLocale.Script = ...
        MalayalamScript: QLocale.Script = ...
        MandaeanScript: QLocale.Script = ...
        ManichaeanScript: QLocale.Script = ...
        MarchenScript: QLocale.Script = ...
        MeiteiMayekScript: QLocale.Script = ...
        MendeKikakuiScript: QLocale.Script = ...
        MendeScript: QLocale.Script = ...
        MeroiticCursiveScript: QLocale.Script = ...
        MeroiticScript: QLocale.Script = ...
        ModiScript: QLocale.Script = ...
        MongolianScript: QLocale.Script = ...
        MroScript: QLocale.Script = ...
        MultaniScript: QLocale.Script = ...
        MyanmarScript: QLocale.Script = ...
        NabataeanScript: QLocale.Script = ...
        NewaScript: QLocale.Script = ...
        NewTaiLueScript: QLocale.Script = ...
        NkoScript: QLocale.Script = ...
        OdiaScript: QLocale.Script = ...
        OriyaScript: QLocale.Script = ...
        OghamScript: QLocale.Script = ...
        OlChikiScript: QLocale.Script = ...
        OldHungarianScript: QLocale.Script = ...
        OldItalicScript: QLocale.Script = ...
        OldNorthArabianScript: QLocale.Script = ...
        OldPermicScript: QLocale.Script = ...
        OldPersianScript: QLocale.Script = ...
        OldSouthArabianScript: QLocale.Script = ...
        OrkhonScript: QLocale.Script = ...
        OsageScript: QLocale.Script = ...
        OsmanyaScript: QLocale.Script = ...
        PahawhHmongScript: QLocale.Script = ...
        PalmyreneScript: QLocale.Script = ...
        PauCinHauScript: QLocale.Script = ...
        PhagsPaScript: QLocale.Script = ...
        PhoenicianScript: QLocale.Script = ...
        PollardPhoneticScript: QLocale.Script = ...
        PsalterPahlaviScript: QLocale.Script = ...
        RejangScript: QLocale.Script = ...
        RunicScript: QLocale.Script = ...
        SamaritanScript: QLocale.Script = ...
        SaurashtraScript: QLocale.Script = ...
        SharadaScript: QLocale.Script = ...
        ShavianScript: QLocale.Script = ...
        SiddhamScript: QLocale.Script = ...
        SignWritingScript: QLocale.Script = ...
        SimplifiedChineseScript: QLocale.Script = ...
        SimplifiedHanScript: QLocale.Script = ...
        SinhalaScript: QLocale.Script = ...
        SoraSompengScript: QLocale.Script = ...
        SundaneseScript: QLocale.Script = ...
        SylotiNagriScript: QLocale.Script = ...
        SyriacScript: QLocale.Script = ...
        TagalogScript: QLocale.Script = ...
        TagbanwaScript: QLocale.Script = ...
        TaiLeScript: QLocale.Script = ...
        TaiVietScript: QLocale.Script = ...
        TakriScript: QLocale.Script = ...
        TamilScript: QLocale.Script = ...
        TangutScript: QLocale.Script = ...
        TeluguScript: QLocale.Script = ...
        ThaanaScript: QLocale.Script = ...
        ThaiScript: QLocale.Script = ...
        TibetanScript: QLocale.Script = ...
        TifinaghScript: QLocale.Script = ...
        TirhutaScript: QLocale.Script = ...
        TraditionalChineseScript: QLocale.Script = ...
        TraditionalHanScript: QLocale.Script = ...
        UgariticScript: QLocale.Script = ...
        VaiScript: QLocale.Script = ...
        VarangKshitiScript: QLocale.Script = ...
        LastScript: QLocale.Script = ...
        YiScript: QLocale.Script = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale

        **QLocale::QLocale()**

        Constructs a QLocale object initialized with the default locale.

        If no default locale was set using **setDefault** (), this locale will
        be the same as the one returned by **system** ().

        **See also** **setDefault** ().
        """
        ...

    @overload
    def __init__(
        self,
        language: PySide6.QtCore.QLocale.Language,
        script: PySide6.QtCore.QLocale.Script = ...,
        territory: PySide6.QtCore.QLocale.Country = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-1

        **QLocale::QLocale(const QString & name )**

        Constructs a QLocale object with the specified **name** , which has the
        format "language[_script][_territory][.codeset][@modifier]" or "C",
        where:

        * language is a lowercase, two-letter, ISO 639 language code (some
        three-letter codes are also recognized),
          * script is a capitalized,
        four-letter, ISO 15924 script code,
          * territory is an uppercase, two-
        letter, ISO 3166 territory code (some numeric codes are also
        recognized), and
          * codeset and modifier are ignored.

        The separator can be either underscore `'_'` (U+005F, "low line") or a
        dash `'-'` (U+002D, "hyphen-minus"). If QLocale has no data for the
        specified combination of language, script, and territory, then it uses
        the most suitable match it can find instead. If the string violates the
        locale format, or no suitable data can be found for the specified keys,
        the "C" locale is used instead.

        This constructor is much slower than QLocale(Language, Script,
        Territory) or QLocale(Language, Territory).

        **See also** **bcp47Name** () and **Matching combinations of language,
        script and territory** .
        """
        ...

    @overload
    def __init__(
        self,
        language: PySide6.QtCore.QLocale.Language,
        territory: PySide6.QtCore.QLocale.Country,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-2

        **QLocale::QLocale(QLocale::Language language , QLocale::Territory
        territory )**

        Constructs a QLocale object for the specified **language** and
        **territory**.

        If there is more than one script in use for this combination, a likely
        script will be selected. If QLocale has no data for the specified
        **language** , the default locale is used. If QLocale has no data for
        the specified combination of **language** and **territory** , an
        alternative territory may be used instead.

        **See also** **setDefault** () and **Matching combinations of language,
        script and territory** .
        """
        ...

    @overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-3

        **QLocale::QLocale(QLocale::Language language , QLocale::Script script =
        AnyScript, QLocale::Territory territory = AnyTerritory)**

        Constructs a QLocale object for the specified **language** , **script**
        and **territory**.

        If QLocale does not have data for the given combination, it will find
        data for as good a match as it can. It falls back on the default locale
        if

        * **language** is `AnyLanguage` and no language can be inferred from
        **script** and **territory**
          * QLocale has no data for the language,
        either given as **language** or inferred as above.

        **See also** **setDefault** () and **Matching combinations of language,
        script and territory** .
        """
        ...

    @overload
    def __init__(
        self, other: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-4

        **QLocale::QLocale(const QLocale & other )**

        Constructs a QLocale object as a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def amText(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#amText

        **QString QLocale::amText() const**

        Returns the localized name of the "AM" suffix for times specified using
        the conventions of the 12-hour clock.

        **See also** **pmText** ().
        """
        ...

    def bcp47Name(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#bcp47Name

        **QString QLocale::bcp47Name() const**

        Returns the dash-separated language, script and country (and possibly
        other BCP47 fields) of this locale as a string.

        Unlike the **uiLanguages** () the returned value of the bcp47Name()
        represents the locale name of the **QLocale**  data but not the language
        the user-interface should be in.

        This function tries to conform the locale name to BCP47.

        **See also** **language** (), **territory** (), **script** (), and
        **uiLanguages** ().
        """
        ...

    @staticmethod
    def c() -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qlocale.html#c

        **[static] QLocale QLocale::c()**

        Returns a **QLocale**  object initialized to the "C" locale.

        This locale is based on en_US but with various quirks of its own, such
        as simplified number formatting and its own date formatting. It
        implements the POSIX standards that describe the behavior of standard
        library functions of the "C" programming language.

        Among other things, this means its collation order is based on the ASCII
        values of letters, so that (for case-sensitive sorting) all upper-case
        letters sort before any lower-case one (rather than each letter's upper-
        and lower-case forms sorting adjacent to one another, before the next
        letter's two forms).

        **See also** **system** ().
        """
        ...

    @staticmethod
    def codeToCountry(countryCode: str) -> PySide6.QtCore.QLocale.Country:
        ...

    @staticmethod
    def codeToLanguage(languageCode: str) -> PySide6.QtCore.QLocale.Language:
        """
        https://doc.qt.io/qt-6/qlocale.html#codeToLanguage

        **[static, since 6.1] QLocale::Language
        QLocale::codeToLanguage(QStringView languageCode )**

        Returns the **QLocale::Language**  enum corresponding to the two- or
        three-letter **languageCode** , as defined in the ISO 639 standards.

        If the code is invalid or not known **QLocale::AnyLanguage**  is
        returned.

        This function was introduced in Qt 6.1.

        **See also** **languageToCode** (), **codeToTerritory** (), and
        **codeToScript** ().
        """
        ...

    @staticmethod
    def codeToScript(scriptCode: str) -> PySide6.QtCore.QLocale.Script:
        """
        https://doc.qt.io/qt-6/qlocale.html#codeToScript

        **[static, since 6.1] QLocale::Script QLocale::codeToScript(QStringView
        scriptCode )**

        Returns the **QLocale::Script**  enum corresponding to the four-letter
        script **scriptCode** , as defined in the ISO 15924 standard.

        If the code is invalid or not known **QLocale::AnyScript**  is returned.

        This function was introduced in Qt 6.1.

        **See also** **scriptToCode** (), **codeToLanguage** (), and
        **codeToTerritory** ().
        """
        ...

    @staticmethod
    def codeToTerritory(territoryCode: str) -> PySide6.QtCore.QLocale.Country:
        """
        https://doc.qt.io/qt-6/qlocale.html#codeToTerritory

        **[static, since 6.2] QLocale::Territory
        QLocale::codeToTerritory(QStringView territoryCode )**

        Returns the QLocale::Territory enum corresponding to the two-letter or
        three-digit **territoryCode** , as defined in the ISO 3166 standard.

        If the code is invalid or not known **QLocale::AnyTerritory**  is
        returned.

        This function was introduced in Qt 6.2.

        **See also** **territoryToCode** (), **codeToLanguage** (), and
        **codeToScript** ().
        """
        ...

    def collation(self) -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qlocale.html#collation

        **[since 5.13] QLocale QLocale::collation() const**

        Returns the locale to use for collation.

        The result is usually this locale; however, the system locale (which is
        commonly the default locale) will return the system collation locale.
        The result is suitable for passing to **QCollator** 's constructor.

        This function was introduced in Qt 5.13.

        **See also** **QCollator** .
        """
        ...

    @staticmethod
    def countriesForLanguage(
        lang: PySide6.QtCore.QLocale.Language,
    ) -> List[PySide6.QtCore.QLocale.Country]:
        ...

    def country(self) -> PySide6.QtCore.QLocale.Country:
        ...

    @staticmethod
    def countryToCode(country: PySide6.QtCore.QLocale.Country) -> str:
        ...

    @staticmethod
    def countryToString(country: PySide6.QtCore.QLocale.Country) -> str:
        ...

    def createSeparatedList(self, strl: Sequence[str]) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#createSeparatedList

        **QString QLocale::createSeparatedList(const QStringList & list )
        const**

        Returns a string that represents a join of a given **list** of strings
        with a separator defined by the locale.
        """
        ...

    def currencySymbol(
        self, arg__1: PySide6.QtCore.QLocale.CurrencySymbolFormat = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#currencySymbol

        **QString QLocale::currencySymbol(QLocale::CurrencySymbolFormat format =
        CurrencySymbol) const**

        Returns a currency symbol according to the **format**.
        """
        ...

    def dateFormat(self, format: PySide6.QtCore.QLocale.FormatType = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#dateFormat

        **QString QLocale::dateFormat(QLocale::FormatType format = LongFormat)
        const**

        Returns the date format used for the current locale.

        If **format** is **LongFormat** , the format will be elaborate,
        otherwise it will be short. For example, **LongFormat**  for the `en_US`
        locale is `dddd, MMMM d, yyyy`, **ShortFormat**  is `M/d/yy`.

        **See also** **QDate::toString** () and **QDate::fromString** ().
        """
        ...

    def dateTimeFormat(self, format: PySide6.QtCore.QLocale.FormatType = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#dateTimeFormat

        **QString QLocale::dateTimeFormat(QLocale::FormatType format =
        LongFormat) const**

        Returns the date time format used for the current locale.

        If **format** is **LongFormat** , the format will be elaborate,
        otherwise it will be short. For example, **LongFormat**  for the `en_US`
        locale is `dddd, MMMM d, yyyy h:mm:ss AP t`, **ShortFormat**  is `M/d/yy
        h:mm AP`.

        **See also** **QDateTime::toString** () and **QDateTime::fromString**
        ().
        """
        ...

    def dayName(
        self, arg__1: int, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#dayName

        **QString QLocale::dayName(int day , QLocale::FormatType type =
        LongFormat) const**

        Returns the localized name of the **day** (where 1 represents Monday, 2
        represents Tuesday and so on), in the format specified by **type**.

        For example, if the locale is `en_US` and **day** is 1, **LongFormat**
        will return `Monday`, **ShortFormat**  `Mon`, and **NarrowFormat**  `M`.

        **See also** **monthName** () and **standaloneDayName** ().
        """
        ...

    def decimalPoint(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#decimalPoint

        **QString QLocale::decimalPoint() const**

        Returns the decimal point character of this locale.

        **See also** **groupSeparator** () and **toString** ().
        """
        ...

    def exponential(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#exponential

        **QString QLocale::exponential() const**

        Returns the exponential character of this locale, used to separate
        exponent from mantissa in some floating-point numeric representations.

        **See also** **toString** (double, char, int).
        """
        ...

    def firstDayOfWeek(self) -> PySide6.QtCore.Qt.DayOfWeek:
        """
        https://doc.qt.io/qt-6/qlocale.html#firstDayOfWeek

        **Qt::DayOfWeek QLocale::firstDayOfWeek() const**

        Returns the first day of the week according to the current locale.
        """
        ...

    def formattedDataSize(
        self,
        bytes: int,
        precision: int = ...,
        format: PySide6.QtCore.QLocale.DataSizeFormats = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#formattedDataSize

        **[since 5.10] QString QLocale::formattedDataSize(qint64 bytes , int
        precision = 2, QLocale::DataSizeFormats format = DataSizeIecFormat)
        const**

        Converts a size in bytes to a human-readable localized string,
        comprising a number and a quantified unit. The quantifier is chosen such
        that the number is at least one, and as small as possible. For example
        if **bytes** is 16384, **precision** is 2, and **format** is
        **DataSizeIecFormat**  (the default), this function returns "16.00 KiB";
        for 1330409069609 bytes it returns "1.21 GiB"; and so on. If **format**
        is **DataSizeIecFormat**  or **DataSizeTraditionalFormat** , the given
        number of bytes is divided by a power of 1024, with result less than
        1024; for **DataSizeSIFormat** , it is divided by a power of 1000, with
        result less than 1000. `DataSizeIecFormat` uses the new IEC standard
        quantifiers Ki, Mi and so on, whereas `DataSizeSIFormat` uses the older
        SI quantifiers k, M, etc., and `DataSizeTraditionalFormat` abuses them.

        This function was introduced in Qt 5.10.
        """
        ...

    def groupSeparator(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#groupSeparator

        **QString QLocale::groupSeparator() const**

        Returns the group separator character of this locale.

        **See also** **decimalPoint** () and **toString** ().
        """
        ...

    def language(self) -> PySide6.QtCore.QLocale.Language:
        """
        https://doc.qt.io/qt-6/qlocale.html#language

        **QLocale::Language QLocale::language() const**

        Returns the language of this locale.

        **See also** **script** (), **territory** (), **languageToString** (),
        and **bcp47Name** ().
        """
        ...

    @staticmethod
    def languageToCode(language: PySide6.QtCore.QLocale.Language) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#languageToCode

        **[static, since 6.1] QString QLocale::languageToCode(QLocale::Language
        language )**

        Returns the two- or three-letter language code for **language** , as
        defined in the ISO 639 standards.

        **Note:** For `QLocale::C` the function returns `"C"`. For
        `QLocale::AnyLanguage` an empty string is returned.

        This function was introduced in Qt 6.1.

        **See also** **codeToLanguage** (), **language** (), **name** (),
        **bcp47Name** (), **territoryToCode** (), and **scriptToCode** ().
        """
        ...

    @staticmethod
    def languageToString(language: PySide6.QtCore.QLocale.Language) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#languageToString

        **[static] QString QLocale::languageToString(QLocale::Language language
        )**

        Returns a **QString**  containing the name of **language**.

        **See also** **territoryToString** (), **scriptToString** (), and
        **bcp47Name** ().
        """
        ...

    @staticmethod
    def matchingLocales(
        language: PySide6.QtCore.QLocale.Language,
        script: PySide6.QtCore.QLocale.Script,
        territory: PySide6.QtCore.QLocale.Country,
    ) -> List[PySide6.QtCore.QLocale]:
        """
        https://doc.qt.io/qt-6/qlocale.html#matchingLocales

        **[static] QList<QLocale> QLocale::matchingLocales(QLocale::Language
        language , QLocale::Script script , QLocale::Territory territory )**

        Returns a list of valid locale objects that match the given **language**
        , **script** and **territory**.

        Getting a list of all locales: **QList** <**QLocale** > allLocales =
        QLocale::matchingLocales(**QLocale::AnyLanguage** ,
        **QLocale::AnyScript** , **QLocale::AnyTerritory** );

        Getting a list of locales suitable for Russia: **QList** <**QLocale** >
        locales = QLocale::matchingLocales(**QLocale::AnyLanguage** ,
        **QLocale::AnyScript** , **QLocale::Russia** );
        """
        ...

    def measurementSystem(self) -> PySide6.QtCore.QLocale.MeasurementSystem:
        """
        https://doc.qt.io/qt-6/qlocale.html#measurementSystem

        **QLocale::MeasurementSystem QLocale::measurementSystem() const**

        Returns the measurement system for the locale.
        """
        ...

    def monthName(
        self, arg__1: int, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#monthName

        **QString QLocale::monthName(int month , QLocale::FormatType type =
        LongFormat) const**

        Returns the localized name of **month** , in the format specified by
        **type**.

        For example, if the locale is `en_US` and **month** is 1, **LongFormat**
        will return `January`. **ShortFormat**  `Jan`, and **NarrowFormat**
        `J`.

        **See also** **dayName** () and **standaloneMonthName** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#name

        **QString QLocale::name() const**

        Returns the language and country of this locale as a string of the form
        "language_country", where language is a lowercase, two-letter ISO 639
        language code, and country is an uppercase, two- or three-letter ISO
        3166 country code.

        Note that even if **QLocale**  object was constructed with an explicit
        script, name() will not contain it for compatibility reasons. Use
        **bcp47Name** () instead if you need a full locale name.

        **See also** **QLocale** (), **language** (), **script** (),
        **territory** (), and **bcp47Name** ().
        """
        ...

    def nativeCountryName(self) -> str:
        ...

    def nativeLanguageName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#nativeLanguageName

        **QString QLocale::nativeLanguageName() const**

        Returns a native name of the language for the locale. For example
        "Schwiizertüütsch" for Swiss-German locale.

        **See also** **nativeTerritoryName** () and **languageToString** ().
        """
        ...

    def nativeTerritoryName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#nativeTerritoryName

        **[since 6.2] QString QLocale::nativeTerritoryName() const**

        Returns a native name of the territory for the locale. For example
        "España" for Spanish/Spain locale.

        This function was introduced in Qt 6.2.

        **See also** **nativeLanguageName** () and **territoryToString** ().
        """
        ...

    def negativeSign(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#negativeSign

        **QString QLocale::negativeSign() const**

        Returns the negative sign character of this locale.

        **See also** **positiveSign** () and **toString** ().
        """
        ...

    def numberOptions(self) -> PySide6.QtCore.QLocale.NumberOptions:
        """
        https://doc.qt.io/qt-6/qlocale.html#numberOptions

        **QLocale::NumberOptions QLocale::numberOptions() const**

        Returns the options related to number conversions for this **QLocale**
        instance.

        By default, no options are set for the standard locales, except for the
        "C" locale, which has **OmitGroupSeparator**  set by default.

        **See also** **setNumberOptions** (), **toString** (),
        **groupSeparator** (), and **FloatingPointPrecisionOption** .
        """
        ...

    def percent(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#percent

        **QString QLocale::percent() const**

        Returns the percent character of this locale.

        **See also** **toString** ().
        """
        ...

    def pmText(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#pmText

        **QString QLocale::pmText() const**

        Returns the localized name of the "PM" suffix for times specified using
        the conventions of the 12-hour clock.

        **See also** **amText** ().
        """
        ...

    def positiveSign(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#positiveSign

        **QString QLocale::positiveSign() const**

        Returns the positive sign character of this locale.

        **See also** **negativeSign** () and **toString** ().
        """
        ...

    def quoteString(
        self, str: str, style: PySide6.QtCore.QLocale.QuotationStyle = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#quoteString

        **QString QLocale::quoteString(const QString & str ,
        QLocale::QuotationStyle style = StandardQuotation) const**

        Returns **str** quoted according to the current locale using the given
        quotation **style**.
        """
        ...

    def script(self) -> PySide6.QtCore.QLocale.Script:
        """
        https://doc.qt.io/qt-6/qlocale.html#script

        **QLocale::Script QLocale::script() const**

        Returns the script of this locale.

        **See also** **language** (), **territory** (), **languageToString** (),
        **scriptToString** (), and **bcp47Name** ().
        """
        ...

    @staticmethod
    def scriptToCode(script: PySide6.QtCore.QLocale.Script) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#scriptToCode

        **[static, since 6.1] QString QLocale::scriptToCode(QLocale::Script
        script )**

        Returns the four-letter script code for **script** , as defined in the
        ISO 15924 standard.

        **Note:** For `QLocale::AnyScript` an empty string is returned.

        This function was introduced in Qt 6.1.

        **See also** **script** (), **name** (), **bcp47Name** (),
        **languageToCode** (), and **territoryToCode** ().
        """
        ...

    @staticmethod
    def scriptToString(script: PySide6.QtCore.QLocale.Script) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#scriptToString

        **[static] QString QLocale::scriptToString(QLocale::Script script )**

        Returns a **QString**  containing the name of **script**.

        **See also** **languageToString** (), **territoryToString** (),
        **script** (), and **bcp47Name** ().
        """
        ...

    @staticmethod
    def setDefault(
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#setDefault

        **[static] void QLocale::setDefault(const QLocale & locale )**

        Sets the global default locale to **locale**. These values are used when
        a **QLocale**  object is constructed with no arguments. If this function
        is not called, the system's locale is used.

        **Warning:** In a multithreaded application, the default locale should
        be set at application startup, before any non-GUI threads are created.

        **Warning:** This function is not **reentrant** .

        **See also** **system** () and **c** ().
        """
        ...

    def setNumberOptions(self, options: PySide6.QtCore.QLocale.NumberOptions) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#setNumberOptions

        **void QLocale::setNumberOptions(QLocale::NumberOptions options )**

        Sets the **options** related to number conversions for this **QLocale**
        instance.

        **See also** **numberOptions** () and **FloatingPointPrecisionOption** .
        """
        ...

    def standaloneDayName(
        self, arg__1: int, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#standaloneDayName

        **QString QLocale::standaloneDayName(int day , QLocale::FormatType type
        = LongFormat) const**

        Returns the localized name of the **day** (where 1 represents Monday, 2
        represents Tuesday and so on) that is used as a standalone text, in the
        format specified by **type**.

        If the locale information does not specify the standalone day name then
        return value is the same as in **dayName** ().

        **See also** **dayName** () and **standaloneMonthName** ().
        """
        ...

    def standaloneMonthName(
        self, arg__1: int, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#standaloneMonthName

        **QString QLocale::standaloneMonthName(int month , QLocale::FormatType
        type = LongFormat) const**

        Returns the localized name of **month** that is used as a standalone
        text, in the format specified by **type**.

        If the locale information doesn't specify the standalone month name then
        return value is the same as in **monthName** ().

        **See also** **monthName** () and **standaloneDayName** ().
        """
        ...

    def swap(
        self, other: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#swap

        **[since 5.6] void QLocale::swap(QLocale & other )**

        Swaps locale **other** with this locale. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.6.
        """
        ...

    @staticmethod
    def system() -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qlocale.html#system

        **[static] QLocale QLocale::system()**

        Returns a **QLocale**  object initialized to the system locale.

        The system locale may use system-specific sources for locale data, where
        available, otherwise falling back on **QLocale** 's built-in database
        entry for the language, script and territory the system reports.

        For example, on Windows and Mac, this locale will use the
        decimal/grouping characters and date/time formats specified in the
        system configuration panel.

        **See also** **c** ().
        """
        ...

    def territory(self) -> PySide6.QtCore.QLocale.Country:
        """
        https://doc.qt.io/qt-6/qlocale.html#territory

        **[since 6.2] QLocale::Territory QLocale::territory() const**

        Returns the territory of this locale.

        This function was introduced in Qt 6.2.

        **See also** **language** (), **script** (), **territoryToString** (),
        and **bcp47Name** ().
        """
        ...

    @staticmethod
    def territoryToCode(territory: PySide6.QtCore.QLocale.Country) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#territoryToCode

        **[static, since 6.2] QString
        QLocale::territoryToCode(QLocale::Territory territory )**

        Returns the two-letter territory code for **territory** , as defined in
        the ISO 3166 standard.

        **Note:** For `QLocale::AnyTerritory` an empty string is returned.

        This function was introduced in Qt 6.2.

        **See also** **codeToTerritory** (), **territory** (), **name** (),
        **bcp47Name** (), **languageToCode** (), and **scriptToCode** ().
        """
        ...

    @staticmethod
    def territoryToString(territory: PySide6.QtCore.QLocale.Country) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#territoryToString

        **[static, since 6.2] QString
        QLocale::territoryToString(QLocale::Territory territory )**

        Returns a **QString**  containing the name of **territory**.

        This function was introduced in Qt 6.2.

        **See also** **languageToString** (), **scriptToString** (),
        **territory** (), and **bcp47Name** ().
        """
        ...

    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qlocale.html#textDirection

        **Qt::LayoutDirection QLocale::textDirection() const**

        Returns the text direction of the language.
        """
        ...

    def timeFormat(self, format: PySide6.QtCore.QLocale.FormatType = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#timeFormat

        **QString QLocale::timeFormat(QLocale::FormatType format = LongFormat)
        const**

        Returns the time format used for the current locale.

        If **format** is **LongFormat** , the format will be elaborate,
        otherwise it will be short. For example, **LongFormat**  for the `en_US`
        locale is `h:mm:ss AP t`, **ShortFormat**  is `h:mm AP`.

        **See also** **QTime::toString** () and **QTime::fromString** ().
        """
        ...

    @overload
    def toCurrencyString(
        self, arg__1: float, symbol: str = ..., precision: int = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString

        **QString QLocale::toCurrencyString(qlonglong value , const QString &
        symbol = QString()) const**

        Returns a localized string representation of **value** as a currency. If
        the **symbol** is provided it is used instead of the default currency
        symbol.

        **See also** **currencySymbol** ().
        """
        ...

    @overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-1

        **QString QLocale::toCurrencyString(qulonglong value , const QString &
        symbol = QString()) const**

        This is an overloaded function.
        """
        ...

    @overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-2

        **QString QLocale::toCurrencyString(short value , const QString & symbol
        = QString()) const**

        This is an overloaded function.
        """
        ...

    @overload
    def toCurrencyString(
        self, i: float, symbol: str = ..., precision: int = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-3

        **QString QLocale::toCurrencyString(ushort value , const QString &
        symbol = QString()) const**

        This is an overloaded function.
        """
        ...

    @overload
    def toCurrencyString(self, i: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-4

        **QString QLocale::toCurrencyString(int value , const QString & symbol =
        QString()) const**

        This is an overloaded function.
        """
        ...

    @overload
    def toCurrencyString(self, i: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-5

        **QString QLocale::toCurrencyString(uint value , const QString & symbol
        = QString()) const**

        This is an overloaded function.
        """
        ...

    @overload
    def toCurrencyString(self, i: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-6

        **[since 5.7] QString QLocale::toCurrencyString(double value , const
        QString & symbol = QString(), int precision = -1) const**

        This function overloads toCurrencyString().

        Returns a localized string representation of **value** as a currency. If
        the **symbol** is provided it is used instead of the default currency
        symbol. If the **precision** is provided it is used to set the precision
        of the currency value.

        This function was introduced in Qt 5.7.

        **See also** **currencySymbol** ().
        """
        ...

    @overload
    def toCurrencyString(self, i: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-7

        **QString QLocale::toCurrencyString(float i , const QString & symbol =
        QString(), int precision = -1) const**

        This function overloads toCurrencyString().
        """
        ...

    @overload
    def toDate(
        self,
        string: str,
        format: PySide6.QtCore.QLocale.FormatType,
        cal: PySide6.QtCore.QCalendar,
    ) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate

        **QDate QLocale::toDate(const QString & string , QLocale::FormatType
        format = LongFormat) const**

        Parses the date string given in **string** and returns the date. The
        format of the date string is chosen according to the **format**
        parameter (see **dateFormat** ()).

        If the date could not be parsed, returns an invalid date.

        **See also** **dateFormat** (), **toTime** (), **toDateTime** (), and
        **QDate::fromString** ().
        """
        ...

    @overload
    def toDate(
        self, string: str, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate-1

        **QDate QLocale::toDate(const QString & string , const QString & format
        ) const**

        Parses the date string given in **string** and returns the date. See
        **QDate::fromString** () for information on the expressions that can be
        used with this function.

        This function searches month names and the names of the days of the week
        in the current locale.

        If the date could not be parsed, returns an invalid date.

        **See also** **dateFormat** (), **toTime** (), **toDateTime** (), and
        **QDate::fromString** ().
        """
        ...

    @overload
    def toDate(self, string: str, format: str) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate-2

        **[since 5.14] QDate QLocale::toDate(const QString & string ,
        QLocale::FormatType format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def toDate(
        self, string: str, format: str, cal: PySide6.QtCore.QCalendar
    ) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate-3

        **[since 5.14] QDate QLocale::toDate(const QString & string , const
        QString & format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def toDateTime(
        self,
        string: str,
        format: PySide6.QtCore.QLocale.FormatType,
        cal: PySide6.QtCore.QCalendar,
    ) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime

        **QDateTime QLocale::toDateTime(const QString & string ,
        QLocale::FormatType format = LongFormat) const**

        Parses the date/time string given in **string** and returns the time.
        The format of the date/time string is chosen according to the **format**
        parameter (see **dateTimeFormat** ()).

        If the string could not be parsed, returns an invalid **QDateTime** .

        **See also** **dateTimeFormat** (), **toTime** (), **toDate** (), and
        **QDateTime::fromString** ().
        """
        ...

    @overload
    def toDateTime(
        self, string: str, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime-1

        **QDateTime QLocale::toDateTime(const QString & string , const QString &
        format ) const**

        Parses the date/time string given in **string** and returns the time.
        See **QDateTime::fromString** () for information on the expressions that
        can be used with this function.

        **Note:** The month and day names used must be given in the user's local
        language.

        If the string could not be parsed, returns an invalid **QDateTime** . If
        the string can be parsed and represents an invalid date-time (e.g. in a
        gap skipped by a time-zone transition), an invalid **QDateTime**  is
        returned, whose toMSecsSinceEpoch() represents a near-by date-time that
        is valid. Passing that to fromMSecsSinceEpoch() will produce a valid
        date-time that isn't faithfully represented by the string parsed.

        **See also** **dateTimeFormat** (), **toTime** (), **toDate** (), and
        **QDateTime::fromString** ().
        """
        ...

    @overload
    def toDateTime(self, string: str, format: str) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime-2

        **[since 5.14] QDateTime QLocale::toDateTime(const QString & string ,
        QLocale::FormatType format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def toDateTime(
        self, string: str, format: str, cal: PySide6.QtCore.QCalendar
    ) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime-3

        **[since 5.14] QDateTime QLocale::toDateTime(const QString & string ,
        const QString & format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def toDouble(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDouble

        **double QLocale::toDouble(const QString & s , bool * ok = nullptr)
        const**

        Returns the double represented by the localized string **s**.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for any other reason (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function does not fall back to the 'C' locale if the string cannot
        be interpreted in this locale.

        bool ok;
            double d;

            **QLocale**  c(**QLocale** ::C);
            d =
        c.toDouble("1234.56", &ok);  // ok == true,  d == 1234.56
            d =
        c.toDouble("1,234.56", &ok); // ok == true,  d == 1234.56
            d =
        c.toDouble("1234,56", &ok);  // ok == false, d == 0

            **QLocale**
        german(**QLocale** ::German);
            d = german.toDouble("1234,56", &ok);
        // ok == true,  d == 1234.56
            d = german.toDouble("1.234,56", &ok);
        // ok == true,  d == 1234.56
            d = german.toDouble("1234.56", &ok);
        // ok == false, d == 0

            d = german.toDouble("1.234", &ok);    //
        ok == true,  d == 1234.0

        Notice that the last conversion returns 1234.0, because '.' is the
        thousands group separator in the German locale.

        This function ignores leading and trailing whitespace.

        **See also** **toFloat** (), **toInt** (), and **toString** ().
        """
        ...

    @overload
    def toDouble(self, s: str) -> Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDouble-1

        **[since 5.10] double QLocale::toDouble(QStringView s , bool * ok =
        nullptr) const**

        Returns the double represented by the localized string **s**.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for any other reason (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        Unlike **QString::toDouble** (), this function does not fall back to the
        "C" locale if the string cannot be interpreted in this locale.

        bool ok;
            double d;

            **QLocale**  c(**QLocale** ::C);
            d =
        c.toDouble(u"1234.56", &ok);  // ok == true,  d == 1234.56
            d =
        c.toDouble(u"1,234.56", &ok); // ok == true,  d == 1234.56
            d =
        c.toDouble(u"1234,56", &ok);  // ok == false, d == 0
        **QLocale**  german(**QLocale** ::German);
            d =
        german.toDouble(u"1234,56", &ok);  // ok == true,  d == 1234.56
            d =
        german.toDouble(u"1.234,56", &ok); // ok == true,  d == 1234.56
            d =
        german.toDouble(u"1234.56", &ok);  // ok == false, d == 0

            d =
        german.toDouble(u"1.234", &ok);    // ok == true,  d == 1234.0

        Notice that the last conversion returns 1234.0, because '.' is the
        thousands group separator in the German locale.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toFloat** (), **toInt** (), and **toString** ().
        """
        ...

    @overload
    def toFloat(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toFloat

        **float QLocale::toFloat(const QString & s , bool * ok = nullptr)
        const**

        Returns the float represented by the localized string **s**.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for any other reason (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function does not fall back to the 'C' locale if the string cannot
        be interpreted in this locale.

        This function ignores leading and trailing whitespace.

        **See also** **toDouble** (), **toInt** (), and **toString** ().
        """
        ...

    @overload
    def toFloat(self, s: str) -> Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toFloat-1

        **[since 5.10] float QLocale::toFloat(QStringView s , bool * ok =
        nullptr) const**

        Returns the float represented by the localized string **s**.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for any other reason (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toDouble** (), **toInt** (), and **toString** ().
        """
        ...

    @overload
    def toInt(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toInt

        **int QLocale::toInt(const QString & s , bool * ok = nullptr) const**

        Returns the int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toUInt** () and **toString** ().
        """
        ...

    @overload
    def toInt(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toInt-1

        **[since 5.10] int QLocale::toInt(QStringView s , bool * ok = nullptr)
        const**

        Returns the int represented by the localized string **s**.

        If the conversion fails, the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toUInt** () and **toString** ().
        """
        ...

    def toLong(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLong

        **[since 5.13] long QLocale::toLong(const QString & s , bool * ok =
        nullptr) const**

        Returns the long int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.13.

        **See also** **toInt** (), **toULong** (), **toDouble** (), and
        **toString** ().
        """
        ...

    @overload
    def toLongLong(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLongLong

        **qlonglong QLocale::toLongLong(const QString & s , bool * ok = nullptr)
        const**

        Returns the long long int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toInt** (), **toULongLong** (), **toDouble** (), and
        **toString** ().
        """
        ...

    @overload
    def toLongLong(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLongLong-1

        **[since 5.10] qlonglong QLocale::toLongLong(QStringView s , bool * ok =
        nullptr) const**

        Returns the long long int represented by the localized string **s**.

        If the conversion fails, the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toInt** (), **toULongLong** (), **toDouble** (), and
        **toString** ().
        """
        ...

    def toLower(self, str: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLower

        **QString QLocale::toLower(const QString & str ) const**

        Returns a lowercase copy of **str**.

        If Qt Core is using the ICU libraries, they will be used to perform the
        transformation according to the rules of the current locale. Otherwise
        the conversion may be done in a platform-dependent manner, with
        **QString::toLower** () as a generic fallback.

        **See also** **QString::toLower** ().
        """
        ...

    @overload
    def toShort(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toShort

        **short QLocale::toShort(const QString & s , bool * ok = nullptr)
        const**

        Returns the short int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toUShort** () and **toString** ().
        """
        ...

    @overload
    def toShort(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toShort-1

        **[since 5.10] short QLocale::toShort(QStringView s , bool * ok =
        nullptr) const**

        Returns the short int represented by the localized string **s**.

        If the conversion fails, the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toUShort** () and **toString** ().
        """
        ...

    @overload
    def toString(
        self,
        date: PySide6.QtCore.QDate,
        format: PySide6.QtCore.QLocale.FormatType,
        cal: PySide6.QtCore.QCalendar,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(
        self,
        date: PySide6.QtCore.QDate,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-1

        **QString QLocale::toString(qulonglong i ) const**

        This is an overloaded function.

        **See also** **toULongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(self, date: PySide6.QtCore.QDate, format: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-2

        **QString QLocale::toString(long i ) const**

        This is an overloaded function.

        **See also** **toLong** ().
        """
        ...

    @overload
    def toString(
        self, date: PySide6.QtCore.QDate, format: str, cal: PySide6.QtCore.QCalendar
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-3

        **QString QLocale::toString(ulong i ) const**

        This is an overloaded function.

        **See also** **toULong** ().
        """
        ...

    @overload
    def toString(
        self,
        dateTime: PySide6.QtCore.QDateTime,
        format: PySide6.QtCore.QLocale.FormatType,
        cal: PySide6.QtCore.QCalendar,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-4

        **QString QLocale::toString(short i ) const**

        This is an overloaded function.

        **See also** **toShort** ().
        """
        ...

    @overload
    def toString(
        self,
        dateTime: PySide6.QtCore.QDateTime,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-5

        **QString QLocale::toString(ushort i ) const**

        This is an overloaded function.

        **See also** **toUShort** ().
        """
        ...

    @overload
    def toString(self, dateTime: PySide6.QtCore.QDateTime, format: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-6

        **QString QLocale::toString(int i ) const**

        This is an overloaded function.

        **See also** **toInt** ().
        """
        ...

    @overload
    def toString(
        self,
        dateTime: PySide6.QtCore.QDateTime,
        format: str,
        cal: PySide6.QtCore.QCalendar,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-7

        **QString QLocale::toString(uint i ) const**

        This is an overloaded function.

        **See also** **toUInt** ().
        """
        ...

    @overload
    def toString(self, f: float, format: int = ..., precision: int = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-8

        **QString QLocale::toString(double f , char format = 'g', int precision
        = 6) const**

        This is an overloaded function.

        Returns a string representing the floating-point number **f**.

        The form of the representation is controlled by the **format** and
        **precision** parameters.

        The **format** defaults to `'g'`. It can be any of the following:

        FormatMeaning
        `'e'`format as [-]9.9e[+|-]999
        `'E'`format as
        [-]9.9E[+|-]999
        `'f'`format as [-]9.9
        `'g'`use `'e'` or `'f'`
        format, whichever is more concise
        `'G'`use `'E'` or `'f'` format,
        whichever is more concise

        For the `'e'`, `'E'`, and `'f'` formats, the **precision** represents
        the number of digits **after** the decimal point. For the `'g'` and
        `'G'` formats, the **precision** represents the maximum number of
        significant digits (trailing zeroes are omitted). The special
        **precision** value **QLocale::FloatingPointShortest**  selects the
        shortest representation that, when read as a number, gets back the
        original floating-point value. Aside from that, any negative
        **precision** is ignored in favor of the default, 6.

        For the `'e'`, `'f'` and `'g'` formats, positive infinity is represented
        as "inf", negative infinity as "-inf" and floating-point NaN (not-a-
        number) values are represented as "nan". For the `'E'` and `'G'`
        formats, "INF" and "NAN" are used instead. This does not vary with
        locale.

        **See also** **toDouble** (), **numberOptions** (), **exponential** (),
        **decimalPoint** (), **zeroDigit** (), **positiveSign** (), **percent**
        (), **toCurrencyString** (), **formattedDataSize** (), and
        **QLocale::FloatingPointPrecisionOption** .
        """
        ...

    @overload
    def toString(self, f: float, format: int = ..., precision: int = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-9

        **QString QLocale::toString(float f , char format = 'g', int precision =
        6) const**

        This is an overloaded function.

        Returns a string representing the floating-point number **f**.

        The **format** and **precision** have the same meanings as described in
        **toString** (double, char, int).

        **See also** **toFloat** (), **toDouble** (), **numberOptions** (),
        **exponential** (), **decimalPoint** (), **zeroDigit** (),
        **positiveSign** (), **percent** (), **toCurrencyString** (),
        **formattedDataSize** (), and **QLocale::FloatingPointPrecisionOption**
        .
        """
        ...

    @overload
    def toString(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-10

        **QString QLocale::toString(QDate date , const QString & format )
        const**

        Returns a localized string representation of the given **date** in the
        specified **format**. If **format** is an empty string, an empty string
        is returned.

        **See also** **QDate::toString** ().
        """
        ...

    @overload
    def toString(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(
        self,
        time: PySide6.QtCore.QTime,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toString(self, time: PySide6.QtCore.QTime, format: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @overload
    def toTime(
        self, string: str, format: PySide6.QtCore.QLocale.FormatType = ...
    ) -> PySide6.QtCore.QTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toTime

        **QTime QLocale::toTime(const QString & string , QLocale::FormatType
        format = LongFormat) const**

        Parses the time string given in **string** and returns the time. The
        format of the time string is chosen according to the **format**
        parameter (see **timeFormat** ()).

        If the time could not be parsed, returns an invalid time.

        **See also** **timeFormat** (), **toDate** (), **toDateTime** (), and
        **QTime::fromString** ().
        """
        ...

    @overload
    def toTime(self, string: str, format: str) -> PySide6.QtCore.QTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toTime-1

        **QTime QLocale::toTime(const QString & string , const QString & format
        ) const**

        Parses the time string given in **string** and returns the time. See
        **QTime::fromString** () for information on what is a valid format
        string.

        If the time could not be parsed, returns an invalid time.

        **See also** **timeFormat** (), **toDate** (), **toDateTime** (), and
        **QTime::fromString** ().
        """
        ...

    @overload
    def toUInt(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUInt

        **uint QLocale::toUInt(const QString & s , bool * ok = nullptr) const**

        Returns the unsigned int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toInt** () and **toString** ().
        """
        ...

    @overload
    def toUInt(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUInt-1

        **[since 5.10] uint QLocale::toUInt(QStringView s , bool * ok = nullptr)
        const**

        Returns the unsigned int represented by the localized string **s**.

        If the conversion fails, the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toInt** () and **toString** ().
        """
        ...

    def toULong(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toULong

        **[since 5.13] ulong QLocale::toULong(const QString & s , bool * ok =
        nullptr) const**

        Returns the unsigned long int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.13.

        **See also** **toLong** (), **toInt** (), **toDouble** (), and
        **toString** ().
        """
        ...

    @overload
    def toULongLong(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toULongLong

        **qulonglong QLocale::toULongLong(const QString & s , bool * ok =
        nullptr) const**

        Returns the unsigned long long int represented by the localized string
        **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toLongLong** (), **toInt** (), **toDouble** (), and
        **toString** ().
        """
        ...

    @overload
    def toULongLong(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toULongLong-1

        **[since 5.10] qulonglong QLocale::toULongLong(QStringView s , bool * ok
        = nullptr) const**

        Returns the unsigned long long int represented by the localized string
        **s**.

        If the conversion fails, the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toLongLong** (), **toInt** (), **toDouble** (), and
        **toString** ().
        """
        ...

    @overload
    def toUShort(self, s: str) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUShort

        **ushort QLocale::toUShort(const QString & s , bool * ok = nullptr)
        const**

        Returns the unsigned short int represented by the localized string
        **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toShort** () and **toString** ().
        """
        ...

    @overload
    def toUShort(self, s: str) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUShort-1

        **[since 5.10] ushort QLocale::toUShort(QStringView s , bool * ok =
        nullptr) const**

        Returns the unsigned short int represented by the localized string
        **s**.

        If the conversion fails, the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.10.

        **See also** **toShort** () and **toString** ().
        """
        ...

    def toUpper(self, str: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUpper

        **QString QLocale::toUpper(const QString & str ) const**

        Returns an uppercase copy of **str**.

        If Qt Core is using the ICU libraries, they will be used to perform the
        transformation according to the rules of the current locale. Otherwise
        the conversion may be done in a platform-dependent manner, with
        **QString::toUpper** () as a generic fallback.

        **See also** **QString::toUpper** ().
        """
        ...

    def uiLanguages(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qlocale.html#uiLanguages

        **QStringList QLocale::uiLanguages() const**

        Returns an ordered list of locale names for translation purposes in
        preference order (like "en-Latn-US", "en-US", "en").

        The return value represents locale names that the user expects to see
        the UI translation in.

        Most like you do not need to use this function directly, but just pass
        the **QLocale**  object to the **QTranslator::load** () function.

        The first item in the list is the most preferred one.

        **See also** **QTranslator**  and **bcp47Name** ().
        """
        ...

    def weekdays(self) -> List[PySide6.QtCore.Qt.DayOfWeek]:
        """
        https://doc.qt.io/qt-6/qlocale.html#weekdays

        **QList<Qt::DayOfWeek> QLocale::weekdays() const**

        Returns a list of days that are considered weekdays according to the
        current locale.
        """
        ...

    def zeroDigit(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#zeroDigit

        **QString QLocale::zeroDigit() const**

        Returns the zero digit character of this locale.

        **See also** **toString** ().
        """
        ...
