"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QLine(object):
    """
    https://doc.qt.io/qt-6/qline.html

    **Detailed Description**

    A QLine describes a finite length line (or a line segment) on a two-
    dimensional surface. The start and end points of the line are specified
    using integer point accuracy for coordinates. Use the **QLineF**
    constructor to retrieve a floating point copy.

    ![](images/qline-point.png)![](images/qline-coordinates.png)

    The positions of the line's start and end points can be retrieved using the
    **p1** (), **x1** (), **y1** (), **p2** (), **x2** (), and **y2** ()
    functions. The **dx** () and **dy** () functions return the horizontal and
    vertical components of the line. Use **isNull** () to determine whether the
    QLine represents a valid line or a null line.

    Finally, the line can be translated a given offset using the **translate**
    () function.

    **See also** **QLineF** , **QPolygon** , and **QRect** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine

        **QLine::QLine()**

        Constructs a null line.
        """
        ...

    @overload
    def __init__(self, QLine: PySide6.QtCore.QLine) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine-1

        **QLine::QLine(const QPoint & p1 , const QPoint & p2 )**

        Constructs a line object that represents the line between **p1** and
        **p2**.
        """
        ...

    @overload
    def __init__(self, pt1: PySide6.QtCore.QPoint, pt2: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine-2

        **QLine::QLine(int x1 , int y1 , int x2 , int y2 )**

        Constructs a line object that represents the line between ( **x1** ,
        **y1** ) and ( **x2** , **y2** ).
        """
        ...

    @overload
    def __init__(self, x1: int, y1: int, x2: int, y2: int) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine

        **QLine::QLine()**

        Constructs a null line.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def center(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qline.html#center

        **[since 5.8] QPoint QLine::center() const**

        Returns the center point of this line. This is equivalent to (**p1** ()
        + **p2** ()) / 2, except it will never overflow.

        This function was introduced in Qt 5.8.
        """
        ...

    def dx(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#dx

        **int QLine::dx() const**

        Returns the horizontal component of the line's vector.

        **See also** **dy** ().
        """
        ...

    def dy(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#dy

        **int QLine::dy() const**

        Returns the vertical component of the line's vector.

        **See also** **dx** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qline.html#isNull

        **bool QLine::isNull() const**

        Returns `true` if the line does not have distinct start and end points;
        otherwise returns `false`.
        """
        ...

    def p1(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qline.html#p1

        **QPoint QLine::p1() const**

        Returns the line's start point.

        **See also** **setP1** (), **x1** (), **y1** (), and **p2** ().
        """
        ...

    def p2(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qline.html#p2

        **QPoint QLine::p2() const**

        Returns the line's end point.

        **See also** **setP2** (), **x2** (), **y2** (), and **p1** ().
        """
        ...

    def setLine(self, x1: int, y1: int, x2: int, y2: int) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setLine

        **void QLine::setLine(int x1 , int y1 , int x2 , int y2 )**

        Sets this line to the start in **x1** , **y1** and end in **x2** ,
        **y2**.

        **See also** **setP1** (), **setP2** (), **p1** (), and **p2** ().
        """
        ...

    def setP1(self, p1: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setP1

        **void QLine::setP1(const QPoint & p1 )**

        Sets the starting point of this line to **p1**.

        **See also** **setP2** () and **p1** ().
        """
        ...

    def setP2(self, p2: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setP2

        **void QLine::setP2(const QPoint & p2 )**

        Sets the end point of this line to **p2**.

        **See also** **setP1** () and **p2** ().
        """
        ...

    def setPoints(self, p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setPoints

        **void QLine::setPoints(const QPoint & p1 , const QPoint & p2 )**

        Sets the start point of this line to **p1** and the end point of this
        line to **p2**.

        **See also** **setP1** (), **setP2** (), **p1** (), and **p2** ().
        """
        ...

    def toTuple(self) -> object:
        ...

    @overload
    def translate(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#translate

        **void QLine::translate(const QPoint & offset )**

        Translates this line by the given **offset**.
        """
        ...

    @overload
    def translate(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#translate-1

        **void QLine::translate(int dx , int dy )**

        This is an overloaded function.

        Translates this line the distance specified by **dx** and **dy**.
        """
        ...

    @overload
    def translated(self, dx: int, dy: int) -> PySide6.QtCore.QLine:
        """
        https://doc.qt.io/qt-6/qline.html#translated

        **QLine QLine::translated(const QPoint & offset ) const**

        Returns this line translated by the given **offset**.
        """
        ...

    @overload
    def translated(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QLine:
        """
        https://doc.qt.io/qt-6/qline.html#translated-1

        **QLine QLine::translated(int dx , int dy ) const**

        This is an overloaded function.

        Returns this line translated the distance specified by **dx** and
        **dy**.
        """
        ...

    def x1(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#x1

        **int QLine::x1() const**

        Returns the x-coordinate of the line's start point.

        **See also** **p1** ().
        """
        ...

    def x2(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#x2

        **int QLine::x2() const**

        Returns the x-coordinate of the line's end point.

        **See also** **p2** ().
        """
        ...

    def y1(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#y1

        **int QLine::y1() const**

        Returns the y-coordinate of the line's start point.

        **See also** **p1** ().
        """
        ...

    def y2(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#y2

        **int QLine::y2() const**

        Returns the y-coordinate of the line's end point.

        **See also** **p2** ().
        """
        ...
