"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QKeyCombination(object):
    """
    https://doc.qt.io/qt-6/qkeycombination.html

    **Detailed Description**

    The QKeyCombination class can be used to represent a combination of a key
    with zero or more keyboard modifiers.

    **See also** **QKeySequence** .
    """

    @overload
    def __init__(self, key: PySide6.QtCore.Qt.Key = ...) -> None:
        """
        https://doc.qt.io/qt-6/qkeycombination.html#QKeyCombination

        **QKeyCombination::QKeyCombination(Qt::Key key = Qt::Key_unknown)**

        Constructs a QKeyCombination object that represents the key **key** and
        no modifiers.

        **See also** **key** ().
        """
        ...

    @overload
    def __init__(
        self,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
        key: PySide6.QtCore.Qt.Key = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeycombination.html#QKeyCombination-1

        **QKeyCombination::QKeyCombination(Qt::Modifiers modifiers , Qt::Key key
        = Qt::Key_unknown)**

        Constructs a QKeyCombination object that represents the combination of
        **key** with the modifiers **modifiers**.

        **See also** **key** () and **keyboardModifiers** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def fromCombined(combined: int) -> PySide6.QtCore.QKeyCombination:
        """
        https://doc.qt.io/qt-6/qkeycombination.html#fromCombined

        **[static] QKeyCombination QKeyCombination::fromCombined(int combined
        )**

        Constructs a **QKeyCombination**  object by extracting the key and the
        modifiers out of **combined** , which must be the result of a bitwise OR
        between a value of type **Qt::Key**  and value of type
        **Qt::KeyboardModifiers** . **toCombined** () can be used in order to
        produce valid values for **combined**.

        **See also** **toCombined** ().
        """
        ...

    def key(self) -> PySide6.QtCore.Qt.Key:
        """
        https://doc.qt.io/qt-6/qkeycombination.html#key

        **Qt::Key QKeyCombination::key() const**

        Returns the key represented by this **QKeyCombination**  object.

        **See also** **keyboardModifiers** ().
        """
        ...

    def keyboardModifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qkeycombination.html#keyboardModifiers

        **Qt::KeyboardModifiers QKeyCombination::keyboardModifiers() const**

        Returns the keyboard modifiers represented by this **QKeyCombination**
        object.

        **See also** **key** ().
        """
        ...

    def toCombined(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeycombination.html#toCombined

        **int QKeyCombination::toCombined() const**

        Returns an integer value obtained by applying a bitwise OR between the
        values of **key** () and **keyboardModifiers** () represented by this
        object. A **QKeyCombination**  object can be created from the returned
        integer value by using **fromCombined** ().

        **See also** **fromCombined** (), **key** (), and **keyboardModifiers**
        ().
        """
        ...
