"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, Union, overload
import PySide6.QtCore

bytes = str


class QJsonValue(object):
    """
    https://doc.qt.io/qt-6/qjsonvalue.html

    **Detailed Description**

    A value in JSON can be one of 6 basic types:

    JSON is a format to store structured data. It has 6 basic data types:

    * bool **QJsonValue::Bool**
      * double **QJsonValue::Double**
      * string
    **QJsonValue::String**
      * array **QJsonValue::Array**
      * object
    **QJsonValue::Object**
      * null **QJsonValue::Null**

    A value can represent any of the above data types. In addition, QJsonValue
    has one special flag to represent undefined values. This can be queried with
    **isUndefined** ().

    The type of the value can be queried with **type** () or accessors like
    **isBool** (), **isString** (), and so on. Likewise, the value can be
    converted to the type stored in it using the **toBool** (), **toString** ()
    and so on.

    Values are strictly typed internally and contrary to **QVariant**  will not
    attempt to do any implicit type conversions. This implies that converting to
    a type that is not stored in the value will return a default constructed
    return value.

    **QJsonValueRef**

    **QJsonValueRef**  is a helper class for **QJsonArray**  and **QJsonObject**
    . When you get an object of type **QJsonValueRef** , you can use it as if it
    were a reference to a QJsonValue. If you assign to it, the assignment will
    apply to the element in the **QJsonArray**  or **QJsonObject**  from which
    you got the reference.

    The following methods return **QJsonValueRef** :

    * **QJsonArray** ::operator[](qsizetype i)
      * **QJsonObject**
    ::operator[](const **QString**  & key) const

    **See also** **JSON Support in Qt**  and **JSON Save Game Example** .
    """

    Null: QJsonValue.Type = ...
    Bool: QJsonValue.Type = ...
    Double: QJsonValue.Type = ...
    String: QJsonValue.Type = ...
    Array: QJsonValue.Type = ...
    Object: QJsonValue.Type = ...
    Undefined: QJsonValue.Type = ...

    class Type(Enum):
        Null: QJsonValue.Type = ...
        Bool: QJsonValue.Type = ...
        Double: QJsonValue.Type = ...
        String: QJsonValue.Type = ...
        Array: QJsonValue.Type = ...
        Object: QJsonValue.Type = ...
        Undefined: QJsonValue.Type = ...

    @overload
    def __init__(self, a: PySide6.QtCore.QJsonArray) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue

        **QJsonValue::QJsonValue(QJsonValue::Type type = Null)**

        Creates a QJsonValue of type **type**.

        The default is to create a Null value.
        """
        ...

    @overload
    def __init__(self, arg__1: PySide6.QtCore.QJsonValue.Type = ...) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-1

        **QJsonValue::QJsonValue(bool b )**

        Creates a value of type Bool, with value **b**.
        """
        ...

    @overload
    def __init__(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-2

        **QJsonValue::QJsonValue(double v )**

        Creates a value of type Double, with value **v**.
        """
        ...

    @overload
    def __init__(self, n: float) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-3

        **QJsonValue::QJsonValue(int v )**

        This is an overloaded function.

        Creates a value of type Double, with value **v**.
        """
        ...

    @overload
    def __init__(self, n: int) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-4

        **QJsonValue::QJsonValue(qint64 v )**

        This is an overloaded function.

        Creates a value of type Double, with value **v**. NOTE: the integer
        limits for IEEE 754 double precision data is 2^53 (-9007199254740992 to
        +9007199254740992). If you pass in values outside this range expect a
        loss of precision to occur.
        """
        ...

    @overload
    def __init__(self, o: Dict[str, PySide6.QtCore.QJsonValue]) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-5

        **QJsonValue::QJsonValue(const QString & s )**

        Creates a value of type String, with value **s**.
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtCore.QJsonValue,
            PySide6.QtCore.QJsonValue.Type,
            PySide6.QtCore.QJsonArray,
            Dict[str, PySide6.QtCore.QJsonValue],
            str,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-6

        **QJsonValue::QJsonValue(QLatin1String s )**

        Creates a value of type String, with value **s**.
        """
        ...

    @overload
    def __init__(self, s: str) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-7

        **[since 5.3] QJsonValue::QJsonValue(const char * s )**

        Creates a value of type String with value **s** , assuming UTF-8
        encoding of the input.

        You can disable this constructor by defining `QT_NO_CAST_FROM_ASCII`
        when you compile your applications.

        This function was introduced in Qt 5.3.
        """
        ...

    @overload
    def __init__(self, s: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-8

        **QJsonValue::QJsonValue(const QJsonArray & a )**

        Creates a value of type Array, with value **a**.
        """
        ...

    @overload
    def __init__(self, v: int) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#QJsonValue-9

        **QJsonValue::QJsonValue(const QJsonObject & o )**

        Creates a value of type Object, with value **o**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def fromVariant(variant: Any) -> PySide6.QtCore.QJsonValue:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#fromVariant

        **[static] QJsonValue QJsonValue::fromVariant(const QVariant & variant
        )**

        Converts **variant** to a **QJsonValue**  and returns it.

        The conversion will convert **QVariant**  types as follows:

        Source typeDestination type

          * **QMetaType::Nullptr**
        **QJsonValue::Null**

          * **QMetaType::Bool**

        **QJsonValue::Bool**
        * **QMetaType::Int**
          * **QMetaType::UInt**
          *
        **QMetaType::LongLong**
          * **QMetaType::ULongLong**
          *
        **QMetaType::Float**
          * **QMetaType::Double**

        **QJsonValue::Double**
        * **QMetaType::QString**

        **QJsonValue::String**

          *
        **QMetaType::QStringList**
          * **QMetaType::QVariantList**
        **QJsonValue::Array**

          * **QMetaType::QVariantMap**
          *
        **QMetaType::QVariantHash**

        **QJsonValue::Object**

          *
        **QMetaType::QUrl**

        **QJsonValue::String** . The conversion will use
        **QUrl::toString** () with flag **QUrl::FullyEncoded** , so as to ensure
        maximum compatibility in parsing the URL

          * **QMetaType::QUuid**
        **QJsonValue::String** . Since Qt 5.11, the resulting string will not
        include braces

          * **QMetaType::QCborValue**

        Whichever type
        **QCborValue::toJsonValue** () returns.

          *
        **QMetaType::QCborArray**

        **QJsonValue::Array** . See
        **QCborValue::toJsonValue** () for conversion restrictions.

          *
        **QMetaType::QCborMap**

        QJsonValue::Map. See
        **QCborValue::toJsonValue** () for conversion restrictions and the
        "stringification" of map keys.

        **Loss of information and other types**

        **QVariant**  can carry more information than is representable in JSON.
        If the **QVariant**  is not one of the types above, the conversion is
        not guaranteed and is subject to change in future versions of Qt, as the
        UUID one did. Code should strive not to use any other types than those
        listed above.

        If **QVariant::isNull** () returns true, a null **QJsonValue**  is
        returned or inserted into the list or object, regardless of the type
        carried by **QVariant** . Note the behavior change in Qt 6.0 affecting
        **QVariant::isNull** () also affects this function.

        A floating point value that is either an infinity or NaN will be
        converted to a null JSON value. Since Qt 6.0, **QJsonValue**  can store
        the full precision of any 64-bit signed integer without loss, but in
        previous versions values outside the range of ±2^53 may lose precision.
        Unsigned 64-bit values greater than or equal to 2^63 will either lose
        precision or alias to negative values, so **QMetaType::ULongLong**
        should be avoided.

        For other types not listed above, a conversion to string will be
        attempted, usually but not always by calling **QVariant::toString** ().
        If the conversion fails the value is replaced by a null JSON value. Note
        that **QVariant::toString** () is also lossy for the majority of types.
        For example, if the passed **QVariant**  is representing raw byte array
        data, it is recommended to pre-encode it to **Base64**  (or another
        lossless encoding), otherwise a lossy conversion using
        **QString::fromUtf8** () will be used.

        Please note that the conversions via **QVariant::toString** () are
        subject to change at any time. Both **QVariant**  and **QJsonValue**
        may be extended in the future to support more types, which will result
        in a change in how this function performs conversions.

        **See also** **toVariant** () and **QCborValue::fromVariant** ().
        """
        ...

    def isArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isArray

        **bool QJsonValue::isArray() const**

        Returns `true` if the value contains an array.

        **See also** **toArray** ().
        """
        ...

    def isBool(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isBool

        **bool QJsonValue::isBool() const**

        Returns `true` if the value contains a boolean.

        **See also** **toBool** ().
        """
        ...

    def isDouble(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isDouble

        **bool QJsonValue::isDouble() const**

        Returns `true` if the value contains a double.

        **See also** **toDouble** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isNull

        **bool QJsonValue::isNull() const**

        Returns `true` if the value is null.
        """
        ...

    def isObject(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isObject

        **bool QJsonValue::isObject() const**

        Returns `true` if the value contains an object.

        **See also** **toObject** ().
        """
        ...

    def isString(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isString

        **bool QJsonValue::isString() const**

        Returns `true` if the value contains a string.

        **See also** **toString** ().
        """
        ...

    def isUndefined(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#isUndefined

        **bool QJsonValue::isUndefined() const**

        Returns `true` if the value is undefined. This can happen in certain
        error cases as e.g. accessing a non existing key in a **QJsonObject** .
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtCore.QJsonValue,
            PySide6.QtCore.QJsonValue.Type,
            PySide6.QtCore.QJsonArray,
            Dict[str, PySide6.QtCore.QJsonValue],
            str,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#swap

        **[since 5.10] void QJsonValue::swap(QJsonValue & other )**

        Swaps the value **other** with this. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.10.
        """
        ...

    @overload
    def toArray(self) -> PySide6.QtCore.QJsonArray:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toArray

        **QJsonArray QJsonValue::toArray(const QJsonArray & defaultValue )
        const**

        Converts the value to an array and returns it.

        If **type** () is not Array, the **defaultValue** will be returned.
        """
        ...

    @overload
    def toArray(
        self, defaultValue: PySide6.QtCore.QJsonArray
    ) -> PySide6.QtCore.QJsonArray:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toArray-1

        **QJsonArray QJsonValue::toArray() const**

        This is an overloaded function.

        Converts the value to an array and returns it.

        If **type** () is not Array, a **QJsonArray** () will be returned.
        """
        ...

    def toBool(self, defaultValue: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toBool

        **bool QJsonValue::toBool(bool defaultValue = false) const**

        Converts the value to a bool and returns it.

        If **type** () is not bool, the **defaultValue** will be returned.
        """
        ...

    def toDouble(self, defaultValue: float = ...) -> float:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toDouble

        **double QJsonValue::toDouble(double defaultValue = 0) const**

        Converts the value to a double and returns it.

        If **type** () is not Double, the **defaultValue** will be returned.
        """
        ...

    def toInt(self, defaultValue: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toInt

        **[since 5.2] int QJsonValue::toInt(int defaultValue = 0) const**

        Converts the value to an int and returns it.

        If **type** () is not Double or the value is not a whole number, the
        **defaultValue** will be returned.

        This function was introduced in Qt 5.2.
        """
        ...

    def toInteger(self, defaultValue: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toInteger

        **[since 6.0] qint64 QJsonValue::toInteger(qint64 defaultValue = 0)
        const**

        Converts the value to an integer and returns it.

        If **type** () is not Double or the value is not a whole number
        representable as qint64, the **defaultValue** will be returned.

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    def toObject(self) -> Dict[str, PySide6.QtCore.QJsonValue]:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toObject

        **QJsonObject QJsonValue::toObject(const QJsonObject & defaultValue )
        const**

        Converts the value to an object and returns it.

        If **type** () is not Object, the **defaultValue** will be returned.
        """
        ...

    @overload
    def toObject(
        self, defaultValue: Dict[str, PySide6.QtCore.QJsonValue]
    ) -> Dict[str, PySide6.QtCore.QJsonValue]:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toObject-1

        **QJsonObject QJsonValue::toObject() const**

        This is an overloaded function.

        Converts the value to an object and returns it.

        If **type** () is not Object, the **QJsonObject** () will be returned.
        """
        ...

    @overload
    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toString

        **QString QJsonValue::toString() const**

        Converts the value to a **QString**  and returns it.

        If **type** () is not String, a null **QString**  will be returned.

        **See also** **QString::isNull** ().
        """
        ...

    @overload
    def toString(self, defaultValue: str) -> str:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toString-1

        **QString QJsonValue::toString(const QString & defaultValue ) const**

        Converts the value to a **QString**  and returns it.

        If **type** () is not String, the **defaultValue** will be returned.
        """
        ...

    def toVariant(self) -> Any:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#toVariant

        **QVariant QJsonValue::toVariant() const**

        Converts the value to a **QVariant** ().

        The **QJsonValue**  types will be converted as follows:

        ConstantDescription
        `Null`**QMetaType::Nullptr**
        `Bool`**QMetaType::Bool**
        `Double`**QMetaType::Double**  or
        **QMetaType::LongLong**
        `String`**QString**
        `Array`QVariantList
        `Object`QVariantMap
        `Undefined`**QVariant** ()

        **See also** **fromVariant** ().
        """
        ...

    def type(self) -> PySide6.QtCore.QJsonValue.Type:
        """
        https://doc.qt.io/qt-6/qjsonvalue.html#type

        **QJsonValue::Type QJsonValue::type() const**

        Returns the type of the value.

        **See also** **QJsonValue::Type** .
        """
        ...
