"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Union, overload
import PySide6.QtCore

bytes = str


class QItemSelectionModel(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qitemselectionmodel.html

    **Detailed Description**

    A QItemSelectionModel keeps track of the selected items in a view, or in
    several views onto the same model. It also keeps track of the currently
    selected item in a view.

    The QItemSelectionModel class is one of the **Model/View Classes**  and is
    part of Qt's **model/view framework** .

    The selected items are stored using ranges. Whenever you want to modify the
    selected items use **select** () and provide either a **QItemSelection** ,
    or a **QModelIndex**  and a **QItemSelectionModel::SelectionFlag** .

    The QItemSelectionModel takes a two layer approach to selection management,
    dealing with both selected items that have been committed and items that are
    part of the current selection. The current selected items are part of the
    current interactive selection (for example with rubber-band selection or
    keyboard-shift selections).

    To update the currently selected items, use the bitwise OR of
    **QItemSelectionModel::Current**  and any of the other **SelectionFlags** .
    If you omit the **QItemSelectionModel::Current**  command, a new current
    selection will be created, and the previous one added to the whole
    selection. All functions operate on both layers; for example,
    **selecteditems** () will return items from both layers.

    **Note:** Since 5.5, **model** , **hasSelection** , and **currentIndex**
    are meta-object properties.

    **See also** **Model/View Programming** , **QAbstractItemModel** , and
    **Chart Example** .
    """

    NoUpdate: QItemSelectionModel.SelectionFlag = ...
    Clear: QItemSelectionModel.SelectionFlag = ...
    Select: QItemSelectionModel.SelectionFlag = ...
    ClearAndSelect: QItemSelectionModel.SelectionFlag = ...
    Deselect: QItemSelectionModel.SelectionFlag = ...
    Toggle: QItemSelectionModel.SelectionFlag = ...
    Current: QItemSelectionModel.SelectionFlag = ...
    SelectCurrent: QItemSelectionModel.SelectionFlag = ...
    ToggleCurrent: QItemSelectionModel.SelectionFlag = ...
    Rows: QItemSelectionModel.SelectionFlag = ...
    Columns: QItemSelectionModel.SelectionFlag = ...

    class SelectionFlag(Enum):
        NoUpdate: QItemSelectionModel.SelectionFlag = ...
        Clear: QItemSelectionModel.SelectionFlag = ...
        Select: QItemSelectionModel.SelectionFlag = ...
        ClearAndSelect: QItemSelectionModel.SelectionFlag = ...
        Deselect: QItemSelectionModel.SelectionFlag = ...
        Toggle: QItemSelectionModel.SelectionFlag = ...
        Current: QItemSelectionModel.SelectionFlag = ...
        SelectCurrent: QItemSelectionModel.SelectionFlag = ...
        ToggleCurrent: QItemSelectionModel.SelectionFlag = ...
        Rows: QItemSelectionModel.SelectionFlag = ...
        Columns: QItemSelectionModel.SelectionFlag = ...

    class SelectionFlags(object):
        ...

    @overload
    def __init__(
        self, model: PySide6.QtCore.QAbstractItemModel, parent: PySide6.QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#QItemSelectionModel

        **QItemSelectionModel::QItemSelectionModel(QAbstractItemModel * model =
        nullptr)**

        Constructs a selection model that operates on the specified item
        **model**.
        """
        ...

    @overload
    def __init__(
        self, model: Optional[PySide6.QtCore.QAbstractItemModel] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#QItemSelectionModel-1

        **QItemSelectionModel::QItemSelectionModel(QAbstractItemModel * model ,
        QObject * parent )**

        Constructs a selection model that operates on the specified item
        **model** with **parent**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#clear

        **[virtual slot] void QItemSelectionModel::clear()**

        Clears the selection model. Emits **selectionChanged** () and
        **currentChanged** ().
        """
        ...

    def clearCurrentIndex(self) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#clearCurrentIndex

        **[virtual slot] void QItemSelectionModel::clearCurrentIndex()**

        Clears the current index. Emits **currentChanged** ().
        """
        ...

    def clearSelection(self) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#clearSelection

        **[slot] void QItemSelectionModel::clearSelection()**

        Clears the selection in the selection model. Emits **selectionChanged**
        ().
        """
        ...

    def columnIntersectsSelection(
        self,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#columnIntersectsSelectio
        n

        **[invokable] bool QItemSelectionModel::columnIntersectsSelection(int
        column , const QModelIndex & parent = QModelIndex()) const**

        Returns `true` if there are any items selected in the **column** with
        the given **parent**.

        **Note:** Since Qt 5.15, the default argument for **parent** is an empty
        model index.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def currentIndex(self) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#currentIndex

        **QModelIndex QItemSelectionModel::currentIndex() const**

        Returns the model item index for the current item, or an invalid index
        if there is no current item.

        **See also** **setCurrentIndex** ().
        """
        ...

    def emitSelectionChanged(
        self,
        newSelection: PySide6.QtCore.QItemSelection,
        oldSelection: PySide6.QtCore.QItemSelection,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#emitSelectionChanged

        **[protected] void QItemSelectionModel::emitSelectionChanged(const
        QItemSelection & newSelection , const QItemSelection & oldSelection )**

        Compares the two selections **newSelection** and **oldSelection** and
        emits **selectionChanged** () with the deselected and selected items.
        """
        ...

    def hasSelection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#hasSelection

        **bool QItemSelectionModel::hasSelection() const**

        Returns `true` if the selection model contains any selected item,
        otherwise returns `false`.
        """
        ...

    def isColumnSelected(
        self,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#isColumnSelected

        **[invokable] bool QItemSelectionModel::isColumnSelected(int column ,
        const QModelIndex & parent = QModelIndex()) const**

        Returns `true` if all items are selected in the **column** with the
        given **parent**.

        Note that this function is usually faster than calling **isSelected** ()
        on all items in the same column and that unselectable items are ignored.

        **Note:** Since Qt 5.15, the default argument for **parent** is an empty
        model index.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def isRowSelected(
        self,
        row: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#isRowSelected

        **[invokable] bool QItemSelectionModel::isRowSelected(int row , const
        QModelIndex & parent = QModelIndex()) const**

        Returns `true` if all items are selected in the **row** with the given
        **parent**.

        Note that this function is usually faster than calling **isSelected** ()
        on all items in the same row and that unselectable items are ignored.

        **Note:** Since Qt 5.15, the default argument for **parent** is an empty
        model index.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def isSelected(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#isSelected

        **[invokable] bool QItemSelectionModel::isSelected(const QModelIndex &
        index ) const**

        Returns `true` if the given model item **index** is selected.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#model

        **const QAbstractItemModel *QItemSelectionModel::model() const**

        Returns the item model operated on by the selection model.

        **See also** **setModel** ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#reset

        **[virtual slot] void QItemSelectionModel::reset()**

        Clears the selection model. Does not emit any signals.
        """
        ...

    def rowIntersectsSelection(
        self,
        row: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#rowIntersectsSelection

        **[invokable] bool QItemSelectionModel::rowIntersectsSelection(int row ,
        const QModelIndex & parent = QModelIndex()) const**

        Returns `true` if there are any items selected in the **row** with the
        given **parent**.

        **Note:** Since Qt 5.15, the default argument for **parent** is an empty
        model index.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @overload
    def select(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        command: PySide6.QtCore.QItemSelectionModel.SelectionFlags,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#select

        **[virtual slot] void QItemSelectionModel::select(const QModelIndex &
        index , QItemSelectionModel::SelectionFlags command )**

        Selects the model item **index** using the specified **command** , and
        emits **selectionChanged** ().

        **See also** **QItemSelectionModel::SelectionFlags** .
        """
        ...

    @overload
    def select(
        self,
        selection: PySide6.QtCore.QItemSelection,
        command: PySide6.QtCore.QItemSelectionModel.SelectionFlags,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#select-1

        **[virtual slot] void QItemSelectionModel::select(const QItemSelection &
        selection , QItemSelectionModel::SelectionFlags command )**

        Selects the item **selection** using the specified **command** , and
        emits **selectionChanged** ().

        **See also** **QItemSelectionModel::SelectionFlag** .
        """
        ...

    def selectedColumns(self, row: int = ...) -> List[int]:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#selectedColumns

        **[invokable] QModelIndexList QItemSelectionModel::selectedColumns(int
        row = 0) const**

        Returns the indexes in the given **row** for columns where all rows are
        selected.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **selectedIndexes** () and **selectedRows** ().
        """
        ...

    def selectedIndexes(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#selectedIndexes

        **QModelIndexList QItemSelectionModel::selectedIndexes() const**

        Returns a list of all selected model item indexes. The list contains no
        duplicates, and is not sorted.

        **Note:** Getter function for property selectedIndexes.
        """
        ...

    def selectedRows(self, column: int = ...) -> List[int]:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#selectedRows

        **[invokable] QModelIndexList QItemSelectionModel::selectedRows(int
        column = 0) const**

        Returns the indexes in the given **column** for the rows where all
        columns are selected.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **selectedIndexes** () and **selectedColumns** ().
        """
        ...

    def selection(self) -> PySide6.QtCore.QItemSelection:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#selection

        **const QItemSelection QItemSelectionModel::selection() const**

        Returns the selection ranges stored in the selection model.
        """
        ...

    def setCurrentIndex(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        command: PySide6.QtCore.QItemSelectionModel.SelectionFlags,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#setCurrentIndex

        **[virtual slot] void QItemSelectionModel::setCurrentIndex(const
        QModelIndex & index , QItemSelectionModel::SelectionFlags command )**

        Sets the model item **index** to be the current item, and emits
        **currentChanged** (). The current item is used for keyboard navigation
        and focus indication; it is independent of any selected items, although
        a selected item can also be the current item.

        Depending on the specified **command** , the **index** can also become
        part of the current selection.

        **See also** **currentIndex** () and **select** ().
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#setModel

        **[since 5.5] void QItemSelectionModel::setModel(QAbstractItemModel *
        model )**

        Sets the model to **model**. The **modelChanged** () signal will be
        emitted.

        This function was introduced in Qt 5.5.

        **See also** **model** () and **modelChanged** ().
        """
        ...

    @property
    def currentChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#currentChanged

        **[signal] void QItemSelectionModel::currentChanged(const QModelIndex &
        current , const QModelIndex & previous )**

        This signal is emitted whenever the current item changes. The
        **previous** model item index is replaced by the **current** index as
        the selection's current item.

        Note that this signal will not be emitted when the item model is reset.

        **See also** **currentIndex** (), **setCurrentIndex** (), and
        **selectionChanged** ().
        """
        ...

    @property
    def currentColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#currentColumnChanged

        **[signal] void QItemSelectionModel::currentColumnChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        This signal is emitted if the **current** item changes and its column is
        different to the column of the **previous** current item.

        Note that this signal will not be emitted when the item model is reset.

        **See also** **currentChanged** (), **currentRowChanged** (),
        **currentIndex** (), and **setCurrentIndex** ().
        """
        ...

    @property
    def currentRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#currentRowChanged

        **[signal] void QItemSelectionModel::currentRowChanged(const QModelIndex
        & current , const QModelIndex & previous )**

        This signal is emitted if the **current** item changes and its row is
        different to the row of the **previous** current item.

        Note that this signal will not be emitted when the item model is reset.

        **See also** **currentChanged** (), **currentColumnChanged** (),
        **currentIndex** (), and **setCurrentIndex** ().
        """
        ...

    @property
    def modelChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#modelChanged

        **[signal, since 5.5] void
        QItemSelectionModel::modelChanged(QAbstractItemModel * model )**

        This signal is emitted when the **model** is successfully set with
        **setModel** ().

        This function was introduced in Qt 5.5.

        **See also** **model** () and **setModel** ().
        """
        ...

    @property
    def selectionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qitemselectionmodel.html#selectionChanged

        **[signal] void QItemSelectionModel::selectionChanged(const
        QItemSelection & selected , const QItemSelection & deselected )**

        This signal is emitted whenever the selection changes. The change in the
        selection is represented as an item selection of **deselected** items
        and an item selection of **selected** items.

        Note the that the current index changes independently from the
        selection. Also note that this signal will not be emitted when the item
        model is reset.

        Items which stay selected but change their index are not included in
        **selected** and **deselected**. Thus, this signal might be emitted with
        both **selected** and **deselected** empty, if only the indices of
        selected items change.

        **Note:** Notifier signal for property **selectedIndexes** .

        **See also** **select** () and **currentChanged** ().
        """
        ...
