"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Union, overload
import PySide6.QtCore

bytes = str


class QIdentityProxyModel(PySide6.QtCore.QAbstractProxyModel):
    """
    https://doc.qt.io/qt-6/qidentityproxymodel.html

    **Detailed Description**

    QIdentityProxyModel can be used to forward the structure of a source model
    exactly, with no sorting, filtering or other transformation. This is similar
    in concept to an identity matrix where A.I = A.

    Because it does no sorting or filtering, this class is most suitable to
    proxy models which transform the **data** () of the source model. For
    example, a proxy model could be created to define the font used, or the
    background colour, or the tooltip etc. This removes the need to implement
    all data handling in the same class that creates the structure of the model,
    and can also be used to create re-usable components.

    This also provides a way to change the data in the case where a source model
    is supplied by a third party which cannot be modified.

    class DateFormatProxyModel : public **QIdentityProxyModel**
        {
          //
    ...

          void setDateFormatString(const **QString**  &formatString)
    {
            m_formatString = formatString;
          }

          **QVariant**
    data(const **QModelIndex**  &index, int role) const override
          {
    if (role != Qt::DisplayRole)
              return **QIdentityProxyModel**
    ::data(index, role);

            const **QDateTime**  dateTime =
    sourceModel()->data(SourceClass::DateRole).toDateTime();

            return
    dateTime.toString(m_formatString);
          }

        private:
    **QString**  m_formatString;
        };

    **See also** **QAbstractProxyModel** , **Model/View Programming** , and
    **QAbstractItemModel** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#QIdentityProxyModel

        **QIdentityProxyModel::QIdentityProxyModel(QObject * parent = nullptr)**

        Constructs an identity model with the given **parent**.
        """
        ...

    def columnCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#columnCount

        **[override virtual] int QIdentityProxyModel::columnCount(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount(const QModelIndex
        &parent) const** .
        """
        ...

    def dropMimeData(
        self,
        data: PySide6.QtCore.QMimeData,
        action: PySide6.QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#dropMimeData

        **[override virtual] bool QIdentityProxyModel::dropMimeData(const
        QMimeData * data , Qt::DropAction action , int row , int column , const
        QModelIndex & parent )**

        Reimplements: **QAbstractProxyModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).
        """
        ...

    def headerData(
        self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#headerData

        **[override virtual] QVariant QIdentityProxyModel::headerData(int
        section , Qt::Orientation orientation , int role = Qt::DisplayRole)
        const**

        Reimplements: **QAbstractProxyModel::headerData(int section,
        Qt::Orientation orientation, int role) const** .
        """
        ...

    def index(
        self,
        row: int,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#index

        **[override virtual] QModelIndex QIdentityProxyModel::index(int row ,
        int column , const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index(int row, int column, const
        QModelIndex &parent) const** .
        """
        ...

    def insertColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#insertColumns

        **[override virtual] bool QIdentityProxyModel::insertColumns(int column
        , int count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertColumns** (int column, int
        count, const QModelIndex &parent).
        """
        ...

    def insertRows(
        self,
        row: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#insertRows

        **[override virtual] bool QIdentityProxyModel::insertRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertRows** (int row, int count,
        const QModelIndex &parent).
        """
        ...

    def mapFromSource(
        self,
        sourceIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#mapFromSource

        **[override virtual] QModelIndex
        QIdentityProxyModel::mapFromSource(const QModelIndex & sourceIndex )
        const**

        Reimplements: **QAbstractProxyModel::mapFromSource(const QModelIndex
        &sourceIndex) const** .
        """
        ...

    def mapSelectionFromSource(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtCore.QItemSelection:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#mapSelectionFromSource

        **[override virtual] QItemSelection
        QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &
        selection ) const**

        Reimplements: **QAbstractProxyModel::mapSelectionFromSource(const
        QItemSelection &sourceSelection) const** .
        """
        ...

    def mapSelectionToSource(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtCore.QItemSelection:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#mapSelectionToSource

        **[override virtual] QItemSelection
        QIdentityProxyModel::mapSelectionToSource(const QItemSelection &
        selection ) const**

        Reimplements: **QAbstractProxyModel::mapSelectionToSource(const
        QItemSelection &proxySelection) const** .
        """
        ...

    def mapToSource(
        self,
        proxyIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#mapToSource

        **[override virtual] QModelIndex QIdentityProxyModel::mapToSource(const
        QModelIndex & proxyIndex ) const**

        Reimplements: **QAbstractProxyModel::mapToSource(const QModelIndex
        &proxyIndex) const** .
        """
        ...

    def match(
        self,
        start: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int,
        value: Any,
        hits: int = ...,
        flags: PySide6.QtCore.Qt.MatchFlags = ...,
    ) -> List[int]:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#match

        **[override virtual] QModelIndexList QIdentityProxyModel::match(const
        QModelIndex & start , int role , const QVariant & value , int hits = 1,
        Qt::MatchFlags flags =
        Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)) const**

        Reimplements: **QAbstractItemModel::match(const QModelIndex &start, int
        role, const QVariant &value, int hits, Qt::MatchFlags flags) const** .
        """
        ...

    def moveColumns(
        self,
        sourceParent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        sourceColumn: int,
        count: int,
        destinationParent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        destinationChild: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#moveColumns

        **[override virtual, since 5.15] bool
        QIdentityProxyModel::moveColumns(const QModelIndex & sourceParent , int
        sourceColumn , int count , const QModelIndex & destinationParent , int
        destinationChild )**

        Reimplements: **QAbstractItemModel::moveColumns** (const QModelIndex
        &sourceParent, int sourceColumn, int count, const QModelIndex
        &destinationParent, int destinationChild).

        This function was introduced in Qt 5.15.
        """
        ...

    def moveRows(
        self,
        sourceParent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        sourceRow: int,
        count: int,
        destinationParent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        destinationChild: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#moveRows

        **[override virtual, since 5.15] bool
        QIdentityProxyModel::moveRows(const QModelIndex & sourceParent , int
        sourceRow , int count , const QModelIndex & destinationParent , int
        destinationChild )**

        Reimplements: **QAbstractItemModel::moveRows** (const QModelIndex
        &sourceParent, int sourceRow, int count, const QModelIndex
        &destinationParent, int destinationChild).

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def parent(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#parent

        **[override virtual] QModelIndex QIdentityProxyModel::parent(const
        QModelIndex & child ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .
        """
        ...

    @overload
    def parent(
        self,
        child: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#parent

        **[override virtual] QModelIndex QIdentityProxyModel::parent(const
        QModelIndex & child ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .
        """
        ...

    def removeColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#removeColumns

        **[override virtual] bool QIdentityProxyModel::removeColumns(int column
        , int count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeColumns** (int column, int
        count, const QModelIndex &parent).
        """
        ...

    def removeRows(
        self,
        row: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#removeRows

        **[override virtual] bool QIdentityProxyModel::removeRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeRows** (int row, int count,
        const QModelIndex &parent).
        """
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#rowCount

        **[override virtual] int QIdentityProxyModel::rowCount(const QModelIndex
        & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount(const QModelIndex &parent)
        const** .
        """
        ...

    def setSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#setSourceModel

        **[override virtual] void
        QIdentityProxyModel::setSourceModel(QAbstractItemModel * newSourceModel
        )**

        Reimplements: **QAbstractProxyModel::setSourceModel**
        (QAbstractItemModel *sourceModel).
        """
        ...

    def sibling(
        self,
        row: int,
        column: int,
        idx: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qidentityproxymodel.html#sibling

        **[override virtual] QModelIndex QIdentityProxyModel::sibling(int row ,
        int column , const QModelIndex & idx ) const**

        Reimplements: **QAbstractProxyModel::sibling(int row, int column, const
        QModelIndex &idx) const** .
        """
        ...
