"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore

bytes = str


class QFileDevice(PySide6.QtCore.QIODevice):
    """
    https://doc.qt.io/qt-6/qfiledevice.html

    **Detailed Description**

    QFileDevice is the base class for I/O devices that can read and write text
    and binary files and **resources** . **QFile**  offers the main
    functionality, QFileDevice serves as a base class for sharing functionality
    with other file devices such as **QTemporaryFile** , by providing all the
    operations that can be done on files that have been opened by **QFile**  or
    **QTemporaryFile** .

    **See also** **QFile**  and **QTemporaryFile** .
    """

    NoError: QFileDevice.FileError = ...
    ReadError: QFileDevice.FileError = ...
    WriteError: QFileDevice.FileError = ...
    FatalError: QFileDevice.FileError = ...
    ResourceError: QFileDevice.FileError = ...
    OpenError: QFileDevice.FileError = ...
    AbortError: QFileDevice.FileError = ...
    TimeOutError: QFileDevice.FileError = ...
    UnspecifiedError: QFileDevice.FileError = ...
    RemoveError: QFileDevice.FileError = ...
    RenameError: QFileDevice.FileError = ...
    PositionError: QFileDevice.FileError = ...
    ResizeError: QFileDevice.FileError = ...
    PermissionsError: QFileDevice.FileError = ...
    CopyError: QFileDevice.FileError = ...
    DontCloseHandle: QFileDevice.FileHandleFlag = ...
    AutoCloseHandle: QFileDevice.FileHandleFlag = ...
    FileAccessTime: QFileDevice.FileTime = ...
    FileBirthTime: QFileDevice.FileTime = ...
    FileMetadataChangeTime: QFileDevice.FileTime = ...
    FileModificationTime: QFileDevice.FileTime = ...
    NoOptions: QFileDevice.MemoryMapFlag = ...
    MapPrivateOption: QFileDevice.MemoryMapFlag = ...
    ExeOther: QFileDevice.Permission = ...
    WriteOther: QFileDevice.Permission = ...
    ReadOther: QFileDevice.Permission = ...
    ExeGroup: QFileDevice.Permission = ...
    WriteGroup: QFileDevice.Permission = ...
    ReadGroup: QFileDevice.Permission = ...
    ExeUser: QFileDevice.Permission = ...
    WriteUser: QFileDevice.Permission = ...
    ReadUser: QFileDevice.Permission = ...
    ExeOwner: QFileDevice.Permission = ...
    WriteOwner: QFileDevice.Permission = ...
    ReadOwner: QFileDevice.Permission = ...

    class FileError(Enum):
        NoError: QFileDevice.FileError = ...
        ReadError: QFileDevice.FileError = ...
        WriteError: QFileDevice.FileError = ...
        FatalError: QFileDevice.FileError = ...
        ResourceError: QFileDevice.FileError = ...
        OpenError: QFileDevice.FileError = ...
        AbortError: QFileDevice.FileError = ...
        TimeOutError: QFileDevice.FileError = ...
        UnspecifiedError: QFileDevice.FileError = ...
        RemoveError: QFileDevice.FileError = ...
        RenameError: QFileDevice.FileError = ...
        PositionError: QFileDevice.FileError = ...
        ResizeError: QFileDevice.FileError = ...
        PermissionsError: QFileDevice.FileError = ...
        CopyError: QFileDevice.FileError = ...

    class FileHandleFlag(Enum):
        DontCloseHandle: QFileDevice.FileHandleFlag = ...
        AutoCloseHandle: QFileDevice.FileHandleFlag = ...

    class FileHandleFlags(object):
        ...

    class FileTime(Enum):
        FileAccessTime: QFileDevice.FileTime = ...
        FileBirthTime: QFileDevice.FileTime = ...
        FileMetadataChangeTime: QFileDevice.FileTime = ...
        FileModificationTime: QFileDevice.FileTime = ...

    class MemoryMapFlag(Enum):
        NoOptions: QFileDevice.MemoryMapFlag = ...
        MapPrivateOption: QFileDevice.MemoryMapFlag = ...

    class MemoryMapFlags(object):
        ...

    class Permission(Enum):
        ExeOther: QFileDevice.Permission = ...
        WriteOther: QFileDevice.Permission = ...
        ReadOther: QFileDevice.Permission = ...
        ExeGroup: QFileDevice.Permission = ...
        WriteGroup: QFileDevice.Permission = ...
        ReadGroup: QFileDevice.Permission = ...
        ExeUser: QFileDevice.Permission = ...
        WriteUser: QFileDevice.Permission = ...
        ReadUser: QFileDevice.Permission = ...
        ExeOwner: QFileDevice.Permission = ...
        WriteOwner: QFileDevice.Permission = ...
        ReadOwner: QFileDevice.Permission = ...

    class Permissions(object):
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#atEnd

        **[override virtual] bool QFileDevice::atEnd() const**

        Reimplements: **QIODevice::atEnd() const** .

        Returns `true` if the end of the file has been reached; otherwise
        returns false.

        For regular empty files on Unix (e.g. those in `/proc`), this function
        returns `true`, since the file system reports that the size of such a
        file is 0. Therefore, you should not depend on atEnd() when reading data
        from such a file, but rather call **read** () until no more data can be
        read.
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#close

        **[override virtual] void QFileDevice::close()**

        Reimplements: **QIODevice::close** ().

        Calls **QFileDevice::flush** () and closes the file. Errors from flush
        are ignored.

        **See also** **QIODevice::close** ().
        """
        ...

    def error(self) -> PySide6.QtCore.QFileDevice.FileError:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#error

        **QFileDevice::FileError QFileDevice::error() const**

        Returns the file error status.

        The I/O device status returns an error code. For example, if **open** ()
        returns `false`, or a read/write operation returns -1, this function can
        be called to find out the reason why the operation failed.

        **See also** **unsetError** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#fileName

        **[virtual] QString QFileDevice::fileName() const**

        Returns the name of the file. The default implementation in
        **QFileDevice**  returns a null string.
        """
        ...

    def fileTime(
        self, time: PySide6.QtCore.QFileDevice.FileTime
    ) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#fileTime

        **[since 5.10] QDateTime QFileDevice::fileTime(QFileDevice::FileTime
        time ) const**

        Returns the file time specified by **time**. If the time cannot be
        determined return QDateTime() (an invalid date time).

        This function was introduced in Qt 5.10.

        **See also** **setFileTime** (), **FileTime** , and
        **QDateTime::isValid** ().
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#flush

        **bool QFileDevice::flush()**

        Flushes any buffered data to the file. Returns `true` if successful;
        otherwise returns `false`.
        """
        ...

    def handle(self) -> int:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#handle

        **int QFileDevice::handle() const**

        Returns the file handle of the file.

        This is a small positive integer, suitable for use with C library
        functions such as `fdopen()` and `fcntl()`. On systems that use file
        descriptors for sockets (i.e. Unix systems, but not Windows) the handle
        can be used with **QSocketNotifier**  as well.

        If the file is not open, or there is an error, handle() returns -1.

        **See also** **QSocketNotifier** .
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#isSequential

        **[override virtual] bool QFileDevice::isSequential() const**

        Reimplements: **QIODevice::isSequential() const** .

        Returns `true` if the file can only be manipulated sequentially;
        otherwise returns `false`.

        Most files support random-access, but some special files may not.

        **See also** **QIODevice::isSequential** ().
        """
        ...

    def map(
        self,
        offset: int,
        size: int,
        flags: PySide6.QtCore.QFileDevice.MemoryMapFlags = ...,
    ) -> object:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#map

        **uchar *QFileDevice::map(qint64 offset , qint64 size ,
        QFileDevice::MemoryMapFlags flags = NoOptions)**

        Maps **size** bytes of the file into memory starting at **offset**. A
        file should be open for a map to succeed but the file does not need to
        stay open after the memory has been mapped. When the **QFile**  is
        destroyed or a new file is opened with this object, any maps that have
        not been unmapped will automatically be unmapped.

        The mapping will have the same open mode as the file (read and/or
        write), except when using **MapPrivateOption** , in which case it is
        always possible to write to the mapped memory.

        Any mapping options can be passed through **flags**.

        Returns a pointer to the memory or `nullptr` if there is an error.

        **See also** **unmap** ().
        """
        ...

    def permissions(self) -> PySide6.QtCore.QFileDevice.Permissions:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#permissions

        **[virtual] QFileDevice::Permissions QFileDevice::permissions() const**

        Returns the complete OR-ed together combination of QFile::Permission for
        the file.

        **See also** **setPermissions** ().
        """
        ...

    def pos(self) -> int:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#pos

        **[override virtual] qint64 QFileDevice::pos() const**

        Reimplements: **QIODevice::pos() const** .
        """
        ...

    def readData(self, data: bytes, maxlen: int) -> object:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#readData

        **[override virtual protected] qint64 QFileDevice::readData(char * data
        , qint64 len )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def readLineData(self, data: bytes, maxlen: int) -> object:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#readLineData

        **[override virtual protected] qint64 QFileDevice::readLineData(char *
        data , qint64 maxlen )**

        Reimplements: **QIODevice::readLineData** (char *data, qint64 maxSize).
        """
        ...

    def resize(self, sz: int) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#resize

        **[virtual] bool QFileDevice::resize(qint64 sz )**

        Sets the file size (in bytes) **sz**. Returns `true` if the resize
        succeeds; false otherwise. If **sz** is larger than the file currently
        is, the new bytes will be set to 0; if **sz** is smaller, the file is
        simply truncated.

        **Warning:** This function can fail if the file doesn't exist.

        **See also** **size** ().
        """
        ...

    def seek(self, offset: int) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#seek

        **[override virtual] bool QFileDevice::seek(qint64 pos )**

        Reimplements: **QIODevice::seek** (qint64 pos).

        For random-access devices, this function sets the current position to
        **pos** , returning true on success, or false if an error occurred. For
        sequential devices, the default behavior is to do nothing and return
        false.

        Seeking beyond the end of a file: If the position is beyond the end of a
        file, then seek() will not immediately extend the file. If a write is
        performed at this position, then the file will be extended. The content
        of the file between the previous end of file and the newly written data
        is UNDEFINED and varies between platforms and file systems.
        """
        ...

    def setFileTime(
        self,
        newDate: PySide6.QtCore.QDateTime,
        fileTime: PySide6.QtCore.QFileDevice.FileTime,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#setFileTime

        **[since 5.10] bool QFileDevice::setFileTime(const QDateTime & newDate ,
        QFileDevice::FileTime fileTime )**

        Sets the file time specified by **fileTime** to **newDate** , returning
        true if successful; otherwise returns false.

        **Note:** The file must be open to use this function.

        This function was introduced in Qt 5.10.

        **See also** **fileTime** () and **FileTime** .
        """
        ...

    def setPermissions(
        self, permissionSpec: PySide6.QtCore.QFileDevice.Permissions
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#setPermissions

        **[virtual] bool QFileDevice::setPermissions(QFileDevice::Permissions
        permissions )**

        Sets the permissions for the file to the **permissions** specified.
        Returns `true` if successful, or `false` if the permissions cannot be
        modified.

        **Warning:** This function does not manipulate ACLs, which may limit its
        effectiveness.

        **See also** **permissions** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#size

        **[override virtual] qint64 QFileDevice::size() const**

        Reimplements: **QIODevice::size() const** .

        Returns the size of the file.

        For regular empty files on Unix (e.g. those in `/proc`), this function
        returns 0; the contents of such a file are generated on demand in
        response to you calling **read** ().
        """
        ...

    def unmap(self, address: bytes) -> bool:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#unmap

        **bool QFileDevice::unmap(uchar * address )**

        Unmaps the memory **address**.

        Returns `true` if the unmap succeeds; false otherwise.

        **See also** **map** ().
        """
        ...

    def unsetError(self) -> None:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#unsetError

        **void QFileDevice::unsetError()**

        Sets the file's error to **QFileDevice::NoError** .

        **See also** **error** ().
        """
        ...

    def writeData(self, data: bytes, len: int) -> int:
        """
        https://doc.qt.io/qt-6/qfiledevice.html#writeData

        **[override virtual protected] qint64 QFileDevice::writeData(const char
        * data , qint64 len )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...
