"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
import os
from typing import Tuple, Union, overload
import PySide6.QtCore

bytes = str


class QFile(PySide6.QtCore.QFileDevice):
    """
    https://doc.qt.io/qt-6/qfile.html

    **Detailed Description**

    QFile is an I/O device for reading and writing text and binary files and
    **resources** . A QFile may be used by itself or, more conveniently, with a
    **QTextStream**  or **QDataStream** .

    The file name is usually passed in the constructor, but it can be set at any
    time using **setFileName** (). QFile expects the file separator to be '/'
    regardless of operating system. The use of other separators (e.g., '\\') is
    not supported.

    You can check for a file's existence using **exists** (), and remove a file
    using **remove** (). (More advanced file system related operations are
    provided by **QFileInfo**  and **QDir** .)

    The file is opened with **open** (), closed with **close** (), and flushed
    with **flush** (). Data is usually read and written using **QDataStream**
    or **QTextStream** , but you can also call the **QIODevice** -inherited
    functions **read** (), **readLine** (), **readAll** (), **write** (). QFile
    also inherits **getChar** (), **putChar** (), and **ungetChar** (), which
    work one character at a time.

    The size of the file is returned by **size** (). You can get the current
    file position using **pos** (), or move to a new file position using
    **seek** (). If you've reached the end of the file, **atEnd** () returns
    `true`.

    **Reading Files Directly**

    The following example reads a text file line by line:

    **QFile**  file("in.txt");
            if (!file.open(**QIODevice** ::ReadOnly |
    **QIODevice** ::Text))
                return;

            while
    (!file.atEnd()) {
                **QByteArray**  line = file.readLine();
    process_line(line);
            }

    The QIODevice::Text flag passed to **open** () tells Qt to convert Windows-
    style line terminators ("\\r\\n") into C++-style terminators ("\\n"). By
    default, QFile assumes binary, i.e. it doesn't perform any conversion on the
    bytes stored in the file.

    **Using Streams to Read Files**

    The next example uses **QTextStream**  to read a text file line by line:

    **QFile**  file("in.txt");
            if (!file.open(**QIODevice** ::ReadOnly |
    **QIODevice** ::Text))
                return;

            **QTextStream**
    in(&file);
            while (!in.atEnd()) {
                **QString**  line =
    in.readLine();
                process_line(line);
            }

    **QTextStream**  takes care of converting the 8-bit data stored on disk into
    a 16-bit Unicode **QString** . By default, it assumes that the file is
    encoded in UTF-8. This can be changed using **QTextStream::setEncoding** ().

    To write text, we can use operator<<(), which is overloaded to take a
    **QTextStream**  on the left and various data types (including **QString** )
    on the right:

    **QFile**  file("out.txt");
            if (!file.open(**QIODevice** ::WriteOnly
    | **QIODevice** ::Text))
                return;

            **QTextStream**
    out(&file);
            out << "The magic number is: " << 49 << "\\n";

    **QDataStream**  is similar, in that you can use operator<<() to write data
    and operator>>() to read it back. See the class documentation for details.

    When you use QFile, **QFileInfo** , and **QDir**  to access the file system
    with Qt, you can use Unicode file names. On Unix, these file names are
    converted to an 8-bit encoding. If you want to use standard C++ APIs
    (`<cstdio>` or `<iostream>`) or platform-specific APIs to access files
    instead of QFile, you can use the **encodeName** () and **decodeName** ()
    functions to convert between Unicode file names and 8-bit file names.

    On Unix, there are some special system files (e.g. in `/proc`) for which
    **size** () will always return 0, yet you may still be able to read more
    data from such a file; the data is generated in direct response to you
    calling **read** (). In this case, however, you cannot use **atEnd** () to
    determine if there is more data to read (since **atEnd** () will return true
    for a file that claims to have size 0). Instead, you should either call
    **readAll** (), or call **read** () or **readLine** () repeatedly until no
    more data can be read. The next example uses **QTextStream**  to read
    `/proc/modules` line by line:

    **QFile**  file("/proc/modules");
            if (!file.open(**QIODevice**
    ::ReadOnly | **QIODevice** ::Text))
                return;
    **QTextStream**  in(&file);
            **QString**  line = in.readLine();
    while (!line.isNull()) {
                process_line(line);
                line =
    in.readLine();
            }

    **Signals**

    Unlike other **QIODevice**  implementations, such as **QTcpSocket** , QFile
    does not emit the **aboutToClose** (), **bytesWritten** (), or **readyRead**
    () signals. This implementation detail means that QFile is not suitable for
    reading and writing certain types of files, such as device files on Unix
    platforms.

    **Platform Specific Issues**

    File permissions are handled differently on Unix-like systems and Windows.
    In a non **writable**  directory on Unix-like systems, files cannot be
    created. This is not always the case on Windows, where, for instance, the
    'My Documents' directory usually is not writable, but it is still possible
    to create files in it.

    Qt's understanding of file permissions is limited, which affects especially
    the **QFile::setPermissions** () function. On Windows, Qt will set only the
    legacy read-only flag, and that only when none of the Write* flags are
    passed. Qt does not manipulate access control lists (ACLs), which makes this
    function mostly useless for NTFS volumes. It may still be of use for USB
    sticks that use VFAT file systems. POSIX ACLs are not manipulated, either.

    **See also** **QTextStream** , **QDataStream** , **QFileInfo** , **QDir** ,
    and **The Qt Resource System** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qfile.html#QFile

        **QFile::QFile()**

        Constructs a QFile object.
        """
        ...

    @overload
    def __init__(self, name: Union[str, bytes, os.PathLike]) -> None:
        """
        https://doc.qt.io/qt-6/qfile.html#QFile-1

        **QFile::QFile(const QString & name )**

        Constructs a new file object to represent the file with the given
        **name**.
        """
        ...

    @overload
    def __init__(
        self, name: Union[str, bytes, os.PathLike], parent: PySide6.QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfile.html#QFile-2

        **[since 6.0] QFile::QFile(const std::filesystem::path & name )**

        Constructs a new file object to represent the file with the given
        **name**.

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qfile.html#QFile-3

        **QFile::QFile(QObject * parent )**

        Constructs a new file object with the given **parent**.
        """
        ...

    @overload
    @staticmethod
    def copy(fileName: str, newName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#copy

        **bool QFile::copy(const QString & newName )**

        Copies the file named **fileName** () to **newName**.

        This file is closed before it is copied.

        If the copied file is a symbolic link (symlink), the file it refers to
        is copied, not the link itself. With the exception of permissions, which
        are copied, no other file metadata is copied.

        Returns `true` if successful; otherwise returns `false`.

        Note that if a file with the name **newName** already exists, copy()
        returns `false`. This means **QFile**  will not overwrite it.

        **See also** **setFileName** ().
        """
        ...

    @overload
    def copy(self, newName: Union[str, bytes, os.PathLike]) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#copy-1

        **[since 6.0] bool QFile::copy(const std::filesystem::path & newName )**

        This is an overloaded function.

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    @staticmethod
    def decodeName(localFileName: bytes) -> str:
        """
        https://doc.qt.io/qt-6/qfile.html#decodeName

        **[static] QString QFile::decodeName(const QByteArray & localFileName
        )**

        This does the reverse of **QFile::encodeName** () using
        **localFileName**.

        **See also** **encodeName** ().
        """
        ...

    @overload
    @staticmethod
    def decodeName(localFileName: Union[PySide6.QtCore.QByteArray, bytes]) -> str:
        """
        https://doc.qt.io/qt-6/qfile.html#decodeName-1

        **[static] QString QFile::decodeName(const char * localFileName )**

        This is an overloaded function.

        Returns the Unicode version of the given **localFileName**. See
        **encodeName** () for details.
        """
        ...

    @staticmethod
    def encodeName(fileName: str) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qfile.html#encodeName

        **[static] QByteArray QFile::encodeName(const QString & fileName )**

        Converts **fileName** to the local 8-bit encoding determined by the
        user's locale. This is sufficient for file names that the user chooses.
        File names hard-coded into the application should only use 7-bit ASCII
        filename characters.

        **See also** **decodeName** ().
        """
        ...

    @overload
    @staticmethod
    def exists(fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#exists

        **[static] bool QFile::exists(const QString & fileName )**

        Returns `true` if the file specified by **fileName** exists; otherwise
        returns `false`.

        **Note:** If **fileName** is a symlink that points to a non-existing
        file, false is returned.
        """
        ...

    @overload
    def exists(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#exists-1

        **bool QFile::exists() const**

        This is an overloaded function.

        Returns `true` if the file specified by **fileName** () exists;
        otherwise returns `false`.

        **See also** **fileName** () and **setFileName** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qfile.html#fileName

        **[override virtual] QString QFile::fileName() const**

        Reimplements: **QFileDevice::fileName() const** .

        Returns the name set by **setFileName** () or to the **QFile**
        constructors.

        **See also** **setFileName** () and **QFileInfo::fileName** ().
        """
        ...

    @overload
    @staticmethod
    def link(oldname: str, newName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#link

        **bool QFile::link(const QString & linkName )**

        Creates a link named **linkName** that points to the file currently
        specified by **fileName** (). What a link is depends on the underlying
        filesystem (be it a shortcut on Windows or a symbolic link on Unix).
        Returns `true` if successful; otherwise returns `false`.

        This function will not overwrite an already existing entity in the file
        system; in this case, `link()` will return false and set **error** () to
        return **RenameError** .

        **Note:** To create a valid link on Windows, **linkName** must have a
        `.lnk` file extension.

        **See also** **setFileName** ().
        """
        ...

    @overload
    def link(self, newName: Union[str, bytes, os.PathLike]) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#link-1

        **[since 6.0] bool QFile::link(const std::filesystem::path & newName )**

        This is an overloaded function.

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    @staticmethod
    def moveToTrash(fileName: str) -> Tuple[bool, str]:
        """
        https://doc.qt.io/qt-6/qfile.html#moveToTrash

        **[since 5.15] bool QFile::moveToTrash()**

        Moves the file specified by **fileName** () to the trash. Returns `true`
        if successful, and sets the **fileName** () to the path at which the
        file can be found within the trash; otherwise returns `false`.

        **Note:** On systems where the system API doesn't report the location of
        the file in the trash, **fileName** () will be set to the null string
        once the file has been moved. On systems that don't have a trash can,
        this function always returns false.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def moveToTrash(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#moveToTrash-1

        **[static, since 5.15] bool QFile::moveToTrash(const QString & fileName
        , QString * pathInTrash = nullptr)**

        This is an overloaded function.

        Moves the file specified by **fileName** () to the trash. Returns `true`
        if successful, and sets **pathInTrash** (if provided) to the path at
        which the file can be found within the trash; otherwise returns `false`.

        **Note:** On systems where the system API doesn't report the path of the
        file in the trash, **pathInTrash** will be set to the null string once
        the file has been moved. On systems that don't have a trash can, this
        function always returns false.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def open(
        self,
        fd: int,
        ioFlags: PySide6.QtCore.QIODeviceBase.OpenMode,
        handleFlags: PySide6.QtCore.QFileDevice.FileHandleFlags = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#open

        **[override virtual] bool QFile::open(QIODeviceBase::OpenMode mode )**

        Reimplements: **QIODevice::open** (QIODeviceBase::OpenMode mode).

        Opens the file using OpenMode **mode** , returning true if successful;
        otherwise false.

        The **mode** must be QIODevice::ReadOnly, QIODevice::WriteOnly, or
        QIODevice::ReadWrite. It may also have additional flags, such as
        QIODevice::Text and QIODevice::Unbuffered.

        **Note:** In **WriteOnly**  or **ReadWrite**  mode, if the relevant file
        does not already exist, this function will try to create a new file
        before opening it.

        **See also** **QIODevice::OpenMode**  and **setFileName** ().
        """
        ...

    @overload
    def open(self, flags: PySide6.QtCore.QIODeviceBase.OpenMode) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#open-1

        **bool QFile::open(FILE * fh , QIODeviceBase::OpenMode mode ,
        QFileDevice::FileHandleFlags handleFlags = DontCloseHandle)**

        This is an overloaded function.

        Opens the existing file handle **fh** in the given **mode**.
        **handleFlags** may be used to specify additional options. Returns
        `true` if successful; otherwise returns `false`.

        Example:

        #include <stdio.h>

            void printError(const char* msg)
            {
        **QFile**  file;
                file.open(stderr, **QIODevice** ::WriteOnly);
        file.write(msg, qstrlen(msg));        // write to stderr
        file.close();
            }

        When a **QFile**  is opened using this function, behaviour of **close**
        () is controlled by the AutoCloseHandle flag. If AutoCloseHandle is
        specified, and this function succeeds, then calling **close** () closes
        the adopted handle. Otherwise, **close** () does not actually close the
        file, but only flushes it.

        **Warning:**

        1. If **fh** does not refer to a regular file, e.g., it is `stdin`,
        `stdout`, or `stderr`, you may not be able to **seek** (). **size** ()
        returns `0` in those cases. See **QIODevice::isSequential** () for more
        information.
          2. Since this function opens the file without specifying
        the file name, you cannot use this **QFile**  with a **QFileInfo** .

        **Note for the Windows Platform**

        **fh** must be opened in binary mode (i.e., the mode string must contain
        'b', as in "rb" or "wb") when accessing files and other random-access
        devices. Qt will translate the end-of-line characters if you pass
        QIODevice::Text to **mode**. Sequential devices, such as stdin and
        stdout, are unaffected by this limitation.

        You need to enable support for console applications in order to use the
        stdin, stdout and stderr streams at the console. To do this, add the
        following declaration to your application's project file:

        CONFIG += console

        **See also** **close** ().
        """
        ...

    @overload
    @staticmethod
    def permissions(
        filename: Union[str, bytes, os.PathLike]
    ) -> PySide6.QtCore.QFileDevice.Permissions:
        """
        https://doc.qt.io/qt-6/qfile.html#permissions

        **[override virtual] QFileDevice::Permissions QFile::permissions()
        const**

        Reimplements: **QFileDevice::permissions() const** .

        **See also** **setPermissions** ().
        """
        ...

    @overload
    def permissions(self) -> PySide6.QtCore.QFileDevice.Permissions:
        """
        https://doc.qt.io/qt-6/qfile.html#permissions-1

        **[static] QFileDevice::Permissions QFile::permissions(const QString &
        fileName )**

        This is an overloaded function.

        Returns the complete OR-ed together combination of QFile::Permission for
        **fileName**.
        """
        ...

    @overload
    @staticmethod
    def remove(fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#remove

        **bool QFile::remove()**

        Removes the file specified by **fileName** (). Returns `true` if
        successful; otherwise returns `false`.

        The file is closed before it is removed.

        **See also** **setFileName** ().
        """
        ...

    @overload
    def remove(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#remove-1

        **[static] bool QFile::remove(const QString & fileName )**

        This is an overloaded function.

        Removes the file specified by the **fileName** given.

        Returns `true` if successful; otherwise returns `false`.

        **See also** **remove** ().
        """
        ...

    @overload
    @staticmethod
    def rename(oldName: str, newName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#rename

        **bool QFile::rename(const QString & newName )**

        Renames the file currently specified by **fileName** () to **newName**.
        Returns `true` if successful; otherwise returns `false`.

        If a file with the name **newName** already exists, rename() returns
        `false` (i.e., **QFile**  will not overwrite it).

        The file is closed before it is renamed.

        If the rename operation fails, Qt will attempt to copy this file's
        contents to **newName** , and then remove this file, keeping only
        **newName**. If that copy operation fails or this file can't be removed,
        the destination file **newName** is removed to restore the old state.

        **See also** **setFileName** ().
        """
        ...

    @overload
    def rename(self, newName: Union[str, bytes, os.PathLike]) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#rename-1

        **[since 6.0] bool QFile::rename(const std::filesystem::path & newName
        )**

        This is an overloaded function.

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    @staticmethod
    def resize(filename: str, sz: int) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#resize

        **[override virtual] bool QFile::resize(qint64 sz )**

        Reimplements: **QFileDevice::resize** (qint64 sz).
        """
        ...

    @overload
    def resize(self, sz: int) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#resize-1

        **[static] bool QFile::resize(const QString & fileName , qint64 sz )**

        This is an overloaded function.

        Sets **fileName** to size (in bytes) **sz**. Returns `true` if the
        resize succeeds; false otherwise. If **sz** is larger than **fileName**
        currently is the new bytes will be set to 0, if **sz** is smaller the
        file is simply truncated.

        **Warning:** This function can fail if the file doesn't exist.

        **See also** **resize** ().
        """
        ...

    def setFileName(self, name: Union[str, bytes, os.PathLike]) -> None:
        """
        https://doc.qt.io/qt-6/qfile.html#setFileName

        **void QFile::setFileName(const QString & name )**

        Sets the **name** of the file. The name can have no path, a relative
        path, or an absolute path.

        Do not call this function if the file has already been opened.

        If the file name has no path or a relative path, the path used will be
        the application's current directory path **at the time of the**open**
        ()** call.

        Example:

        **QFile**  file;
            **QDir** ::setCurrent("/tmp");
        file.setFileName("readme.txt");
            **QDir** ::setCurrent("/home");
        file.open(**QIODevice** ::ReadOnly);      // opens "/home/readme.txt"
        under Unix

        Note that the directory separator "/" works for all operating systems
        supported by Qt.

        **See also** **fileName** (), **QFileInfo** , and **QDir** .
        """
        ...

    @overload
    @staticmethod
    def setPermissions(
        filename: Union[str, bytes, os.PathLike],
        permissionSpec: PySide6.QtCore.QFileDevice.Permissions,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#setPermissions

        **[override virtual] bool QFile::setPermissions(QFileDevice::Permissions
        permissions )**

        Reimplements: **QFileDevice::setPermissions** (QFileDevice::Permissions
        permissions).

        Sets the permissions for the file to the **permissions** specified.
        Returns `true` if successful, or `false` if the permissions cannot be
        modified.

        **Warning:** This function does not manipulate ACLs, which may limit its
        effectiveness.

        **See also** **permissions** () and **setFileName** ().
        """
        ...

    @overload
    def setPermissions(
        self, permissionSpec: PySide6.QtCore.QFileDevice.Permissions
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfile.html#setPermissions-1

        **[static] bool QFile::setPermissions(const QString & fileName ,
        QFileDevice::Permissions permissions )**

        This is an overloaded function.

        Sets the permissions for **fileName** file to **permissions**.
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qfile.html#size

        **[override virtual] qint64 QFile::size() const**

        Reimplements: **QFileDevice::size() const** .
        """
        ...

    @overload
    @staticmethod
    def symLinkTarget(fileName: str) -> str:
        """
        https://doc.qt.io/qt-6/qfile.html#symLinkTarget

        **[static] QString QFile::symLinkTarget(const QString & fileName )**

        Returns the absolute path of the file or directory referred to by the
        symlink (or shortcut on Windows) specified by **fileName** , or returns
        an empty string if the **fileName** does not correspond to a symbolic
        link.

        This name may not represent an existing file; it is only a string.
        **QFile::exists** () returns `true` if the symlink points to an existing
        file.
        """
        ...

    @overload
    def symLinkTarget(self) -> str:
        """
        https://doc.qt.io/qt-6/qfile.html#symLinkTarget-1

        **QString QFile::symLinkTarget() const**

        This is an overloaded function.

        Returns the absolute path of the file or directory a symlink (or
        shortcut on Windows) points to, or a an empty string if the object isn't
        a symbolic link.

        This name may not represent an existing file; it is only a string.
        **QFile::exists** () returns `true` if the symlink points to an existing
        file.

        **See also** **fileName** () and **setFileName** ().
        """
        ...
