"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore

bytes = str


class QEvent(object):
    """
    https://doc.qt.io/qt-6/qevent.html

    **Detailed Description**

    Qt's main event loop (**QCoreApplication::exec** ()) fetches native window
    system events from the event queue, translates them into QEvents, and sends
    the translated events to **QObject** s.

    In general, events come from the underlying window system (**spontaneous**
    () returns `true`), but it is also possible to manually send events using
    **QCoreApplication::sendEvent** () and **QCoreApplication::postEvent** ()
    (**spontaneous** () returns `false`).

    **QObjects**  receive events by having their **QObject::event** () function
    called. The function can be reimplemented in subclasses to customize event
    handling and add additional event types; **QWidget::event** () is a notable
    example. By default, events are dispatched to event handlers like
    **QObject::timerEvent** () and **QWidget::mouseMoveEvent** ().
    **QObject::installEventFilter** () allows an object to intercept events
    destined for another object.

    The basic QEvent contains only an event type parameter and an "accept" flag.
    The accept flag set with **accept** (), and cleared with **ignore** (). It
    is set by default, but don't rely on this as subclasses may choose to clear
    it in their constructor.

    Subclasses of QEvent contain additional parameters that describe the
    particular event.

    **See also** **QObject::event** (), **QObject::installEventFilter** (),
    **QCoreApplication::sendEvent** (), **QCoreApplication::postEvent** (), and
    **QCoreApplication::processEvents** ().
    """

    None_: QEvent.Type = ...
    Timer: QEvent.Type = ...
    MouseButtonPress: QEvent.Type = ...
    MouseButtonRelease: QEvent.Type = ...
    MouseButtonDblClick: QEvent.Type = ...
    MouseMove: QEvent.Type = ...
    KeyPress: QEvent.Type = ...
    KeyRelease: QEvent.Type = ...
    FocusIn: QEvent.Type = ...
    FocusOut: QEvent.Type = ...
    Enter: QEvent.Type = ...
    Leave: QEvent.Type = ...
    Paint: QEvent.Type = ...
    Move: QEvent.Type = ...
    Resize: QEvent.Type = ...
    Create: QEvent.Type = ...
    Destroy: QEvent.Type = ...
    Show: QEvent.Type = ...
    Hide: QEvent.Type = ...
    Close: QEvent.Type = ...
    Quit: QEvent.Type = ...
    ParentChange: QEvent.Type = ...
    ThreadChange: QEvent.Type = ...
    FocusAboutToChange: QEvent.Type = ...
    WindowActivate: QEvent.Type = ...
    WindowDeactivate: QEvent.Type = ...
    ShowToParent: QEvent.Type = ...
    HideToParent: QEvent.Type = ...
    Wheel: QEvent.Type = ...
    WindowTitleChange: QEvent.Type = ...
    WindowIconChange: QEvent.Type = ...
    ApplicationWindowIconChange: QEvent.Type = ...
    ApplicationFontChange: QEvent.Type = ...
    ApplicationLayoutDirectionChange: QEvent.Type = ...
    ApplicationPaletteChange: QEvent.Type = ...
    PaletteChange: QEvent.Type = ...
    Clipboard: QEvent.Type = ...
    Speech: QEvent.Type = ...
    MetaCall: QEvent.Type = ...
    SockAct: QEvent.Type = ...
    ShortcutOverride: QEvent.Type = ...
    DeferredDelete: QEvent.Type = ...
    DragEnter: QEvent.Type = ...
    DragMove: QEvent.Type = ...
    DragLeave: QEvent.Type = ...
    Drop: QEvent.Type = ...
    DragResponse: QEvent.Type = ...
    ChildAdded: QEvent.Type = ...
    ChildPolished: QEvent.Type = ...
    ChildRemoved: QEvent.Type = ...
    ShowWindowRequest: QEvent.Type = ...
    PolishRequest: QEvent.Type = ...
    Polish: QEvent.Type = ...
    LayoutRequest: QEvent.Type = ...
    UpdateRequest: QEvent.Type = ...
    UpdateLater: QEvent.Type = ...
    EmbeddingControl: QEvent.Type = ...
    ActivateControl: QEvent.Type = ...
    DeactivateControl: QEvent.Type = ...
    ContextMenu: QEvent.Type = ...
    InputMethod: QEvent.Type = ...
    TabletMove: QEvent.Type = ...
    LocaleChange: QEvent.Type = ...
    LanguageChange: QEvent.Type = ...
    LayoutDirectionChange: QEvent.Type = ...
    Style: QEvent.Type = ...
    TabletPress: QEvent.Type = ...
    TabletRelease: QEvent.Type = ...
    OkRequest: QEvent.Type = ...
    HelpRequest: QEvent.Type = ...
    IconDrag: QEvent.Type = ...
    FontChange: QEvent.Type = ...
    EnabledChange: QEvent.Type = ...
    ActivationChange: QEvent.Type = ...
    StyleChange: QEvent.Type = ...
    IconTextChange: QEvent.Type = ...
    ModifiedChange: QEvent.Type = ...
    WindowBlocked: QEvent.Type = ...
    WindowUnblocked: QEvent.Type = ...
    WindowStateChange: QEvent.Type = ...
    ReadOnlyChange: QEvent.Type = ...
    MouseTrackingChange: QEvent.Type = ...
    ToolTip: QEvent.Type = ...
    WhatsThis: QEvent.Type = ...
    StatusTip: QEvent.Type = ...
    ActionChanged: QEvent.Type = ...
    ActionAdded: QEvent.Type = ...
    ActionRemoved: QEvent.Type = ...
    FileOpen: QEvent.Type = ...
    Shortcut: QEvent.Type = ...
    WhatsThisClicked: QEvent.Type = ...
    ToolBarChange: QEvent.Type = ...
    ApplicationActivate: QEvent.Type = ...
    ApplicationActivated: QEvent.Type = ...
    ApplicationDeactivate: QEvent.Type = ...
    ApplicationDeactivated: QEvent.Type = ...
    QueryWhatsThis: QEvent.Type = ...
    EnterWhatsThisMode: QEvent.Type = ...
    LeaveWhatsThisMode: QEvent.Type = ...
    ZOrderChange: QEvent.Type = ...
    HoverEnter: QEvent.Type = ...
    HoverLeave: QEvent.Type = ...
    HoverMove: QEvent.Type = ...
    ParentAboutToChange: QEvent.Type = ...
    WinEventAct: QEvent.Type = ...
    AcceptDropsChange: QEvent.Type = ...
    ZeroTimerEvent: QEvent.Type = ...
    GraphicsSceneMouseMove: QEvent.Type = ...
    GraphicsSceneMousePress: QEvent.Type = ...
    GraphicsSceneMouseRelease: QEvent.Type = ...
    GraphicsSceneMouseDoubleClick: QEvent.Type = ...
    GraphicsSceneContextMenu: QEvent.Type = ...
    GraphicsSceneHoverEnter: QEvent.Type = ...
    GraphicsSceneHoverMove: QEvent.Type = ...
    GraphicsSceneHoverLeave: QEvent.Type = ...
    GraphicsSceneHelp: QEvent.Type = ...
    GraphicsSceneDragEnter: QEvent.Type = ...
    GraphicsSceneDragMove: QEvent.Type = ...
    GraphicsSceneDragLeave: QEvent.Type = ...
    GraphicsSceneDrop: QEvent.Type = ...
    GraphicsSceneWheel: QEvent.Type = ...
    KeyboardLayoutChange: QEvent.Type = ...
    DynamicPropertyChange: QEvent.Type = ...
    TabletEnterProximity: QEvent.Type = ...
    TabletLeaveProximity: QEvent.Type = ...
    NonClientAreaMouseMove: QEvent.Type = ...
    NonClientAreaMouseButtonPress: QEvent.Type = ...
    NonClientAreaMouseButtonRelease: QEvent.Type = ...
    NonClientAreaMouseButtonDblClick: QEvent.Type = ...
    MacSizeChange: QEvent.Type = ...
    ContentsRectChange: QEvent.Type = ...
    MacGLWindowChange: QEvent.Type = ...
    FutureCallOut: QEvent.Type = ...
    GraphicsSceneResize: QEvent.Type = ...
    GraphicsSceneMove: QEvent.Type = ...
    CursorChange: QEvent.Type = ...
    ToolTipChange: QEvent.Type = ...
    NetworkReplyUpdated: QEvent.Type = ...
    GrabMouse: QEvent.Type = ...
    UngrabMouse: QEvent.Type = ...
    GrabKeyboard: QEvent.Type = ...
    UngrabKeyboard: QEvent.Type = ...
    StateMachineSignal: QEvent.Type = ...
    StateMachineWrapped: QEvent.Type = ...
    TouchBegin: QEvent.Type = ...
    TouchUpdate: QEvent.Type = ...
    TouchEnd: QEvent.Type = ...
    NativeGesture: QEvent.Type = ...
    Gesture: QEvent.Type = ...
    RequestSoftwareInputPanel: QEvent.Type = ...
    CloseSoftwareInputPanel: QEvent.Type = ...
    GestureOverride: QEvent.Type = ...
    WinIdChange: QEvent.Type = ...
    ScrollPrepare: QEvent.Type = ...
    Scroll: QEvent.Type = ...
    Expose: QEvent.Type = ...
    InputMethodQuery: QEvent.Type = ...
    OrientationChange: QEvent.Type = ...
    TouchCancel: QEvent.Type = ...
    ThemeChange: QEvent.Type = ...
    SockClose: QEvent.Type = ...
    PlatformPanel: QEvent.Type = ...
    StyleAnimationUpdate: QEvent.Type = ...
    ApplicationStateChange: QEvent.Type = ...
    WindowChangeInternal: QEvent.Type = ...
    ScreenChangeInternal: QEvent.Type = ...
    PlatformSurface: QEvent.Type = ...
    Pointer: QEvent.Type = ...
    TabletTrackingChange: QEvent.Type = ...
    GraphicsSceneLeave: QEvent.Type = ...
    User: QEvent.Type = ...
    MaxUser: QEvent.Type = ...

    class Type(Enum):
        None_: QEvent.Type = ...
        Timer: QEvent.Type = ...
        MouseButtonPress: QEvent.Type = ...
        MouseButtonRelease: QEvent.Type = ...
        MouseButtonDblClick: QEvent.Type = ...
        MouseMove: QEvent.Type = ...
        KeyPress: QEvent.Type = ...
        KeyRelease: QEvent.Type = ...
        FocusIn: QEvent.Type = ...
        FocusOut: QEvent.Type = ...
        Enter: QEvent.Type = ...
        Leave: QEvent.Type = ...
        Paint: QEvent.Type = ...
        Move: QEvent.Type = ...
        Resize: QEvent.Type = ...
        Create: QEvent.Type = ...
        Destroy: QEvent.Type = ...
        Show: QEvent.Type = ...
        Hide: QEvent.Type = ...
        Close: QEvent.Type = ...
        Quit: QEvent.Type = ...
        ParentChange: QEvent.Type = ...
        ThreadChange: QEvent.Type = ...
        FocusAboutToChange: QEvent.Type = ...
        WindowActivate: QEvent.Type = ...
        WindowDeactivate: QEvent.Type = ...
        ShowToParent: QEvent.Type = ...
        HideToParent: QEvent.Type = ...
        Wheel: QEvent.Type = ...
        WindowTitleChange: QEvent.Type = ...
        WindowIconChange: QEvent.Type = ...
        ApplicationWindowIconChange: QEvent.Type = ...
        ApplicationFontChange: QEvent.Type = ...
        ApplicationLayoutDirectionChange: QEvent.Type = ...
        ApplicationPaletteChange: QEvent.Type = ...
        PaletteChange: QEvent.Type = ...
        Clipboard: QEvent.Type = ...
        Speech: QEvent.Type = ...
        MetaCall: QEvent.Type = ...
        SockAct: QEvent.Type = ...
        ShortcutOverride: QEvent.Type = ...
        DeferredDelete: QEvent.Type = ...
        DragEnter: QEvent.Type = ...
        DragMove: QEvent.Type = ...
        DragLeave: QEvent.Type = ...
        Drop: QEvent.Type = ...
        DragResponse: QEvent.Type = ...
        ChildAdded: QEvent.Type = ...
        ChildPolished: QEvent.Type = ...
        ChildRemoved: QEvent.Type = ...
        ShowWindowRequest: QEvent.Type = ...
        PolishRequest: QEvent.Type = ...
        Polish: QEvent.Type = ...
        LayoutRequest: QEvent.Type = ...
        UpdateRequest: QEvent.Type = ...
        UpdateLater: QEvent.Type = ...
        EmbeddingControl: QEvent.Type = ...
        ActivateControl: QEvent.Type = ...
        DeactivateControl: QEvent.Type = ...
        ContextMenu: QEvent.Type = ...
        InputMethod: QEvent.Type = ...
        TabletMove: QEvent.Type = ...
        LocaleChange: QEvent.Type = ...
        LanguageChange: QEvent.Type = ...
        LayoutDirectionChange: QEvent.Type = ...
        Style: QEvent.Type = ...
        TabletPress: QEvent.Type = ...
        TabletRelease: QEvent.Type = ...
        OkRequest: QEvent.Type = ...
        HelpRequest: QEvent.Type = ...
        IconDrag: QEvent.Type = ...
        FontChange: QEvent.Type = ...
        EnabledChange: QEvent.Type = ...
        ActivationChange: QEvent.Type = ...
        StyleChange: QEvent.Type = ...
        IconTextChange: QEvent.Type = ...
        ModifiedChange: QEvent.Type = ...
        WindowBlocked: QEvent.Type = ...
        WindowUnblocked: QEvent.Type = ...
        WindowStateChange: QEvent.Type = ...
        ReadOnlyChange: QEvent.Type = ...
        MouseTrackingChange: QEvent.Type = ...
        ToolTip: QEvent.Type = ...
        WhatsThis: QEvent.Type = ...
        StatusTip: QEvent.Type = ...
        ActionChanged: QEvent.Type = ...
        ActionAdded: QEvent.Type = ...
        ActionRemoved: QEvent.Type = ...
        FileOpen: QEvent.Type = ...
        Shortcut: QEvent.Type = ...
        WhatsThisClicked: QEvent.Type = ...
        ToolBarChange: QEvent.Type = ...
        ApplicationActivate: QEvent.Type = ...
        ApplicationActivated: QEvent.Type = ...
        ApplicationDeactivate: QEvent.Type = ...
        ApplicationDeactivated: QEvent.Type = ...
        QueryWhatsThis: QEvent.Type = ...
        EnterWhatsThisMode: QEvent.Type = ...
        LeaveWhatsThisMode: QEvent.Type = ...
        ZOrderChange: QEvent.Type = ...
        HoverEnter: QEvent.Type = ...
        HoverLeave: QEvent.Type = ...
        HoverMove: QEvent.Type = ...
        ParentAboutToChange: QEvent.Type = ...
        WinEventAct: QEvent.Type = ...
        AcceptDropsChange: QEvent.Type = ...
        ZeroTimerEvent: QEvent.Type = ...
        GraphicsSceneMouseMove: QEvent.Type = ...
        GraphicsSceneMousePress: QEvent.Type = ...
        GraphicsSceneMouseRelease: QEvent.Type = ...
        GraphicsSceneMouseDoubleClick: QEvent.Type = ...
        GraphicsSceneContextMenu: QEvent.Type = ...
        GraphicsSceneHoverEnter: QEvent.Type = ...
        GraphicsSceneHoverMove: QEvent.Type = ...
        GraphicsSceneHoverLeave: QEvent.Type = ...
        GraphicsSceneHelp: QEvent.Type = ...
        GraphicsSceneDragEnter: QEvent.Type = ...
        GraphicsSceneDragMove: QEvent.Type = ...
        GraphicsSceneDragLeave: QEvent.Type = ...
        GraphicsSceneDrop: QEvent.Type = ...
        GraphicsSceneWheel: QEvent.Type = ...
        KeyboardLayoutChange: QEvent.Type = ...
        DynamicPropertyChange: QEvent.Type = ...
        TabletEnterProximity: QEvent.Type = ...
        TabletLeaveProximity: QEvent.Type = ...
        NonClientAreaMouseMove: QEvent.Type = ...
        NonClientAreaMouseButtonPress: QEvent.Type = ...
        NonClientAreaMouseButtonRelease: QEvent.Type = ...
        NonClientAreaMouseButtonDblClick: QEvent.Type = ...
        MacSizeChange: QEvent.Type = ...
        ContentsRectChange: QEvent.Type = ...
        MacGLWindowChange: QEvent.Type = ...
        FutureCallOut: QEvent.Type = ...
        GraphicsSceneResize: QEvent.Type = ...
        GraphicsSceneMove: QEvent.Type = ...
        CursorChange: QEvent.Type = ...
        ToolTipChange: QEvent.Type = ...
        NetworkReplyUpdated: QEvent.Type = ...
        GrabMouse: QEvent.Type = ...
        UngrabMouse: QEvent.Type = ...
        GrabKeyboard: QEvent.Type = ...
        UngrabKeyboard: QEvent.Type = ...
        StateMachineSignal: QEvent.Type = ...
        StateMachineWrapped: QEvent.Type = ...
        TouchBegin: QEvent.Type = ...
        TouchUpdate: QEvent.Type = ...
        TouchEnd: QEvent.Type = ...
        NativeGesture: QEvent.Type = ...
        Gesture: QEvent.Type = ...
        RequestSoftwareInputPanel: QEvent.Type = ...
        CloseSoftwareInputPanel: QEvent.Type = ...
        GestureOverride: QEvent.Type = ...
        WinIdChange: QEvent.Type = ...
        ScrollPrepare: QEvent.Type = ...
        Scroll: QEvent.Type = ...
        Expose: QEvent.Type = ...
        InputMethodQuery: QEvent.Type = ...
        OrientationChange: QEvent.Type = ...
        TouchCancel: QEvent.Type = ...
        ThemeChange: QEvent.Type = ...
        SockClose: QEvent.Type = ...
        PlatformPanel: QEvent.Type = ...
        StyleAnimationUpdate: QEvent.Type = ...
        ApplicationStateChange: QEvent.Type = ...
        WindowChangeInternal: QEvent.Type = ...
        ScreenChangeInternal: QEvent.Type = ...
        PlatformSurface: QEvent.Type = ...
        Pointer: QEvent.Type = ...
        TabletTrackingChange: QEvent.Type = ...
        GraphicsSceneLeave: QEvent.Type = ...
        User: QEvent.Type = ...
        MaxUser: QEvent.Type = ...

    @overload
    def __init__(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#QEvent-2

        **QEvent::QEvent(QEvent::Type type )**

        Constructs an event object of type **type**.
        """
        ...

    @overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#QEvent-2

        **QEvent::QEvent(QEvent::Type type )**

        Constructs an event object of type **type**.
        """
        ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#accept

        **void QEvent::accept()**

        Sets the accept flag of the event object, the equivalent of calling
        **setAccepted** (true).

        Setting the accept parameter indicates that the event receiver wants the
        event. Unwanted events might be propagated to the parent widget.

        **See also** **ignore** ().
        """
        ...

    def clone(self) -> PySide6.QtCore.QEvent:
        """
        https://doc.qt.io/qt-6/qevent.html#clone

        **[virtual, since 6.0] QEvent *QEvent::clone() const**

        Creates and returns an identical copy of this event.

        This function was introduced in Qt 6.0.
        """
        ...

    def ignore(self) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#ignore

        **void QEvent::ignore()**

        Clears the accept flag parameter of the event object, the equivalent of
        calling **setAccepted** (false).

        Clearing the accept parameter indicates that the event receiver does not
        want the event. Unwanted events might be propagated to the parent
        widget.

        **See also** **accept** ().
        """
        ...

    def isAccepted(self) -> bool:
        ...

    def isInputEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#isInputEvent

        **[since 6.0] bool QEvent::isInputEvent() const**

        Returns `true` if the event object is a **QInputEvent**  or one of its
        subclasses.

        This function was introduced in Qt 6.0.
        """
        ...

    def isPointerEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#isPointerEvent

        **[since 6.0] bool QEvent::isPointerEvent() const**

        Returns `true` if the event object is a **QPointerEvent**  or one of its
        subclasses.

        This function was introduced in Qt 6.0.
        """
        ...

    def isSinglePointEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#isSinglePointEvent

        **[since 6.0] bool QEvent::isSinglePointEvent() const**

        Returns `true` if the event object is a subclass of
        **QSinglePointEvent** .

        This function was introduced in Qt 6.0.
        """
        ...

    @staticmethod
    def registerEventType(hint: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qevent.html#registerEventType

        **[static] int QEvent::registerEventType(int hint = -1)**

        Registers and returns a custom event type. The **hint** provided will be
        used if it is available, otherwise it will return a value between
        **QEvent::User**  and **QEvent::MaxUser**  that has not yet been
        registered. The **hint** is ignored if its value is not between
        **QEvent::User**  and **QEvent::MaxUser** .

        Returns -1 if all available values are already taken or the program is
        shutting down.

        **Note:** This function is **thread-safe** .
        """
        ...

    def setAccepted(self, accepted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#accepted-prop

        **accepted : bool**

        This property holds the accept flag of the event object.

        Setting the accept parameter indicates that the event receiver wants the
        event. Unwanted events might be propagated to the parent widget. By
        default, isAccepted() is set to true, but don't rely on this as
        subclasses may choose to clear it in their constructor.

        For convenience, the accept flag can also be set with **accept** (), and
        cleared with **ignore** ().

        **Note:** Accepting a **QPointerEvent**  implicitly **accepts**  all the
        **points**  that the event carries.

        **Access functions:**

        bool **isAccepted** () const
        virtual void **setAccepted** (bool
        **accepted** )

        **Member Function Documentation**
        """
        ...

    def spontaneous(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#spontaneous

        **bool QEvent::spontaneous() const**

        Returns `true` if the event originated outside the application (a system
        event); otherwise returns `false`.
        """
        ...

    def type(self) -> PySide6.QtCore.QEvent.Type:
        """
        https://doc.qt.io/qt-6/qevent.html#type

        **QEvent::Type QEvent::type() const**

        Returns the event type.
        """
        ...
